/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivitySequenceJump;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Element;

public class ActivitySequenceElement
implements Editable,
Domable,
Cloneable {
    private String tag;
    private String description;
    private String activityName;
    public ActivitySequenceJump fwdJump;
    public ActivitySequenceJump backJump;
    public int navButtons;
    public int delay;
    public static final String ELEMENT_NAME = "item";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String DESCRIPTION = "description";
    public static final String DELAY = "delay";
    public static final String FORWARD = "forward";
    public static final String BACK = "back";
    public static final String NAV_BUTTONS = "navButtons";
    public static final int NAV_NONE = 0;
    public static final int NAV_FWD = 1;
    public static final int NAV_BACK = 2;
    public static final int NAV_BOTH = 3;
    public static final String[] NAV_BUTTONS_TAG = new String[]{"none", "fwd", "back", "both"};

    public ActivitySequenceElement(String string) {
        this(string, false);
    }

    public ActivitySequenceElement(String string, boolean bl) {
        this(string, 0, 3);
        if (bl) {
            this.setTag(this.getActivityName());
            this.fwdJump = new ActivitySequenceJump(1);
            this.backJump = new ActivitySequenceJump(2);
        }
    }

    public ActivitySequenceElement(String string, int n, int n2) {
        this.setActivityName(string);
        this.delay = n;
        this.tag = null;
        this.description = null;
        this.fwdJump = null;
        this.backJump = null;
        this.navButtons = n2;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        if (this.tag != null) {
            element.setAttribute(ID, this.tag);
            if (this.description != null) {
                JDomUtility.addParagraphs(element, DESCRIPTION, this.description);
            }
        }
        element.setAttribute(NAME, this.activityName);
        if (this.delay != 0) {
            element.setAttribute(DELAY, Integer.toString(this.delay));
        }
        if (this.fwdJump != null) {
            element.addContent(this.fwdJump.getJDomElement(FORWARD));
        }
        if (this.backJump != null) {
            element.addContent(this.backJump.getJDomElement(BACK));
        }
        if (this.navButtons != 3) {
            element.setAttribute(NAV_BUTTONS, NAV_BUTTONS_TAG[this.navButtons]);
        }
        return element;
    }

    public static ActivitySequenceElement getActivitySequenceElement(Element element) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        ActivitySequenceElement activitySequenceElement = new ActivitySequenceElement("", 0, 3);
        activitySequenceElement.setProperties(element, null);
        return activitySequenceElement;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.setActivityName(element.getAttributeValue(NAME));
        this.delay = JDomUtility.getIntAttr(element, DELAY, 0);
        this.setTag(JDomUtility.getStringAttr(element, ID, this.tag, false));
        this.description = JDomUtility.getParagraphs(element.getChild(DESCRIPTION));
        Iterator iterator = element.getChildren("jump").iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getAttributeValue(ID);
            ActivitySequenceJump activitySequenceJump = ActivitySequenceJump.getActivitySequenceJump(element2);
            if (FORWARD.equals(string)) {
                this.fwdJump = activitySequenceJump;
                continue;
            }
            if (!BACK.equals(string)) continue;
            this.backJump = activitySequenceJump;
        }
        this.navButtons = JDomUtility.getStrIndexAttr(element, NAV_BUTTONS, NAV_BUTTONS_TAG, 3);
    }

    public void setTag(String string) {
        this.tag = FileSystem.stdFn(string);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDescription() {
        return this.description;
    }

    public void setActivityName(String string) {
        this.activityName = FileSystem.stdFn(string);
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void listReferences(String string, HashMap hashMap) {
        if (this.activityName != null && (string == null || string.equals("activity"))) {
            hashMap.put(this.activityName, "activity");
        }
        if (this.tag != null && (string == null || string.equals("sequence"))) {
            hashMap.put(this.tag, "sequence");
        }
        if (this.backJump != null) {
            this.backJump.listReferences(string, hashMap);
        }
        if (this.fwdJump != null) {
            this.fwdJump.listReferences(string, hashMap);
        }
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }

    public Object clone() throws CloneNotSupportedException {
        ActivitySequenceElement activitySequenceElement = (ActivitySequenceElement)super.clone();
        if (this.fwdJump != null) {
            activitySequenceElement.fwdJump = (ActivitySequenceJump)this.fwdJump.clone();
        }
        if (this.backJump != null) {
            activitySequenceElement.backJump = (ActivitySequenceJump)this.backJump.clone();
        }
        return activitySequenceElement;
    }
}

