/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;

public class Counter
extends AbstractBox {
    int value = 0;
    int countDown;
    boolean enabled = false;
    Image img = null;
    Dimension dSize;
    Point origin;

    public Counter(AbstractBox abstractBox, JComponent jComponent, Rectangle2D rectangle2D, BoxBase boxBase) {
        super(abstractBox, jComponent, boxBase);
        this.setBounds(rectangle2D);
        this.countDown = 0;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.repaint();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCountDown(int n) {
        this.countDown = n;
        this.repaint();
    }

    public void setSource(Image image, Point point, Dimension dimension) {
        this.img = image;
        this.origin = point;
        this.dSize = dimension;
        this.repaint();
    }

    public void incValue() {
        ++this.value;
        if (this.enabled) {
            this.repaint();
        }
    }

    public void setValue(int n) {
        this.value = n;
        if (this.enabled) {
            this.repaint();
        }
    }

    public int getValue() {
        return this.value;
    }

    public boolean updateContent(Graphics2D graphics2D, Rectangle rectangle, ImageObserver imageObserver) {
        double d = (this.width - (double)(3 * this.dSize.width)) / 2.0;
        double d2 = (this.height - (double)this.dSize.height) / 2.0;
        if (this.img == null) {
            return false;
        }
        int n = this.value;
        if (this.countDown > 0) {
            n = Math.max(0, this.countDown - this.value);
        }
        n = Math.min(999, n);
        boolean bl = false;
        int n2 = 0;
        int n3 = 100;
        while (n2 < 3) {
            int n4;
            if (!this.enabled) {
                n4 = 1;
            } else {
                int n5 = n / n3 % 10;
                if (n5 != 0) {
                    bl = true;
                    n4 = 11 - n5;
                } else {
                    n4 = bl || n2 == 2 ? 11 : 1;
                }
            }
            graphics2D.drawImage(this.img, (int)(this.x + d + (double)(this.dSize.width * n2)), (int)(this.y + d2), (int)(this.x + d + (double)(this.dSize.width * (n2 + 1))), (int)(this.y + d2 + (double)this.dSize.height), this.origin.x, this.origin.y + this.dSize.height * n4, this.origin.x + this.dSize.width, this.origin.y + this.dSize.height * (n4 + 1), imageObserver);
            ++n2;
            n3 /= 10;
        }
        return true;
    }
}

