/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.jclic.project.ProjectLibraryEditor;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProjectLibraryEditorPanel
extends EditorPanel {
    private JPanel mainPanel;
    private JTextField titleText;

    public ProjectLibraryEditorPanel(Options options) {
        super(options);
        ProjectLibraryEditor.createActions(options);
        this.initComponents();
        this.postInit(250, true, false);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.titleText = new JTextField();
        this.titleText.getDocument().addDocumentListener(this);
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setOpaque(false);
        jLabel.setText(this.options.getMsg("edit_name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        this.titleText.setToolTipText(this.options.getMsg("library_dlg_name_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.mainPanel.add((Component)this.titleText, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    public boolean checkIfEditorValid(Editor editor) {
        return editor instanceof ProjectLibraryEditor;
    }

    protected ProjectLibrary getProjectLibrary() {
        if (this.editor == null) {
            return null;
        }
        return ((ProjectLibraryEditor)this.editor).getProjectLibrary();
    }

    public void fillData() {
        ProjectLibrary projectLibrary = this.getProjectLibrary();
        this.titleText.setText(projectLibrary == null ? this.options.getMsg("UNNAMED") : projectLibrary.settings.title);
    }

    public void saveData() {
        ProjectLibrary projectLibrary = this.getProjectLibrary();
        if (projectLibrary != null) {
            projectLibrary.settings.title = this.checkEmptyString(this.titleText.getText(), true, this.options.getMsg("UNNAMED"));
            this.titleText.setText(projectLibrary.settings.title);
        }
    }

    protected Icon getIcon() {
        return ProjectLibraryEditor.getIcon();
    }

    protected String getTitle() {
        return this.options.getMsg("library_dlg_title");
    }
}

