/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.StrUtils;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Html {
    public static final String SP = " ";
    public static final String NBSP = "&nbsp;";
    public static final String BR = "\n<BR>\n";
    public static final String P = "\n<P>\n";
    public static final String Q = "\"";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final String[] ALIGN = new String[]{"", "ALIGN=\"center\"", "ALIGN=\"right\""};
    protected StringBuffer sb;
    public static final String validChars = " -_.*0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public Html(int n) {
        this.sb = new StringBuffer(n);
    }

    public Html(StringBuffer stringBuffer) {
        this.sb = stringBuffer;
    }

    public String toString() {
        return this.sb.substring(0);
    }

    public Html append(String string) {
        this.sb.append(string == null ? "" : string);
        return this;
    }

    public Html appendParagraphs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            if (!bl) {
                this.sb.append(BR);
            } else {
                bl = false;
            }
            this.sb.append(stringTokenizer.nextToken());
        }
        return this;
    }

    public Html mailTo(String string, boolean bl) {
        if (bl) {
            this.sb.append("(");
        }
        this.sb.append("<A HREF=\"mailto:").append(string).append("\">").append(string).append("</A>");
        if (bl) {
            this.sb.append(")");
        }
        return this;
    }

    public Html linkTo(String string, String string2) {
        this.sb.append("<A HREF=\"").append(string).append("\">");
        this.sb.append(string2 == null ? string : string2);
        this.sb.append("</A>");
        return this;
    }

    public Html bold(String string) {
        this.sb.append("<B>").append(string).append("</B>");
        return this;
    }

    public Html td(boolean bl) {
        this.sb.append(bl ? "<TD VALIGN=\"top\">" : "</TD>\n");
        return this;
    }

    public Html td(String string) {
        return this.td(string, false);
    }

    public Html td(String string, int n, boolean bl, String string2) {
        this.sb.append("<TD VALIGN=\"top\" ");
        if (n > 0) {
            this.sb.append(SP).append(ALIGN[n]);
        }
        if (string2 != null) {
            this.sb.append(SP).append(string2);
        }
        this.sb.append(">");
        if (bl) {
            this.bold(string);
        } else {
            this.sb.append(string);
        }
        this.sb.append("</TD>\n");
        return this;
    }

    public Html td(String string, boolean bl) {
        this.sb.append("<TD VALIGN=\"top\">");
        if (bl) {
            this.bold(string);
        } else {
            this.sb.append(string);
        }
        this.sb.append("</TD>\n");
        return this;
    }

    public Html tr(boolean bl) {
        return this.append(bl ? "<TR>" : "</TR>\n");
    }

    public Html br() {
        return this.append(BR);
    }

    public Html p() {
        return this.append(P);
    }

    public Html sp() {
        return this.append(SP);
    }

    public Html nbsp() {
        return this.append(NBSP);
    }

    public Html doubleCell(String string, boolean bl, String string2, boolean bl2) {
        this.tr(true);
        this.td(true);
        if (bl) {
            this.sb.append("<B>");
        }
        this.appendParagraphs(string);
        if (bl) {
            this.sb.append("</B>");
        }
        this.td(false);
        this.td(true);
        if (bl2) {
            this.sb.append("<B>");
        }
        this.appendParagraphs(string2);
        if (bl2) {
            this.sb.append("</B>");
        }
        this.td(false);
        this.tr(false);
        return this;
    }

    public static String table(String string, String string2, int n, int n2, int n3, String string3, boolean bl) {
        int n4 = string != null ? string.length() : 100;
        StringBuffer stringBuffer = new StringBuffer(n4 + 200);
        stringBuffer.append("<TABLE ");
        if (string2 != null) {
            stringBuffer.append(" WIDTH=\"").append(string2).append(Q);
        }
        if (n >= 0) {
            stringBuffer.append(" BORDER=\"").append(n).append(Q);
        }
        if (n2 >= 0) {
            stringBuffer.append(" CELLPADDING=\"").append(n2).append(Q);
        }
        if (n3 >= 0) {
            stringBuffer.append(" CELLSPACING=\"").append(n3).append(Q);
        }
        if (string3 != null) {
            stringBuffer.append(" STYLE=\"").append(string3).append(Q);
        }
        stringBuffer.append(">\n");
        if (bl) {
            stringBuffer.append("<TR><TD>");
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append("</TD></TR>");
        }
        stringBuffer.append("\n</TABLE>");
        return stringBuffer.substring(0);
    }

    public static String getHtmlDoc(String string, String string2) {
        int n = string != null ? string.length() : 100;
        StringBuffer stringBuffer = new StringBuffer(n + 100);
        stringBuffer.append("<HTML>\n");
        stringBuffer.append("<BODY");
        if (string2 != null) {
            stringBuffer.append(" BGCOLOR=\"#").append(string2).append(Q);
        }
        stringBuffer.append(">\n");
        stringBuffer.append(string);
        stringBuffer.append("</BODY></HTML>");
        return stringBuffer.substring(0);
    }

    public static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3);
        stringBuffer.append("'");
        stringBuffer.append(StrUtils.replace(StrUtils.replace(StrUtils.replace(string, "'", "&#39;"), Q, "&quot;"), "`", "&rsquo;"));
        stringBuffer.append("'");
        return stringBuffer.substring(0);
    }

    public static String encode(String string) {
        if (string == null || string.length() < 1) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (validChars.indexOf(c) >= 0) {
                stringBuffer.append(c);
                continue;
            }
            if (c < '\u0100') {
                stringBuffer.append("%").append(Integer.toHexString(c));
                continue;
            }
            stringBuffer.append("%26%23").append(Integer.toHexString(c)).append("%3B");
        }
        return stringBuffer.substring(0);
    }

    public static String decode(String string) {
        int n;
        if (string == null || string.length() < 1) {
            return string;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (n == 37) {
                stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                i += 2;
                continue;
            }
            stringBuffer.append((char)n);
        }
        String string2 = stringBuffer.substring(0);
        n2 = string2.length();
        stringBuffer.setLength(0);
        n = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c == '&' && (n = string2.indexOf(59, i)) > i + 2) {
                String string3 = string2.substring(i + 1, n).toLowerCase();
                if (string3.length() > 2 && string3.charAt(0) == '#') {
                    int n3 = 0;
                    n3 = string3.charAt(1) == 'x' ? Integer.parseInt(string3.substring(2), 16) : Integer.parseInt(string3.substring(1));
                    stringBuffer.append((char)n3);
                } else {
                    stringBuffer.append('?');
                }
                i = n;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.substring(0);
    }

    public static void processParamsLine(String string, HashMap hashMap, char c, char c2) {
        if (string != null && string.length() > 0 && hashMap != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(c));
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = null;
                String string4 = null;
                int n = string2.indexOf(c2);
                if (n > 0) {
                    string3 = Html.decode(string2.substring(0, n).replace('+', ' '));
                    if (n < string2.length() - 1) {
                        string4 = Html.decode(string2.substring(n + 1).replace('+', ' '));
                    }
                } else {
                    string3 = Html.decode(string2.replace('+', ' '));
                }
                hashMap.put(string3, string4);
            }
        }
    }

    public static void writeScriptConfirm(PrintStream printStream) {
        printStream.println("<SCRIPT language=\"javascript\">");
        printStream.println("function confirmAction(msg){");
        printStream.println("   var agree=confirm(msg);");
        printStream.println("   if (agree)");
        printStream.println("     return true;");
        printStream.println("   else");
        printStream.println("     return false;");
        printStream.println("}");
        printStream.println("</SCRIPT>");
    }
}

