/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.image4j.io.EndianUtils;

public class LittleEndianRandomAccessFile
extends RandomAccessFile {
    public LittleEndianRandomAccessFile(File file, String string) throws FileNotFoundException {
        super(file, string);
    }

    public LittleEndianRandomAccessFile(String string, String string2) throws FileNotFoundException {
        super(string, string2);
    }

    public short readShortLE() throws IOException {
        short s = super.readShort();
        s = EndianUtils.swapShort(s);
        return s;
    }

    public int readIntLE() throws IOException {
        int n = super.readInt();
        n = EndianUtils.swapInteger(n);
        return n;
    }

    public float readFloatLE() throws IOException {
        float f = super.readFloat();
        f = EndianUtils.swapFloat(f);
        return f;
    }

    public long readLongLE() throws IOException {
        long l = super.readLong();
        l = EndianUtils.swapLong(l);
        return l;
    }

    public double readDoubleLE() throws IOException {
        double d = super.readDouble();
        d = EndianUtils.swapDouble(d);
        return d;
    }

    public void writeShortLE(short s) throws IOException {
        s = EndianUtils.swapShort(s);
        super.writeShort(s);
    }

    public void writeIntLE(int n) throws IOException {
        n = EndianUtils.swapInteger(n);
        super.writeInt(n);
    }

    public void writeFloatLE(float f) throws IOException {
        f = EndianUtils.swapFloat(f);
        super.writeFloat(f);
    }

    public void writeLongLE(long l) throws IOException {
        l = EndianUtils.swapLong(l);
        super.writeLong(l);
    }

    public void writeDoubleLE(double d) throws IOException {
        d = EndianUtils.swapDouble(d);
        super.writeDouble(d);
    }
}

