/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.IllegalAddException;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.filter.Filter;

final class ContentList
extends AbstractList
implements Serializable {
    private static final String CVS_ID = "@(#) $RCSfile: ContentList.java,v $ $Revision: 1.39 $ $Date: 2004/02/28 03:30:27 $ $Name: jdom_1_0 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    private static final int CREATE = 0;
    private static final int HASPREV = 1;
    private static final int HASNEXT = 2;
    private static final int PREV = 3;
    private static final int NEXT = 4;
    private static final int ADD = 5;
    private static final int REMOVE = 6;
    private Content[] elementData;
    private int size;
    private Parent parent;

    ContentList(Parent parent) {
        this.parent = parent;
    }

    final void uncheckedAddContent(Content content) {
        content.parent = this.parent;
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = content;
        ++this.modCount;
    }

    public void add(int n, Object object) {
        if (object == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (!(object instanceof Content)) {
            throw new IllegalAddException("Class " + object.getClass().getName() + " is of unrecognized type and cannot be added");
        }
        this.add(n, (Content)object);
    }

    private void documentCanContain(int n, Content content) throws IllegalAddException {
        if (content instanceof Element) {
            if (this.indexOfFirstElement() >= 0) {
                throw new IllegalAddException("Cannot add a second root element, only one is allowed");
            }
            if (this.indexOfDocType() > n) {
                throw new IllegalAddException("A root element cannot be added before the DocType");
            }
        }
        if (content instanceof DocType) {
            if (this.indexOfDocType() >= 0) {
                throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
            }
            int n2 = this.indexOfFirstElement();
            if (n2 != -1 && n2 < n) {
                throw new IllegalAddException("A DocType cannot be added after the root element");
            }
        }
        if (content instanceof CDATA) {
            throw new IllegalAddException("A CDATA is not allowed at the document root");
        }
        if (content instanceof Text) {
            throw new IllegalAddException("A Text is not allowed at the document root");
        }
        if (content instanceof EntityRef) {
            throw new IllegalAddException("An EntityRef is not allowed at the document root");
        }
    }

    private static void elementCanContain(int n, Content content) throws IllegalAddException {
        if (content instanceof DocType) {
            throw new IllegalAddException("A DocType is not allowed except at the document level");
        }
    }

    void add(int n, Content content) {
        if (content == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (this.parent instanceof Document) {
            this.documentCanContain(n, content);
        } else {
            ContentList.elementCanContain(n, content);
        }
        if (content.getParent() != null) {
            Parent parent = content.getParent();
            if (parent instanceof Document) {
                throw new IllegalAddException((Element)content, "The Content already has an existing parent document");
            }
            throw new IllegalAddException("The Content already has an existing parent \"" + ((Element)parent).getQualifiedName() + "\"");
        }
        if (content == this.parent) {
            throw new IllegalAddException("The Element cannot be added to itself");
        }
        if (this.parent instanceof Element && content instanceof Element && ((Element)content).isAncestor((Element)this.parent)) {
            throw new IllegalAddException("The Element cannot be added as a descendent of itself");
        }
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        content.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (n == this.size) {
            this.elementData[this.size++] = content;
        } else {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
            this.elementData[n] = content;
            ++this.size;
        }
        ++this.modCount;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        this.ensureCapacity(this.size() + collection.size());
        int n2 = 0;
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.add(n + n2, e);
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            for (int i = 0; i < n2; ++i) {
                this.remove(n);
            }
            throw runtimeException;
        }
        return true;
    }

    public void clear() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                Content content = this.elementData[i];
                ContentList.removeParent(content);
            }
            this.elementData = null;
            this.size = 0;
        }
        ++this.modCount;
    }

    void clearAndSet(Collection collection) {
        Content[] contentArray = this.elementData;
        int n = this.size;
        this.elementData = null;
        this.size = 0;
        if (collection != null && collection.size() != 0) {
            this.ensureCapacity(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException runtimeException) {
                this.elementData = contentArray;
                this.size = n;
                throw runtimeException;
            }
        }
        if (contentArray != null) {
            for (int i = 0; i < n; ++i) {
                ContentList.removeParent(contentArray[i]);
            }
        }
        ++this.modCount;
    }

    void ensureCapacity(int n) {
        if (this.elementData == null) {
            this.elementData = new Content[Math.max(n, 5)];
        } else {
            int n2 = this.elementData.length;
            if (n > n2) {
                Content[] contentArray = this.elementData;
                int n3 = n2 * 3 / 2 + 1;
                if (n3 < n) {
                    n3 = n;
                }
                this.elementData = new Content[n3];
                System.arraycopy(contentArray, 0, this.elementData, 0, this.size);
            }
        }
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        return this.elementData[n];
    }

    List getView(Filter filter) {
        return new FilterList(filter);
    }

    int indexOfFirstElement() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof Element)) continue;
                return i;
            }
        }
        return -1;
    }

    int indexOfDocType() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof DocType)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        Content content = this.elementData[n];
        ContentList.removeParent(content);
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        ++this.modCount;
        return content;
    }

    private static void removeParent(Content content) {
        content.setParent(null);
    }

    public Object set(int n, Object object) {
        int n2;
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        if (object instanceof Element && this.parent instanceof Document && (n2 = this.indexOfFirstElement()) >= 0 && n2 != n) {
            throw new IllegalAddException("Cannot add a second root element, only one is allowed");
        }
        if (object instanceof DocType && this.parent instanceof Document && (n2 = this.indexOfDocType()) >= 0 && n2 != n) {
            throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
        }
        Object object2 = this.remove(n);
        try {
            this.add(n, object);
        }
        catch (RuntimeException runtimeException) {
            this.add(n, object2);
            throw runtimeException;
        }
        return object2;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return super.toString();
    }

    private int getModCount() {
        return this.modCount;
    }

    class FilterListIterator
    implements ListIterator {
        Filter filter;
        int lastOperation;
        int initialCursor;
        int cursor;
        int last;
        int expected;

        FilterListIterator(Filter filter, int n) {
            this.filter = filter;
            this.initialCursor = this.initializeCursor(n);
            this.last = -1;
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 0;
        }

        public boolean hasNext() {
            this.checkConcurrentModification();
            switch (this.lastOperation) {
                case 0: {
                    this.cursor = this.initialCursor;
                    break;
                }
                case 3: {
                    this.cursor = this.last;
                    break;
                }
                case 4: 
                case 5: {
                    this.cursor = this.moveForward(this.last + 1);
                    break;
                }
                case 6: {
                    this.cursor = this.moveForward(this.last);
                    break;
                }
                case 1: {
                    this.cursor = this.moveForward(this.cursor + 1);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation");
                }
            }
            if (this.lastOperation != 0) {
                this.lastOperation = 2;
            }
            return this.cursor < ContentList.this.size();
        }

        public Object next() {
            this.checkConcurrentModification();
            if (!this.hasNext()) {
                this.last = ContentList.this.size();
                throw new NoSuchElementException();
            }
            this.last = this.cursor;
            this.lastOperation = 4;
            return ContentList.this.get(this.last);
        }

        public boolean hasPrevious() {
            this.checkConcurrentModification();
            switch (this.lastOperation) {
                case 0: {
                    this.cursor = this.initialCursor;
                    int n = ContentList.this.size();
                    if (this.cursor < n) break;
                    this.cursor = this.moveBackward(n - 1);
                    break;
                }
                case 3: 
                case 6: {
                    this.cursor = this.moveBackward(this.last - 1);
                    break;
                }
                case 2: {
                    this.cursor = this.moveBackward(this.cursor - 1);
                    break;
                }
                case 4: 
                case 5: {
                    this.cursor = this.last;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation");
                }
            }
            if (this.lastOperation != 0) {
                this.lastOperation = 1;
            }
            return this.cursor >= 0;
        }

        public Object previous() {
            this.checkConcurrentModification();
            if (!this.hasPrevious()) {
                this.last = -1;
                throw new NoSuchElementException();
            }
            this.last = this.cursor;
            this.lastOperation = 3;
            return ContentList.this.get(this.last);
        }

        public int nextIndex() {
            this.checkConcurrentModification();
            this.hasNext();
            int n = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                if (!this.filter.matches(ContentList.this.get(i))) continue;
                if (i == this.cursor) {
                    return n;
                }
                ++n;
            }
            this.expected = ContentList.this.getModCount();
            return n;
        }

        public int previousIndex() {
            this.checkConcurrentModification();
            if (this.hasPrevious()) {
                int n = 0;
                for (int i = 0; i < ContentList.this.size(); ++i) {
                    if (!this.filter.matches(ContentList.this.get(i))) continue;
                    if (i == this.cursor) {
                        return n;
                    }
                    ++n;
                }
            }
            return -1;
        }

        public void add(Object object) {
            this.checkConcurrentModification();
            if (!this.filter.matches(object)) {
                throw new IllegalAddException("Filter won't allow add of " + object.getClass().getName());
            }
            this.last = this.cursor + 1;
            ContentList.this.add(this.last, object);
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 5;
        }

        public void remove() {
            this.checkConcurrentModification();
            if (this.last < 0 || this.lastOperation == 6) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (this.lastOperation == 5) {
                throw new IllegalStateException("cannot call remove() after add()");
            }
            Object object = ContentList.this.get(this.last);
            if (!this.filter.matches(object)) {
                throw new IllegalAddException("Filter won't allow " + object.getClass().getName() + " (index " + this.last + ") to be removed");
            }
            ContentList.this.remove(this.last);
            this.expected = ContentList.this.getModCount();
            this.lastOperation = 6;
        }

        public void set(Object object) {
            this.checkConcurrentModification();
            if (this.lastOperation == 5 || this.lastOperation == 6) {
                throw new IllegalStateException("cannot call set() after add() or remove()");
            }
            if (this.last < 0) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (this.filter.matches(object)) {
                Object object2 = ContentList.this.get(this.last);
                if (!this.filter.matches(object2)) {
                    throw new IllegalAddException("Filter won't allow " + object2.getClass().getName() + " (index " + this.last + ") to be removed");
                }
            } else {
                throw new IllegalAddException("Filter won't allow index " + this.last + " to be set to " + object.getClass().getName());
            }
            ContentList.this.set(this.last, object);
            this.expected = ContentList.this.getModCount();
        }

        private int initializeCursor(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n);
            }
            int n2 = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                Object object = ContentList.this.get(i);
                if (!this.filter.matches(object)) continue;
                if (n == n2) {
                    return i;
                }
                ++n2;
            }
            if (n > n2) {
                throw new IndexOutOfBoundsException("Index: " + n + " Size: " + n2);
            }
            return ContentList.this.size();
        }

        private int moveForward(int n) {
            if (n < 0) {
                n = 0;
            }
            for (int i = n; i < ContentList.this.size(); ++i) {
                Object object = ContentList.this.get(i);
                if (!this.filter.matches(object)) continue;
                return i;
            }
            return ContentList.this.size();
        }

        private int moveBackward(int n) {
            if (n >= ContentList.this.size()) {
                n = ContentList.this.size() - 1;
            }
            for (int i = n; i >= 0; --i) {
                Object object = ContentList.this.get(i);
                if (!this.filter.matches(object)) continue;
                return i;
            }
            return -1;
        }

        private void checkConcurrentModification() {
            if (this.expected != ContentList.this.getModCount()) {
                throw new ConcurrentModificationException();
            }
        }
    }

    class FilterList
    extends AbstractList
    implements Serializable {
        Filter filter;
        int count = 0;
        int expected = -1;

        FilterList(Filter filter) {
            this.filter = filter;
        }

        public void add(int n, Object object) {
            if (this.filter.matches(object)) {
                int n2 = this.getAdjustedIndex(n);
                ContentList.this.add(n2, object);
                ++this.expected;
                ++this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + object.getClass().getName() + " '" + object + "' to be added to the list");
            }
        }

        public Object get(int n) {
            int n2 = this.getAdjustedIndex(n);
            return ContentList.this.get(n2);
        }

        public Iterator iterator() {
            return new FilterListIterator(this.filter, 0);
        }

        public ListIterator listIterator() {
            return new FilterListIterator(this.filter, 0);
        }

        public ListIterator listIterator(int n) {
            return new FilterListIterator(this.filter, n);
        }

        public Object remove(int n) {
            int n2 = this.getAdjustedIndex(n);
            Object object = ContentList.this.get(n2);
            if (this.filter.matches(object)) {
                object = ContentList.this.remove(n2);
                ++this.expected;
                --this.count;
            } else {
                throw new IllegalAddException("Filter won't allow the " + object.getClass().getName() + " '" + object + "' (index " + n + ") to be removed");
            }
            return object;
        }

        public Object set(int n, Object object) {
            Object object2 = null;
            if (this.filter.matches(object)) {
                int n2 = this.getAdjustedIndex(n);
                object2 = ContentList.this.get(n2);
                if (!this.filter.matches(object2)) {
                    throw new IllegalAddException("Filter won't allow the " + object2.getClass().getName() + " '" + object2 + "' (index " + n + ") to be removed");
                }
                object2 = ContentList.this.set(n2, object);
                this.expected += 2;
            } else {
                throw new IllegalAddException("Filter won't allow index " + n + " to be set to " + object.getClass().getName());
            }
            return object2;
        }

        public int size() {
            if (this.expected == ContentList.this.getModCount()) {
                return this.count;
            }
            this.count = 0;
            for (int i = 0; i < ContentList.this.size(); ++i) {
                Content content = ContentList.this.elementData[i];
                if (!this.filter.matches(content)) continue;
                ++this.count;
            }
            this.expected = ContentList.this.getModCount();
            return this.count;
        }

        private final int getAdjustedIndex(int n) {
            int n2 = 0;
            for (int i = 0; i < ContentList.this.size; ++i) {
                Content content = ContentList.this.elementData[i];
                if (!this.filter.matches(content)) continue;
                if (n == n2) {
                    return i;
                }
                ++n2;
            }
            if (n == n2) {
                return ContentList.this.size;
            }
            return ContentList.this.size + 1;
        }
    }
}

