/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share;

import org.tritonus.share.TDebug;

public class TCircularBuffer {
    private boolean m_bBlockingRead;
    private boolean m_bBlockingWrite;
    private byte[] m_abData;
    private int m_nSize;
    private int m_nReadPos;
    private int m_nWritePos;
    private Trigger m_trigger;
    private boolean m_bOpen;

    public TCircularBuffer(int n, boolean bl, boolean bl2, Trigger trigger) {
        this.m_bBlockingRead = bl;
        this.m_bBlockingWrite = bl2;
        this.m_nSize = n;
        this.m_abData = new byte[this.m_nSize];
        this.m_nReadPos = 0;
        this.m_nWritePos = 0;
        this.m_trigger = trigger;
        this.m_bOpen = true;
    }

    public void close() {
        this.m_bOpen = false;
    }

    private boolean isOpen() {
        return this.m_bOpen;
    }

    public int availableRead() {
        return this.m_nWritePos - this.m_nReadPos;
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private int getReadPos() {
        return this.m_nReadPos % this.m_nSize;
    }

    private int getWritePos() {
        return this.m_nWritePos % this.m_nSize;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.read(): called.");
            this.dumpInternalState();
        }
        if (!this.isOpen()) {
            if (this.availableRead() > 0) {
                n2 = Math.min(n2, this.availableRead());
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("reading rest in closed buffer, length: " + n2);
                }
            } else {
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("< not open. returning -1.");
                }
                return -1;
            }
        }
        TCircularBuffer tCircularBuffer = this;
        synchronized (tCircularBuffer) {
            if (this.m_trigger != null && this.availableRead() < n2) {
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("executing trigger.");
                }
                this.m_trigger.execute();
            }
            if (!this.m_bBlockingRead) {
                n2 = Math.min(this.availableRead(), n2);
            }
            int n3 = n2;
            while (n3 > 0) {
                while (this.availableRead() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(interruptedException);
                    }
                }
                int n4 = Math.min(this.availableRead(), n3);
                while (n4 > 0) {
                    int n5 = Math.min(n4, this.m_nSize - this.getReadPos());
                    System.arraycopy(this.m_abData, this.getReadPos(), byArray, n, n5);
                    this.m_nReadPos += n5;
                    n += n5;
                    n4 -= n5;
                    n3 -= n5;
                }
                this.notifyAll();
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After read:");
                this.dumpInternalState();
                TDebug.out("< completed. Read " + n2 + " bytes");
            }
            return n2;
        }
    }

    public int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] byArray, int n, int n2) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.write(): called; nLength: " + n2);
            this.dumpInternalState();
        }
        TCircularBuffer tCircularBuffer = this;
        synchronized (tCircularBuffer) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("entered synchronized block.");
            }
            if (!this.m_bBlockingWrite) {
                n2 = Math.min(this.availableWrite(), n2);
            }
            int n3 = n2;
            while (n3 > 0) {
                while (this.availableWrite() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(interruptedException);
                    }
                }
                int n4 = Math.min(this.availableWrite(), n3);
                while (n4 > 0) {
                    int n5 = Math.min(n4, this.m_nSize - this.getWritePos());
                    System.arraycopy(byArray, n, this.m_abData, this.getWritePos(), n5);
                    this.m_nWritePos += n5;
                    n += n5;
                    n4 -= n5;
                    n3 -= n5;
                }
                this.notifyAll();
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After write:");
                this.dumpInternalState();
                TDebug.out("< completed. Wrote " + n2 + " bytes");
            }
            return n2;
        }
    }

    private void dumpInternalState() {
        TDebug.out("m_nReadPos  = " + this.m_nReadPos + " ^= " + this.getReadPos());
        TDebug.out("m_nWritePos = " + this.m_nWritePos + " ^= " + this.getWritePos());
        TDebug.out("availableRead()  = " + this.availableRead());
        TDebug.out("availableWrite() = " + this.availableWrite());
    }

    public static interface Trigger {
        public void execute();
    }
}

