/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditorInternalPanel;
import edu.xtec.jclic.ActivityEditorPanel;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.beans.GradientButton;
import edu.xtec.jclic.beans.ImgButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class ActivityEditorFramePanel
extends ActivityEditorInternalPanel {
    MediaBagEditor mediaBagEditor;
    private JRadioButton absoluteBtn;
    private ColorButton actBgColorBtn;
    private GradientButton actGradientButton;
    private ColorButton bgColorBtn;
    private JCheckBox borderChk;
    private JRadioButton centeredBtn;
    private GradientButton gradientButton;
    private ImgButton imgButton;
    private ButtonGroup locationGroup;
    private JLabel locationLb;
    private SmallIntEditor marginInt;
    private JPanel previewPanel;
    private JCheckBox tiledBgImgChk;
    private JCheckBox transpChk;
    private SmallIntEditor xInt;
    private SmallIntEditor yInt;

    public ActivityEditorFramePanel(ActivityEditorPanel activityEditorPanel) {
        super(activityEditorPanel);
        this.initComponents();
        this.setEnabled(false);
    }

    private void initComponents() {
        this.locationGroup = new ButtonGroup();
        JPanel jPanel = new JPanel();
        this.previewPanel = new PreviewPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.bgColorBtn = new ColorButton();
        this.bgColorBtn.setOptions(this.options);
        JLabel jLabel2 = new JLabel();
        this.gradientButton = new GradientButton();
        this.gradientButton.setOptions(this.options);
        JLabel jLabel3 = new JLabel();
        this.imgButton = new ImgButton();
        this.imgButton.setOptions(this.options);
        this.tiledBgImgChk = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.actBgColorBtn = new ColorButton();
        this.actBgColorBtn.setOptions(this.options);
        JLabel jLabel5 = new JLabel();
        this.actGradientButton = new GradientButton();
        this.actGradientButton.setOptions(this.options);
        this.transpChk = new JCheckBox();
        this.borderChk = new JCheckBox();
        JLabel jLabel6 = new JLabel();
        this.marginInt = new SmallIntEditor();
        JLabel jLabel7 = new JLabel();
        this.locationLb = new JLabel();
        this.centeredBtn = new JRadioButton();
        this.absoluteBtn = new JRadioButton();
        JLabel jLabel8 = new JLabel();
        this.xInt = new SmallIntEditor();
        JLabel jLabel9 = new JLabel();
        this.yInt = new SmallIntEditor();
        this.setLayout(new GridBagLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(this.options.getMsg("edit_act_preview")));
        this.previewPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        jPanel.add((Component)this.previewPanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jPanel, gridBagConstraints);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(this.options.getMsg("edit_act_mainWindow")));
        jLabel.setLabelFor(this.bgColorBtn);
        jLabel.setText(this.options.getMsg("edit_act_bgColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.bgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.bgColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.bgColorBtn, gridBagConstraints);
        jLabel2.setLabelFor(this.gradientButton);
        jLabel2.setText(this.options.getMsg("edit_act_gradient"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.gradientButton.setToolTipText(this.options.getMsg("edit_act_gradient_tooltip"));
        this.gradientButton.addPropertyChangeListener("gradient", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.gradientButton, gridBagConstraints);
        jLabel3.setLabelFor(this.imgButton);
        jLabel3.setText(this.options.getMsg("edit_act_image"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.imgButton.setToolTipText(this.options.getMsg("edit_act_image_tooltip"));
        this.imgButton.addPropertyChangeListener("imageName", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.imgButton, gridBagConstraints);
        this.tiledBgImgChk.setToolTipText(this.options.getMsg("edit_act_tiledBgImg_tooltip"));
        this.tiledBgImgChk.setText(this.options.getMsg("edit_act_tiledBgImg"));
        this.tiledBgImgChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.tiledBgImgChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jPanel2, gridBagConstraints);
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(this.options.getMsg("edit_act_gameWindow")));
        jLabel4.setLabelFor(this.actBgColorBtn);
        jLabel4.setText(this.options.getMsg("edit_act_bgColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)jLabel4, gridBagConstraints);
        this.actBgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.actBgColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.actBgColorBtn, gridBagConstraints);
        jLabel5.setLabelFor(this.actGradientButton);
        jLabel5.setText(this.options.getMsg("edit_act_gradient"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)jLabel5, gridBagConstraints);
        this.actGradientButton.setToolTipText(this.options.getMsg("edit_act_gradient_tooltip"));
        this.actGradientButton.addPropertyChangeListener("gradient", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.actGradientButton, gridBagConstraints);
        this.transpChk.setToolTipText(this.options.getMsg("edit_act_transparent_tooltip"));
        this.transpChk.setText(this.options.getMsg("edit_act_transparent"));
        this.transpChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this.transpChk, gridBagConstraints);
        this.borderChk.setToolTipText(this.options.getMsg("edit_act_border_tooltip"));
        this.borderChk.setText(this.options.getMsg("edit_act_border"));
        this.borderChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.borderChk, gridBagConstraints);
        jLabel6.setLabelFor(this.marginInt);
        jLabel6.setText(this.options.getMsg("edit_act_margin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)jLabel6, gridBagConstraints);
        this.marginInt.setToolTipText(this.options.getMsg("edit_act_margin_tooltip"));
        this.marginInt.setMax(999);
        this.marginInt.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.marginInt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)jLabel7, gridBagConstraints);
        this.locationLb.setText(this.options.getMsg("edit_act_location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)this.locationLb, gridBagConstraints);
        this.centeredBtn.setToolTipText(this.options.getMsg("edit_act_centered_tooltip"));
        this.centeredBtn.setSelected(true);
        this.centeredBtn.setText(this.options.getMsg("edit_act_centered"));
        this.locationGroup.add(this.centeredBtn);
        this.centeredBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.centeredBtn, gridBagConstraints);
        this.absoluteBtn.setToolTipText(this.options.getMsg("edit_act_absolute_tooltip"));
        this.absoluteBtn.setText(this.options.getMsg("edit_act_absolute"));
        this.locationGroup.add(this.absoluteBtn);
        this.absoluteBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.absoluteBtn, gridBagConstraints);
        jLabel8.setLabelFor(this.xInt);
        jLabel8.setText(this.options.getMsg("edit_act_x"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)jLabel8, gridBagConstraints);
        this.xInt.setToolTipText(this.options.getMsg("edit_act_x_tooltip"));
        this.xInt.setMax(999);
        this.xInt.setMin(-999);
        this.xInt.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.xInt, gridBagConstraints);
        jLabel9.setLabelFor(this.yInt);
        jLabel9.setText(this.options.getMsg("edit_act_y"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)jLabel9, gridBagConstraints);
        this.yInt.setToolTipText(this.options.getMsg("edit_act_y_tooltip"));
        this.yInt.setMax(999);
        this.yInt.setMin(-999);
        this.yInt.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this.yInt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jPanel3, gridBagConstraints);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.marginInt.setEnabled(bl);
        this.bgColorBtn.setEnabled(bl);
        this.gradientButton.setEnabled(bl);
        this.imgButton.setEnabled(bl);
        this.tiledBgImgChk.setEnabled(bl && this.imgButton.getObject() != null);
        this.borderChk.setEnabled(bl);
        this.transpChk.setEnabled(bl);
        this.actBgColorBtn.setEnabled(bl);
        this.actGradientButton.setEnabled(bl);
        this.absoluteBtn.setEnabled(bl);
        this.centeredBtn.setEnabled(bl);
        this.xInt.setEnabled(bl && this.absoluteBtn.isSelected());
        this.yInt.setEnabled(bl && this.absoluteBtn.isSelected());
    }

    public boolean eventPerformed(EventObject eventObject) {
        Object object;
        Object object2 = object = eventObject == null ? null : eventObject.getSource();
        if (object == null || object == this.imgButton) {
            this.tiledBgImgChk.setEnabled(this.imgButton.getObject() != null);
        }
        if (object == null || object == this.centeredBtn || object == this.absoluteBtn) {
            this.xInt.setEnabled(this.absoluteBtn.isSelected());
            this.yInt.setEnabled(this.absoluteBtn.isSelected());
        }
        ((PreviewPanel)this.previewPanel).reset();
        return eventObject != null;
    }

    public void fillData() {
        Activity activity = this.getActivity();
        this.marginInt.setValue(activity == null ? 8 : activity.margin);
        this.mediaBagEditor = activity == null ? null : this.getActivityEditor().getMediaBagEditor();
        this.bgColorBtn.setColor(activity == null ? Activity.DEFAULT_BG_COLOR : activity.bgColor);
        this.gradientButton.setGradient(activity == null ? null : activity.bgGradient);
        this.imgButton.setMediaBagEditor(this.mediaBagEditor);
        this.imgButton.setImgName(activity == null ? null : activity.bgImageFile);
        this.tiledBgImgChk.setSelected(activity == null ? true : activity.tiledBgImg || activity.bgImageFile == null);
        ((PreviewPanel)this.previewPanel).reset();
        this.borderChk.setSelected(activity == null ? true : activity.border);
        this.transpChk.setSelected(activity == null ? false : activity.transparentBg);
        this.actBgColorBtn.setColor(activity == null ? Activity.DEFAULT_BG_COLOR : activity.activityBgColor);
        this.actGradientButton.setGradient(activity == null ? null : activity.activityBgGradient);
        this.absoluteBtn.setSelected(activity == null ? false : activity.absolutePositioned);
        this.centeredBtn.setSelected(activity == null ? true : !activity.absolutePositioned);
        if (activity != null && activity.absolutePosition != null) {
            this.xInt.setValue(activity.absolutePosition.x);
            this.yInt.setValue(activity.absolutePosition.y);
        } else {
            this.xInt.setValue(0);
            this.yInt.setValue(0);
        }
        this.eventPerformed(null);
    }

    public void saveData() {
        Activity activity = this.getActivity();
        if (activity != null) {
            activity.margin = this.marginInt.getValue();
            activity.bgColor = this.bgColorBtn.getColor();
            activity.bgGradient = this.gradientButton.getGradient();
            activity.bgImageFile = this.imgButton.getImgName();
            activity.tiledBgImg = this.tiledBgImgChk.isSelected() && activity.bgImageFile != null;
            activity.border = this.borderChk.isSelected();
            activity.transparentBg = this.transpChk.isSelected();
            activity.activityBgColor = this.actBgColorBtn.getColor();
            activity.activityBgGradient = this.actGradientButton.getGradient();
            activity.absolutePositioned = this.absoluteBtn.isSelected();
            activity.absolutePosition = activity.absolutePositioned ? new Point(this.xInt.getValue(), this.yInt.getValue()) : null;
        }
    }

    protected Icon getIcon() {
        return ResourceManager.getImageIcon("icons/frame.gif");
    }

    protected String getTitle() {
        return this.options.getMsg("edit_act_panels_frame");
    }

    protected String getTooltip() {
        return this.options.getMsg("edit_act_panels_frame_tooltip");
    }

    class PreviewPanel
    extends JPanel {
        InnerPreviewPane innerPane;
        Image bgImage;
        boolean tiledBgImg;
        Gradient bgGradient;
        Gradient actBgGradient;
        Point bgImageOrigin = new Point();
        double scale = 1.0;

        PreviewPanel() {
            this.setLayout(null);
            this.innerPane = new InnerPreviewPane();
            this.add(this.innerPane);
        }

        public void reset() {
            this.bgImage = null;
            this.bgGradient = null;
            this.actBgGradient = null;
            this.bgImage = null;
            this.tiledBgImg = true;
            if (ActivityEditorFramePanel.this.mediaBagEditor != null) {
                String string = ActivityEditorFramePanel.this.imgButton.getImgName();
                if (string != null) {
                    try {
                        this.bgImage = ActivityEditorFramePanel.this.mediaBagEditor.getMediaBag().getImageElement(string).getImage();
                    }
                    catch (Exception exception) {
                        ActivityEditorFramePanel.this.options.getMessages().showErrorWarning(this, "ERROR", exception);
                    }
                }
                this.tiledBgImg = ActivityEditorFramePanel.this.tiledBgImgChk.isSelected();
            }
            this.innerPane.setBorder(ActivityEditorFramePanel.this.borderChk.isSelected() ? BorderFactory.createBevelBorder(0) : BorderFactory.createEmptyBorder());
            this.innerPane.setOpaque(!ActivityEditorFramePanel.this.transpChk.isSelected());
            this.innerPane.setBackground(ActivityEditorFramePanel.this.actBgColorBtn.getColor());
            this.actBgGradient = ActivityEditorFramePanel.this.actGradientButton.getGradient();
            this.bgGradient = ActivityEditorFramePanel.this.gradientButton.getGradient();
            this.setBackground(ActivityEditorFramePanel.this.bgColorBtn.getColor());
            this.revalidate();
            this.repaint();
        }

        public void doLayout() {
            this.scale = 1.0;
            this.bgImageOrigin.x = 0;
            this.bgImageOrigin.y = 0;
            Rectangle rectangle = this.getBounds();
            int n = ActivityEditorFramePanel.this.marginInt.getValue();
            Rectangle rectangle2 = new Rectangle(n, n, rectangle.width - 2 * n, rectangle.height - 2 * n);
            if (this.bgImage != null && !this.tiledBgImg) {
                int n2 = this.bgImage.getWidth(this);
                int n3 = this.bgImage.getHeight(this);
                if (n2 > 0 && n3 > 0 && (n2 > this.getWidth() || n3 > this.getHeight())) {
                    this.scale = Math.min((double)this.getWidth() / (double)n2, (double)this.getHeight() / (double)n3);
                    n2 = (int)(this.scale * (double)n2);
                    n3 = (int)(this.scale * (double)n3);
                } else {
                    this.scale = 1.0;
                }
                this.bgImageOrigin.x = (this.getWidth() - n2) / 2;
                this.bgImageOrigin.y = (this.getHeight() - n3) / 2;
                if (ActivityEditorFramePanel.this.absoluteBtn.isSelected()) {
                    rectangle2.x = this.bgImageOrigin.x;
                    rectangle2.y = this.bgImageOrigin.y;
                    rectangle2.width -= this.bgImageOrigin.x - n;
                    rectangle2.height -= this.bgImageOrigin.y - n;
                    rectangle2.width = Math.min(rectangle2.width, rectangle.width);
                    rectangle2.height = Math.min(rectangle2.height, rectangle.height);
                }
            }
            this.innerPane.fitTo(rectangle2, rectangle);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            if (this.bgGradient == null || this.bgGradient.hasTransparency()) {
                super.paintComponent(graphics);
            }
            if (this.bgGradient != null || this.bgImage != null) {
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
                if (this.bgGradient != null) {
                    this.bgGradient.paint(graphics2D, rectangle);
                }
                if (this.bgImage != null) {
                    Rectangle rectangle2 = new Rectangle(0, 0, this.bgImage.getWidth(this), this.bgImage.getHeight(this));
                    Rectangle rectangle3 = graphics2D.getClipBounds();
                    if (!this.tiledBgImg) {
                        rectangle2.setLocation(this.bgImageOrigin);
                        if (rectangle2.intersects(rectangle3)) {
                            if (this.scale == 1.0) {
                                graphics2D.drawImage(this.bgImage, this.bgImageOrigin.x, this.bgImageOrigin.y, this);
                            } else {
                                int n = this.bgImage.getWidth(this);
                                int n2 = this.bgImage.getHeight(this);
                                int n3 = (int)(this.scale * (double)n);
                                int n4 = (int)(this.scale * (double)n2);
                                graphics2D.drawImage(this.bgImage, this.bgImageOrigin.x, this.bgImageOrigin.y, this.bgImageOrigin.x + n3, this.bgImageOrigin.y + n4, 0, 0, n, n2, this);
                            }
                        }
                    } else {
                        Utils.tileImage(graphics2D, this.bgImage, rectangle, rectangle2, this);
                    }
                }
                graphics2D.setRenderingHints(renderingHints);
            }
        }

        class InnerPreviewPane
        extends JPanel {
            InnerPreviewPane() {
                this.setLayout(null);
            }

            public void fitTo(Rectangle rectangle, Rectangle rectangle2) {
                Activity activity = ActivityEditorFramePanel.this.getActivity();
                Dimension dimension = new Dimension(activity == null ? 400 : activity.getWindowSize().width, activity == null ? 300 : activity.getWindowSize().height);
                int n = Math.max(40, Math.min(rectangle.width, (int)(PreviewPanel.this.scale * (double)dimension.width)));
                int n2 = Math.max(40, Math.min(rectangle.height, (int)(PreviewPanel.this.scale * (double)dimension.height)));
                boolean bl = ActivityEditorFramePanel.this.centeredBtn.isSelected();
                int n3 = (bl ? 0 : PreviewPanel.this.bgImageOrigin.x) + Math.max(0, bl ? rectangle.x + (rectangle.width - n) / 2 : (int)(PreviewPanel.this.scale * (double)ActivityEditorFramePanel.this.xInt.getValue()));
                int n4 = (bl ? 0 : PreviewPanel.this.bgImageOrigin.y) + Math.max(0, bl ? rectangle.y + (rectangle.height - n2) / 2 : (int)(PreviewPanel.this.scale * (double)ActivityEditorFramePanel.this.yInt.getValue()));
                if (n3 > rectangle2.width - 40) {
                    n3 = rectangle2.width - 40;
                }
                if (n3 + n > rectangle2.width) {
                    n = rectangle2.width - n3;
                }
                if (n4 > rectangle2.height - 40) {
                    n4 = rectangle2.height - 40;
                }
                if (n4 + n2 > rectangle2.height) {
                    n2 = rectangle2.height - n4;
                }
                this.setBounds(n3, n4, n, n2);
            }

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                if (!this.isOpaque() || PreviewPanel.this.actBgGradient == null || PreviewPanel.this.actBgGradient.hasTransparency()) {
                    super.paintComponent(graphics);
                }
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                if (this.isOpaque() && PreviewPanel.this.actBgGradient != null) {
                    graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
                    PreviewPanel.this.actBgGradient.paint(graphics2D, rectangle);
                }
                if (ActivityEditorFramePanel.this.getActivityEditor() != null) {
                    ActivityEditorFramePanel.this.getActivityEditor().drawPreview(graphics2D, rectangle, ActivityEditorFramePanel.this.marginInt.getValue());
                }
                graphics2D.setRenderingHints(renderingHints);
            }
        }
    }
}

