/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.ActivityEditor;
import edu.xtec.jclic.ActivityEditorInternalPanel;
import edu.xtec.jclic.activities.text.TextActivityEditorTextPanel;
import edu.xtec.jclic.boxes.ActiveBagContentEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ActivityEditorPanel
extends EditorPanel {
    Vector internalPanels = new Vector(4);
    String currentActivityClass;
    HashMap panelStore = new HashMap();
    public static final String SINGLE = "SINGLE";
    public static final String SINGLE_ALT = "SINGLE_ALT";
    public static final String SINGLE_BOOL_ALT = "SINGLE_BOOL_ALT";
    public static final String SINGLE_LAYOUT = "SINGLE_LAYOUT";
    public static final String DOUBLE_ALT = "DOUBLE_ALT";
    public static final String DOUBLE_REL = "DOUBLE_REL";
    public static final String DOUBLE_REL_ALT = "DOUBLE_REL_ALT";
    public static final String TEXTGRID_ALT = "TEXTGRID_ALT";
    public static final String TEXTGRID_CRW = "TEXTGRID_CRW";
    public static final String TEXT_BASE = "TEXT_BASE";
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;

    public ActivityEditorPanel(Options options) {
        super(options);
        this.initComponents();
        this.postInit(250, false, false);
        this.setEnabled(false);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Iterator iterator = this.internalPanels.iterator();
        while (iterator.hasNext()) {
            ((ActivityEditorInternalPanel)iterator.next()).setEnabled(bl);
        }
    }

    public void addInternalPanel(ActivityEditorInternalPanel activityEditorInternalPanel, String string, String string2) {
        if (string == null) {
            string = activityEditorInternalPanel.getTitle();
        }
        if (string2 == null) {
            string2 = activityEditorInternalPanel.getTooltip();
        }
        this.tabbedPane.addTab(string, activityEditorInternalPanel.getIcon(), activityEditorInternalPanel, string2);
        this.internalPanels.add(activityEditorInternalPanel);
    }

    public void addInternalPanel(String string, String string2, String string3) {
        ActivityEditorInternalPanel activityEditorInternalPanel = (ActivityEditorInternalPanel)this.panelStore.get(string);
        if (activityEditorInternalPanel == null) {
            if (SINGLE.equals(string)) {
                activityEditorInternalPanel = new ActiveBagContentEditor(this, 0);
                this.panelStore.put(string, activityEditorInternalPanel);
            } else if (SINGLE_LAYOUT.equals(string)) {
                activityEditorInternalPanel = new ActiveBagContentEditor(this, 3);
                this.panelStore.put(string, activityEditorInternalPanel);
            } else if (SINGLE_ALT.equals(string)) {
                activityEditorInternalPanel = new ActiveBagContentEditor(this, 1);
                this.panelStore.put(string, activityEditorInternalPanel);
            } else if (SINGLE_BOOL_ALT.equals(string)) {
                activityEditorInternalPanel = new ActiveBagContentEditor(this, 2);
                this.panelStore.put(string, activityEditorInternalPanel);
            } else if (DOUBLE_ALT.equals(string)) {
                activityEditorInternalPanel = new ActiveBagContentEditor(this, 4);
                this.panelStore.put(string, activityEditorInternalPanel);
            } else if (DOUBLE_REL.equals(string)) {
                activityEditorInternalPanel = new ActiveBagContentEditor(this, 5);
                this.panelStore.put(string, activityEditorInternalPanel);
            } else if (DOUBLE_REL_ALT.equals(string)) {
                activityEditorInternalPanel = new ActiveBagContentEditor(this, 6);
                this.panelStore.put(string, activityEditorInternalPanel);
            } else if (TEXTGRID_ALT.equals(string)) {
                activityEditorInternalPanel = new ActiveBagContentEditor(this, 7);
                this.panelStore.put(string, activityEditorInternalPanel);
            } else if (TEXTGRID_CRW.equals(string)) {
                activityEditorInternalPanel = new ActiveBagContentEditor(this, 8);
                this.panelStore.put(string, activityEditorInternalPanel);
            } else if (TEXT_BASE.equals(string)) {
                activityEditorInternalPanel = new TextActivityEditorTextPanel(this);
                this.panelStore.put(string, activityEditorInternalPanel);
            }
        }
        if (activityEditorInternalPanel != null) {
            this.addInternalPanel(activityEditorInternalPanel, string2, string3);
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.setToolTipText(this.options.getMsg("edit_act_descriptionTab_tooltip"));
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.mainPanel, "Center");
    }

    protected synchronized void setEditor(Editor editor) {
        if (editor instanceof ActivityEditor) {
            ActivityEditor activityEditor = (ActivityEditor)editor;
            String string = activityEditor.getActivity().getClass().getName();
            if (!string.equals(this.currentActivityClass)) {
                int n;
                int n2 = Math.max(this.tabbedPane.getSelectedIndex(), 0);
                int n3 = this.tabbedPane.getTabCount();
                for (n = n3 - 1; n >= 3; --n) {
                    this.tabbedPane.remove((Component)this.internalPanels.remove(n));
                }
                activityEditor.createPanels(this);
                n = Math.min(n2, this.internalPanels.size() - 1);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (ActivityEditorPanel.this.internalPanels.size() >= n) {
                            ActivityEditorPanel.this.tabbedPane.setSelectedIndex(n);
                        }
                    }
                });
            }
            this.currentActivityClass = string;
        }
        super.setEditor(editor);
    }

    public boolean checkIfEditorValid(Editor editor) {
        return editor instanceof ActivityEditor;
    }

    protected ActivityEditor getActivityEditor() {
        return (ActivityEditor)this.editor;
    }

    protected Activity getActivity() {
        if (this.editor == null) {
            return null;
        }
        return this.getActivityEditor().getActivity();
    }

    public void fillData() {
        Activity activity = this.getActivity();
        if (activity != null) {
            Iterator iterator = this.internalPanels.iterator();
            while (iterator.hasNext()) {
                ((ActivityEditorInternalPanel)iterator.next()).fillData();
            }
        }
    }

    public void saveData() {
        Activity activity = this.getActivity();
        if (activity != null) {
            Iterator iterator = this.internalPanels.iterator();
            while (iterator.hasNext()) {
                ((ActivityEditorInternalPanel)iterator.next()).saveData();
            }
            this.getActivityEditor().saveData();
        }
    }

    protected Icon getIcon() {
        return ActivityEditor.getIcon();
    }

    protected String getTitle() {
        return "activity";
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.editor != null) {
            this.editor.collectData();
        }
    }
}

