/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivitySequence;
import edu.xtec.jclic.bags.ActivitySequenceEditorPanel;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.ActivitySequenceElementEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.ListComboModel;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ActivitySequenceEditor
extends Editor {
    public static ImageIcon icon;
    protected DefaultListModel tagList;
    private boolean initializing;
    public static boolean actionsCreated;
    public static EditorAction newActivitySequenceElementAction;

    public ActivitySequenceEditor(ActivitySequence activitySequence) {
        super(activitySequence);
    }

    protected void createChildren() {
        this.initializing = true;
        ActivitySequence activitySequence = this.getActivitySequence();
        int n = activitySequence.getSize();
        for (int i = 0; i < n; ++i) {
            activitySequence.getElement(i, false).getEditor(this);
        }
        this.initializing = false;
    }

    public EditorPanel createEditorPanel(Options options) {
        return new ActivitySequenceEditorPanel(options);
    }

    public Class getEditorPanelClass() {
        return ActivitySequenceEditorPanel.class;
    }

    public String getTitleKey() {
        return "edit_sequences";
    }

    public ActivitySequence getActivitySequence() {
        return (ActivitySequence)this.getUserObject();
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/sequence.gif");
        }
        return icon;
    }

    public Icon getIcon(boolean bl, boolean bl2) {
        return ActivitySequenceEditor.getIcon();
    }

    public String toString() {
        return "Activity sequence";
    }

    public Options getOptions() {
        return this.getActivitySequence().getProject().getBridge().getOptions();
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public void removeElementsWith(String string) {
        String string2 = StrUtils.nullableString(string);
        if (string2 != null) {
            int n = 0;
            int n2 = this.getChildCount();
            block0: while (n < n2) {
                n2 = this.getChildCount();
                for (n = 0; n < n2; ++n) {
                    ActivitySequenceElementEditor activitySequenceElementEditor = (ActivitySequenceElementEditor)this.getChildAt(n);
                    if (!string2.equals(activitySequenceElementEditor.getActivitySequenceElement().getActivityName())) continue;
                    this.remove(n);
                    continue block0;
                }
            }
        }
    }

    public boolean createNewSequenceElement(int n, boolean bl, Component component) {
        String string = null;
        String string2 = null;
        Messages messages = this.getOptions().getMessages();
        if (bl) {
            AbstractListModel abstractListModel = this.getProjectEditor().getActivityBagEditor().getListModel();
            if (abstractListModel.getSize() == 0) {
                messages.showAlert(component, "edit_seq_newElement_error_emptyList");
                return false;
            }
            JComboBox jComboBox = new JComboBox(new ListComboModel(this.getProjectEditor().getActivityBagEditor().getListModel()));
            jComboBox.setToolTipText(messages.get("edit_seq_activity_tooltip"));
            JTextField jTextField = new JTextField();
            jTextField.setToolTipText(messages.get("edit_seq_tag_tooltip"));
            JComponent[] jComponentArray = new JComponent[]{jComboBox, jTextField};
            String[] stringArray = new String[]{"edit_seq_activity", "edit_seq_tag"};
            String[] stringArray2 = new String[]{"edit_seq_newElement_msg"};
            if (!messages.showInputDlg(component, stringArray2, stringArray, jComponentArray, "edit_seq_newElement")) {
                return false;
            }
            string = StrUtils.nullableString(jComboBox.getSelectedItem());
            string2 = StrUtils.nullableString(jTextField.getText());
        }
        if (string == null) {
            messages.showAlert(component, "edit_seq_newElement_error_noAct");
            return false;
        }
        return this.createNewSequenceElement(string, string2, n);
    }

    public boolean createNewSequenceElement(String string, String string2, int n) {
        ActivitySequenceElement activitySequenceElement = new ActivitySequenceElement(string);
        if (string2 != null) {
            activitySequenceElement.setTag(string2);
        }
        ActivitySequenceElementEditor activitySequenceElementEditor = (ActivitySequenceElementEditor)activitySequenceElement.getEditor(null);
        n = n < 0 ? this.getChildCount() : Math.min(n, this.getChildCount());
        return this.insertEditor(activitySequenceElementEditor, true, n, true);
    }

    public ListModel getTagList() {
        if (this.tagList == null) {
            this.tagList = new DefaultListModel();
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                ActivitySequenceElementEditor activitySequenceElementEditor = (ActivitySequenceElementEditor)enumeration.nextElement();
                String string = StrUtils.nullableString(activitySequenceElementEditor.getActivitySequenceElement().getTag());
                if (string == null) continue;
                this.tagList.addElement(string);
            }
        }
        return this.tagList;
    }

    public String getTag(String string) {
        String string2 = null;
        this.getTagList();
        Enumeration enumeration = this.tagList.elements();
        while (enumeration.hasMoreElements() && string2 == null) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.equals(string)) continue;
            string2 = string3;
        }
        return string2;
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        super.insert(mutableTreeNode, n);
        if (!this.initializing) {
            String string;
            ActivitySequenceElementEditor activitySequenceElementEditor = (ActivitySequenceElementEditor)mutableTreeNode;
            this.getActivitySequence().insertElementAt(activitySequenceElementEditor.getActivitySequenceElement(), n);
            if (this.tagList != null && (string = activitySequenceElementEditor.getTag()) != null && this.getTag(string) == null) {
                this.tagList.addElement(string);
            }
        }
    }

    public void remove(int n) {
        String string;
        ActivitySequenceElementEditor activitySequenceElementEditor = (ActivitySequenceElementEditor)this.getChildAt(n);
        super.remove(n);
        this.getActivitySequence().remove(activitySequenceElementEditor.getActivitySequenceElement());
        if (this.tagList != null && activitySequenceElementEditor.getTag() != null && (string = this.getTag(activitySequenceElementEditor.getTag())) != null) {
            this.tagList.removeElement(string);
        }
    }

    public boolean nameChanged(int n, String string, String string2) {
        boolean bl = false;
        if ((n & 3) != 0) {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                bl |= ((ActivitySequenceElementEditor)enumeration.nextElement()).nameChanged(n, string, string2);
            }
        }
        return bl;
    }

    public void setActionsOwner() {
        this.allowPaste = false;
        this.allowCopy = false;
        this.allowCut = false;
        this.allowDelete = false;
        super.setActionsOwner();
        if (actionsCreated) {
            newActivitySequenceElementAction.setActionOwner(this);
        }
    }

    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            newActivitySequenceElementAction.setActionOwner(null);
        }
    }

    public static void createActions(Options options) {
        ActivitySequenceEditor.createBasicActions(options);
        if (!actionsCreated) {
            newActivitySequenceElementAction = new EditorAction("edit_seq_newElement", "icons/sequence_new.gif", "edit_seq_newElement_tooltip", options){

                protected void doAction(Editor editor) {
                    Editor editor2 = null;
                    if (editor instanceof ActivitySequenceElementEditor) {
                        editor2 = editor;
                        editor = editor.getEditorParent();
                    }
                    if (editor instanceof ActivitySequenceEditor) {
                        ((ActivitySequenceEditor)editor).createNewSequenceElement(editor.getNearestIndex(editor2, true), true, this.getComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }
}

