/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.bags.MediaBagElementEditor;
import edu.xtec.jclic.bags.MediaBagMultiEditorPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StreamIO;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;

public class MediaBagEditor
extends Editor {
    public static boolean actionsCreated;
    private boolean initializing;
    public static EditorAction newMediaBagElementAction;
    public static EditorAction updateAllMediaAction;
    public static EditorAction exportAllMediaAction;
    private static Icon icon;

    public MediaBagEditor(MediaBag mediaBag) {
        super(mediaBag);
    }

    public Options getOptions() {
        return this.getMediaBag().getProject().getBridge().getOptions();
    }

    protected void createChildren() {
        this.initializing = true;
        Iterator iterator = this.getMediaBag().getElementsByName().iterator();
        while (iterator.hasNext()) {
            ((MediaBagElement)iterator.next()).getEditor(this);
        }
        this.initializing = false;
    }

    public EditorPanel createEditorPanel(Options options) {
        return new MediaBagMultiEditorPanel(options);
    }

    public Class getEditorPanelClass() {
        return MediaBagMultiEditorPanel.class;
    }

    public String getTitleKey() {
        return "edit_media";
    }

    public MediaBag getMediaBag() {
        return (MediaBag)this.getUserObject();
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public static String[] selectMediaFiles(MediaBag mediaBag, Options options, Component component, int n, String string) {
        String[] stringArray = null;
        FileSystem fileSystem = mediaBag.getProject().getFileSystem();
        int[] nArray = new int[]{11, 13, 14, 15, 16, 18, 17, 19};
        stringArray = fileSystem.chooseFiles(string, false, nArray, options, "edit_find_media", component, true, true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray[i] = stringArray[i].replace(File.separatorChar, '/');
            }
        }
        return stringArray;
    }

    public String getValidMediaName(String string) {
        String string2 = string;
        int n = 1;
        while (this.getMediaBag().getElement(string2) != null) {
            string2 = string2 + "_" + n++;
        }
        return string2;
    }

    public MediaBagElementEditor addMediaBagElement(MediaBagElement mediaBagElement) {
        MediaBagElementEditor mediaBagElementEditor = null;
        if (this.getMediaBag().addElement(mediaBagElement)) {
            mediaBagElementEditor = (MediaBagElementEditor)mediaBagElement.getEditor(this);
            this.fireEditorDataChanged(null);
        }
        return mediaBagElementEditor;
    }

    public MediaBagElementEditor[] createNewMediaBagElements(Options options, Component component, int n) {
        Object[] objectArray = null;
        Messages messages = options.getMessages();
        MediaBag mediaBag = this.getMediaBag();
        String[] stringArray = MediaBagEditor.selectMediaFiles(this.getMediaBag(), options, component, n, null);
        if (stringArray != null) {
            Vector<Editor> vector = new Vector<Editor>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (mediaBag.getElementByFileName(stringArray[i]) != null) {
                    messages.showAlert(component, new String[]{messages.get("edit_media_exists_1"), stringArray[i], messages.get("edit_media_exists_2")});
                    continue;
                }
                MediaBagElement mediaBagElement = new MediaBagElement(stringArray[i], null, this.getValidMediaName(stringArray[i]));
                if (!mediaBag.addElement(mediaBagElement)) continue;
                vector.add(mediaBagElement.getEditor(this));
            }
            if (vector.size() > 0) {
                objectArray = new MediaBagElementEditor[vector.size()];
                vector.copyInto(objectArray);
                this.fireEditorDataChanged(null);
            }
        }
        return objectArray;
    }

    public void updateAllElements(JComponent jComponent) {
        final ProgressDialog progressDialog = new ProgressDialog(jComponent, this.getOptions());
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                FileSystem fileSystem = MediaBagEditor.this.getMediaBag().getProject().getFileSystem();
                ZipFileSystem zipFileSystem = fileSystem instanceof ZipFileSystem ? (ZipFileSystem)fileSystem : null;
                int n = 0;
                progressDialog.setProgressMax(MediaBagEditor.this.getChildCount());
                progressDialog.setProgressValue(n);
                Enumeration<TreeNode> enumeration = MediaBagEditor.this.children();
                while (enumeration.hasMoreElements() && !this.isCancelled()) {
                    ZipFileSystem.ExtendedZipEntry extendedZipEntry;
                    MediaBagElementEditor mediaBagElementEditor = (MediaBagElementEditor)enumeration.nextElement();
                    String string = mediaBagElementEditor.getMediaBagElement().getFileName();
                    progressDialog.setFileLabel(string);
                    if (zipFileSystem != null && (extendedZipEntry = zipFileSystem.getEntry(string)) != null && zipFileSystem.fileExists(string)) {
                        extendedZipEntry.ignore = true;
                    }
                    mediaBagElementEditor.updateContent(null);
                    progressDialog.setProgressValue(++n);
                }
                MediaBagEditor.this.setModified(true);
                progressDialog.setFileLabel(null);
                MediaBagEditor.this.fireEditorDataChanged(null);
                return null;
            }

            public void finished() {
                progressDialog.setVisible(false);
            }
        };
        progressDialog.start("edit_media_refreshAll", "edit_media_refreshAll_working", swingWorker, true, true, false);
    }

    public void exportAllElements(final JComponent jComponent) {
        final Options options = this.getOptions();
        final ProgressDialog progressDialog = new ProgressDialog(jComponent, options);
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                FileSystem fileSystem = MediaBagEditor.this.getMediaBag().getProject().getFileSystem();
                ZipFileSystem zipFileSystem = fileSystem instanceof ZipFileSystem ? (ZipFileSystem)fileSystem : null;
                String string = options.getMessages().get("filesystem_copyFile");
                int n = 0;
                progressDialog.setProgressMax(MediaBagEditor.this.getChildCount());
                progressDialog.setProgressValue(n);
                Enumeration<TreeNode> enumeration = MediaBagEditor.this.children();
                boolean bl = false;
                boolean bl2 = false;
                while (enumeration.hasMoreElements() && !this.isCancelled()) {
                    MediaBagElementEditor mediaBagElementEditor = (MediaBagElementEditor)enumeration.nextElement();
                    String string2 = mediaBagElementEditor.getMediaBagElement().getFileName();
                    if (zipFileSystem == null) continue;
                    ZipFileSystem.ExtendedZipEntry extendedZipEntry = zipFileSystem.getEntry(string2);
                    if (extendedZipEntry != null && !extendedZipEntry.ignore) {
                        progressDialog.setFileLabel(string2);
                        String string3 = zipFileSystem.getFullFileNamePath(string2);
                        File file = new File(string3);
                        boolean bl3 = true;
                        if (file.exists()) {
                            if (bl2) continue;
                            if (!bl) {
                                boolean bl4 = false;
                                boolean bl5 = false;
                                switch (options.getMessages().confirmOverwriteFile(jComponent, file, "yYnNc")) {
                                    case 7: {
                                        bl2 = true;
                                    }
                                    case 3: {
                                        bl4 = true;
                                        break;
                                    }
                                    case 6: {
                                        bl = true;
                                    }
                                    case 1: {
                                        break;
                                    }
                                    default: {
                                        bl5 = true;
                                    }
                                }
                                if (bl4) continue;
                                if (bl5) break;
                            }
                        }
                        try {
                            FileOutputStream fileOutputStream = zipFileSystem.createSecureFileOutputStream(string3);
                            InputStream inputStream = zipFileSystem.getInputStream(string2);
                            StreamIO.writeStreamTo(inputStream, fileOutputStream);
                        }
                        catch (Exception exception) {
                            options.getMessages().showErrorWarning(progressDialog, "FILE_ERR_SAVING", exception);
                            break;
                        }
                    }
                    progressDialog.setProgressValue(++n);
                }
                progressDialog.setFileLabel(null);
                return null;
            }

            public void finished() {
                progressDialog.setVisible(false);
            }
        };
        progressDialog.start("edit_media_refreshAll", "edit_media_refreshAll_working", swingWorker, true, true, false);
    }

    public void setActionsOwner() {
        this.allowPaste = false;
        this.allowCopy = false;
        this.allowCut = false;
        this.allowDelete = false;
        super.setActionsOwner();
        if (actionsCreated) {
            newMediaBagElementAction.setActionOwner(this);
            FileSystem fileSystem = this.getMediaBag().getProject().getFileSystem();
            boolean bl = fileSystem instanceof ZipFileSystem;
            updateAllMediaAction.setActionOwner(bl ? this : null);
            exportAllMediaAction.setActionOwner(bl ? this : null);
        }
    }

    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            newMediaBagElementAction.setActionOwner(null);
            updateAllMediaAction.setActionOwner(null);
            exportAllMediaAction.setActionOwner(null);
        }
    }

    public static void createActions(Options options) {
        MediaBagEditor.createBasicActions(options);
        if (!actionsCreated) {
            newMediaBagElementAction = new EditorAction("edit_media_new", "icons/media_new.gif", "edit_media_new_tooltip", options){

                protected void doAction(Editor editor) {
                    Editor editor2 = null;
                    if (editor instanceof MediaBagElementEditor) {
                        editor2 = editor;
                        editor = editor.getEditorParent();
                    }
                    if (editor instanceof MediaBagEditor) {
                        EditorPanel editorPanel = this.getEditorPanelSrc();
                        MediaBagMultiEditorPanel mediaBagMultiEditorPanel = null;
                        if (editorPanel instanceof MediaBagMultiEditorPanel) {
                            mediaBagMultiEditorPanel = (MediaBagMultiEditorPanel)editorPanel;
                        }
                        int n = mediaBagMultiEditorPanel == null ? -1 : mediaBagMultiEditorPanel.getFilters();
                        MediaBagElementEditor[] mediaBagElementEditorArray = ((MediaBagEditor)editor).createNewMediaBagElements(this.options, this.getComponentSrc(), n);
                        if (mediaBagElementEditorArray != null && mediaBagElementEditorArray.length > 0 && mediaBagMultiEditorPanel != null) {
                            mediaBagMultiEditorPanel.setSelected(mediaBagElementEditorArray[0]);
                        }
                    }
                }
            };
            updateAllMediaAction = new EditorAction("edit_media_refreshAll", "icons/reset_all.gif", "edit_media_refreshAll_tooltip", options){

                protected void doAction(Editor editor) {
                    if (editor instanceof MediaBagEditor) {
                        ((MediaBagEditor)editor).updateAllElements(this.getJComponentSrc());
                    }
                }
            };
            exportAllMediaAction = new EditorAction("edit_media_exportAll", "icons/file_save_all.gif", "edit_media_exportAll_tooltip", options){

                protected void doAction(Editor editor) {
                    if (editor instanceof MediaBagEditor) {
                        ((MediaBagEditor)editor).exportAllElements(this.getJComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    public MediaBagElementEditor getChildFor(MediaBagElement mediaBagElement) {
        MediaBagElementEditor mediaBagElementEditor = null;
        if (mediaBagElement != null) {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                Editor editor = (Editor)enumeration.nextElement();
                if (editor.getUserObject() != mediaBagElement) continue;
                mediaBagElementEditor = (MediaBagElementEditor)editor;
                break;
            }
        }
        return mediaBagElementEditor;
    }

    public Vector getChildrenList(int n) {
        Vector<MediaBagElementEditor> vector = new Vector<MediaBagElementEditor>();
        Iterator iterator = this.getMediaBag().getElementsByName().iterator();
        String[] stringArray = Utils.getFileFilterExtensions(n);
        while (iterator.hasNext()) {
            MediaBagElementEditor mediaBagElementEditor;
            int n2;
            MediaBagElement mediaBagElement = (MediaBagElement)iterator.next();
            String string = mediaBagElement.getFileName().toLowerCase();
            if (stringArray != null) {
                for (n2 = 0; n2 < stringArray.length && !string.endsWith(stringArray[n2]); ++n2) {
                }
            }
            if (stringArray != null && n2 >= stringArray.length || (mediaBagElementEditor = this.getChildFor(mediaBagElement)) == null) continue;
            vector.add(mediaBagElementEditor);
        }
        return vector;
    }

    public boolean nameChanged(int n, String string, String string2) {
        boolean bl = false;
        if ((n & 0x47F0) != 0) {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                bl |= ((MediaBagElementEditor)enumeration.nextElement()).nameChanged(n, string, string2);
            }
        }
        return bl;
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/media_bag.gif");
        }
        return icon;
    }

    public int checkOrphanElements(Options options, Component component, boolean bl) {
        int n = 1;
        Vector<MediaBagElementEditor> vector = new Vector<MediaBagElementEditor>();
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            MediaBagElementEditor mediaBagElementEditor = (MediaBagElementEditor)enumeration.nextElement();
            if (!mediaBagElementEditor.listReferences().isEmpty()) continue;
            vector.add(mediaBagElementEditor);
        }
        if (!vector.isEmpty()) {
            Object[] objectArray;
            boolean bl2;
            boolean bl3 = bl2 = !bl;
            if (!bl2) {
                objectArray = new Object[]{options.getMsg("edit_project_orphanMedia"), vector.size() > 10 ? new JScrollPane(new JList(vector)) : vector, options.getMsg("edit_project_orphanMedia_prompt")};
                n = options.getMessages().showQuestionDlgObj(component, objectArray, "edit_project_orphanMedia_title", "ync");
                boolean bl4 = bl2 = n == 1;
            }
            if (bl2) {
                objectArray = vector.iterator();
                while (objectArray.hasNext()) {
                    MediaBagElementEditor mediaBagElementEditor = (MediaBagElementEditor)objectArray.next();
                    mediaBagElementEditor.delete(true);
                }
            }
        }
        return n;
    }
}

