/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.bags.MediaBagElementEditorPanel;
import edu.xtec.jclic.bags.MediaPreviewPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProjectEditor;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Component;
import java.awt.Image;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;

public class MediaBagElementEditor
extends Editor {
    private static boolean actionsCreated;
    private static Icon icon;
    public static EditorAction testMediaBagElementAction;
    private static MediaPreviewPanel previewPanel;

    public MediaBagElementEditor(MediaBagElement mediaBagElement) {
        super(mediaBagElement);
    }

    protected void createChildren() {
    }

    public Class getEditorPanelClass() {
        return MediaBagElementEditorPanel.class;
    }

    public EditorPanel createEditorPanel(Options options) {
        return new MediaBagElementEditorPanel(options);
    }

    public MediaBagElement getMediaBagElement() {
        return (MediaBagElement)this.getFirstObject(MediaBagElement.class);
    }

    public MediaBag getMediaBag() {
        MediaBag mediaBag = null;
        if (this.getEditorParent() instanceof MediaBagEditor) {
            mediaBag = ((MediaBagEditor)this.getParent()).getMediaBag();
        }
        return mediaBag;
    }

    public String getName() {
        return this.getMediaBagElement().getName();
    }

    public void testMedia(Component component, Options options) {
        if (previewPanel == null) {
            previewPanel = new MediaPreviewPanel(this, options);
            options.getMessages().showInputDlg(component, previewPanel, "edit_media_preview_tooltip", null);
            previewPanel.end();
            previewPanel = null;
        }
    }

    public boolean rename(String string, Editor.EditorListener editorListener, Messages messages) {
        String string2 = this.getName();
        String string3 = null;
        string = string.trim();
        Component component = editorListener instanceof Component ? (Component)((Object)editorListener) : null;
        boolean bl = false;
        if (!string2.equals(string)) {
            if (string.length() < 1) {
                string3 = "edit_media_rename_invalid";
            } else if (this.getMediaBag().getElement(string) != null) {
                string3 = "edit_media_rename_exists";
            } else {
                bl = this.getProjectEditor().nameChanged(Utils.T_CODES[Utils.getFileType(this.getMediaBagElement().getFileName())], string2, string);
            }
        }
        if (string3 != null && messages != null && component != null) {
            messages.showAlert(component, string3);
        }
        return bl;
    }

    public void updateContent(Editor.EditorListener editorListener) {
        this.getMediaBagElement().setData(null);
        this.fireEditorDataChanged(null);
    }

    public boolean changeFileName(String string, Editor.EditorListener editorListener, Messages messages) {
        Component component;
        boolean bl = false;
        String string2 = null;
        String string3 = this.getMediaBagElement().getFileName();
        FileSystem fileSystem = this.getMediaBag().getProject().getFileSystem();
        string = FileSystem.stdFn(string.trim());
        Component component2 = component = editorListener instanceof Component ? (Component)((Object)editorListener) : null;
        if (!string3.equals(string)) {
            if (Utils.getFileType(string3) != Utils.getFileType(string)) {
                string2 = "edit_media_chfile_different";
            } else if (string.length() < 1) {
                string2 = "edit_media_chfile_invalid";
            } else if (this.getMediaBag().getElementByFileName(string) != null) {
                if (messages != null && component != null) {
                    messages.showAlert(component, new String[]{messages.get("edit_media_exists_1"), string, messages.get("edit_media_exists_2")});
                }
            } else {
                this.getMediaBagElement().setFileName(string);
                bl = true;
                this.fireEditorDataChanged(editorListener);
            }
        }
        if (string2 != null && messages != null && component != null) {
            messages.showAlert(component, string2);
        }
        return bl;
    }

    public String toString() {
        return this.getName();
    }

    protected void saveData() {
    }

    protected boolean delete(boolean bl) {
        MediaBagEditor mediaBagEditor = (MediaBagEditor)this.getEditorParent();
        boolean bl2 = super.delete(bl);
        if (bl2 && mediaBagEditor != null) {
            bl2 = mediaBagEditor.getMediaBag().removeElement(this.getMediaBagElement());
            mediaBagEditor.fireEditorDataChanged(null);
        }
        return bl2;
    }

    protected boolean canClone() {
        return false;
    }

    protected void setActionsFlag() {
        this.allowDelete = true;
        this.allowCut = false;
        this.allowCopy = false;
        this.allowPaste = false;
    }

    public void setActionsOwner() {
        this.setActionsFlag();
        super.setActionsOwner();
        if (actionsCreated) {
            testMediaBagElementAction.setActionOwner(this);
        }
    }

    public void clearActionsOwner() {
        super.clearActionsOwner();
        if (actionsCreated) {
            testMediaBagElementAction.setActionOwner(null);
        }
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/movie.gif");
        }
        return icon;
    }

    public Icon getIcon(boolean bl, boolean bl2) {
        return MediaBagElementEditor.getIcon();
    }

    public boolean canBeParentOf(Editor editor) {
        return false;
    }

    public boolean canBeSiblingOf(Editor editor) {
        return editor instanceof MediaBagElementEditor;
    }

    public JClicProjectEditor getProjectEditor() {
        return (JClicProjectEditor)this.getFirstParent(JClicProjectEditor.class);
    }

    public static void createActions(Options options) {
        MediaBagElementEditor.createBasicActions(options);
        if (!actionsCreated) {
            testMediaBagElementAction = new EditorAction("edit_media_preview", "icons/media_view.gif", "edit_media_preview_tooltip", options){

                protected void doAction(Editor editor) {
                    EditorPanel editorPanel = this.getEditorPanelSrc();
                    if (editorPanel != null && editor instanceof MediaBagElementEditor) {
                        ((MediaBagElementEditor)editor).testMedia(editorPanel, editorPanel.getOptions());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    public String getDescription(Options options) {
        MediaBagElement mediaBagElement = this.getMediaBagElement();
        StringBuffer stringBuffer = new StringBuffer();
        String string = mediaBagElement.getFileName();
        if (string != null) {
            int n = Utils.getFileType(string);
            stringBuffer.append(options.getMsg(Utils.TYPE_CODES[n]));
            if (n == 0) {
                if (mediaBagElement.animated) {
                    stringBuffer.append(" ").append(options.getMsg("ftype_animated"));
                }
                try {
                    Image image = mediaBagElement.getImage();
                    if (image != null) {
                        stringBuffer.append(" (").append(image.getWidth(null)).append("x").append(image.getHeight(null)).append(")");
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append(" - ").append(options.getMsg("ERROR"));
                    System.err.println("Error reading image " + string);
                }
            }
        }
        return stringBuffer.substring(0);
    }

    public long getFileSize() {
        String string;
        MediaBagElement mediaBagElement = this.getMediaBagElement();
        long l = -1L;
        if (mediaBagElement != null && (string = mediaBagElement.getFileName()) != null && this.getMediaBag() != null) {
            try {
                l = this.getMediaBag().getProject().getFileSystem().getFileLength(string);
            }
            catch (Exception exception) {
                System.err.println("ERROR getting the size of " + string);
            }
        }
        return l;
    }

    public boolean nameChanged(int n, String string, String string2) {
        boolean bl = false;
        if ((n & 0x47F0) != 0 && string.equals(this.getMediaBagElement().getName())) {
            this.getMediaBagElement().setName(string2);
            this.setModified(true);
            bl = true;
        }
        return bl;
    }

    public Vector listReferences() {
        Vector vector = null;
        MediaBag mediaBag = this.getMediaBag();
        if (mediaBag != null) {
            HashMap hashMap = new HashMap();
            mediaBag.listReferencesTo(this.getName(), "media", hashMap);
            vector = new Vector(hashMap.keySet());
        }
        this.allowDelete = vector == null || vector.size() == 0;
        deleteAction.setEnabled(this.allowDelete);
        return vector;
    }

    static {
        previewPanel = null;
    }
}

