/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class Compass
extends JPanel {
    public static final String PROP_DIRECTION = "direction";
    public static final String[] BT_NAMES = new String[]{"nw", "n", "ne", "w", "c", "e", "sw", "s", "se"};
    public static final Dimension BT_DIMENSION = new Dimension(16, 16);
    private JToggleButton[] buttons;
    private int direction;

    public Compass() {
        super(new GridLayout(3, 3));
        this.setOpaque(false);
        this.direction = -1;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                for (int i = 0; i < 9; ++i) {
                    if (!BT_NAMES[i].equals(string)) continue;
                    Compass.this.setDirection(i);
                    break;
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttons = new JToggleButton[9];
        for (int i = 0; i < 9; ++i) {
            JToggleButton jToggleButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/" + BT_NAMES[i] + ".gif")));
            jToggleButton.setPreferredSize(BT_DIMENSION);
            buttonGroup.add(jToggleButton);
            jToggleButton.setActionCommand(BT_NAMES[i]);
            jToggleButton.addActionListener(actionListener);
            jToggleButton.setFocusPainted(false);
            this.add(jToggleButton);
            this.buttons[i] = jToggleButton;
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        int n2 = this.direction;
        this.direction = n;
        this.firePropertyChange(PROP_DIRECTION, n2, this.direction);
        if (n >= 0) {
            if (this.buttons[n] != null && !this.buttons[n].isSelected()) {
                this.buttons[n].setSelected(true);
            }
        } else if (n2 >= 0) {
            this.buttons[n2].setSelected(false);
        }
    }

    public int[] getDoubleDirection() {
        int[] nArray = new int[2];
        int n = this.direction < 0 ? 4 : this.direction;
        nArray[0] = n % 3;
        nArray[1] = n / 3;
        return nArray;
    }

    public void setDoubleDirection(int[] nArray) {
        if (nArray == null || nArray.length != 2 || nArray[0] < 0 || nArray[1] < 0) {
            this.setDirection(-1);
        } else {
            this.setDirection(3 * nArray[1] + nArray[0]);
        }
    }
}

