/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.beans.NullableObject;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.jclic.misc.GradientEditor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.JButton;

public class GradientButton
extends NullableObject {
    public static final String PROP_GRADIENT = "gradient";

    protected String getObjectType() {
        return PROP_GRADIENT;
    }

    public Gradient getGradient() {
        return (Gradient)this.getObject();
    }

    public void setGradient(Gradient gradient) {
        this.setObject(gradient);
    }

    protected AbstractButton buildButton() {
        return new JButton(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Gradient gradient = GradientButton.this.getGradient();
                if (gradient != null) {
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    rectangle.grow(-3, -3);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    RenderingHints renderingHints = graphics2D.getRenderingHints();
                    graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
                    gradient.paint(graphics2D, rectangle);
                    graphics2D.setRenderingHints(renderingHints);
                }
            }
        };
    }

    protected Object createObject() {
        return new Gradient();
    }

    protected Object editObject(Object object) {
        Gradient gradient = (Gradient)(object == null ? this.createObject() : object);
        return GradientEditor.getGradient(gradient, this, this.options);
    }
}

