/*
 * Decompiled with CFR 0.152.
 */
import edu.xtec.jclic.ReportServerConstants;
import edu.xtec.jclic.report.HTTPReportServer;
import edu.xtec.jclic.report.ReportServerEvent;
import edu.xtec.jclic.report.ReportServerEventMaker;
import edu.xtec.jclic.report.ReportServerJDBCBridge;
import edu.xtec.util.Encryption;
import edu.xtec.util.Messages;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;

public class CmdReportServer
implements ReportServerEventMaker.Listener,
ReportServerConstants {
    static String iDriver;
    static String iUrl;
    static String iUser;
    static String iPwd;
    static int iHttpPort;
    static int iHttpTimeout;
    static boolean iCreateTables;
    static String iTablePrefix;
    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);

    public CmdReportServer(String string, String string2, String string3, String string4, int n, int n2, boolean bl, String string5) throws Exception {
        this.showValidCommands();
        ConnectionBeanProvider connectionBeanProvider = ConnectionBeanProvider.getConnectionBeanProvider(true, string, string2, string3, string4, true);
        ReportServerJDBCBridge reportServerJDBCBridge = new ReportServerJDBCBridge(connectionBeanProvider, bl, string5);
        this.reportEventPerformed(new ReportServerEvent(0, string2, null, 0));
        HTTPReportServer hTTPReportServer = new HTTPReportServer(new Messages("messages.ReportServerMessages"));
        hTTPReportServer.addListener(this);
        hTTPReportServer.startServer(n, n2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        boolean bl2 = true;
        String string6 = null;
        while (bl2) {
            try {
                string6 = bufferedReader.readLine();
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (string6 == null) continue;
            if (string6.equalsIgnoreCase("stop")) {
                hTTPReportServer.stopServer();
                continue;
            }
            if (string6.equalsIgnoreCase("start")) {
                hTTPReportServer.startServer(n, n2);
                continue;
            }
            if (string6.equalsIgnoreCase("exit")) {
                if (hTTPReportServer.serverRunning()) {
                    hTTPReportServer.stopServer();
                }
                bl2 = false;
                continue;
            }
            this.showValidCommands();
        }
        reportServerJDBCBridge.end();
        reportServerJDBCBridge = null;
        this.reportEventPerformed(new ReportServerEvent(0, string2, null, 1));
    }

    public static void main(String[] stringArray) {
        String string = "jclicReports.properties";
        int n = 0;
        if (stringArray.length > 0) {
            if (stringArray[1].equals("-help")) {
                CmdReportServer.displayHelp();
                return;
            }
            if (!stringArray[0].startsWith("-")) {
                string = stringArray[0];
                ++n;
            }
        }
        Properties properties = new Properties();
        try {
            properties.load(ReportServerConstants.class.getResourceAsStream("jclicReports.properties"));
            if (!"jclicReports.properties".equals(string)) {
                properties.load(CmdReportServer.class.getResourceAsStream(string));
                String string2 = properties.getProperty("dbPassword");
                if (string2 != null && string2.length() > 0) {
                    properties.setProperty("dbPassword", Encryption.Decrypt(string2));
                }
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: Invalid properties file name\n" + exception);
            CmdReportServer.displayHelp();
            return;
        }
        iDriver = properties.getProperty("dbDriver", "sun.jdbc.odbc.JdbcOdbcDriver");
        iUrl = properties.getProperty("dbServer", "jdbc:odbc:JClicUserReports");
        iUser = properties.getProperty("dbLogin", null);
        iPwd = properties.getProperty("dbPassword", null);
        iHttpPort = Integer.parseInt(properties.getProperty("http_port", Integer.toString(9000)));
        iHttpTimeout = Integer.parseInt(properties.getProperty("http_timeout", Integer.toString(1200)));
        iTablePrefix = properties.getProperty("tablePrefix", null);
        iCreateTables = "true".equalsIgnoreCase(properties.getProperty("createTables", "true"));
        while (n < stringArray.length) {
            boolean bl = false;
            if (n < stringArray.length - 1) {
                if (stringArray[n].equals("-driver")) {
                    iDriver = stringArray[++n];
                } else if (stringArray[n].equals("-url")) {
                    iUrl = stringArray[++n];
                } else if (stringArray[n].equals("-user")) {
                    iUser = stringArray[++n];
                } else if (stringArray[n].equals("-pwd")) {
                    iPwd = stringArray[++n];
                } else if (stringArray[n].equals("-port")) {
                    iHttpPort = Integer.parseInt(stringArray[++n]);
                } else if (stringArray[n].equals("-timeout")) {
                    iHttpTimeout = Integer.parseInt(stringArray[++n]);
                } else if (stringArray[n].equals("-prefix")) {
                    iTablePrefix = stringArray[++n];
                } else if (stringArray[n].equals("-create")) {
                    iCreateTables = "true".equalsIgnoreCase(stringArray[++n]);
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                System.err.println("Syntax error!");
                CmdReportServer.displayHelp();
                return;
            }
            ++n;
        }
        try {
            new CmdReportServer(iDriver, iUrl, iUser, iPwd, iHttpPort, iHttpTimeout, iCreateTables, iTablePrefix);
            System.err.println("Report Server closed");
        }
        catch (Exception exception) {
            System.err.println("Unable to start!\n" + exception);
        }
    }

    static void displayHelp() {
        System.out.println("Syntax: java CmdReportServer [-help] [fileName] [-option value]..");
        System.out.println("Switches:");
        System.out.println("  -help     displays this message");
        System.out.println("  fileName  get values from the specified fileName");
        System.out.println("            if ommitted, default values will be read");
        System.out.println("            from ReportServer.properties");
        System.out.println("Option-Value pairs:");
        System.out.println("  -driver   name of the JDBC driver");
        System.out.println("  -url      JDBC path to the database");
        System.out.println("  -user     system user name");
        System.out.println("  -pwd      system user password");
        System.out.println("  -port     HTTP port for foreign connections (default: 9000)");
        System.out.println("  -timeout  maximum number of seconds of socket inactivity");
        System.out.println("  -create   [true|false] automatic creation of tables (default: true)");
        System.out.println("  -prefix   prefix used in table names");
    }

    public void reportEventPerformed(ReportServerEvent reportServerEvent) {
        System.out.println(this.dateFormat.format(new Date()) + " " + reportServerEvent.toString());
    }

    void showValidCommands() {
        System.out.println("-----------------------------------------------------");
        System.out.println("Valid control commands:");
        System.out.println("stop - Close all connections and stop server");
        System.out.println("start - Start server");
        System.out.println("exit - Close all connections, stop server and exit");
        System.out.println("-----------------------------------------------------");
    }
}

