/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.ActivityData;
import edu.xtec.jclic.report.SessionData;
import edu.xtec.jclic.report.rp.BasicReport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.imageio.ImageIO;

public class Img
extends BasicReport {
    public static final String URL = "img";
    public static final String TYPE = "type";
    public static final String HEADER = "header";
    public static final String GRAPH = "graph";
    public static final String TEXT = "text";
    public static final String DIST = "dist";
    public static final String WIDTH = "w";
    public static final String HEIGHT = "h";
    public static final String USER_GRAPH = "userGraph";
    public static final String GROUP_GRAPH = "groupGraph";
    public static final String PROJECT_GRAPH = "projectGraph";
    public static int DEFAULT_WIDTH;
    public static int DIST_WIDTH;
    public static int DEFAULT_HEIGHT;
    public static int DEFAULT_HEADER_HEIGHT;
    public static int MRG;
    public static Color BG_COLOR;
    public static Color TEXT_COLOR;
    public static Color BORDER_COLOR;
    public static Color HEADER_BG_COLOR;
    public static Color HEADER_TEXT_COLOR;
    public static Color V1_COLOR;
    public static Color V2_COLOR;
    public static Color DIST_COLOR;
    public static Color ALERT_COLOR;
    public static Stroke THIN_STROKE;
    public static Stroke BOLD_STROKE;
    public static Font STD_FONT;
    public static Font BOLD_FONT;
    public static Font ALERT_FONT;
    public static int MARGE_X;
    public static int MARGE_Y;
    public static int NUM_DIVISIONS_Y;
    public static int MAX_COLS;
    public static int M_X_DIST;
    public static int M_Y_DIST;
    boolean withHeader;
    boolean isDist;
    int width;
    int height;
    String titleKey;
    public static final int N_DIST_ELEMENTS = 5;
    private static DecimalFormat DF;

    public String getTitle(ResourceBundle resourceBundle) {
        return "";
    }

    public String getUrl() {
        return URL;
    }

    public boolean noCache() {
        return false;
    }

    public static void loadSettings(String string) throws Exception {
        Img.loadProperties(string);
        DEFAULT_WIDTH = Integer.parseInt(prop.getProperty("graph_width", "440"));
        DIST_WIDTH = Integer.parseInt(prop.getProperty("graph_dist_width", "192"));
        DEFAULT_HEIGHT = Integer.parseInt(prop.getProperty("graph_height", "155"));
        DEFAULT_HEADER_HEIGHT = Integer.parseInt(prop.getProperty("graph_header_height", "25"));
        MRG = Integer.parseInt(prop.getProperty("graph_margin", "8"));
        BG_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_bg", "008080"), 16));
        TEXT_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_text", "FFFFFF"), 16));
        HEADER_BG_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_header_bg", "008080"), 16));
        HEADER_TEXT_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_header_text", "FFFFFF"), 16));
        BORDER_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_border", "000000"), 16));
        V1_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_v1", "00FF00"), 16));
        V2_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_v2", "0000FF"), 16));
        DIST_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_dist", "0000FF"), 16));
        ALERT_COLOR = new Color(Integer.parseInt(prop.getProperty("graph_color_alert", "FF0000"), 16));
        BOLD_STROKE = new BasicStroke(Float.parseFloat(prop.getProperty("graph_stroke_width", "3.0")));
        THIN_STROKE = new BasicStroke(1.0f);
        try {
            String string2 = prop.getProperty("graph_font_family", "Dialog");
            int n = Integer.parseInt(prop.getProperty("graph_font_size", "11"));
            STD_FONT = new Font(string2, 0, n);
            BOLD_FONT = new Font(string2, 1, n);
            ALERT_FONT = new Font(string2, 1, 24);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MARGE_X = Integer.parseInt(prop.getProperty("graph_margin_x", "50"));
        MARGE_Y = Integer.parseInt(prop.getProperty("graph_margin_y", "20"));
        NUM_DIVISIONS_Y = Integer.parseInt(prop.getProperty("graph_div_y", "4"));
        MAX_COLS = Integer.parseInt(prop.getProperty("graph_max_cols", "10"));
        M_X_DIST = Integer.parseInt(prop.getProperty("graph_margin_dist_x", "15"));
        M_Y_DIST = Integer.parseInt(prop.getProperty("graph_margin_dist_y", "20"));
    }

    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.withHeader = this.getBoolParam(HEADER, "true");
        this.isDist = this.getBoolParam(DIST, "true");
        this.type = -1;
        String string = this.getParam(TYPE);
        if (USER_GRAPH.equals(string)) {
            this.type = 0;
            this.titleKey = "report_user_evolution";
        } else if (GROUP_GRAPH.equals(string)) {
            this.type = 1;
            this.titleKey = "report_group_evolution";
        } else if (PROJECT_GRAPH.equals(string)) {
            this.type = 2;
            this.titleKey = "report_project_evolution";
        } else {
            this.type = -1;
            this.errCode = 400;
            throw new Exception();
        }
        if (this.isDist) {
            this.titleKey = "report_result_distribution";
        }
        this.width = this.getIntParam(WIDTH, this.isDist ? DIST_WIDTH : DEFAULT_WIDTH);
        this.height = this.getIntParam(HEIGHT, DEFAULT_HEIGHT);
        if (this.width <= 0 || this.height <= 0) {
            System.err.println("EP!!");
        }
        return true;
    }

    public void header(Vector vector) {
        vector.add(new String[]{"CONTENT_TYPE", "image/png"});
    }

    public boolean usesWriter() {
        return false;
    }

    public void process(OutputStream outputStream) throws Exception {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n = this.withHeader ? DEFAULT_HEADER_HEIGHT : 0;
        Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
        Rectangle rectangle2 = new Rectangle(0, 0, this.width, n);
        Rectangle rectangle3 = new Rectangle(0, n, this.width, this.height - n);
        graphics2D.setColor(BG_COLOR);
        graphics2D.fill(rectangle);
        if (this.withHeader) {
            graphics2D.setColor(HEADER_BG_COLOR);
            graphics2D.fill(rectangle2);
        }
        graphics2D.setColor(BORDER_COLOR);
        graphics2D.draw(new Rectangle(0, 0, this.width - 1, this.height - 1));
        if (this.withHeader) {
            this.drawHeader(graphics2D, rectangle2);
            graphics2D.setColor(BORDER_COLOR);
            graphics2D.drawLine(0, n, this.width, n);
        }
        if (this.isDist) {
            this.dibuixaDistribucio(graphics2D, this.getSessionList(), rectangle3);
        } else {
            this.dibuixaImatge(graphics2D, this.getSessionList(), rectangle3);
        }
        graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
    }

    protected void drawHeader(Graphics2D graphics2D, Rectangle rectangle) throws Exception {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(STD_FONT);
        int n = fontMetrics.getHeight();
        int n2 = n / 2;
        int n3 = (rectangle.height - n) / 2;
        int n4 = (rectangle.height - n2) / 2;
        if (!this.isDist) {
            String string = this.bundle.getString("report_global_precision");
            String string2 = this.bundle.getString("report_solved_activities");
            int n5 = fontMetrics.stringWidth(string);
            int n6 = fontMetrics.stringWidth(string2);
            Rectangle rectangle2 = new Rectangle(rectangle.x + rectangle.width - MRG - n6 - 6 - n2 - 2 * MRG - n5 - 6 - n, rectangle.y + n4, n2, n2);
            Rectangle rectangle3 = new Rectangle(rectangle.x + rectangle.width - MRG - n6 - 6 - n2, rectangle.y + n4, n2, n2);
            graphics2D.setColor(V1_COLOR);
            graphics2D.fill(rectangle2);
            graphics2D.setColor(V2_COLOR);
            graphics2D.fill(rectangle3);
            graphics2D.setColor(BORDER_COLOR);
            graphics2D.draw(rectangle2);
            graphics2D.draw(rectangle3);
            graphics2D.setFont(STD_FONT);
            graphics2D.setColor(HEADER_TEXT_COLOR);
            graphics2D.drawString(string, rectangle.x + rectangle2.x + n2 + 6, rectangle.y + n3 + fontMetrics.getAscent());
            graphics2D.drawString(string2, rectangle.x + rectangle3.x + n2 + 6, rectangle.y + n3 + fontMetrics.getAscent());
        }
        graphics2D.setColor(HEADER_TEXT_COLOR);
        graphics2D.setFont(BOLD_FONT);
        graphics2D.drawString(this.bundle.getString(this.titleKey), rectangle.x + MRG, rectangle.y + n3 + fontMetrics.getAscent());
    }

    public void dibuixaImatge(Graphics2D graphics2D, Vector vector, Rectangle rectangle) throws Exception {
        graphics2D.setColor(TEXT_COLOR);
        graphics2D.setStroke(THIN_STROKE);
        int n = rectangle.width - 2 * MARGE_X;
        int n2 = rectangle.height - 2 * MARGE_Y;
        graphics2D.drawRect(rectangle.x + MARGE_X, rectangle.y + MARGE_Y, n, n2);
        if (vector.size() > 0) {
            int n3;
            int n4;
            int n5;
            float f = n2 / NUM_DIVISIONS_Y;
            for (int i = 1; i < NUM_DIVISIONS_Y; ++i) {
                n5 = (int)((float)MARGE_Y + (float)i * f);
                graphics2D.drawLine(rectangle.x + MARGE_X, rectangle.y + n5, rectangle.x + MARGE_X + n, rectangle.y + n5);
            }
            graphics2D.setFont(STD_FONT);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            for (n5 = 0; n5 <= NUM_DIVISIONS_Y; ++n5) {
                String string = Integer.toString(100 - n5 * (100 / NUM_DIVISIONS_Y));
                n4 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, rectangle.x + MARGE_X - 5 - n4, rectangle.y + MARGE_Y + (int)(f * (float)n5) + 3);
            }
            n5 = vector.size();
            if (n5 == 1) {
                vector.add(vector.get(0));
                ++n5;
            }
            int n6 = n5 - 1;
            n4 = Math.min(MAX_COLS, n6);
            float f2 = n / n4;
            float f3 = (float)n6 / (float)n4;
            int[] nArray = new int[n4 + 2];
            int n7 = 0;
            for (float f4 = 0.0f; f4 <= (float)(n6 + 1); f4 += f3) {
                nArray[n7++] = Math.round(f4);
            }
            int[] nArray2 = new int[n5];
            int n8 = 0;
            for (int i = 0; i <= n6; ++i) {
                if (nArray[n8] == i) {
                    nArray2[i] = (int)((float)MARGE_X + (float)n8++ * f2);
                    continue;
                }
                n3 = nArray[n8];
                int n9 = nArray[n8 - 1];
                float f5 = (float)(i - n9) * (f2 / (float)(n3 - n9));
                nArray2[i] = (int)((float)MARGE_X + (float)(n8 - 1) * f2 + f5);
            }
            n8 = 0;
            Date date = null;
            n3 = 1;
            for (n7 = 0; n7 < n6 && n3 != 0; ++n7) {
                SessionData sessionData = (SessionData)vector.get(n7);
                SessionData sessionData2 = (SessionData)vector.get(n7 + 1);
                if (nArray[n8] == n7) {
                    graphics2D.setColor(TEXT_COLOR);
                    graphics2D.setStroke(THIN_STROKE);
                    graphics2D.drawLine(rectangle.x + nArray2[n7], rectangle.y + MARGE_Y, rectangle.x + nArray2[n7], rectangle.y + MARGE_Y + n2);
                }
                graphics2D.setStroke(BOLD_STROKE);
                graphics2D.setColor(V2_COLOR);
                graphics2D.drawLine(rectangle.x + nArray2[n7], rectangle.y + MARGE_Y + n2 - sessionData.percentSolved() * n2 / 100, rectangle.x + nArray2[n7 + 1], rectangle.y + MARGE_Y + n2 - sessionData2.percentSolved() * n2 / 100);
                graphics2D.setColor(V1_COLOR);
                graphics2D.drawLine(rectangle.x + nArray2[n7], rectangle.y + MARGE_Y + n2 - sessionData.percentPrec() * n2 / 100, rectangle.x + nArray2[n7 + 1], rectangle.y + MARGE_Y + n2 - sessionData2.percentPrec() * n2 / 100);
                if (nArray[n8] == n7) {
                    graphics2D.setColor(TEXT_COLOR);
                    graphics2D.drawString(this.veryShortDateFormat.format(sessionData.date), rectangle.x + nArray2[n7], rectangle.y + MARGE_Y + n2 + 15);
                    ++n8;
                }
                date = sessionData2.date;
            }
            graphics2D.setColor(TEXT_COLOR);
            graphics2D.drawString(this.veryShortDateFormat.format(date), rectangle.x + nArray2[n7], rectangle.y + MARGE_Y + n2 + 15);
        } else {
            String string = this.bundle.getString("report_no_data");
            graphics2D.setColor(ALERT_COLOR);
            graphics2D.setFont(ALERT_FONT);
            Rectangle rectangle2 = ALERT_FONT.getStringBounds(string, graphics2D.getFontRenderContext()).getBounds();
            graphics2D.drawString(string, rectangle.x + MARGE_X + (n - rectangle2.width) / 2, rectangle.y + MARGE_Y + n2 / 2 + rectangle2.height / 4);
        }
    }

    public void dibuixaDistribucio(Graphics2D graphics2D, Vector vector, Rectangle rectangle) {
        int n;
        int[] nArray = new int[5];
        Iterator iterator = vector.iterator();
        int n2 = 20;
        while (iterator.hasNext()) {
            SessionData sessionData = (SessionData)iterator.next();
            if (sessionData.actData != null && sessionData.actData.size() > 0) {
                Iterator iterator2 = sessionData.actData.iterator();
                while (iterator.hasNext()) {
                    ActivityData activityData = (ActivityData)iterator.next();
                    int n3 = Math.min(99, activityData.qualification) / n2;
                    nArray[n3] = nArray[n3] + 1;
                }
                continue;
            }
            int n4 = Math.min(99, sessionData.percentPrec()) / n2;
            nArray[n4] = nArray[n4] + sessionData.numActs;
        }
        int n5 = M_X_DIST;
        int n6 = M_Y_DIST;
        graphics2D.setColor(TEXT_COLOR);
        graphics2D.setStroke(THIN_STROKE);
        graphics2D.setFont(STD_FONT);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        boolean bl = false;
        for (n = 0; n < nArray.length && !bl; ++n) {
            bl = nArray[n] > 0;
        }
        if (bl) {
            f = nArray[0];
            for (n = 1; n < nArray.length; ++n) {
                f = Math.max(f, (float)nArray[n]);
            }
            f2 = Img.getMaximOrdenades(f, false);
            f3 = Img.getMaximOrdenades(f, true);
            String string = Img.formatNumber(f3);
            n5 += graphics2D.getFontMetrics().stringWidth(string);
        }
        n = rectangle.width - n5 - 10;
        int n7 = rectangle.height - 2 * n6;
        graphics2D.drawRect(rectangle.x + n5, rectangle.y + n6, n, n7);
        if (bl) {
            int n8;
            int n9 = 0;
            float f4 = f;
            while ((double)f4 > 0.01) {
                ++n9;
                f4 -= f3;
            }
            if (n9 > 0) {
                f4 = n7 / n9;
                for (n8 = 1; n8 < n9; ++n8) {
                    graphics2D.drawLine(rectangle.x + n5, rectangle.y + n6 + (int)((float)n8 * f4), rectangle.x + n5 + n, rectangle.y + n6 + (int)((float)n8 * f4));
                }
                for (n8 = 0; n8 <= n9; ++n8) {
                    float f5 = f3 * (float)n9 - (float)n8 * f3;
                    String string = Img.formatNumber(f5);
                    graphics2D.drawString(string, rectangle.x + n5 - 5 - graphics2D.getFontMetrics().stringWidth(string), rectangle.y + n6 + (int)(f4 * (float)n8) + 3);
                }
            }
            f4 = n / 5;
            for (n8 = 0; n8 < 5; ++n8) {
                graphics2D.setColor(TEXT_COLOR);
                graphics2D.setStroke(THIN_STROKE);
                graphics2D.drawLine(rectangle.x + n5 + (int)((float)n8 * f4), rectangle.y + n6, rectangle.x + n5 + (int)((float)n8 * f4), rectangle.y + n6 + n7);
                StringBuffer stringBuffer = new StringBuffer(Integer.toString(n8 * 20));
                stringBuffer.append("%");
                graphics2D.drawString(stringBuffer.substring(0), rectangle.x + n5 + (int)((float)n8 * f4), rectangle.y + n6 + n7 + 15);
                graphics2D.setColor(DIST_COLOR);
                int n10 = (nArray[n8] * 100 / (int)(f3 * (float)n9) * n7 - 1) / 100;
                int n11 = n8 == 4 ? (int)((float)n - f4 * (float)n8 - 1.0f) : (int)(f4 - 1.0f);
                graphics2D.fillRect(rectangle.x + n5 + (int)((float)n8 * f4) + 1, rectangle.y + n6 + n7 - n10, n11, n10);
            }
        } else {
            String string = this.bundle.getString("report_no_data");
            graphics2D.setColor(ALERT_COLOR);
            graphics2D.setFont(STD_FONT);
            Rectangle rectangle2 = STD_FONT.getStringBounds(string, graphics2D.getFontRenderContext()).getBounds();
            graphics2D.drawString(string, rectangle.x + n5 + (n - rectangle2.width) / 2, rectangle.y + n6 + n7 / 2 + rectangle2.height / 4);
        }
    }

    public static float getMaximOrdenades(float f, boolean bl) {
        float f2 = f * 100.0f;
        if (bl) {
            f2 /= 6.0f;
        }
        int n = (int)f2;
        int n2 = 0;
        while (n > 9) {
            n = (int)f2;
            f2 /= 10.0f;
            ++n2;
        }
        n = n == 1 ? 2 : (n > 1 && n < 5 ? 5 : 10);
        for (int i = 1; i < n2; ++i) {
            n *= 10;
        }
        return (float)n / 100.0f;
    }

    protected static String formatNumber(float f) {
        if (DF == null) {
            DF = new DecimalFormat();
            DF.setMaximumFractionDigits(1);
            DF.setGroupingUsed(false);
        }
        return DF.format(f);
    }

    static {
        if (DEFAULT_WIDTH == 0) {
            try {
                Img.loadSettings(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DF = null;
    }
}

