/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "uimain.h"
#include "widgets.h"
#include "callbacks.h"
#include "interface.h"
#include "mltlang.h"

void ConnectSignals(UIPropDlg *prop);

UIPropDlg* CreatePropDlg(UIDialog *parent, int ui_type , int color_mode, int special_func)
{
	UIPropDlg *prop;

	prop = (UIPropDlg *)CreateDialog(sizeof(UIPropDlg), parent);

	if(prop == NULL)
		return NULL;

	UI_DIALOG(prop)->window = create_PropertiesDlg();
	prop->ui_type = ui_type;
	prop->color_type = color_mode;
	prop->show_passwd = -1;
	prop->special_func = special_func;
#ifndef OLD_GTK
	GtkWidget *window;
	GtkRange *range;
	window = UI_DIALOG(prop)->window;
	range = GTK_RANGE(getWidget(window, "Cyan_hscale"));
	range->round_digits = 0;
	range = GTK_RANGE(getWidget(window, "Magenta_hscale"));
	range->round_digits = 0;
	range = GTK_RANGE(getWidget(window, "Yellow_hscale"));
	range->round_digits = 0;
	range = GTK_RANGE(getWidget(window, "Black_hscale"));
	range->round_digits = 0;
	range = GTK_RANGE(getWidget(window, "Sharpness_hscale"));
	range->round_digits = 0;
#endif
	ConnectSignals(prop);

	return prop;
}

void ConnectSignals(UIPropDlg *prop)
{
	GtkWidget *window;
	window = UI_DIALOG(prop)->window;
	HscaleSignalConnect(window, "BrightnessValue_hscale", GTK_SIGNAL_FUNC(on_BrightnessValue_hscale_value_changed));
	HscaleSignalConnect(window, "GammaValue_hscale", GTK_SIGNAL_FUNC(on_GammaValue_hscale_value_changed));
	HscaleSignalConnect(window, "Hue_hscale", GTK_SIGNAL_FUNC(on_Hue_hscale_value_changed));
	HscaleSignalConnect(window, "Saturation_hscale", GTK_SIGNAL_FUNC(on_Saturation_hscale_value_changed));
	HscaleSignalConnect(window, "ImgReso_hscale", GTK_SIGNAL_FUNC(on_ImgReso_hscale_value_changed));
	HscaleSignalConnect(window, "ImgPercent_hscale", GTK_SIGNAL_FUNC(on_ImgPercent_hscale_value_changed));
	HscaleSignalConnect(window, "ImgPagePercent_hscale", GTK_SIGNAL_FUNC(on_ImgPagePercent_hscale_value_changed));


	ComboSignalConnect(window, "Nup_combo", GTK_SIGNAL_FUNC(on_Nup_combo_popwin_event));
	ComboSignalConnect(window, "BannerStart_combo", GTK_SIGNAL_FUNC(on_BannerStart_combo_popwin_event));
	ComboSignalConnect(window, "BannerEnd_combo", GTK_SIGNAL_FUNC(on_BannerEnd_combo_popwin_event));
	ComboSignalConnect(window, "Filter_combo", GTK_SIGNAL_FUNC(on_Filter_combo_popwin_event));
	ComboSignalConnect(window, "PaperSize_combo", GTK_SIGNAL_FUNC(on_PaperSize_combo_popwin_event));
	ComboSignalConnect(window, "SpecialPrintAdjustmentA_combo", GTK_SIGNAL_FUNC(on_SpecialPrintAdjustmentA_combo_popwin_event));
	ComboSignalConnect(window, "SpecialPrintAdjustmentB_combo", GTK_SIGNAL_FUNC(on_SpecialPrintAdjustmentB_combo_popwin_event));

	if(prop->ui_type == PRINTER_TYPE_CAPT){
		ComboSignalConnect(window, "CaptPaperSource_combo", GTK_SIGNAL_FUNC(on_CaptPaperSource_combo_popwin_event));
		ComboSignalConnect(window, "CaptPaperType_combo", GTK_SIGNAL_FUNC(on_CaptPaperType_combo_popwin_event));
	}else{
		ComboSignalConnect(window, "BindingLocation_combo", GTK_SIGNAL_FUNC(on_BindingLocation_combo_popwin_event));
		ComboSignalConnect(window, "FinCollate_combo", GTK_SIGNAL_FUNC(on_FinCollate_combo_popwin_event));
		ComboSignalConnect(window, "StaplePosition_combo", GTK_SIGNAL_FUNC(on_StaplePosition_combo_popwin_event));
		ComboSignalConnect(window, "PaperDisti_combo", GTK_SIGNAL_FUNC(on_PaperDisti_combo_popwin_event));
		ComboSignalConnect(window, "PaperSource_combo", GTK_SIGNAL_FUNC(on_PaperSource_combo_popwin_event));
		ComboSignalConnect(window, "PaperType_combo", GTK_SIGNAL_FUNC(on_PaperType_combo_popwin_event));
		ComboSignalConnect(window, "QualityReso_combo", GTK_SIGNAL_FUNC(on_QualityReso_combo_popwin_event));
		ComboSignalConnect(window, "ColorMode_combo", GTK_SIGNAL_FUNC(on_ColorMode_combo_popwin_event));
		ComboSignalConnect(window, "QualityHalftone_combo", GTK_SIGNAL_FUNC(on_QualityHalftone_combo_popwin_event));
		ComboSignalConnect(window, "QualityTonerSave_combo", GTK_SIGNAL_FUNC(on_QualityTonerSave_combo_popwin_event));
		ComboSignalConnect(window, "QualityGrayComp_combo", GTK_SIGNAL_FUNC(on_QualityGrayComp_combo_popwin_event));
		ComboSignalConnect(window, "OutputMethod_combo", GTK_SIGNAL_FUNC(on_OutputMethod_combo_popwin_event));
		ComboSignalConnect(window, "OutputOption_combo", GTK_SIGNAL_FUNC(on_OutputOption_combo_popwin_event));
		ComboSignalConnect(window, "OutputSide_combo", GTK_SIGNAL_FUNC(on_OutputSide_combo_popwin_event));
		ComboSignalConnect(window, "ImgSpecialProc_combo", GTK_SIGNAL_FUNC(on_ImgSpecialProc_combo_popwin_event));
		ComboSignalConnect(window, "QualityDraftMode_combo", GTK_SIGNAL_FUNC(on_QualityDraftMode_combo_popwin_event));
		ComboSignalConnect(window, "InterleafMediaType_combo", GTK_SIGNAL_FUNC(on_InterleafMediaType_combo_popwin_event));
		ComboSignalConnect(window, "SourceOption_combo", GTK_SIGNAL_FUNC(on_SourceOption_combo_popwin_event));
		ComboSignalConnect(window, "QualityClrHalftone_combo", GTK_SIGNAL_FUNC(on_QualityClrHalftone_combo_popwin_event));
		ComboSignalConnect(window, "QualityKeepGray_combo", GTK_SIGNAL_FUNC(on_QualityKeepGray_combo_popwin_event));
		HscaleSignalConnect(window, "Cyan_hscale", GTK_SIGNAL_FUNC(on_Cyan_hscale_value_changed));
		HscaleSignalConnect(window, "Magenta_hscale", GTK_SIGNAL_FUNC(on_Magenta_hscale_value_changed));
		HscaleSignalConnect(window, "Yellow_hscale", GTK_SIGNAL_FUNC(on_Yellow_hscale_value_changed));
		HscaleSignalConnect(window, "Black_hscale", GTK_SIGNAL_FUNC(on_Black_hscale_value_changed));
		ComboSignalConnect(window, "QualityGradeSmooth_combo", GTK_SIGNAL_FUNC(on_QualityGradeSmooth_combo_popwin_event));
		ComboSignalConnect(window, "QualityImgRefine_combo", GTK_SIGNAL_FUNC(on_QualityImgRefine_combo_popwin_event));
		ComboSignalConnect(window, "QualityLineRefine_combo", GTK_SIGNAL_FUNC(on_QualityLineRefine_combo_popwin_event));
		ComboSignalConnect(window, "SpotColorMatching_combo", GTK_SIGNAL_FUNC(on_SpotColorMatching_combo_popwin_event));
		ComboSignalConnect(window, "OHPPrintMode_combo", GTK_SIGNAL_FUNC(on_OHPPrintMode_combo_popwin_event));
		ComboSignalConnect(window, "AdvancedSmooth_combo", GTK_SIGNAL_FUNC(on_AdvancedSmooth_combo_popwin_event));
		ComboSignalConnect(window, "SpecialPrintMode_combo", GTK_SIGNAL_FUNC(on_SpecialPrintMode_combo_popwin_event));
		ComboSignalConnect(window, "QualitySmallSizeCurl_combo", GTK_SIGNAL_FUNC(on_QualitySmallSizeCurl_combo_popwin_event));
		ComboSignalConnect(window, "ImageCompression_combo", GTK_SIGNAL_FUNC(on_ImageCompression_combo_popwin_event));
		ComboSignalConnect(window, "FinCfoldSetting_combo", GTK_SIGNAL_FUNC(on_FinCfoldSetting_combo_popwin_event));
		ComboSignalConnect(window, "LineControl_combo", GTK_SIGNAL_FUNC(on_LineControl_combo_popwin_event));
		ComboSignalConnect(window, "TonerVolumeAdjustment_combo", GTK_SIGNAL_FUNC(on_TonerVolumeAdjustment_combo_popwin_event));
		HscaleSignalConnect(window, "Sharpness_hscale", GTK_SIGNAL_FUNC(on_Sharpness_hscale_value_changed));
	}
}

void ShowPropDlg(UIPropDlg *dialog)
{
	GtkWidget *window;
	int show;
	char *printer_name;

	window = UI_DIALOG(dialog)->window;
	show = dialog->ui_type == PRINTER_TYPE_CAPT ? 0 : 1;
	SetShowPage(window, UI_PAGE_GENERAL, TRUE);
	SetShowPage(window, UI_PAGE_FINISH, show);
	SetShowPage(window, UI_PAGE_PAPER, show);
	SetShowPage(window, UI_PAGE_QUALITY, show);
	SetShowPage(window, UI_PAGE_SPECIAL, show);
	SetShowPage(window, UI_PAGE_CAPT, !show);
	SetShowPage(window, UI_PAGE_FILTER, TRUE);

	dialog->show_passwd = -1;

	CreatePropDlgWidget(dialog);

	SigDisable();
	UpdatePropGeneralWidgets(dialog, 0);
	UpdatePropFilterWidgets(dialog, 0);
	UpdateAllPPDWidgets(dialog);
	SigEnable();

	printer_name = GetCurrOpt(ID_PRINTERNAME, NULL);
	SetDialogTitle(window, printer_name);

	ChangeShowPage(window, UI_PAGE_GENERAL);

	ShowDialog((UIDialog *)dialog, "Property_button");
	memFree(printer_name);
}

void HidePropDlg(UIPropDlg *dialog, int apply)
{
	UIMainDlg *top = (UIMainDlg *)UI_DIALOG(dialog)->parent;
	HideDialog((UIDialog *)dialog);
	memFree(dialog->id_list);
	dialog->id_list = NULL;

	if(apply){
		cngplpSetData(top->data, ID_OK, "Prop");
	}else{
		cngplpSetData(top->data, ID_CANCEL, "Prop");
	}
}

int IsPS(void)
{
	return (g_main_window->prop->ui_type == PRINTER_TYPE_PS) ? 1 : 0;
}

int IsPortrait(void)
{
	int orientation = PORTRAIT;
	orientation = GetCurrOptInt(ID_ORIENTATION_REQUESTED, PORTRAIT);
	return (orientation == PORTRAIT || orientation == REV_PORT) ? 1 : 0;
}

int IsReverse(void)
{
	int orientation = PORTRAIT;
	orientation = GetCurrOptInt(ID_ORIENTATION_REQUESTED, PORTRAIT);
	return (orientation == REV_LAND || orientation == REV_PORT) ? 1 : 0;
}

int IsUS(void)
{
	return g_main_window->data->ppd_opt->us_type;
}

int GetCNTblMediaType(void)
{
	char *id_list_media;
	int ret = 0;

	id_list_media = GetOptionList(ID_LIST_MEDIATYPE);

	if(id_list_media != NULL){
		ret = atoi(id_list_media);
	}
	return ret;
}

int GetCNTblPageSize(void)
{
	char *id_list_pagesize;
	int ret = 0;

	id_list_pagesize = GetOptionList(ID_LIST_PAGESIZE);

	if(id_list_pagesize != NULL){
		ret = atoi(id_list_pagesize);
	}

	return ret;
}

int IsCAPT(void)
{
	if(GetCurrOptInt(ID_PRINTERTYPE, 0) == PRINTER_TYPE_CAPT)
		return 1;

	return 0;
}

int GetInputSlotType(void)
{
	char *id_input_slot_type;
	int type = 0;

	id_input_slot_type = GetOptionList(ID_INPUTSLOT_TYPE);

	if(id_input_slot_type != NULL){
		type = atoi(id_input_slot_type);
	}
	return type;
}

int GetOptionCassetteType(void)
{
	int ret = 0;
	char *type = NULL;

	if((type = GetCNUIValue("CNSrcOptionType")) != NULL){
		ret = atoi(type);
		free(type);
		return ret;
	}
	return 0;
}


