/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public abstract class ReportUtils {
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
    public static final String ALPHANUM_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String VALID_URL_CHARS = "-_.!~*'()";

    public static Date strToDate(String string) throws Exception {
        return ReportUtils.strToDate(string, false);
    }

    public static Date strToDate(String string, boolean bl) throws Exception {
        Calendar calendar = null;
        if (string.indexOf(47) > 0 || string.indexOf(45) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/- ");
            calendar = new GregorianCalendar(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()) - 1, Integer.parseInt(stringTokenizer.nextToken()), bl ? 23 : 0, bl ? 59 : 0, bl ? 59 : 0);
        } else if (string.length() >= 8) {
            calendar = new GregorianCalendar(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), bl ? 23 : 0, bl ? 59 : 0, bl ? 59 : 0);
        }
        return calendar.getTime();
    }

    public static String dateToStr(Date date) throws Exception {
        return SDF.format(date);
    }

    public static String urlEncode(String string, boolean bl, boolean bl2) {
        if (string == null || string.length() < 1) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (ALPHANUM_CHARS.indexOf(c) >= 0 || !bl && VALID_URL_CHARS.indexOf(c) >= 0 || bl2 && c == ' ') {
                stringBuffer.append(c);
                continue;
            }
            String string2 = Integer.toHexString(c);
            if (c < '\u0010') {
                stringBuffer.append("%0").append(string2);
                continue;
            }
            if (c > '\u00ff') {
                stringBuffer.append("%26%23").append(string2).append("%3B");
                continue;
            }
            stringBuffer.append("%").append(string2);
        }
        return stringBuffer.substring(0);
    }
}

