/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.rp.Basic;
import edu.xtec.jclic.report.rp.Main;
import edu.xtec.util.Encryption;
import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.ResourceBundle;

public class DbAdmin
extends Basic {
    public static String TITLE = "db_admin_title";
    public static String URL = "dbAdmin";
    public static final int MENU = 0;
    public static final int EDIT_SETTINGS = 1;
    public static final int UPDATE_SETTINGS = 2;
    public static final int EDIT_PWD = 3;
    public static final int UPDATE_PWD = 4;
    public static final String[] ACTIONS = new String[]{"", "edit", "update", "editPwd", "updatePwd"};
    public static final String ALLOW_GROUP_CREATE = "agc";
    public static final String ALLOW_USER_CREATE = "auc";
    public static final String SHOW_GROUP_LIST = "shgl";
    public static final String SHOW_USER_LIST = "shul";
    public static final String USER_TABLES = "ut";
    public static final String TIME_LAP = "lap";
    public static final String[] DB_BOOL_KEYS = new String[]{"ALLOW_CREATE_GROUPS", "ALLOW_CREATE_USERS", "SHOW_GROUP_LIST", "SHOW_USER_LIST", "USER_TABLES"};
    public static final String[] DB_BOOL_PARAMS = new String[]{"agc", "auc", "shgl", "shul", "ut"};
    public static final String[] DB_LITERAL_KEYS = new String[]{"TIME_LAP"};
    public static final String[] DB_LITERAL_PARAMS = new String[]{"lap"};
    public static final int[] DB_LITERAL_PARAMS_LENGTH = new int[]{4};
    public static final String PW_FIELD = "pw";
    protected int page;

    public String getTitle(ResourceBundle resourceBundle) {
        return resourceBundle.getString(TITLE);
    }

    public String getUrl() {
        return DbAdmin.urlParam(URL, "lang", this.lang);
    }

    public String getUrl(int n) {
        return DbAdmin.urlParam(this.getUrl(), "action", ACTIONS[n]);
    }

    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.page = this.getAction(ACTIONS, 0);
        switch (this.page) {
            case 2: {
                this.updateSettings();
                break;
            }
            case 4: {
                this.updatePwd();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettings() throws Exception {
        block10: {
            Exception exception = null;
            boolean[] blArray = new boolean[DB_BOOL_PARAMS.length];
            for (int i = 0; i < DB_BOOL_PARAMS.length; ++i) {
                blArray[i] = this.getBoolParam(DB_BOOL_PARAMS[i], "on");
            }
            String[] stringArray = new String[DB_LITERAL_PARAMS.length];
            for (int i = 0; i < DB_LITERAL_PARAMS.length; ++i) {
                stringArray[i] = this.getParam(DB_LITERAL_PARAMS[i]);
            }
            ConnectionBeanProvider connectionBeanProvider = bridge.getConnectionBeanProvider();
            ConnectionBean connectionBean = connectionBeanProvider.getConnectionBean();
            PreparedStatement preparedStatement = null;
            PreparedStatement preparedStatement2 = null;
            try {
                int n;
                preparedStatement = connectionBean.getPreparedStatement("UPDATE " + bridge.getTableName("SETTINGS") + " SET SETTING_VALUE=? WHERE SETTING_KEY=?");
                preparedStatement2 = connectionBean.getPreparedStatement("INSERT INTO " + bridge.getTableName("SETTINGS") + "(SETTING_KEY,SETTING_VALUE) VALUES(?,?)");
                for (n = 0; n < DB_BOOL_PARAMS.length; ++n) {
                    this.updateItem(DB_BOOL_KEYS[n], blArray[n] ? "true" : "false", preparedStatement, preparedStatement2);
                }
                for (n = 0; n < DB_LITERAL_PARAMS.length; ++n) {
                    this.updateItem(DB_LITERAL_KEYS[n], stringArray[n], preparedStatement, preparedStatement2);
                }
                connectionBean.closeStatement(preparedStatement);
                connectionBean.closeStatement(preparedStatement2);
                connectionBeanProvider.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                connectionBean.closeStatement(preparedStatement2);
                connectionBeanProvider.freeConnectionBean(connectionBean);
                if (exception == null) break block10;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    private void updateItem(String string, String string2, PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws Exception {
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            if (n == 0) {
                preparedStatement2.setString(1, string);
                preparedStatement2.setString(2, string2);
                n = preparedStatement2.executeUpdate();
            }
            if (n != 1) {
                throw new Exception(this.bundle.getString("db_admin_settings_error"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePwd() throws Exception {
        block9: {
            Exception exception = null;
            String string = this.getParam(PW_FIELD);
            Object var3_3 = null;
            ConnectionBeanProvider connectionBeanProvider = bridge.getConnectionBeanProvider();
            ConnectionBean connectionBean = connectionBeanProvider.getConnectionBean();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connectionBean.getPreparedStatement("SELECT count(*) FROM " + bridge.getTableName("SETTINGS") + " WHERE SETTING_KEY=?");
                preparedStatement.setString(1, "PASSWORD");
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string = string != null ? Encryption.Encrypt(string) : null;
                    int n = resultSet.getInt(1);
                    PreparedStatement preparedStatement2 = null;
                    if (n == 0) {
                        preparedStatement2 = connectionBean.getPreparedStatement("INSERT INTO " + bridge.getTableName("SETTINGS") + " (SETTING_KEY,SETTING_VALUE) VALUES(?,?)");
                        preparedStatement2.setString(1, "PASSWORD");
                        preparedStatement2.setString(2, string);
                    } else {
                        preparedStatement2 = connectionBean.getPreparedStatement("UPDATE " + bridge.getTableName("SETTINGS") + " SET SETTING_VALUE=? WHERE SETTING_KEY=?");
                        preparedStatement2.setString(1, string);
                        preparedStatement2.setString(2, "PASSWORD");
                    }
                    preparedStatement2.executeUpdate();
                    connectionBean.closeStatement(preparedStatement2);
                }
                resultSet.close();
                connectionBean.closeStatement(preparedStatement);
                connectionBeanProvider.freeConnectionBean(connectionBean);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                connectionBean.closeStatement(preparedStatement);
                connectionBeanProvider.freeConnectionBean(connectionBean);
                if (exception == null) break block9;
                throw exception;
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public void head(PrintWriter printWriter) throws Exception {
        super.head(printWriter);
        if (this.page == 3) {
            StringBuffer stringBuffer = new StringBuffer(500);
            this.writeEditPwdScript(stringBuffer);
            printWriter.println(stringBuffer.substring(0));
        }
    }

    public void body(PrintWriter printWriter) throws Exception {
        super.body(printWriter);
        String string = this.page == 1 ? "db_admin_edit_title" : (this.page == 3 ? "db_admin_pw_edit_title" : "db_admin_title");
        StringBuffer stringBuffer = new StringBuffer(3000);
        stringBuffer.append(DbAdmin.linkTo(DbAdmin.urlParam(Main.URL, "lang", this.lang), this.bundle.getString(Main.TITLE), null));
        if (this.page != 0) {
            stringBuffer.append(" | ").append(DbAdmin.linkTo(this.getUrl(), this.getTitle(this.bundle), null));
        }
        this.standardHeader(printWriter, DbAdmin.filter(this.getMsg(string)), stringBuffer.substring(0));
        stringBuffer.setLength(0);
        switch (this.page) {
            case 1: {
                stringBuffer.append("<form action=\"").append(this.getUrl(2)).append("\" method=\"post\">\n");
                stringBuffer.append("<div class=\"inputForm\">\n");
                this.writeAdminFields(stringBuffer, true);
                stringBuffer.append("<p><input type=\"submit\" value=\"").append(this.getMsg("submit")).append("\"></p>\n");
                stringBuffer.append("</div>\n");
                stringBuffer.append("</form>\n");
                break;
            }
            case 3: {
                this.writeEditPwd(stringBuffer);
                break;
            }
            default: {
                stringBuffer.append("<form>\n");
                stringBuffer.append("<div class=\"inputForm\">\n");
                this.writeAdminFields(stringBuffer, false);
                stringBuffer.append("<p>").append(DbAdmin.buttonTo(this.getUrl(1), this.bundle.getString("db_admin_edit_btn"), null));
                stringBuffer.append("&nbsp;");
                stringBuffer.append(DbAdmin.buttonTo(this.getUrl(3), this.bundle.getString("db_admin_pw_edit_btn"), null)).append("</p>");
                stringBuffer.append("</div>\n");
                stringBuffer.append("</form>\n");
            }
        }
        printWriter.println(stringBuffer.substring(0));
    }

    private void writeEditPwdScript(StringBuffer stringBuffer) throws Exception {
        stringBuffer.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        stringBuffer.append("<!--\n");
        stringBuffer.append(" function verifyPasswords(){\n");
        stringBuffer.append("  if (document.forms[0].").append(PW_FIELD).append("2.value==document.forms[0].").append(PW_FIELD).append(".value) document.forms[0].submit();\n");
        stringBuffer.append("  else{\n");
        stringBuffer.append("    alert(\"").append(this.getMsg("db_admin_pw_noFit")).append("\");\n");
        stringBuffer.append("    event.returnValue=false;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append(" }\n");
        stringBuffer.append("//-->\n");
        stringBuffer.append("</script>\n");
    }

    private void writeEditPwd(StringBuffer stringBuffer) throws Exception {
        stringBuffer.append("<form action=\"").append(DbAdmin.urlParam(this.getUrl(), "action", ACTIONS[4])).append("\" method=\"post\" onSubmit=\"verifyPasswords();\">\n");
        stringBuffer.append("<div class=\"inputForm\">\n");
        stringBuffer.append("<p>").append(this.getMsg("db_admin_pw_newPwd")).append(": ");
        stringBuffer.append("<input type=\"password\" length=\"40\" name=\"").append(PW_FIELD).append("\"></p>\n");
        stringBuffer.append("<p>").append(this.getMsg("db_admin_pw_verifyPwd")).append(": ");
        stringBuffer.append("<input type=\"password\" length=\"40\" name=\"").append(PW_FIELD).append("2\"></p>\n");
        stringBuffer.append("<p><input type=\"submit\" value=\"").append(this.getMsg("submit")).append("\">\n");
        stringBuffer.append("</div>\n");
        stringBuffer.append("</form>\n");
    }

    private void writeAdminFields(StringBuffer stringBuffer, boolean bl) throws Exception {
        String string;
        int n;
        HashMap hashMap = bridge.getProperties();
        for (n = 0; n < DB_BOOL_PARAMS.length; ++n) {
            stringBuffer.append("<p>").append(DbAdmin.filter(this.getMsg("db_admin_param_" + DB_BOOL_PARAMS[n])));
            stringBuffer.append(" <input type=\"checkbox\" name=\"").append(DB_BOOL_PARAMS[n]).append("\" value=\"").append("on").append("\"");
            if (!bl) {
                stringBuffer.append(" disabled");
            }
            if ((string = (String)hashMap.get(DB_BOOL_KEYS[n])) != null && string.trim().toLowerCase().equals("true")) {
                stringBuffer.append(" checked");
            }
            stringBuffer.append("></p>\n");
        }
        for (n = 0; n < DB_LITERAL_PARAMS.length; ++n) {
            stringBuffer.append("<p>");
            stringBuffer.append(DbAdmin.filter(this.getMsg("db_admin_param_" + DB_LITERAL_PARAMS[n])));
            stringBuffer.append(" <input name=\"").append(DB_LITERAL_PARAMS[n]).append("\"");
            string = (String)hashMap.get(DB_LITERAL_KEYS[n]);
            if (string != null) {
                stringBuffer.append(" value=\"").append(string).append("\"");
            }
            if (!bl) {
                stringBuffer.append(" disabled");
            }
            stringBuffer.append(" size=\"").append(DB_LITERAL_PARAMS_LENGTH[n]).append("\">");
            stringBuffer.append("</p>\n");
        }
    }
}

