/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report.rp;

import edu.xtec.jclic.report.ActivityData;
import edu.xtec.jclic.report.ReportUtils;
import edu.xtec.jclic.report.SessionData;
import edu.xtec.jclic.report.UserData;
import edu.xtec.jclic.report.rp.BasicReport;
import edu.xtec.jclic.report.rp.Img;
import edu.xtec.jclic.report.rp.Main;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class Report
extends BasicReport {
    public static final int DEFAULT_SELECT_WIDTH = 180;
    public static final String SESSION = "session";
    protected boolean isEditable = true;
    protected boolean userTables = true;
    protected String change;
    protected String opcioDefecte;
    protected Object[] session;
    protected Vector groups;
    protected Vector users;
    protected Vector projects;
    public static final String[] KCC_LABELS = new String[]{"report_key", "report_code", "report_context"};

    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        this.isEditable = !"false".equalsIgnoreCase(this.getParamNotNull("edit"));
        this.userTables = bridge.hasUserTables();
        if (this.userTables) {
            this.groups = bridge.getGroups();
            if (this.groupId.length() > 0) {
                this.users = bridge.getUsers(this.groupId);
            }
        }
        this.session = this.getParams(SESSION);
        this.change = this.getParam("change");
        switch ("group".equals(this.change) ? 0 : ("user".equals(this.change) ? 1 : ("date".equals(this.change) ? 2 : ("project".equals(this.change) ? 3 : ("activity".equals(this.change) ? 4 : 5))))) {
            case 0: {
                this.userId = this.users != null && this.users.size() > 0 ? ((UserData)this.users.get(0)).getId() : "";
            }
            case 1: {
                this.projectName = "-1";
            }
            case 2: 
            case 3: {
                this.session = null;
                this.activityName = "-1";
            }
        }
        return true;
    }

    public void head(PrintWriter printWriter) throws Exception {
        super.head(printWriter);
        StringBuffer stringBuffer = new StringBuffer(300);
        this.writeGoScript(stringBuffer);
        this.dm.writeDateScript(stringBuffer);
        printWriter.println(stringBuffer.substring(0));
    }

    public void body(PrintWriter printWriter) throws Exception {
        super.body(printWriter);
        StringBuffer stringBuffer = new StringBuffer(2000);
        if (this.isEditable) {
            stringBuffer.append(Report.linkTo(Report.urlParam(Main.URL, "lang", this.lang), this.bundle.getString(Main.TITLE), null));
        }
        this.standardHeader(printWriter, Report.filter(this.getTitle(this.bundle)), stringBuffer.substring(0));
        stringBuffer.setLength(0);
        stringBuffer.append("<form action=\"").append(this.getUrl()).append("\" method=\"post\" name=\"").append("mainForm").append("\">\n");
        stringBuffer.append("<input type=\"hidden\" name=\"").append("change").append("\" value=\"").append("new").append("\">\n");
        stringBuffer.append("<input type=\"hidden\" name=\"").append("lang").append("\" value=\"").append(this.lang).append("\">\n");
        this.dm.writeHiddenFields(stringBuffer);
        if (this.session != null) {
            for (int i = 0; i <= this.session.length; ++i) {
                stringBuffer.append("<input type=\"hidden\" name=\"").append(SESSION).append("\" value=\"");
                stringBuffer.append(i < this.session.length && this.session[i] != null ? (String)this.session[i] : "false").append("\">\n");
            }
        }
        if (!this.isEditable) {
            stringBuffer.append("<input type=\"hidden\" name=\"").append("edit").append("\" value=\"").append("false").append("\">\n");
        }
        printWriter.println(stringBuffer.substring(0));
    }

    protected void writeGoScript(StringBuffer stringBuffer) {
        stringBuffer.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        stringBuffer.append("<!--\n");
        stringBuffer.append(" function go(canvi){\n");
        stringBuffer.append("   document.").append("mainForm").append(".").append("change").append(".value=canvi;\n");
        stringBuffer.append("   document.").append("mainForm").append(".submit();\n");
        stringBuffer.append(" };\n");
        stringBuffer.append("//-->\n");
        stringBuffer.append("</script>\n");
    }

    protected void writeSessionScript(StringBuffer stringBuffer) {
        stringBuffer.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        stringBuffer.append("<!--\n");
        stringBuffer.append(" function session(id,v){\n");
        stringBuffer.append("     document.").append("mainForm").append(".").append(SESSION).append("[id].value=v\n");
        stringBuffer.append("     go('").append(SESSION).append("');\n");
        stringBuffer.append(" };\n");
        stringBuffer.append("//-->\n");
        stringBuffer.append("</script>\n");
    }

    protected void llista(StringBuffer stringBuffer, String string, boolean bl, String string2, String[][] stringArray, String string3, int n) {
        stringBuffer.append("<select name=\"").append(string);
        if (n > 0) {
            stringBuffer.append("\" style=\"width:").append(n).append("px\"");
        }
        stringBuffer.append(" size=\"1\"");
        if (bl) {
            stringBuffer.append(" onChange=\"go('").append(string).append("')\"");
        }
        stringBuffer.append(">\n");
        if (string2 != null) {
            stringBuffer.append("<option>").append(Report.filter(string2)).append("</option>\n");
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("<option value=\"").append(Report.filter(stringArray[i][0])).append("\"");
                if (string3 != null && string3.equals(stringArray[i][0])) {
                    stringBuffer.append(" selected");
                }
                stringBuffer.append(">").append(Report.filter(stringArray[i][1])).append("</option>\n");
            }
        } else {
            stringBuffer.append("<option>");
            for (int i = 0; i < 27; ++i) {
                stringBuffer.append("&nbsp;");
            }
            stringBuffer.append("</option>\n");
        }
        stringBuffer.append("</select>\n");
    }

    protected void zona(StringBuffer stringBuffer, String string, String string2, boolean bl, String string3, String[][] stringArray, String string4, boolean bl2, int n) {
        stringBuffer.append("<p>").append(Report.filter(this.getMsg(string))).append("&nbsp;");
        if (bl2 && stringArray != null) {
            this.llista(stringBuffer, string2, bl, string3, stringArray, string4, n);
        } else {
            stringBuffer.append("<input type=\"hidden\" name=\"").append(string2).append("\"");
            if (string4 != null) {
                stringBuffer.append(" value=\"").append(Report.filter(string4)).append("\"");
            }
            stringBuffer.append("/>\n");
            if (string4 != null && stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string4.equals(stringArray[i][0])) continue;
                    stringBuffer.append(Report.filter(stringArray[i][1])).append("\n");
                    break;
                }
            }
        }
        stringBuffer.append("</p>\n");
    }

    protected void zonaData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer(100);
        stringBuffer2.append("go('").append("date").append("')");
        this.dm.zonaData(stringBuffer, Report.buttonAction(stringBuffer2.substring(0), this.getMsg("submit"), null));
    }

    protected void zonaParams(StringBuffer stringBuffer) {
        stringBuffer.append("<div class=\"inputForm\" id=\"compact\">\n");
        for (int i = 0; i < KCC.length; ++i) {
            stringBuffer.append("<p>");
            if (this.isEditable) {
                stringBuffer.append(Report.filter(this.getMsg(KCC_LABELS[i]))).append("&nbsp;");
            }
            stringBuffer.append("<input name=\"").append(KCC[i]).append("\" size=\"8\"");
            if (this.kcc[i] != null) {
                stringBuffer.append(" value=\"").append(Report.filter(this.kcc[i])).append("\"");
            }
            if (!this.isEditable) {
                stringBuffer.append(" type=\"hidden\"");
            }
            stringBuffer.append("></p>\n");
        }
        stringBuffer.append("</div>\n");
    }

    protected void grafic(StringBuffer stringBuffer, String string, boolean bl, boolean bl2) throws Exception {
        int n = bl ? Img.DIST_WIDTH : Img.DEFAULT_WIDTH;
        int n2 = Img.DEFAULT_HEIGHT + Img.DEFAULT_HEADER_HEIGHT;
        StringBuffer stringBuffer2 = new StringBuffer(300);
        stringBuffer2.append("img");
        Report.urlParamSb(stringBuffer2, "type", string, true);
        if (bl) {
            Report.urlParamSb(stringBuffer2, "dist", "true", false);
        }
        if (bl2) {
            Report.urlParamSb(stringBuffer2, "header", "true", false);
        }
        Report.urlParamSb(stringBuffer2, "w", Integer.toString(n), false);
        Report.urlParamSb(stringBuffer2, "h", Integer.toString(n2), false);
        Report.urlParamSb(stringBuffer2, "pid", this.pageId, false);
        Report.urlParamSb(stringBuffer2, "user", this.userId, false);
        Report.urlParamSb(stringBuffer2, "group", this.groupId, false);
        if (this.projectName.length() > 0 && !this.projectName.equals("-1")) {
            Report.urlParamSb(stringBuffer2, "project", this.projectName, false);
        }
        if (this.activityName.length() > 0 && !this.activityName.equals("-1")) {
            Report.urlParamSb(stringBuffer2, "activity", this.activityName, false);
        }
        for (int i = 0; i < KCC.length; ++i) {
            Report.urlParamSb(stringBuffer2, KCC[i], this.kcc[i], false);
        }
        Report.urlParamSb(stringBuffer2, "from", ReportUtils.dateToStr(this.dm.dFrom), false);
        Report.urlParamSb(stringBuffer2, "to", ReportUtils.dateToStr(this.dm.dTo), false);
        stringBuffer.append("<img src=\"").append(stringBuffer2).append("\" width=\"").append(n).append("\" height=\"").append(n2).append("\">");
    }

    protected void llistaSessions(StringBuffer stringBuffer, Vector vector, boolean bl, String string, String string2) throws Exception {
        int n = 0;
        stringBuffer.append("<table class=\"").append(string).append("\"");
        if (string2 != null) {
            stringBuffer.append(" style=\"").append(string2).append("");
        }
        stringBuffer.append(">\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_date"))).append("</th>\n");
        ++n;
        if (this.type == 2 || this.type == 1) {
            stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_user"))).append("</th>\n");
            stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_sessions"))).append("</th>\n");
            n += 2;
        }
        if (this.type == 0) {
            stringBuffer.append("<th colspan=2>").append(Report.toNbsp(this.getMsg("report_header_project"))).append("</th>\n");
            n += 2;
        }
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_numActs"))).append("</th>\n");
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_actsSolved"))).append("</th>\n");
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_time"))).append("</th>\n");
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_prec"))).append("</th>\n");
        n += 4;
        stringBuffer.append("</tr>\n");
        StringBuffer stringBuffer2 = new StringBuffer(500);
        StringBuffer stringBuffer3 = new StringBuffer(100);
        for (int i = 0; i < vector.size(); ++i) {
            boolean bl2;
            SessionData sessionData = (SessionData)vector.get(i);
            stringBuffer.append("<tr>\n");
            stringBuffer2.setLength(0);
            boolean bl3 = bl && sessionData.id != null && sessionData.id.length() > 0;
            boolean bl4 = bl2 = bl3 && sessionData.actData != null;
            if (bl) {
                if (bl3) {
                    stringBuffer2.append("<a href=\"javascript:session(").append(i).append(",'").append(bl2 ? "false" : "true").append("')\">");
                    stringBuffer2.append("<img src=\"").append(Report.resourceUrl(bl2 ? "menys.gif" : "mes.gif"));
                    stringBuffer2.append("\" width=\"9\" height=\"9\" border=\"0\" alt=\"");
                    stringBuffer2.append(this.getMsg("report_session_detail_" + (bl2 ? "hide" : "show"))).append("\" id=\"noPrint\">");
                    stringBuffer2.append("</a>&nbsp;");
                } else {
                    stringBuffer2.append("&nbsp;&nbsp;");
                }
            }
            stringBuffer2.append(this.shortDateFormat.format(sessionData.date));
            stringBuffer3.setLength(0);
            if (bl2) {
                stringBuffer3.append(" valign=\"top\" rowspan=\"").append(sessionData.actData.size() + 2).append("\"");
            }
            stringBuffer.append("<td align=\"right\"").append(stringBuffer3.substring(0)).append(">").append(stringBuffer2.substring(0)).append("</td>\n");
            if (this.type == 1 || this.type == 2) {
                String string3 = sessionData.getUsr();
                if ("*".equals(string3)) {
                    stringBuffer2.setLength(0);
                    stringBuffer2.append("(").append(this.numberFormat.format(sessionData.users.size())).append(" ").append(this.bundle.getString("report_n_users")).append(")");
                    string3 = stringBuffer2.substring(0);
                }
                stringBuffer.append("<td align=\"right\">").append(Report.filter(string3)).append("</td>\n");
                stringBuffer.append("<td align=\"right\">").append(this.numberFormat.format(sessionData.sessionCount)).append("</td>\n");
            }
            if (this.type == 0) {
                stringBuffer.append("<td align=\"left\" colspan=2>").append(Report.filter(sessionData.project)).append("</td>\n");
            }
            stringBuffer.append("<td align=\"right\">").append(this.numberFormat.format(sessionData.numActs)).append("</td>\n");
            stringBuffer.append("<td align=\"right\">").append(this.numberFormat.format(sessionData.actsSolved)).append("&nbsp;(").append(this.numberFormat.format(sessionData.percentSolved())).append("%)</td>\n");
            stringBuffer.append("<td align=\"right\">").append(this.formatTime(sessionData.totalTime)).append("</td>\n");
            stringBuffer.append("<td align=\"right\">").append(this.numberFormat.format(sessionData.percentPrec())).append("%</td>\n");
            stringBuffer.append("</tr>\n");
            if (!bl2) continue;
            this.llistaActivitats(stringBuffer, sessionData.actData);
        }
        stringBuffer.append("</table>");
    }

    protected void llistaActivitats(StringBuffer stringBuffer, Vector vector) throws Exception {
        stringBuffer.append("<tr id=\"t2x\">\n");
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_activity"))).append("</th>\n");
        if (this.type == 2 || this.type == 1) {
            stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_user"))).append("</th>\n");
        }
        if (this.type == 1) {
            stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_project"))).append("</th>\n");
        }
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_solved"))).append("</th>\n");
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_actions"))).append("</th>\n");
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_score"))).append("</th>\n");
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_time"))).append("</th>\n");
        stringBuffer.append("<th>").append(Report.toNbsp(this.getMsg("report_header_prec"))).append("</th>\n");
        stringBuffer.append("</tr>\n");
        for (int i = 0; i < vector.size(); ++i) {
            ActivityData activityData = (ActivityData)vector.get(i);
            stringBuffer.append("<tr id=\"t2x\">\n");
            stringBuffer.append("<td>").append(Report.filter(activityData.activityName)).append("</td>\n");
            if (this.type == 2 || this.type == 1) {
                stringBuffer.append("<td></td>\n");
            }
            if (this.type == 1) {
                stringBuffer.append("<td>").append(Report.filter(activityData.project)).append("</td>\n");
            }
            stringBuffer.append("<td id=\"").append(activityData.solved ? "green" : "red").append("\">");
            stringBuffer.append(this.getMsg(activityData.solved ? "YES_SHORT" : "NOT_SHORT")).append("</td>\n");
            stringBuffer.append("<td align=\"right\">").append(this.numberFormat.format(activityData.actions)).append("</td>\n");
            stringBuffer.append("<td align=\"right\">").append(this.numberFormat.format(activityData.score)).append("&nbsp;(").append(this.numberFormat.format(activityData.percentSolved())).append("%)</td>\n");
            stringBuffer.append("<td align=\"right\">").append(this.formatTime(activityData.time)).append("</td>\n");
            stringBuffer.append("<td align=\"right\">").append(this.numberFormat.format(activityData.qualification)).append("%</td>\n");
            stringBuffer.append("</tr>\n");
        }
    }

    protected void resumGlobal(StringBuffer stringBuffer, Vector vector, String string, String string2) throws Exception {
        Serializable serializable;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!this.projectName.equals("-1")) {
            n3 = 1;
        } else if (this.projects != null) {
            n3 = this.projects.size();
            if (this.projects.size() > 0 && "-1".equals(this.projects.get(0))) {
                --n3;
            }
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            serializable = (SessionData)iterator.next();
            n4 += ((SessionData)serializable).numActs;
            n5 += ((SessionData)serializable).actsSolved;
            n6 += ((SessionData)serializable).totalTime;
            n7 += ((SessionData)serializable).totalPrec;
            n += ((SessionData)serializable).sessionCount;
            hashSet.addAll(((SessionData)serializable).users);
        }
        n2 = hashSet.size();
        stringBuffer.append("<table class=\"").append(string).append("\"");
        if (string2 != null) {
            stringBuffer.append(" style=\"").append(string2).append("\"");
        }
        stringBuffer.append(">\n");
        stringBuffer.append("<tr><th colspan=2>").append(Report.filter(this.getMsg("report_globalSummary"))).append("</th></tr>\n");
        if (n2 > 1) {
            this.resumTD(stringBuffer, this.getMsg("report_users"), this.numberFormat.format(n2));
        }
        this.resumTD(stringBuffer, this.getMsg("report_sessions"), this.numberFormat.format(n));
        if (this.type != 2) {
            this.resumTD(stringBuffer, this.getMsg("report_projects"), this.numberFormat.format(n3));
        }
        this.resumTD(stringBuffer, this.getMsg("report_actDone"), this.numberFormat.format(n4));
        serializable = new StringBuffer(200);
        ((StringBuffer)serializable).append(this.numberFormat.format(n5)).append(" (").append(this.numberFormat.format(n4 == 0 ? 0L : (long)(100 * n5 / n4))).append("%)");
        this.resumTD(stringBuffer, this.getMsg("report_actSolved"), ((StringBuffer)serializable).substring(0));
        this.resumTD(stringBuffer, this.getMsg("report_totalTime"), this.formatTime(n6));
        ((StringBuffer)serializable).setLength(0);
        ((StringBuffer)serializable).append(this.numberFormat.format(n4 == 0 ? 0L : (long)(n7 / n4))).append("%");
        this.resumTD(stringBuffer, this.getMsg("report_globalPrec"), ((StringBuffer)serializable).substring(0));
        stringBuffer.append("</table>\n");
    }

    protected void resumTD(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("<tr><td>").append(Report.toNbsp(string));
        stringBuffer.append("</td><td align=\"right\">").append(Report.toNbsp(string2)).append("</td></tr>\n");
    }

    public String formatTime(int n) {
        n = Math.max(0, n);
        String[] stringArray = Report.getFormattedNumbers();
        int n2 = n / 3600;
        int n3 = (n - n2 * 60 * 60) / 60;
        int n4 = n % 60;
        StringBuffer stringBuffer = new StringBuffer(8);
        if (n2 > 0) {
            stringBuffer.append(n2).append(":");
        }
        stringBuffer.append(stringArray[n3]).append(":").append(stringArray[n4]);
        return stringBuffer.substring(0);
    }
}

