/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Player;
import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.project.ProjectInstallerDlg;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.util.KJMenuItem;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;

public class ExtendedPlayer
extends Player {
    JFrame debugFrame = null;
    public static final String MESSAGES_BUNDLE = "messages.PlayerMessages";
    protected int recentFilesOffset;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu recentFilesMenu;
    protected JMenu activityMenu;
    protected JMenu toolsMenu;
    protected JMenu helpMenu;
    protected PlayerSettings settings;
    public static final int ACTION_OPEN_FILE = 8;
    public static final int ACTION_OPEN_URL = 9;
    public static final int ACTION_EXIT = 10;
    public static final int ACTION_SETTINGS = 11;
    public static final int ACTION_LIBRARIES = 12;
    public static final int ACTION_ABOUT = 13;
    public static final int NUM_ACTIONS_EXT = 14;
    public static final String[] ACTION_NAME_EXT = new String[]{"openFile", "openUrl", "exit", "settings", "libraries", "helpAbout"};
    public static final String[] ACTION_ICONS_EXT = new String[]{"icons/file_open.gif", "icons/world.gif", "icons/exit_small.gif", "icons/settings.gif", "icons/database.gif", "icons/help.gif"};

    public ExtendedPlayer(Options options) {
        super(options);
    }

    protected void init() {
        this.settings = PlayerSettings.loadPlayerSettings(this);
        super.init();
        this.settings.checkLibrary();
    }

    protected void doInstall(String string) {
        if (this.settings.promptPassword(this, new String[]{"install_info_description", "settings_passwordRequired"})) {
            try {
                ProjectInstallerDlg projectInstallerDlg = ProjectInstallerDlg.getProjectInstallerDlg(this, this.settings.libraryManager, string);
                if (projectInstallerDlg != null) {
                    projectInstallerDlg.setVisible(true);
                    if (projectInstallerDlg.result != null && !projectInstallerDlg.cancel) {
                        if (projectInstallerDlg.launchNow && projectInstallerDlg.pathToMainProject != null) {
                            this.load(projectInstallerDlg.pathToMainProject, null);
                        } else {
                            this.launchProjectLibrary(projectInstallerDlg.result);
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error installing!");
                exception.printStackTrace();
            }
        }
    }

    public boolean start(String string, String string2) {
        boolean bl = super.start(string, string2);
        if (!bl) {
            try {
                ProjectLibrary projectLibrary = this.settings.libraryManager.getAutoStartProjectLibrary();
                if (projectLibrary != null) {
                    this.launchProjectLibrary(projectLibrary);
                }
            }
            catch (Exception exception) {
                System.err.println("Error loading autoStart project library!\n" + exception);
            }
        }
        return bl;
    }

    public boolean load(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 == null && string.endsWith(".jclic.inst")) {
            this.doInstall(string);
        } else {
            bl = super.load(string, string2);
        }
        return bl;
    }

    public Messages setMessages() {
        super.setMessages();
        this.messages.addBundle(MESSAGES_BUNDLE);
        return this.messages;
    }

    protected FileSystem createFileSystem() {
        return this.settings.fileSystem;
    }

    protected void createMenu() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(this.messages.get("m_File"));
        this.fileMenu.setMnemonic(this.messages.get("m_File_Mnemonic").charAt(0));
        this.fileMenu.add(new KJMenuItem(this.getAction(8)));
        this.fileMenu.add(new KJMenuItem(this.getAction(9)));
        this.menuBar.add(this.fileMenu);
        this.activityMenu = new JMenu(this.messages.get("m_Activity"));
        this.activityMenu.setMnemonic(this.messages.get("m_Activity_Mnemonic").charAt(0));
        this.activityMenu.add(new KJMenuItem(this.getAction(1)));
        this.activityMenu.add(new KJMenuItem(this.getAction(0)));
        this.activityMenu.add(new KJMenuItem(this.getAction(2)));
        this.activityMenu.add(new KJMenuItem(this.getAction(3)));
        this.activityMenu.addSeparator();
        this.activityMenu.add(new KJMenuItem(this.getAction(4)));
        this.activityMenu.add(new KJMenuItem(this.getAction(5)));
        this.activityMenu.add(new KJMenuItem(this.getAction(7)));
        this.activityMenu.addSeparator();
        this.activityMenu.add(new KJMenuItem(this.getAction(6)));
        this.menuBar.add(this.activityMenu);
        this.toolsMenu = new JMenu(this.messages.get("m_Tools"));
        this.toolsMenu.setMnemonic(this.messages.get("m_Tools_Mnemonic").charAt(0));
        this.toolsMenu.add(new KJMenuItem(this.getAction(12)));
        this.toolsMenu.add(new KJMenuItem(this.getAction(11)));
        this.menuBar.add(this.toolsMenu);
        this.helpMenu = new JMenu(this.messages.get("m_Help"));
        this.helpMenu.setMnemonic(this.messages.get("m_Help_Mnemonic").charAt(0));
        this.helpMenu.add(new KJMenuItem(this.getAction(13)));
        this.menuBar.add(this.helpMenu);
    }

    protected void postCreateMenu() {
        this.fileMenu.addSeparator();
        this.fileMenu.add(new KJMenuItem(this.getAction(10)));
        this.fileMenu.addSeparator();
        this.recentFilesMenu = this.fileMenu;
        this.recentFilesOffset = this.fileMenu.getItemCount();
        this.updateRecentFilesMenu();
    }

    public void addTo(RootPaneContainer rootPaneContainer, Object object) {
        super.addTo(rootPaneContainer, object);
        this.checkMenu(false);
    }

    protected void checkMenu(boolean bl) {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return;
        }
        if (bl || jRootPane.getJMenuBar() == null) {
            if (bl || this.menuBar == null) {
                this.createMenu();
                this.postCreateMenu();
            }
            jRootPane.setJMenuBar(this.menuBar);
            jRootPane.revalidate();
        }
    }

    protected void updateRecentFilesMenu() {
        if (this.recentFilesMenu != null && this.recentFilesOffset >= 0) {
            int n;
            int n2 = this.recentFilesMenu.getItemCount() - this.recentFilesOffset;
            for (n = 0; n < n2; ++n) {
                this.recentFilesMenu.remove(this.recentFilesOffset);
            }
            for (n = 0; n < PlayerSettings.MAX_RECENT; ++n) {
                if (this.settings.recentFiles[n] == null) continue;
                String string = this.settings.recentFiles[n];
                int n3 = string.lastIndexOf(92);
                if (n3 < 0) {
                    n3 = string.lastIndexOf(47);
                }
                if (n3 >= 0) {
                    string = string.substring(n3 + 1);
                }
                this.createMenuItem(this.recentFilesMenu, Integer.toString(n + 1) + ". " + string, "recent" + n, true, KeyStroke.getKeyStroke(49 + n, 8));
            }
        }
    }

    JMenuItem createMenuItem(JComponent jComponent, String string, String string2, boolean bl, KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (string2 != null) {
            jMenuItem.setActionCommand(string2);
            jMenuItem.addActionListener(this);
        }
        if (bl) {
            jMenuItem.setMnemonic(jMenuItem.getText().charAt(0));
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jComponent.add(jMenuItem);
        return jMenuItem;
    }

    protected int getNumActions() {
        return 14;
    }

    protected void buildActions() {
        super.buildActions();
        this.actions[8] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                int[] nArray;
                String string2;
                FileSystem fileSystem = ExtendedPlayer.this.project.getFileSystem();
                if (fileSystem.isUrlBased()) {
                    fileSystem = ExtendedPlayer.this.settings.fileSystem;
                }
                if ((string2 = fileSystem.chooseFile(null, false, nArray = new int[]{5, 7, 4}, ExtendedPlayer.this.options, null, ExtendedPlayer.this, false)) != null && ExtendedPlayer.this.load(string = fileSystem.getFullFileNamePath(string2), null)) {
                    ExtendedPlayer.this.addRecentFile(string);
                }
            }
        };
        this.actions[9] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ExtendedPlayer.this.messages.showInputDlg((Component)ExtendedPlayer.this, "URL_OPEN", "URL", "http://", "URL_OPEN", false);
                if (string != null) {
                    if ((string = string.trim()).startsWith("http://http://")) {
                        string = string.substring(7);
                    }
                    if (string.length() > 0 && !string.equals("http://") && ExtendedPlayer.this.load(string, null)) {
                        ExtendedPlayer.this.addRecentFile(string);
                    }
                }
            }
        };
        this.actions[10] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedPlayer.this.exit();
            }
        };
        this.actions[11] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ExtendedPlayer.this.options.getString("lookAndFeel");
                String string2 = ExtendedPlayer.this.options.getString("language");
                String string3 = ExtendedPlayer.this.options.getString("country");
                String string4 = ExtendedPlayer.this.options.getString("variant");
                String string5 = ExtendedPlayer.this.options.getString("skin");
                String string6 = ExtendedPlayer.this.settings.reporterClass;
                String string7 = ExtendedPlayer.this.settings.reporterParams;
                boolean bl = ExtendedPlayer.this.settings.reporterEnabled;
                String string8 = ExtendedPlayer.this.settings.mediaSystem;
                if (ExtendedPlayer.this.settings.edit(ExtendedPlayer.this)) {
                    AbstractButton abstractButton;
                    ExtendedPlayer.this.settings.save();
                    ExtendedPlayer.this.options.syncProperties(ExtendedPlayer.this.settings.getProperties(), false);
                    if (!ExtendedPlayer.this.settings.skin.equals(string5)) {
                        ExtendedPlayer.this.initSkin();
                        ExtendedPlayer.this.setSkin(null);
                    } else if (ExtendedPlayer.this.getSkin() != null && (abstractButton = ExtendedPlayer.this.getSkin().getButton(6)) != null) {
                        abstractButton.setSelected(!ExtendedPlayer.this.audioEnabled);
                    }
                    boolean bl2 = false;
                    if (!ExtendedPlayer.this.settings.lookAndFeel.equals(string)) {
                        ExtendedPlayer.this.options.setLookAndFeel();
                        bl2 = true;
                    }
                    if (!(ExtendedPlayer.this.settings.language == null || StrUtils.compareObjects(ExtendedPlayer.this.settings.language, string2) && StrUtils.compareObjects(ExtendedPlayer.this.settings.country, string3) && StrUtils.compareObjects(ExtendedPlayer.this.settings.variant, string4))) {
                        ExtendedPlayer.this.setMessages();
                        bl2 = true;
                    }
                    if (bl2) {
                        ExtendedPlayer.this.checkMenu(true);
                    }
                    if (!(!ExtendedPlayer.this.settings.reporterEnabled || ExtendedPlayer.this.settings.reporterClass.equals(string6) && ExtendedPlayer.this.settings.reporterParams.equals(string7))) {
                        ExtendedPlayer.this.initReporter();
                    }
                    ExtendedPlayer.this.audioEnabled = ExtendedPlayer.this.settings.soundEnabled;
                    EventSounds.globalEnabled = ExtendedPlayer.this.settings.systemSounds;
                    if (!string8.equals(ExtendedPlayer.this.settings.mediaSystem)) {
                        ExtendedPlayer.this.options.put("mediaSystem", ExtendedPlayer.this.settings.mediaSystem);
                        CheckMediaSystem.check(ExtendedPlayer.this.options, false);
                        ExtendedPlayer.this.createEventSounds();
                    }
                }
            }
        };
        this.actions[12] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ProjectLibrary projectLibrary = ExtendedPlayer.this.settings.libraryManager.selectProjectLibrary(true, false);
                    if (projectLibrary != null) {
                        ExtendedPlayer.this.launchProjectLibrary(projectLibrary);
                    }
                }
                catch (Exception exception) {
                    ExtendedPlayer.this.messages.showErrorWarning(ExtendedPlayer.this, "error_launchLibrary", exception);
                }
            }
        };
        this.actions[13] = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedPlayer.this.showAbout(false);
            }
        };
    }

    protected String getActionName(int n) {
        if (n >= 8 && n < 14) {
            return ACTION_NAME_EXT[n - 8];
        }
        return super.getActionName(n);
    }

    protected Icon getActionIcon(int n) {
        if (n >= 8 && n < 14) {
            return ResourceManager.getImageIcon(ACTION_ICONS_EXT[n - 8]);
        }
        return super.getActionIcon(n);
    }

    protected boolean processActionEvent(String string) {
        if (string.startsWith("recent") && string.length() > 6) {
            try {
                int n = Integer.parseInt(string.substring(6));
                if (n >= 0 && n < PlayerSettings.MAX_RECENT && this.settings.recentFiles[n] != null) {
                    this.load(this.settings.recentFiles[n], null);
                }
            }
            catch (Exception exception) {
                System.err.println("invalid command: " + string);
            }
        } else {
            return super.processActionEvent(string);
        }
        return true;
    }

    protected void launchProjectLibrary(ProjectLibrary projectLibrary) {
        if (projectLibrary != null) {
            this.setProject(null);
            MediaContent mediaContent = new MediaContent();
            mediaContent.externalParam = projectLibrary.getFullPath();
            mediaContent.mediaFileName = projectLibrary.activitySequence.getElement(0, false).getTag();
            mediaContent.mediaType = 8;
            this.playMedia(mediaContent, null);
        }
    }

    protected void addRecentFile(String string) {
        this.settings.addRecentFile(string);
        this.updateRecentFilesMenu();
        this.settings.save();
    }
}

