/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.ComplexEvaluator;
import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TargetMarkerBag;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Actions;
import edu.xtec.util.JDomUtility;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import org.jdom.Element;

public class FillInBlanks
extends TextActivityBase {
    protected boolean autoJump = false;
    protected boolean forceOkToAdvance = false;
    protected Evaluator ev;
    public static final String AUTO_JUMP = "autoJump";
    public static final String FORCE_OK_TO_ADVANCE = "forceOkToAdvance";

    public FillInBlanks(JClicProject jClicProject) {
        super(jClicProject);
        this.ev = new ComplexEvaluator(jClicProject);
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        if (this.autoJump) {
            element.setAttribute(AUTO_JUMP, JDomUtility.boolString(this.autoJump));
        }
        if (this.forceOkToAdvance) {
            element.setAttribute(FORCE_OK_TO_ADVANCE, JDomUtility.boolString(this.forceOkToAdvance));
        }
        element.addContent(this.ev.getJDomElement());
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        this.ev = Evaluator.getEvaluator(element.getChild("evaluator"), this.project);
        this.autoJump = JDomUtility.getBoolAttr(element, AUTO_JUMP, this.autoJump);
        this.forceOkToAdvance = JDomUtility.getBoolAttr(element, FORCE_OK_TO_ADVANCE, this.forceOkToAdvance);
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        ((ComplexEvaluator)this.ev).setProperties(clic3Activity);
        this.forceOkToAdvance = clic3Activity.okToNext;
        this.autoJump = !clic3Activity.avNoSalta;
        this.hasCheckButton = !clic3Activity.avCont;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    class Panel
    extends TextActivityBase.Panel {
        boolean locked;
        TextActivityDocument playDoc;

        protected Panel(PlayStation playStation) {
            super(FillInBlanks.this, playStation);
            this.playDoc = null;
            this.locked = true;
        }

        protected void initDocument() throws Exception {
            if (FillInBlanks.this.tad != null) {
                this.playing = false;
                FillInBlanks.this.tad.tmb.setCurrentTarget(null, this);
                FillInBlanks.this.tad.tmb.reset();
                this.playDoc = new TextActivityDocument(FillInBlanks.this.styleContext);
                FillInBlanks.this.tad.cloneDoc(this.playDoc, false, true, false);
                this.pane.setStyledDocument(this.playDoc);
                this.playDoc.attachTo(this.pane, this);
                FillInBlanks.this.tad.tmb.setParentPane(this.pane);
                this.pane.setEnabled(true);
                if (this.playDoc.tmb.size() > 0) {
                    this.pane.setEditable(true);
                    this.pane.requestFocus();
                    this.pane.getCaret().setVisible(true);
                    this.setCaretPos(0);
                    this.locked = false;
                } else {
                    this.locked = true;
                    this.pane.setEditable(false);
                    this.pane.getCaret().setVisible(false);
                }
            }
        }

        protected TextActivityPane buildPane() {
            FillInBlanksPane fillInBlanksPane = new FillInBlanksPane();
            fillInBlanksPane.setActions();
            return fillInBlanksPane;
        }

        protected boolean evalTarget(TargetMarker targetMarker) {
            if (targetMarker.target == null) {
                return false;
            }
            String string = targetMarker.getCurrentText("fill");
            if (string == null || string.length() < 1) {
                return false;
            }
            byte[] byArray = FillInBlanks.this.ev.evalText(string, targetMarker.target.answer);
            boolean bl = Evaluator.isOk(byArray);
            targetMarker.target.targetStatus = bl ? 2 : 3;
            this.markTarget(targetMarker, byArray);
            return bl;
        }

        protected void markTarget(TargetMarker targetMarker, byte[] byArray) {
            if (targetMarker.target.comboList != null) {
                targetMarker.target.comboList.checkColors();
                targetMarker.target.comboList.repaint();
                return;
            }
            int n = targetMarker.begPos.getOffset();
            int n2 = targetMarker.endPos.getOffset();
            int n3 = 0;
            for (int i = n; i < n2 && n3 < byArray.length; ++i) {
                if (this.playDoc.checkBooleanAttribute(i, "fill")) continue;
                this.playDoc.setCharacterAttributes(i, 1, FillInBlanks.this.styleContext.getStyle(byArray[n3] == 0 ? "target" : "targetError"), false);
                ++n3;
            }
        }

        protected void setCaretPos(int n) {
            this.setCaretPos(n, this.pane.getCaret().getDot(), true);
        }

        protected void setCaretPos(int n, int n2, boolean bl) {
            int n3 = this.checkCaretPos(n, bl);
            if (n3 == -1) {
                this.pane.setEditable(false);
            } else if (n3 != n2) {
                this.pane.setCaretPosition(n3);
            }
        }

        protected int checkCaretPos(int n, boolean bl) {
            TargetMarkerBag targetMarkerBag = this.playDoc.tmb;
            TargetMarker targetMarker = targetMarkerBag.getElementByOffset(n, true);
            int n2 = n;
            if (targetMarker == null) {
                targetMarker = targetMarkerBag.getNearestElement(n, bl);
                if (targetMarker == null) {
                    targetMarker = targetMarkerBag.getNearestElement(n, !bl);
                }
                if (targetMarker == null) {
                    this.pane.setEditable(false);
                    this.locked = true;
                    return -1;
                }
                n2 = bl ? targetMarker.begPos.getOffset() : targetMarker.endPos.getOffset();
            }
            if (targetMarkerBag.getCurrentTarget() != targetMarker || targetMarker.target.comboList != null) {
                n2 = this.goToTarget(targetMarker, n2);
            }
            return n2;
        }

        protected int goToTarget(TargetMarker targetMarker, int n) {
            int n2 = n;
            TargetMarkerBag targetMarkerBag = this.playDoc.tmb;
            if (targetMarkerBag.getCurrentTarget() != null && !FillInBlanks.this.hasCheckButton) {
                TargetMarker targetMarker2 = targetMarkerBag.getCurrentTarget();
                if (!FillInBlanks.this.hasCheckButton && targetMarker2 != null && (targetMarker2.target.isModified() || FillInBlanks.this.forceOkToAdvance)) {
                    boolean bl = this.evalTarget(targetMarker2);
                    if (!bl) {
                        targetMarker2.target.checkPopup(this, targetMarker2, false);
                    }
                    int n3 = targetMarkerBag.countSolvedTargets();
                    this.ps.reportNewAction(this.getActivity(), "WRITE", targetMarker2.getCurrentText("fill"), targetMarker2.target.getAnswers(), bl, n3);
                    if (bl && n3 == targetMarkerBag.size()) {
                        this.finishActivity(true);
                    } else {
                        this.playEvent(bl ? 3 : 2);
                    }
                    if (FillInBlanks.this.forceOkToAdvance && !bl) {
                        targetMarker = targetMarker2;
                        targetMarkerBag.setCurrentTarget(targetMarker, this);
                        return targetMarker.begPos.getOffset();
                    }
                }
            }
            if (n2 < 0) {
                n2 = targetMarker.begPos.getOffset();
            }
            if (!targetMarker.contains(n2, true)) {
                n2 = targetMarker.begOffset;
            }
            targetMarkerBag.setCurrentTarget(targetMarker, this);
            return n2;
        }

        protected void doCheck(boolean bl) {
            if (this.playDoc == null || this.locked) {
                return;
            }
            TargetMarkerBag targetMarkerBag = this.playDoc.tmb;
            if (targetMarkerBag.getCurrentTarget() != null && !FillInBlanks.this.hasCheckButton) {
                this.goToTarget(targetMarkerBag.getCurrentTarget(), -1);
                return;
            }
            int n = 0;
            for (int i = 0; i < targetMarkerBag.size(); ++i) {
                TargetMarker targetMarker = targetMarkerBag.getElement(i);
                if (targetMarker == null || targetMarker.target.targetStatus == 0) continue;
                boolean bl2 = this.evalTarget(targetMarker);
                n = targetMarkerBag.countSolvedTargets();
                this.ps.reportNewAction(this.getActivity(), "WRITE", targetMarker.getCurrentText("fill"), targetMarker.target.getAnswers(), bl2, n);
            }
            if (n != targetMarkerBag.size()) {
                if (bl) {
                    this.playEvent(4);
                    if (targetMarkerBag.getCurrentTarget() != null) {
                        this.goToTarget(targetMarkerBag.getCurrentTarget(), -1);
                    }
                }
            } else {
                this.finishActivity(true);
            }
        }

        public void finishActivity(boolean bl) {
            this.pane.setEditable(false);
            this.pane.setEnabled(false);
            if (this.playDoc == null || this.playDoc.tmb.getCurrentTarget() != null) {
                // empty if block
            }
            this.playDoc.tmb.getCurrentTarget().lostFocus(this);
            super.finishActivity(bl);
        }

        class FillInBlanksPane
        extends TextActivityPane {
            AbstractAction defaultKeyTypedAction;
            AbstractAction forwardAction;
            AbstractAction backwardAction;
            AbstractAction nextTargetAction;
            AbstractAction prevTargetAction;
            AbstractAction insertBreakAction;
            AbstractAction insertTabAction;
            AbstractAction deletePrevCharAction;
            AbstractAction deleteNextCharAction;
            AbstractAction beginWordAction;
            AbstractAction endWordAction;
            AbstractAction beginAction;
            AbstractAction endAction;
            AbstractAction showHelpAction;
            Action kitUpAction;
            AbstractAction upAction;
            Action kitDownAction;
            AbstractAction downAction;

            protected FillInBlanksPane() {
                super(Panel.this);
                this.defaultKeyTypedAction = new AbstractAction("default-typed"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            char c;
                            String string = actionEvent.getActionCommand();
                            int n = actionEvent.getModifiers();
                            if (string != null && string.length() > 0 && (n & 8) == (n & 2) && (c = string.charAt(0)) >= ' ' && c != '\u007f') {
                                FillInBlanksPane.this.insertCharCatch(FillInBlanksPane.this.getCaret().getDot(), c);
                            }
                        }
                    }
                };
                this.forwardAction = new AbstractAction("caret-forward"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            int n = FillInBlanksPane.this.getCaret().getDot();
                            Panel.this.setCaretPos(n + 1, n, true);
                        }
                    }
                };
                this.backwardAction = new AbstractAction("caret-backward"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            int n = FillInBlanksPane.this.getCaret().getDot();
                            Panel.this.setCaretPos(n - 1, n, false);
                        }
                    }
                };
                this.nextTargetAction = new AbstractAction("next-target"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            FillInBlanksPane.this.getCaret().setDot(Panel.this.goToTarget(((FillInBlanksPane)FillInBlanksPane.this).Panel.this.playDoc.tmb.getNextTarget(null), -1));
                        }
                    }
                };
                this.prevTargetAction = new AbstractAction("prev-target"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            FillInBlanksPane.this.getCaret().setDot(Panel.this.goToTarget(((FillInBlanksPane)FillInBlanksPane.this).Panel.this.playDoc.tmb.getPrevTarget(null), -1));
                        }
                    }
                };
                this.insertBreakAction = new AbstractAction("insert-break"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        FillInBlanksPane.this.insertTabAction.actionPerformed(actionEvent);
                    }
                };
                this.insertTabAction = new AbstractAction("insert-tab"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if ((actionEvent.getModifiers() & 1) != 0) {
                            FillInBlanksPane.this.prevTargetAction.actionPerformed(actionEvent);
                        } else {
                            FillInBlanksPane.this.nextTargetAction.actionPerformed(actionEvent);
                        }
                    }
                };
                this.deletePrevCharAction = new AbstractAction("delete-previous"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            FillInBlanksPane.this.removeCharCatch(FillInBlanksPane.this.getCaret().getDot() - 1);
                        }
                    }
                };
                this.deleteNextCharAction = new AbstractAction("delete-next"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            FillInBlanksPane.this.removeCharCatch(FillInBlanksPane.this.getCaret().getDot());
                        }
                    }
                };
                this.beginWordAction = new AbstractAction("caret-begin-word"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TargetMarker targetMarker;
                        if (FillInBlanksPane.this.readyForActions() && (targetMarker = ((FillInBlanksPane)FillInBlanksPane.this).Panel.this.playDoc.tmb.getCurrentTarget()) != null) {
                            Panel.this.setCaretPos(targetMarker.begOffset);
                        }
                    }
                };
                this.endWordAction = new AbstractAction("caret-end-word"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TargetMarker targetMarker;
                        if (FillInBlanksPane.this.readyForActions() && (targetMarker = ((FillInBlanksPane)FillInBlanksPane.this).Panel.this.playDoc.tmb.getCurrentTarget()) != null) {
                            Panel.this.setCaretPos(targetMarker.endOffset);
                        }
                    }
                };
                this.beginAction = new AbstractAction("caret-begin"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            if ((actionEvent.getModifiers() & 2) != 0) {
                                Panel.this.setCaretPos(Panel.this.goToTarget(((FillInBlanksPane)FillInBlanksPane.this).Panel.this.playDoc.tmb.getElement(0), -1));
                            } else {
                                FillInBlanksPane.this.beginWordAction.actionPerformed(actionEvent);
                            }
                        }
                    }
                };
                this.endAction = new AbstractAction("caret-end"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.readyForActions()) {
                            if ((actionEvent.getModifiers() & 2) != 0) {
                                Panel.this.setCaretPos(Panel.this.goToTarget(((FillInBlanksPane)FillInBlanksPane.this).Panel.this.playDoc.tmb.getElement(((FillInBlanksPane)FillInBlanksPane.this).Panel.this.playDoc.tmb.size() - 1), -1));
                            } else {
                                FillInBlanksPane.this.endWordAction.actionPerformed(actionEvent);
                            }
                        }
                    }
                };
                this.showHelpAction = new AbstractAction("show-help"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TargetMarker targetMarker;
                        if (FillInBlanksPane.this.readyForActions() && (targetMarker = ((FillInBlanksPane)FillInBlanksPane.this).Panel.this.playDoc.tmb.getCurrentTarget()) != null && targetMarker.target != null && targetMarker.target.popupContent != null && targetMarker.target.infoMode == 3) {
                            targetMarker.target.checkPopup(Panel.this, targetMarker, true);
                        }
                    }
                };
                this.kitUpAction = null;
                this.upAction = new AbstractAction("caret-up"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.kitUpAction != null && FillInBlanksPane.this.readyForActions()) {
                            int n = FillInBlanksPane.this.getCaret().getDot();
                            FillInBlanksPane.this.kitUpAction.actionPerformed(actionEvent);
                            int n2 = FillInBlanksPane.this.getCaret().getDot();
                            FillInBlanksPane.this.getCaret().setDot(n);
                            Panel.this.setCaretPos(n2, n, false);
                        }
                    }
                };
                this.kitDownAction = null;
                this.downAction = new AbstractAction("caret-down"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FillInBlanksPane.this.kitDownAction != null && FillInBlanksPane.this.readyForActions()) {
                            int n = FillInBlanksPane.this.getCaret().getDot();
                            FillInBlanksPane.this.kitDownAction.actionPerformed(actionEvent);
                            int n2 = FillInBlanksPane.this.getCaret().getDot();
                            FillInBlanksPane.this.getCaret().setDot(n);
                            Panel.this.setCaretPos(n2, n, true);
                        }
                    }
                };
            }

            public boolean processMouse(MouseEvent mouseEvent) {
                int n;
                if (super.processMouse(mouseEvent) && mouseEvent.getID() == 501 && Panel.this.playing && !Panel.this.locked && (n = this.viewToModel(mouseEvent.getPoint())) >= 0) {
                    Panel.this.setCaretPos(n);
                }
                return false;
            }

            protected void removeChar(int n) throws BadLocationException {
                TargetMarker targetMarker = Panel.this.playDoc.tmb.getCurrentTarget();
                if (targetMarker == null || !targetMarker.contains(n, false)) {
                    Panel.this.playEvent(2);
                    return;
                }
                boolean bl = targetMarker.getLength() == 1;
                Panel.this.playDoc.remove(n, 1);
                targetMarker.target.setModified(true);
                if (bl) {
                    Panel.this.playDoc.insertString(targetMarker.begOffset, targetMarker.target.getFillString(1), Panel.this.playDoc.getFillAttributeSet());
                    this.getCaret().setDot(targetMarker.begOffset);
                } else {
                    --targetMarker.endOffset;
                    this.getCaret().setDot(n);
                }
                targetMarker.setPositions();
                Panel.this.playDoc.tmb.updateOffsets();
            }

            protected void removeCharCatch(int n) {
                try {
                    this.removeChar(n);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Text activity error:\n" + badLocationException);
                }
            }

            protected void insertChar(int n, char c) throws BadLocationException {
                TargetMarker targetMarker = Panel.this.playDoc.tmb.getCurrentTarget();
                if (targetMarker == null || !targetMarker.contains(n, true) || c < ' ') {
                    return;
                }
                int n2 = this.getFirstFillChar(targetMarker);
                if (n2 >= 0) {
                    Panel.this.playDoc.remove(n2, 1);
                    if (n > n2) {
                        --n;
                    }
                } else if (targetMarker.getLength() >= targetMarker.target.maxLenResp) {
                    Panel.this.playEvent(2);
                    return;
                }
                Panel.this.playDoc.insertString(n, new String(new char[]{c}), Panel.this.playDoc.getTargetAttributeSet());
                targetMarker.target.setModified(true);
                if (n2 < 0) {
                    ++targetMarker.endOffset;
                }
                targetMarker.setPositions();
                Panel.this.playDoc.tmb.updateOffsets();
                if (((Panel)Panel.this).FillInBlanks.this.autoJump && targetMarker.getCurrentText("fill").length() >= targetMarker.target.maxLenResp) {
                    this.getCaret().setDot(Panel.this.goToTarget(Panel.this.playDoc.tmb.getNextTarget(targetMarker), -1));
                } else {
                    this.getCaret().setDot(n + 1);
                }
            }

            protected void insertCharCatch(int n, char c) {
                try {
                    this.insertChar(n, c);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Text activity error:\n" + badLocationException);
                }
            }

            protected int getFirstFillChar(TargetMarker targetMarker) {
                for (int i = targetMarker.begOffset; i < targetMarker.endOffset; ++i) {
                    TextActivityDocument cfr_ignored_0 = Panel.this.playDoc;
                    if (!Panel.this.playDoc.checkBooleanAttribute(i, "fill")) continue;
                    return i;
                }
                return -1;
            }

            boolean readyForActions() {
                return Panel.this.playing && !Panel.this.locked && this.isEditable() && this.isEnabled();
            }

            protected void setActions() {
                this.kitUpAction = this.getActionMap().get("caret-up");
                this.kitDownAction = this.getActionMap().get("caret-down");
                HashMap hashMap = Actions.getActionKeys(this);
                ActionMap actionMap = new ActionMap();
                actionMap.setParent(this.getActionMap());
                this.setActionMap(actionMap);
                Actions.mapTraceAction(this, hashMap, "beep");
                Actions.mapTraceAction(this, hashMap, "requestFocus");
                Actions.mapTraceAction(this, hashMap, "toggle-componentOrientation");
                Actions.mapAction(this, hashMap, this.defaultKeyTypedAction);
                Actions.mapAction(this, hashMap, this.insertBreakAction);
                Actions.mapAction(this, hashMap, this.insertTabAction);
                Actions.mapAction(this, hashMap, this.deletePrevCharAction);
                Actions.mapAction(this, hashMap, this.deleteNextCharAction);
                Actions.mapAction(this, hashMap, this.forwardAction);
                Actions.mapAction(this, hashMap, this.backwardAction);
                Actions.mapAction(this, hashMap, this.beginWordAction);
                Actions.mapAction(this, hashMap, this.endWordAction);
                Actions.mapAction(this, hashMap, this.beginAction);
                Actions.mapAction(this, hashMap, this.endAction);
                Actions.mapAction(this, hashMap, this.upAction);
                Actions.mapAction(this, hashMap, this.downAction);
                Actions.mapAction(this, hashMap, this.showHelpAction);
                Actions.mapAction(this, hashMap, this.nextTargetAction);
                Actions.mapAction(this, hashMap, this.prevTargetAction);
                Actions.mapAction(this, hashMap, this.nextTargetAction, "caret-next-word");
                Actions.mapAction(this, hashMap, this.prevTargetAction, "caret-previous-word");
                Actions.mapAction(this, hashMap, this.nextTargetAction, "caret-end-paragraph");
                Actions.mapAction(this, hashMap, this.prevTargetAction, "caret-begin-paragraph");
                Actions.mapAction(this, hashMap, this.nextTargetAction, "caret-begin-line");
                Actions.mapAction(this, hashMap, this.prevTargetAction, "caret-end-line");
                Actions.mapAction(this, hashMap, this.nextTargetAction, "page-down");
                Actions.mapAction(this, hashMap, this.prevTargetAction, "page-up");
                actionMap.setParent(null);
                this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), this.insertTabAction.getValue("Name"));
                this.getInputMap().put(KeyStroke.getKeyStroke(112, 0), this.showHelpAction.getValue("Name"));
            }

            protected void targetChanged(TextTarget textTarget) {
                TargetMarker targetMarker;
                if (this.readyForActions() && (targetMarker = Panel.this.playDoc.tmb.getElement(textTarget)) != null) {
                    TargetMarker targetMarker2 = Panel.this.playDoc.tmb.getCurrentTarget();
                    Panel.this.goToTarget(targetMarker, -1);
                    if (targetMarker2 != targetMarker && !((Panel)Panel.this).FillInBlanks.this.hasCheckButton) {
                        targetMarker.target.setModified(true);
                        Panel.this.goToTarget(targetMarker, -1);
                    }
                }
            }
        }
    }
}

