/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.automation.arith;

import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.automation.AutoContentProvider;
import edu.xtec.jclic.automation.arith.Operator;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Random;
import org.jdom.Element;

public class Arith
extends AutoContentProvider {
    private static final String DLL_TITLE = "ARITH2.DLL";
    private static final int ARITHVER = 2;
    protected static final int NMAXLOOPS = 60;
    protected static final int NOSORT = 0;
    protected static final int SORTASC = 1;
    protected static final int SORTDESC = 2;
    protected static final int SUM = 1;
    protected static final int REST = 2;
    protected static final int MULT = 4;
    protected static final int DIV = 8;
    protected static final int NOPERACIONS = 4;
    protected static final String[] OPSTR = new String[]{"+", "-", "\u00d7", ":"};
    protected static final int ABX = 1;
    protected static final int AXC = 2;
    protected static final int XBC = 4;
    protected static final int AXBC = 8;
    protected static final int CAXB = 16;
    protected static final int NTIPUSEX = 5;
    protected static final int INDIF = 0;
    protected static final int AGB = 1;
    protected static final int BGA = 2;
    private static final int RES = -12345;
    private static final int MAX_STR_LEN = 100;
    private static String S = new String("\u00a0");
    protected static final String ID = "id";
    protected static final String A = "A";
    protected static final String B = "B";
    protected static final String OPERATIONS = "operations";
    protected static final String PLUS = "plus";
    protected static final String MINUS = "minus";
    protected static final String MULTIPLY = "multiply";
    protected static final String DIVIDE = "divide";
    protected static final String UNKNOWN = "unknown";
    protected static final String RESULT = "result";
    protected static final String FIRST = "first";
    protected static final String LAST = "last";
    protected static final String OPERAND = "operand";
    protected static final String INVERSE = "inverse";
    protected static final String FROM = "from";
    protected static final String TO = "to";
    protected static final String NOT_CARRY = "notCarry";
    protected static final String DUPLICATES = "duplicates";
    protected static final String ORDER = "order";
    protected static final String ASCENDING = "ascending";
    protected static final String DESCENDING = "descending";
    protected static final String CONDITION = "condition";
    protected static final String FIRST_BIG = "firstBig";
    protected static final String LAST_BIG = "lastBig";
    protected static DecimalFormat[] DF;
    protected static final int WILDCARD_DF = 5;
    Operator opA;
    Operator opB;
    boolean use_add = true;
    boolean use_subst;
    boolean use_mult;
    boolean use_div;
    boolean exp_abx = true;
    boolean exp_axc;
    boolean exp_xbc;
    boolean exp_axbc;
    boolean exp_caxb;
    int resultLimInf = 13;
    int resultLimSup = 25;
    boolean resultCarry;
    boolean resultNoDup;
    int resultOrder = 0;
    int opCond = 0;
    private Random random = new Random();

    public Arith() {
        this.opA = new Operator();
        this.opB = new Operator();
        if (DF == null) {
            DF = new DecimalFormat[6];
            Arith.DF[0] = new DecimalFormat("0");
            Arith.DF[1] = new DecimalFormat("0.0");
            Arith.DF[2] = new DecimalFormat("0.00");
            Arith.DF[3] = new DecimalFormat("0.000");
            Arith.DF[4] = new DecimalFormat("0.0000");
            Arith.DF[5] = new DecimalFormat("0000000000");
        }
    }

    public DecimalFormat getDF(int n) {
        return DF[n <= 5 ? n : 4];
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        Element element2 = this.opA.getJDomElement();
        element2.setAttribute(ID, A);
        element.addContent(element2);
        element2 = this.opB.getJDomElement();
        element2.setAttribute(ID, B);
        element.addContent(element2);
        Element element3 = new Element(OPERATIONS);
        element3.setAttribute(PLUS, JDomUtility.boolString(this.use_add));
        element3.setAttribute(MINUS, JDomUtility.boolString(this.use_subst));
        element3.setAttribute(MULTIPLY, JDomUtility.boolString(this.use_mult));
        element3.setAttribute(DIVIDE, JDomUtility.boolString(this.use_div));
        element.addContent(element3);
        Element element4 = new Element(UNKNOWN);
        element4.setAttribute(RESULT, JDomUtility.boolString(this.exp_abx));
        element4.setAttribute(FIRST, JDomUtility.boolString(this.exp_xbc));
        element4.setAttribute(LAST, JDomUtility.boolString(this.exp_axc));
        element4.setAttribute(OPERAND, JDomUtility.boolString(this.exp_axbc));
        element4.setAttribute(INVERSE, JDomUtility.boolString(this.exp_caxb));
        element.addContent(element4);
        Element element5 = new Element(RESULT);
        element5.setAttribute(FROM, Operator.LIM_CH[this.resultLimInf]);
        element5.setAttribute(TO, Operator.LIM_CH[this.resultLimSup]);
        if (this.resultCarry) {
            element5.setAttribute(NOT_CARRY, JDomUtility.boolString(this.resultCarry));
        }
        element5.setAttribute(DUPLICATES, JDomUtility.boolString(!this.resultNoDup));
        if (this.resultOrder != 0) {
            element5.setAttribute(ORDER, this.resultOrder == 1 ? ASCENDING : DESCENDING);
        }
        if (this.opCond != 0) {
            element5.setAttribute(CONDITION, this.opCond == 1 ? FIRST_BIG : LAST_BIG);
        }
        element.addContent(element5);
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        String string;
        Element element2;
        Iterator iterator = element.getChildren(OPERAND).iterator();
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            string = element2.getAttributeValue(ID);
            if (A.equals(string)) {
                this.opA.setProperties(element2, object);
                continue;
            }
            if (B.equals(string)) {
                this.opB.setProperties(element2, object);
                continue;
            }
            throw new IllegalArgumentException("Unknown operator: " + string);
        }
        element2 = element.getChild(OPERATIONS);
        if (element2 != null) {
            this.use_add = JDomUtility.getBoolAttr(element2, PLUS, this.use_add);
            this.use_subst = JDomUtility.getBoolAttr(element2, MINUS, this.use_subst);
            this.use_mult = JDomUtility.getBoolAttr(element2, MULTIPLY, this.use_mult);
            this.use_div = JDomUtility.getBoolAttr(element2, DIVIDE, this.use_div);
        }
        if ((element2 = element.getChild(UNKNOWN)) != null) {
            this.exp_abx = JDomUtility.getBoolAttr(element2, RESULT, this.exp_abx);
            this.exp_xbc = JDomUtility.getBoolAttr(element2, FIRST, this.exp_xbc);
            this.exp_axc = JDomUtility.getBoolAttr(element2, LAST, this.exp_axc);
            this.exp_axbc = JDomUtility.getBoolAttr(element2, OPERAND, this.exp_axbc);
            this.exp_caxb = JDomUtility.getBoolAttr(element2, INVERSE, this.exp_caxb);
        }
        if ((element2 = element.getChild(RESULT)) != null) {
            this.resultLimInf = JDomUtility.getStrIndexAttr(element2, FROM, Operator.LIM_CH, this.resultLimInf);
            this.resultLimSup = JDomUtility.getStrIndexAttr(element2, TO, Operator.LIM_CH, this.resultLimSup);
            this.resultCarry = JDomUtility.getBoolAttr(element2, NOT_CARRY, this.resultCarry);
            this.resultNoDup = !JDomUtility.getBoolAttr(element2, DUPLICATES, !this.resultNoDup);
            string = element2.getAttributeValue(ORDER);
            this.resultOrder = string == null ? 0 : (string.equals(ASCENDING) ? 1 : 2);
            string = element2.getAttributeValue(CONDITION);
            this.opCond = string == null ? 0 : (string.equals(FIRST_BIG) ? 1 : 2);
        }
    }

    public boolean setClic3Properties(byte[] byArray) {
        int n;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        n2 = this.opA.setClic3Properties(byArray, n2);
        n2 = this.opB.setClic3Properties(byArray, n2);
        if ((n = byArray[n2++] & 0x7F) == 0) {
            n = 1;
        }
        this.use_add = (n & 1) != 0;
        this.use_subst = (n & 2) != 0;
        this.use_mult = (n & 4) != 0;
        this.use_div = (n & 8) != 0;
        if ((n = byArray[n2++] & 0x7F) == 0) {
            n = 1;
        }
        this.exp_abx = (n & 1) != 0;
        this.exp_axc = (n & 2) != 0;
        this.exp_xbc = (n & 4) != 0;
        this.exp_axbc = (n & 8) != 0;
        this.exp_caxb = (n & 0x10) != 0;
        int n4 = byArray[n2++] & 0x7F;
        this.resultLimInf = n4 == 0 ? 13 : n4;
        n4 = byArray[n2++] & 0x7F;
        this.resultLimSup = n4 == 0 ? 25 : n4;
        this.resultCarry = (byArray[n2++] & 1) == 1;
        this.resultNoDup = (byArray[n2++] & 1) == 1;
        this.resultOrder = byArray[n2++] & 3;
        this.opCond = byArray[n2++] & 3;
        n3 = n2 < byArray.length ? byArray[n2++] & 0x7F : 0;
        if (n3 == 0) {
            n3 = 2;
            if (!this.opA.fromBlank) {
                this.opA.limInf = Operator.adjustLimVer(this.opA.limInf);
                this.opA.limSup = Operator.adjustLimVer(this.opA.limSup);
                this.opB.limInf = Operator.adjustLimVer(this.opB.limInf);
                this.opB.limSup = Operator.adjustLimVer(this.opB.limSup);
                this.resultLimInf = Operator.adjustLimVer(this.resultLimInf);
                this.resultLimSup = Operator.adjustLimVer(this.resultLimSup);
            }
        }
        return n3 <= 2;
    }

    boolean genNum(Num num, Operator operator, long l, long l2) {
        boolean bl = false;
        num.c = operator.numDec;
        int n = num.c == 0 ? 1 : (num.c == 1 ? 10 : 100);
        long l3 = Operator.LIMITS[operator.limSup];
        if (l2 != -12345L && l2 < l3) {
            l3 = l2;
        }
        long l4 = Operator.LIMITS[operator.limInf];
        if (l != -12345L && l > l4) {
            l4 = l;
        }
        bl = false;
        if (operator.fromList > 0) {
            num.vf = operator.lst[this.random.nextInt(operator.fromList)];
            bl = true;
        }
        if (!bl) {
            int n2 = this.random.nextInt(100);
            if (operator.wZero && n2 <= 10) {
                num.vf = 0.0f;
                bl = true;
            } else if (operator.wOne && n2 > 10 && n2 <= 20) {
                num.vf = 1.0f;
                bl = true;
            } else if (operator.wMinusOne && n2 > 20 && n2 <= 30) {
                num.vf = -1.0f;
                bl = true;
            }
        }
        if (!bl) {
            int n3;
            if (l4 > l3) {
                long l5 = l4;
                l4 = l3;
                l3 = l5;
            }
            if ((n3 = (int)(l3 - l4 + 1L)) < 0) {
                n3 = 1;
            }
            long l6 = ((long)this.random.nextInt(n3) + l4) * (long)n;
            if (n > 1) {
                l6 += (long)this.random.nextInt(n);
            }
            num.vf = (float)l6 / (float)n;
            bl = true;
        }
        return true;
    }

    boolean genOp(Operacio operacio) {
        int[] nArray = new int[4];
        long l = Operator.LIMITS[this.resultLimInf];
        long l2 = Operator.LIMITS[this.resultLimSup];
        int n = 0;
        if (this.use_add) {
            nArray[n++] = 1;
        }
        if (this.use_subst) {
            nArray[n++] = 2;
        }
        if (this.use_mult) {
            nArray[n++] = 4;
        }
        if (this.use_div) {
            nArray[n++] = 8;
        }
        int n2 = nArray[this.random.nextInt(n)];
        switch (n2) {
            case 1: {
                int n3;
                for (n3 = 0; n3 < 60; ++n3) {
                    this.genNum(operacio.numA, this.opA, -12345L, l2);
                    long l3 = operacio.numA.vf < (float)l ? l - (long)operacio.numA.vf : -12345L;
                    long l4 = l2 - (long)operacio.numA.vf;
                    switch (this.opCond) {
                        case 1: {
                            if (l4 != -12345L && !((float)l4 > operacio.numA.vf)) break;
                            l4 = (long)operacio.numA.vf;
                            break;
                        }
                        case 2: {
                            if (l3 != -12345L && !((float)l3 < operacio.numA.vf)) break;
                            l3 = (long)operacio.numA.vf;
                        }
                    }
                    this.genNum(operacio.numB, this.opB, l3, l4);
                    operacio.numR.vf = operacio.numA.vf + operacio.numB.vf;
                    if (operacio.numR.vf >= (float)l && operacio.numR.vf <= (float)l2) break;
                }
                operacio.numR.c = operacio.numA.c > operacio.numB.c ? operacio.numA.c : operacio.numB.c;
                operacio.op = 0;
                if (!this.resultCarry || !(operacio.numA.vf > 0.0f) || !(operacio.numB.vf > 0.0f)) break;
                float f = operacio.numR.c == 2 ? 100.0f : (operacio.numR.c == 1 ? 10.0f : 1.0f);
                char[] cArray = this.getDF(5).format((long)((double)(operacio.numA.vf * f) + 0.5)).toCharArray();
                char[] cArray2 = this.getDF(5).format((long)((double)(operacio.numB.vf * f) + 0.5)).toCharArray();
                for (n3 = 0; n3 < 10 && cArray[n3] == '0' && cArray2[n3] == '0'; ++n3) {
                }
                while (n3 < 10) {
                    int n4 = cArray[n3] - 48;
                    int n5 = cArray2[n3] - 48;
                    if (n4 + n5 >= 10) {
                        int n6;
                        while (n4 + n5 > 9) {
                            if (n4 > n5) {
                                n4 = n4 > 0 ? this.random.nextInt(n4) : 0;
                                continue;
                            }
                            n5 = n5 > 0 ? this.random.nextInt(n5) : 0;
                        }
                        cArray[n3] = 48;
                        for (n6 = 0; n6 < n4; ++n6) {
                            int n7 = n3;
                            cArray[n7] = (char)(cArray[n7] + '\u0001');
                        }
                        cArray2[n3] = 48;
                        for (n6 = 0; n6 < n5; ++n6) {
                            int n8 = n3;
                            cArray2[n8] = (char)(cArray2[n8] + '\u0001');
                        }
                    }
                    ++n3;
                }
                operacio.numA.vf = Long.parseLong(new String(cArray));
                operacio.numB.vf = Long.parseLong(new String(cArray2));
                operacio.numR.vf = (long)((double)(operacio.numA.vf + operacio.numB.vf) + 0.5);
                operacio.numA.vf /= f;
                operacio.numB.vf /= f;
                operacio.numR.vf /= f;
                break;
            }
            case 2: {
                int n9;
                for (n9 = 0; n9 < 60; ++n9) {
                    this.genNum(operacio.numA, this.opA, l, -12345L);
                    long l5 = operacio.numA.vf > (float)l2 ? (long)(operacio.numA.vf - (float)l2) : -12345L;
                    long l6 = (long)(operacio.numA.vf - (float)l);
                    switch (this.opCond) {
                        case 1: {
                            if (l6 != -12345L && !((float)l6 > operacio.numA.vf)) break;
                            l6 = (long)operacio.numA.vf;
                            break;
                        }
                        case 2: {
                            if (l5 != -12345L && !((float)l5 < operacio.numA.vf)) break;
                            l5 = (long)operacio.numA.vf;
                        }
                    }
                    this.genNum(operacio.numB, this.opB, l5, l6);
                    operacio.numR.vf = operacio.numA.vf - operacio.numB.vf;
                    if (operacio.numR.vf >= (float)l && operacio.numR.vf <= (float)l2) break;
                }
                operacio.numR.c = operacio.numA.c > operacio.numB.c ? operacio.numA.c : operacio.numB.c;
                operacio.op = 1;
                if (!this.resultCarry || !(operacio.numA.vf > 0.0f) || !(operacio.numB.vf > 0.0f) || !(operacio.numA.vf >= operacio.numB.vf)) break;
                float f = operacio.numR.c == 2 ? 100 : (operacio.numR.c == 1 ? 10 : 1);
                char[] cArray = this.getDF(5).format((long)((double)(operacio.numA.vf * f) + 0.5)).toCharArray();
                char[] cArray3 = this.getDF(5).format((long)((double)(operacio.numB.vf * f) + 0.5)).toCharArray();
                for (n9 = 0; n9 < 10 && cArray3[n9] == '0'; ++n9) {
                }
                while (n9 < 10) {
                    int n10 = cArray[n9] - 48;
                    int n11 = cArray3[n9] - 48;
                    if (n10 < n11) {
                        n11 = n10 > 0 ? this.random.nextInt(n10) : 0;
                        cArray3[n9] = 48;
                        for (int i = 0; i < n11; ++i) {
                            int n12 = n9;
                            cArray3[n12] = (char)(cArray3[n12] + '\u0001');
                        }
                    }
                    ++n9;
                }
                operacio.numA.vf = Long.parseLong(new String(cArray));
                operacio.numB.vf = Long.parseLong(new String(cArray3));
                operacio.numR.vf = (long)((double)(operacio.numA.vf - operacio.numB.vf) + 0.5);
                operacio.numA.vf /= f;
                operacio.numB.vf /= f;
                operacio.numR.vf /= f;
                break;
            }
            case 4: {
                for (int i = 0; i < 60; ++i) {
                    this.genNum(operacio.numA, this.opA, -12345L, -12345L);
                    long l7 = Operator.LIMITS[this.opB.limInf];
                    long l8 = Operator.LIMITS[this.opB.limSup];
                    switch (this.opCond) {
                        case 1: {
                            if (!((float)l8 > operacio.numA.vf)) break;
                            l8 = (long)operacio.numA.vf;
                            break;
                        }
                        case 2: {
                            if (!((float)l7 < operacio.numA.vf)) break;
                            l7 = (long)operacio.numA.vf;
                        }
                    }
                    this.genNum(operacio.numB, this.opB, l7, l8);
                    operacio.numR.vf = operacio.numA.vf * operacio.numB.vf;
                    if (operacio.numR.vf >= (float)l && operacio.numR.vf <= (float)l2) break;
                }
                operacio.numR.c = operacio.numA.c + operacio.numB.c;
                operacio.op = 2;
                break;
            }
            case 8: {
                int n13;
                for (n13 = 0; n13 < 60; ++n13) {
                    float f;
                    this.genNum(operacio.numA, this.opA, -12345L, -12345L);
                    long l9 = Operator.LIMITS[this.opB.limInf];
                    long l10 = Operator.LIMITS[this.opB.limSup];
                    switch (this.opCond) {
                        case 1: {
                            if (!((float)l10 > operacio.numA.vf)) break;
                            l10 = (long)operacio.numA.vf;
                            break;
                        }
                        case 2: {
                            if (!((float)l9 < operacio.numA.vf)) break;
                            l9 = (long)operacio.numA.vf;
                        }
                    }
                    this.genNum(operacio.numB, this.opB, l9, l10);
                    if (operacio.numB.vf == 0.0f || !(Math.abs(operacio.numA.vf) >= Math.abs(operacio.numB.vf))) continue;
                    operacio.numR.vf = operacio.numA.vf / operacio.numB.vf;
                    if (f >= (float)l && operacio.numR.vf <= (float)l2) break;
                }
                if (operacio.numB.vf == 0.0f) {
                    operacio.numB.vf = 1.0f;
                }
                operacio.numR.vf = operacio.numA.vf / operacio.numB.vf;
                n13 = operacio.numA.c - operacio.numB.c;
                float f = (float)Math.pow(10.0, n13);
                operacio.numA.vf *= f;
                operacio.numR.vf *= f;
                operacio.numR.vf = (long)operacio.numR.vf;
                operacio.numA.vf = operacio.numR.vf * operacio.numB.vf;
                operacio.numA.vf /= f;
                operacio.numR.vf /= f;
                operacio.numR.c = n13 > 0 ? n13 : 0;
                operacio.op = 3;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean generateContent(Object object, ResourceBridge resourceBridge) {
        boolean bl = false;
        if (object instanceof ActiveBagContentKit) {
            ActiveBagContentKit activeBagContentKit = (ActiveBagContentKit)object;
            bl = this.generateContent(activeBagContentKit.nRows, activeBagContentKit.nCols, activeBagContentKit.content, activeBagContentKit.useIds, resourceBridge);
        }
        return bl;
    }

    protected boolean generateContent(int n, int n2, ActiveBagContent[] activeBagContentArray, boolean bl, ResourceBridge resourceBridge) {
        int n3;
        int n4;
        Operacio operacio;
        int n5;
        if (n <= 0 || n2 <= 0 || activeBagContentArray == null || activeBagContentArray.length < 1 || activeBagContentArray[0] == null || resourceBridge == null) {
            return false;
        }
        int[] nArray = new int[5];
        int n6 = n2;
        int n7 = n;
        int n8 = n * n2;
        if (n8 < 2) {
            return false;
        }
        int[] nArray2 = null;
        int n9 = 0;
        if (this.exp_abx) {
            nArray[n9++] = 1;
        }
        if (this.exp_axc) {
            nArray[n9++] = 2;
        }
        if (this.exp_xbc) {
            nArray[n9++] = 4;
        }
        if (this.exp_axbc) {
            nArray[n9++] = 8;
        }
        if (n9 == 0) {
            return false;
        }
        boolean bl2 = this.exp_caxb;
        Operacio[] operacioArray = new Operacio[n8];
        String[] stringArray = new String[n8];
        String[] stringArray2 = new String[n8];
        String[] stringArray3 = new String[n8];
        for (n5 = 0; n5 < n8; ++n5) {
            operacio = new Operacio();
            for (n4 = 0; n4 < 60; ++n4) {
                this.genOp(operacio);
                if (!this.resultNoDup) break;
                for (n3 = 0; n3 < n5 && operacio.numR.vf != operacioArray[n3].numR.vf; ++n3) {
                }
                if (n3 == n5) break;
            }
            operacioArray[n5] = operacio;
        }
        if (this.resultOrder != 0) {
            for (n5 = n8 - 1; n5 > 0; --n5) {
                for (n4 = 0; n4 < n5; ++n4) {
                    if (!(this.resultOrder == 1 && operacioArray[n4].numR.vf > operacioArray[n4 + 1].numR.vf) && (this.resultOrder != 2 || !(operacioArray[n4].numR.vf < operacioArray[n4 + 1].numR.vf))) continue;
                    operacio = operacioArray[n4];
                    operacioArray[n4] = operacioArray[n4 + 1];
                    operacioArray[n4 + 1] = operacio;
                }
            }
        }
        block22: for (n5 = 0; n5 < n8; ++n5) {
            int n10 = nArray[this.random.nextInt(n9)];
            String string = this.getDF(operacioArray[0].numA.c).format(operacioArray[n5].numA.vf);
            String string2 = this.getDF(operacioArray[0].numB.c).format(operacioArray[n5].numB.vf);
            String string3 = this.getDF(operacioArray[0].numR.c).format(operacioArray[n5].numR.vf);
            String string4 = OPSTR[operacioArray[n5].op];
            stringArray3[n5] = bl2 ? new String(string3 + S + "=" + S + string + S + string4 + S + string2) : new String(string + S + string4 + S + string2 + S + "=" + S + string3);
            switch (n10) {
                case 2: {
                    stringArray2[n5] = new String(string2);
                    if (bl2) {
                        stringArray[n5] = new String(string3 + S + "=" + S + string + S + string4 + S + "?");
                        continue block22;
                    }
                    stringArray[n5] = new String(string + S + string4 + S + "?" + S + "=" + S + string3);
                    continue block22;
                }
                case 4: {
                    stringArray2[n5] = new String(string);
                    if (bl2) {
                        stringArray[n5] = new String(string3 + S + "=" + S + "?" + S + string4 + S + string2);
                        continue block22;
                    }
                    stringArray[n5] = new String("?" + S + string4 + S + string2 + S + "=" + S + string3);
                    continue block22;
                }
                case 8: {
                    stringArray2[n5] = new String(string4);
                    if (bl2) {
                        stringArray[n5] = new String(string3 + S + "=" + S + string + S + "?" + S + string2);
                        continue block22;
                    }
                    stringArray[n5] = new String(string + S + "?" + S + string2 + S + "=" + S + string3);
                    continue block22;
                }
                default: {
                    stringArray2[n5] = new String(string3);
                    stringArray[n5] = bl2 ? new String("?" + S + "=" + S + string + S + string4 + S + string2) : new String(string + S + string4 + S + string2 + S + "=");
                }
            }
        }
        if (bl) {
            nArray2 = new int[n8];
            String[] stringArray4 = new String[n8];
            n3 = 0;
            for (n5 = 0; n5 < n8; ++n5) {
                for (n4 = 0; n4 < n3 && !stringArray2[n5].equals(stringArray4[n4]); ++n4) {
                }
                if (n4 == n3) {
                    stringArray4[n3] = stringArray2[n5];
                    nArray2[n5] = n3++;
                    continue;
                }
                nArray2[n5] = n4;
            }
            stringArray2 = new String[n3];
            for (n5 = 0; n5 < n3; ++n5) {
                stringArray2[n5] = stringArray4[n5];
            }
            if (n7 * n6 != n3) {
                boolean bl3 = false;
                switch (n3) {
                    case 6: {
                        n7 = bl3 ? 2 : 3;
                        n6 = bl3 ? 3 : 2;
                        break;
                    }
                    case 8: {
                        n7 = bl3 ? 2 : 4;
                        n6 = bl3 ? 4 : 2;
                        break;
                    }
                    case 9: {
                        n7 = 3;
                        n6 = 3;
                        break;
                    }
                    case 10: {
                        n7 = bl3 ? 2 : 5;
                        n6 = bl3 ? 5 : 2;
                        break;
                    }
                    case 12: {
                        n7 = bl3 ? 3 : 4;
                        n6 = bl3 ? 4 : 3;
                        break;
                    }
                    case 14: {
                        n7 = bl3 ? 2 : 7;
                        n6 = bl3 ? 7 : 2;
                        break;
                    }
                    case 15: {
                        n7 = bl3 ? 3 : 5;
                        n6 = bl3 ? 3 : 5;
                        break;
                    }
                    case 16: {
                        n7 = 4;
                        n6 = 4;
                        break;
                    }
                    case 18: {
                        n7 = bl3 ? 6 : 3;
                        n6 = bl3 ? 3 : 6;
                        break;
                    }
                    case 20: {
                        n7 = bl3 ? 4 : 5;
                        n6 = bl3 ? 5 : 4;
                        break;
                    }
                    default: {
                        n7 = bl3 ? 1 : n3;
                        n6 = bl3 ? n3 : 1;
                    }
                }
            }
        }
        activeBagContentArray[0].setTextContent(stringArray, n2, n);
        if (nArray2 != null) {
            activeBagContentArray[0].setIds(nArray2);
        }
        if (activeBagContentArray.length > 1 && activeBagContentArray[1] != null) {
            activeBagContentArray[1].setTextContent(stringArray2, n6, n7);
            activeBagContentArray[1].getShaper().reset(n6, n7);
        }
        if (activeBagContentArray.length > 2 && activeBagContentArray[2] != null) {
            activeBagContentArray[2].setTextContent(stringArray3, n2, n);
        }
        return true;
    }

    public static boolean checkClient(Class clazz) {
        return ActiveBagContentKit.Compatible.class.isAssignableFrom(clazz);
    }

    protected class Operacio {
        Num numA;
        Num numB;
        Num numR;
        int op;

        protected Operacio() {
            this.numA = new Num();
            this.numB = new Num();
            this.numR = new Num();
        }
    }

    protected class Num {
        float vf;
        int c;

        protected Num() {
        }
    }
}

