/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.MediaContent;
import java.util.HashSet;
import java.util.Iterator;

public class ActiveMediaBag
extends HashSet {
    public ActiveMediaPlayer createActiveMediaPlayer(MediaContent mediaContent, MediaBag mediaBag, PlayStation playStation) {
        ActiveMediaPlayer activeMediaPlayer = null;
        switch (mediaContent.mediaType) {
            case 5: {
                if (mediaContent.length <= 0 || mediaContent.length >= 20) break;
            }
            case 6: {
                if (mediaContent.recBuffer < 0 || mediaContent.recBuffer >= 10) break;
            }
            case 1: 
            case 2: 
            case 3: {
                activeMediaPlayer = ActiveMediaPlayer.createActiveMediaPlayer(mediaContent, mediaBag, playStation);
            }
        }
        if (activeMediaPlayer != null) {
            this.add(activeMediaPlayer);
        }
        return activeMediaPlayer;
    }

    public ActiveMediaPlayer getActiveMediaPlayer(MediaContent mediaContent, MediaBag mediaBag, PlayStation playStation) {
        ActiveMediaPlayer activeMediaPlayer = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && (activeMediaPlayer = (ActiveMediaPlayer)iterator.next()).getMediaContent() != mediaContent && !activeMediaPlayer.getMediaContent().isEquivalent(mediaContent)) {
            activeMediaPlayer = null;
        }
        if (activeMediaPlayer == null) {
            activeMediaPlayer = this.createActiveMediaPlayer(mediaContent, mediaBag, playStation);
        }
        return activeMediaPlayer;
    }

    public void removeActiveMediaPlayer(MediaContent mediaContent) {
        ActiveMediaPlayer activeMediaPlayer = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && (activeMediaPlayer = (ActiveMediaPlayer)iterator.next()).getMediaContent() != mediaContent) {
            activeMediaPlayer = null;
        }
        if (activeMediaPlayer != null) {
            activeMediaPlayer.clear();
            this.remove(activeMediaPlayer);
        }
    }

    public void realizeAll() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ActiveMediaPlayer activeMediaPlayer = (ActiveMediaPlayer)iterator.next();
            activeMediaPlayer.realize();
        }
    }

    public void stopAll() {
        this.stopAll(-1);
    }

    public void stopAll(int n) {
        ActiveMediaPlayer activeMediaPlayer = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            activeMediaPlayer = (ActiveMediaPlayer)iterator.next();
            if (n != -1 && activeMediaPlayer.getMediaContent().level > n) continue;
            activeMediaPlayer.stop();
        }
    }

    public void removeAll() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ActiveMediaPlayer activeMediaPlayer = (ActiveMediaPlayer)iterator.next();
            activeMediaPlayer.clear();
        }
        this.clear();
        ActiveMediaPlayer.clearAllAudioBuffers();
    }
}

