/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.ActivityBag;
import edu.xtec.jclic.bags.ActivitySequence;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.ProjectSettings;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ProgressDialog;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom.Document;
import org.jdom.Element;

public class JClicProject
implements Editable,
Domable {
    public static String CURRENT_VERSION = "0.1.3";
    protected ResourceBridge bridge;
    protected FileSystem fileSystem;
    public ActivityBag activityBag;
    public ActivitySequence activitySequence;
    public MediaBag mediaBag;
    public Skin skin;
    protected String name;
    public String version;
    public ProjectSettings settings;
    public String type;
    public String code;
    protected String fullPath;
    public static String TYPE = "type";
    public static String ELEMENT_NAME = "JClicProject";
    public static String VERSION = "version";
    public static String NAME = "name";
    public static String CODE = "code";

    public JClicProject(ResourceBridge resourceBridge, FileSystem fileSystem, String string) {
        this.fileSystem = fileSystem;
        this.bridge = resourceBridge;
        this.fullPath = string == null ? "" : string;
        this.version = CURRENT_VERSION;
        this.settings = new ProjectSettings();
        this.settings.title = resourceBridge.getMsg("UNNAMED");
        this.setName(this.settings.title);
        this.type = null;
        this.activityBag = new ActivityBag(this);
        this.activitySequence = new ActivitySequence(this);
        this.mediaBag = new MediaBag(this);
        this.skin = null;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(NAME, this.name);
        element.setAttribute(VERSION, CURRENT_VERSION);
        if (this.type != null) {
            element.setAttribute(TYPE, this.type);
        }
        if (this.code != null) {
            element.setAttribute(CODE, this.code);
        }
        element.addContent(this.settings.getJDomElement());
        element.addContent(this.activitySequence.getJDomElement());
        element.addContent(this.activityBag.getJDomElement());
        element.addContent(this.mediaBag.getJDomElement());
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(element, NAME, this.name, false);
        this.version = JDomUtility.getStringAttr(element, VERSION, this.version, false);
        this.type = JDomUtility.getStringAttr(element, TYPE, this.type, false);
        this.code = JDomUtility.getStringAttr(element, CODE, this.code, false);
        Element element2 = element.getChild(ProjectSettings.ELEMENT_NAME);
        if (element2 != null) {
            this.settings = ProjectSettings.getProjectSettings(element2);
        }
        this.activitySequence.setProperties(element.getChild("sequence"), null);
        this.activityBag.setProperties(element.getChild("activities"), null);
        if (this.version.compareTo("0.1.2") <= 0) {
            this.activityBag.sortByName();
        }
        this.mediaBag.setProperties(element.getChild(MediaBag.ELEMENT_NAME), null);
    }

    public static JClicProject getJClicProject(Element element, ResourceBridge resourceBridge, FileSystem fileSystem, String string) throws Exception {
        JClicProject jClicProject = new JClicProject(resourceBridge, fileSystem, string);
        jClicProject.setProperties(element, null);
        return jClicProject;
    }

    public static JClicProject getJClicProject(ResourceBridge resourceBridge, String string, ProgressDialog progressDialog) throws Exception {
        Object object;
        FileSystem fileSystem;
        JClicProject jClicProject = null;
        if (progressDialog != null) {
            progressDialog.setText(resourceBridge.getMsg("msg_loading") + " " + string);
        }
        if ((string = (fileSystem = FileSystem.createFileSystem(string, resourceBridge)).getUrl(string)).startsWith("file://")) {
            string = string.substring(7);
        }
        String string2 = null;
        if (string.endsWith(".jclic.zip")) {
            fileSystem = FileSystem.createFileSystem(string, resourceBridge);
            object = ((ZipFileSystem)fileSystem).getEntries(".jclic");
            if (object == null) {
                throw new Exception("File " + string + " does not contain any jclic project");
            }
            string2 = object[0];
        } else {
            fileSystem = new FileSystem(FileSystem.getPathPartOf(string), resourceBridge);
            string2 = FileSystem.getFileNameOf(string);
        }
        if (string2.endsWith(".jclic")) {
            object = fileSystem.getXMLDocument(string2);
            System.gc();
            jClicProject = JClicProject.getJClicProject(((Document)object).getRootElement(), resourceBridge, fileSystem, string);
        }
        if (jClicProject != null) {
            jClicProject.mediaBag.waitForAllImages();
        }
        return jClicProject;
    }

    public Document getDocument() {
        return new Document(this.getJDomElement());
    }

    public void saveDocument(OutputStream outputStream) throws Exception {
        JDomUtility.saveDocument(outputStream, this.getDocument());
    }

    public void saveZipDocument(OutputStream outputStream, boolean bl) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        zipOutputStream.putNextEntry(new ZipEntry(this.name + ".jclic"));
        this.saveDocument(zipOutputStream);
        zipOutputStream.closeEntry();
        if (bl) {
            Object object;
            Set<String> set = Collections.synchronizedSet(new HashSet());
            Iterator iterator = this.mediaBag.getElements().iterator();
            while (iterator.hasNext()) {
                String string;
                object = (MediaBagElement)iterator.next();
                if (!((MediaBagElement)object).saveFlag || (string = ((MediaBagElement)object).getFileName()) == null || string.length() <= 0) continue;
                set.add(string);
            }
            iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                zipOutputStream.putNextEntry(new ZipEntry((String)object));
                zipOutputStream.write(this.fileSystem.getBytes((String)object));
                zipOutputStream.closeEntry();
            }
        }
        zipOutputStream.close();
        outputStream.close();
    }

    public void saveZipDocumentPreservingZipContents(OutputStream outputStream, ZipFileSystem zipFileSystem) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        zipOutputStream.putNextEntry(new ZipEntry(this.name + ".jclic"));
        this.saveDocument(zipOutputStream);
        zipOutputStream.closeEntry();
        String[] stringArray = zipFileSystem.getEntries(null);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].endsWith(".jclic")) continue;
                zipOutputStream.putNextEntry(new ZipEntry(stringArray[i]));
                zipOutputStream.write(zipFileSystem.getBytes(stringArray[i]));
                zipOutputStream.closeEntry();
            }
        }
        zipOutputStream.close();
        outputStream.close();
    }

    public void saveProject(String string) throws Exception {
        String string2 = this.fileSystem.getFullFileNamePath(string);
        FileOutputStream fileOutputStream = this.fileSystem.createSecureFileOutputStream(string2);
        this.saveZipDocument(fileOutputStream, true);
        fileOutputStream.close();
        this.setFileSystem(FileSystem.createFileSystem(string2, this.bridge));
        this.setFullPath(string2);
    }

    public void setName(String string) {
        this.name = StrUtils.secureString(string, this.bridge.getMsg("UNNAMED"));
        this.name = new File(this.name).getName();
        int n = this.name.indexOf(46);
        if (n >= 0) {
            this.name = this.name.substring(0, n);
        }
        if (this.name.indexOf(32) >= 0) {
            this.name = this.name.replace(' ', '_');
        }
        if (this.name.length() < 1) {
            this.name = "NO_NAME";
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPublicName() {
        return this.settings.title;
    }

    public void realize(EventSounds eventSounds, PlayStation playStation) {
        if (this.skin == null && this.settings.skinFileName != null && this.settings.skinFileName.length() > 0) {
            this.skin = this.mediaBag.getSkinElement(this.settings.skinFileName, playStation);
        }
        if (this.settings.eventSounds != null) {
            this.settings.eventSounds.setParent(eventSounds);
            this.settings.eventSounds.realize(playStation.getOptions(), this.mediaBag);
        }
        this.mediaBag.buildFonts();
    }

    public void end() {
        if (this.settings.eventSounds != null) {
            this.settings.eventSounds.close();
            this.settings.eventSounds = null;
        }
        this.mediaBag.clearData();
        this.mediaBag.clear();
        this.fileSystem.close();
        System.gc();
    }

    protected void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    public ResourceBridge getBridge() {
        return this.bridge;
    }

    public void setBridge(ResourceBridge resourceBridge) {
        this.bridge = resourceBridge;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        if (this.fileSystem != null && this.fileSystem != fileSystem) {
            this.fileSystem.close();
        }
        this.fileSystem = fileSystem;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String string) {
        this.fullPath = string;
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor("edu.xtec.jclic.project.JClicProjectEditor", this, editor);
    }
}

