/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.BrowserLauncher;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;

public class Check {
    private static final String DLG_KEY = "CHECK_DIALOG";

    private Check() {
    }

    public static void showUrlPane(final Options options, String string) {
        Container container;
        Serializable serializable;
        final Messages messages = options.getMessages();
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    final URL uRL = hyperlinkEvent.getURL();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                if (options.getApplet() != null) {
                                    options.getApplet().getAppletContext().showDocument(uRL);
                                } else {
                                    BrowserLauncher.openURL(uRL.toExternalForm());
                                }
                            }
                            catch (Exception exception) {
                                messages.showErrorWarning((JDialog)options.get(Check.DLG_KEY), "URL_LAUNCH_ERROR", exception);
                            }
                        }
                    });
                }
            }
        };
        JScrollPane jScrollPane = null;
        try {
            serializable = ResourceManager.getResource(messages.get(string));
            container = new JEditorPane((URL)serializable);
            ((JTextComponent)container).setEditable(false);
            ((JEditorPane)container).addHyperlinkListener(hyperlinkListener);
            jScrollPane = new JScrollPane(container);
            jScrollPane.setPreferredSize(new Dimension(500, 400));
        }
        catch (Exception exception) {
            messages.showErrorWarning(options.getMainComponent(), "URL_ERROR", exception);
            return;
        }
        serializable = new JOptionPane(new Object[]{jScrollPane}, 2);
        container = ((JOptionPane)serializable).createDialog(options.getMainComponent(), messages.get("WARNING"));
        options.put(DLG_KEY, container);
        ((Dialog)container).setVisible(true);
        options.remove(DLG_KEY);
    }

    public static boolean checkSignature(Options options, boolean bl) {
        boolean bl2;
        block2: {
            bl2 = false;
            try {
                System.getProperty("java.class.path");
                bl2 = true;
            }
            catch (SecurityException securityException) {
                if (!bl) break block2;
                Check.showUrlPane(options, "CHECK_SIGNATURE_URL");
            }
        }
        return bl2;
    }
}

