/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.ResourceManager;
import edu.xtec.util.StreamIO;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;

public class FontCheck {
    public static final String DEFAULT_FONT_NAME = "default";
    public static final Font DEFAULT_FONT = new Font("default", 0, 17);
    public static final String TMP_FONT_PREFIX = "tmp_font_";
    private static final HashMap systemFonts = new HashMap();
    private static String[] fontList;
    public static final String[] fontSizes;

    private FontCheck() {
    }

    public static String[] getFontList(boolean bl) {
        if (fontList == null || bl) {
            fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        return fontList;
    }

    public static boolean checkFont(Font font) {
        boolean bl = false;
        if (font != null) {
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
            TextLayout textLayout = new TextLayout("AB", font, fontRenderContext);
            bl = textLayout.getBounds().getWidth() > 1.0;
        }
        return bl;
    }

    public static boolean checkFontFamilyName(Object object) {
        return object != null && object instanceof String && FontCheck.checkFont(new Font((String)object, 0, 17));
    }

    public static Font getValidFont(String string, int n, int n2) {
        Font font = new Font(string, n, n2);
        if (!FontCheck.checkFont(font)) {
            Font font2 = (Font)systemFonts.get(string.toLowerCase());
            if (font2 == null) {
                font2 = DEFAULT_FONT;
            }
            font = font2.deriveFont(n, n2);
        }
        return font;
    }

    public static String getValidFontFamilyName(Object object) {
        Font font = (Font)systemFonts.get(object instanceof String ? ((String)object).toLowerCase() : object);
        if (font != null) {
            return font.getFamily();
        }
        return FontCheck.checkFontFamilyName(object) ? (String)object : DEFAULT_FONT_NAME;
    }

    public static Font checkSystemFont(String string, String string2) {
        String string3 = string.toLowerCase();
        Font font = (Font)systemFonts.get(string3);
        if (!(font != null || FontCheck.checkFont(font = new Font(string, 0, 17)) && string.toLowerCase().equals(font.getFamily().toLowerCase()))) {
            try {
                font = FontCheck.buildNewFont(string2, ResourceManager.STREAM_PROVIDER, "fonts/" + string2);
                if (FontCheck.checkFont(font)) {
                    systemFonts.put(string3, font);
                } else {
                    font = DEFAULT_FONT;
                }
            }
            catch (Exception exception) {
                System.err.println("Unable to build font " + string + "\n:" + exception);
            }
        }
        return font;
    }

    public static Font buildNewFont(String string, StreamIO.InputStreamProvider inputStreamProvider, String string2) throws Exception {
        String string3 = System.getProperty("java.io.tmpdir");
        if (string3 == null) {
            throw new Exception("Unable to create fonts: No temp dir!");
        }
        File file = new File(string3 + File.separator + TMP_FONT_PREFIX + string);
        if (!file.exists()) {
            StreamIO.writeStreamTo(inputStreamProvider.getInputStream(string2), new FileOutputStream(file));
        }
        String string4 = null;
        try {
            Method method;
            Class<?> clazz;
            if (FontCheck.class.getResource("/sun/java2d/SunGraphicsEnvironment.class") != null && (clazz = Class.forName("sun.java2d.SunGraphicsEnvironment")) != null && (method = clazz.getMethod("createFont", File.class)) != null) {
                string4 = (String)method.invoke(null, file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string4 == null) {
            throw new Exception("Unable to create font - bad font data");
        }
        return FontCheck.getValidFont(string4, 0, 1);
    }

    static {
        fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    }
}

