/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressInputStream;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends ExtendedJDialog
implements ProgressInputStream.ProgressInputStreamListener {
    protected Options options = null;
    protected SwingWorker worker = null;
    protected boolean progressActive = false;
    protected boolean cancellable = false;
    protected boolean saving = false;
    private JButton cancelButton;
    private JLabel fileLabel;
    private JLabel label;
    private JPanel mainPanel;
    private JProgressBar progressBar;

    public ProgressDialog(JComponent jComponent, Options options) {
        super(jComponent, "", true);
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.label = new JLabel();
        this.fileLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.mainPanel.setLayout(new GridBagLayout());
        this.label.setText(" ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 5, 0, 5);
        this.mainPanel.add((Component)this.label, gridBagConstraints);
        this.fileLabel.setText(" ");
        this.fileLabel.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mainPanel.add((Component)this.fileLabel, gridBagConstraints);
        this.progressBar.setPreferredSize(new Dimension(250, 22));
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.progressBar, gridBagConstraints);
        this.cancelButton.setText(this.options.getMsg("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        if (this.cancellable && this.worker != null) {
            this.worker.cancel();
        }
    }

    public void start(String string, String string2, SwingWorker swingWorker, boolean bl, boolean bl2, boolean bl3) {
        this.worker = swingWorker;
        this.cancellable = bl2;
        this.saving = bl3;
        this.setTitle(string != null ? this.options.getMsg(string) : "");
        this.label.setText(this.options.getMsg(string2 != null ? string2 : "WORKING"));
        this.cancelButton.setVisible(bl2 && swingWorker != null);
        this.progressBar.setVisible(bl);
        this.setProgressValue(0);
        this.mainPanel.revalidate();
        this.pack();
        this.centerOver(this.getParent());
        if (swingWorker != null) {
            swingWorker.startLater();
        }
        this.setVisible(true);
    }

    public void setText(String string) {
        this.label.setText(string);
        this.mainPanel.revalidate();
    }

    public void setFileLabel(String string) {
        this.fileLabel.setText(string == null ? "" : string);
    }

    public void startProgress(String string) {
        this.setProgressValue(0);
        string = string == null ? "" : string.replace('\\', '/');
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        this.fileLabel.setText(string == null ? "" : this.options.getMsg(this.saving ? "SAVING_FILE" : "LOADING_FILE") + " " + string);
        this.progressActive = true;
    }

    public void endProgress() {
        this.progressActive = false;
    }

    public void setProgressMax(int n) {
        this.progressBar.setMaximum(n);
    }

    public void setProgressValue(int n) {
        this.progressBar.setValue(n);
    }

    public InputStream getProgressInputStream(InputStream inputStream, int n, String string) {
        InputStream inputStream2 = null;
        if (!this.progressActive) {
            ProgressInputStream progressInputStream = new ProgressInputStream(inputStream, n, string);
            progressInputStream.addProgressInputStreamListener(this);
            inputStream2 = progressInputStream;
        } else {
            inputStream2 = inputStream;
        }
        return inputStream2;
    }
}

