/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextListEditor
extends JPanel
implements ListSelectionListener {
    public static final String PROP_LIST = "list";
    Options options;
    DefaultListModel listModel;
    boolean modified;
    int maxItems = 999;
    int minItems = 0;
    boolean upperCase;
    private JButton addBtn;
    private JPanel btnPanel;
    private JButton downBtn;
    private JButton editBtn;
    private JList list;
    private JButton removeBtn;
    private JButton upBtn;

    public TextListEditor() {
        this((Options)null);
    }

    public TextListEditor(Options options) {
        this.options = options;
        this.listModel = new DefaultListModel();
        this.initComponents();
        this.list.addListSelectionListener(this);
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        this.list = new JList();
        this.btnPanel = new JPanel();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.editBtn = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.setLayout(new GridBagLayout());
        jScrollPane.setPreferredSize(new Dimension(100, 60));
        this.list.setModel(this.listModel);
        this.list.setSelectionMode(0);
        jScrollPane.setViewportView(this.list);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.btnPanel.setLayout(new BoxLayout(this.btnPanel, 0));
        this.addBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/plus16.gif")));
        this.addBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_newElement_tooltip"));
        this.addBtn.setMargin(new Insets(0, 0, 0, 0));
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextListEditor.this.addBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.addBtn);
        this.removeBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/minus16.gif")));
        this.removeBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_deleteElement_tooltip"));
        this.removeBtn.setMargin(new Insets(0, 0, 0, 0));
        this.removeBtn.setEnabled(false);
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextListEditor.this.removeBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.removeBtn);
        this.editBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/edit.gif")));
        this.editBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_editElement_tooltip"));
        this.editBtn.setMargin(new Insets(0, 0, 0, 0));
        this.editBtn.setEnabled(false);
        this.editBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextListEditor.this.editBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.editBtn);
        this.upBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/up.gif")));
        this.upBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_upBtn_tooltip"));
        this.upBtn.setMargin(new Insets(0, 0, 0, 0));
        this.upBtn.setEnabled(false);
        this.upBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextListEditor.this.upBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.upBtn);
        this.downBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/down.gif")));
        this.downBtn.setToolTipText(this.options == null ? "" : this.options.getMsg("edit_list_downBtn_tooltip"));
        this.downBtn.setMargin(new Insets(0, 0, 0, 0));
        this.downBtn.setEnabled(false);
        this.downBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextListEditor.this.downBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.downBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.add((Component)this.btnPanel, gridBagConstraints);
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        Object object;
        int n = this.list.getSelectedIndex();
        if (this.options != null && (object = this.editItem(null, true)) != null && object.toString().length() > 0) {
            if (this.upperCase) {
                object = object.toString().toUpperCase();
            }
            this.listModel.add(n + 1, object);
            this.list.setSelectedIndex(n + 1);
            this.firePropertyChange(PROP_LIST, "", object);
            this.modified = true;
        }
    }

    private void editBtnActionPerformed(ActionEvent actionEvent) {
        Object e;
        Object object;
        int n = this.list.getSelectedIndex();
        if (n >= 0 && this.options != null && (object = this.editItem(e = this.listModel.getElementAt(n), false)) != null && object.toString().length() > 0 && !object.equals(e)) {
            if (this.upperCase) {
                object = object.toString().toUpperCase();
            }
            this.listModel.setElementAt(object, n);
            this.firePropertyChange(PROP_LIST, e, object);
            this.modified = true;
        }
    }

    private void downBtnActionPerformed(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex();
        if (n >= 0 && n < this.listModel.getSize() - 1) {
            this.listModel.add(n + 1, this.listModel.remove(n));
            this.list.setSelectedIndex(n + 1);
            this.firePropertyChange(PROP_LIST, n, n + 1);
            this.modified = true;
        }
    }

    private void upBtnActionPerformed(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.listModel.add(n - 1, this.listModel.remove(n));
            this.list.setSelectedIndex(n - 1);
            this.firePropertyChange(PROP_LIST, n, n - 1);
            this.modified = true;
        }
    }

    private void removeBtnActionPerformed(ActionEvent actionEvent) {
        Object e = this.list.getSelectedValue();
        if (e != null) {
            this.listModel.removeElement(e);
            this.firePropertyChange(PROP_LIST, e, null);
            this.modified = true;
            this.checkEnabled();
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent == null || !listSelectionEvent.getValueIsAdjusting()) {
            this.checkEnabled();
        }
    }

    protected void checkEnabled() {
        boolean bl = this.isEnabled();
        int n = this.list.getSelectedIndex();
        int n2 = this.listModel.size();
        this.addBtn.setEnabled(bl && n2 < this.maxItems);
        this.upBtn.setEnabled(bl && n > 0);
        this.downBtn.setEnabled(bl && n >= 0 && n < this.list.getModel().getSize() - 1);
        this.removeBtn.setEnabled(bl && n >= 0 && n2 > this.minItems);
        this.editBtn.setEnabled(bl && n >= 0);
    }

    public Vector getListData() {
        Enumeration enumeration = this.listModel.elements();
        Vector vector = new Vector(this.listModel.getSize());
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public void setListData(Vector vector) {
        this.listModel.removeAllElements();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (this.upperCase) {
                    object = object.toString().toUpperCase();
                }
                this.listModel.addElement(object);
            }
        }
        this.modified = false;
        this.checkEnabled();
    }

    public void setTextList(String[] stringArray) {
        this.listModel.removeAllElements();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length && i < this.maxItems; ++i) {
                String string = stringArray[i];
                if (this.upperCase) {
                    string = string.toUpperCase();
                }
                this.listModel.addElement(string);
            }
        }
        this.modified = false;
        this.checkEnabled();
    }

    public String[] getTextList() {
        Vector vector = this.getListData();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.checkEnabled();
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int n) {
        this.maxItems = n;
        this.checkEnabled();
    }

    public int getMinItems() {
        return this.minItems;
    }

    public void setMinItems(int n) {
        this.minItems = n;
        this.checkEnabled();
    }

    protected Object editItem(Object object, boolean bl) {
        String string = null;
        string = bl ? this.options.getMessages().showInputDlg((Component)this, (String)null, "edit_list_newValue", "", "edit_list_addElement", false) : this.options.getMessages().showInputDlg((Component)this, (String)null, "edit_list_newValue", StrUtils.nullableString(object), "edit_list_modifyValue", false);
        return string;
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.list.setToolTipText(string);
        this.btnPanel.setToolTipText(string);
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean bl) {
        this.upperCase = bl;
    }
}

