/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.project.ProjectInstaller;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Document;

public class ProjectInstallerEditPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    Options options;
    DefaultListModel availModel;
    DefaultListModel filesModel;
    private String suggestedFileName;
    private JButton addBtn;
    private JTextField authFld;
    private JList availFiles;
    private JScrollPane availFilesSP;
    private JTextField descFld;
    private JTextField folderFld;
    private JTextField iconFld;
    private JList includedFiles;
    private JScrollPane includedFilesSP;
    private JTextField projectFld;
    private JButton removeBtn;
    private JTextField textFld;
    private JTextField titleFld;

    public ProjectInstallerEditPanel(Options options) {
        this.options = options;
        this.availModel = new DefaultListModel();
        this.filesModel = new DefaultListModel();
        this.initComponents();
        this.availFiles.addListSelectionListener(this);
        this.includedFiles.addListSelectionListener(this);
        this.addBtn.addActionListener(this);
        this.removeBtn.addActionListener(this);
        this.checkButtons();
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.titleFld = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.authFld = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.folderFld = new JTextField();
        JPanel jPanel = new JPanel();
        this.availFilesSP = new JScrollPane();
        this.availFiles = new JList();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.includedFilesSP = new JScrollPane();
        this.includedFiles = new JList();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.projectFld = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.textFld = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.iconFld = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.descFld = new JTextField();
        this.setLayout(new GridBagLayout());
        jLabel.setLabelFor(this.titleFld);
        jLabel.setText(this.options.getMsg("installer_title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, gridBagConstraints);
        this.titleFld.setToolTipText(this.options.getMsg("installer_title_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.titleFld, gridBagConstraints);
        jLabel2.setLabelFor(this.authFld);
        jLabel2.setText(this.options.getMsg("installer_authors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel2, gridBagConstraints);
        this.authFld.setToolTipText(this.options.getMsg("installer_authors_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.authFld, gridBagConstraints);
        jLabel3.setLabelFor(this.folderFld);
        jLabel3.setText(this.options.getMsg("installer_folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel3, gridBagConstraints);
        this.folderFld.setToolTipText(this.options.getMsg("installer_folder_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.folderFld, gridBagConstraints);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.options.getMsg("installer_files")));
        jPanel.setToolTipText(this.options.getMsg("installer_files_tooltip"));
        this.availFilesSP.setPreferredSize(new Dimension(120, 100));
        this.availFiles.setToolTipText(this.options.getMsg("installer_files_available"));
        this.availFiles.setModel(this.availModel);
        this.availFilesSP.setViewportView(this.availFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.availFilesSP, gridBagConstraints);
        this.addBtn.setToolTipText(this.options.getMsg("installer_files_add_tooltip"));
        this.addBtn.setText(this.options.getMsg("installer_files_add"));
        this.addBtn.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.addBtn, gridBagConstraints);
        this.removeBtn.setToolTipText(this.options.getMsg("installer_files_tooltip"));
        this.removeBtn.setText(this.options.getMsg("installer_files_remove"));
        this.removeBtn.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.removeBtn, gridBagConstraints);
        this.includedFilesSP.setPreferredSize(new Dimension(120, 100));
        this.includedFiles.setToolTipText(this.options.getMsg("installer_files_selected"));
        this.includedFiles.setModel(this.filesModel);
        this.includedFilesSP.setViewportView(this.includedFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.includedFilesSP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jPanel, gridBagConstraints);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(this.options.getMsg("installer_button")));
        jPanel2.setToolTipText(this.options.getMsg("installer_button_tooltip"));
        jLabel4.setLabelFor(this.projectFld);
        jLabel4.setText(this.options.getMsg("installer_button_project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        this.projectFld.setToolTipText(this.options.getMsg("installer_button_project_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.projectFld, gridBagConstraints);
        jLabel5.setLabelFor(this.textFld);
        jLabel5.setText(this.options.getMsg("installer_button_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        this.textFld.setToolTipText(this.options.getMsg("installer_button_text_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.textFld, gridBagConstraints);
        jLabel6.setLabelFor(this.iconFld);
        jLabel6.setText(this.options.getMsg("installer_button_icon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        this.iconFld.setToolTipText(this.options.getMsg("installer_button_icon_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.iconFld, gridBagConstraints);
        jLabel7.setLabelFor(this.descFld);
        jLabel7.setText(this.options.getMsg("installer_button_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel7, gridBagConstraints);
        this.descFld.setToolTipText(this.options.getMsg("installer_button_description_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.descFld, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jPanel2, gridBagConstraints);
    }

    public void setValues(JClicProject jClicProject) {
        int n;
        Object object;
        File file;
        ProjectInstaller.IconItem iconItem;
        ProjectInstaller projectInstaller;
        block14: {
            this.suggestedFileName = null;
            projectInstaller = null;
            iconItem = null;
            FileSystem fileSystem = jClicProject.getFileSystem();
            file = new File(FileSystem.sysFn(fileSystem.getFullFileNamePath(null)));
            try {
                object = file.listFiles(Utils.getFileFilter(7, this.options.getMessages()));
                if (object == null) break block14;
                for (n = 0; n < ((File[])object).length; ++n) {
                    if (!object[n].isFile()) continue;
                    this.suggestedFileName = object[n].getName();
                    projectInstaller = ProjectInstaller.getProjectInstaller(fileSystem.getFullFileNamePath(this.suggestedFileName));
                    break;
                }
            }
            catch (Exception exception) {
                System.err.println("Error reading installer: " + exception);
            }
        }
        if (this.suggestedFileName == null) {
            this.suggestedFileName = FileSystem.getValidFileName(jClicProject.getName().trim()) + ".jclic.inst";
        }
        if (projectInstaller == null) {
            projectInstaller = new ProjectInstaller();
            projectInstaller.projectTitle = jClicProject.settings.title;
            projectInstaller.baseFolder = file.getName();
            object = new StringBuffer();
            if (jClicProject.settings.authors != null) {
                for (n = 0; n < jClicProject.settings.authors.length; ++n) {
                    if (n > 0) {
                        ((StringBuffer)object).append(", ");
                    }
                    ((StringBuffer)object).append(jClicProject.settings.authors[n].name);
                }
            }
            projectInstaller.authors = ((StringBuffer)object).substring(0);
            String string = jClicProject.getFullPath();
            if (string != null) {
                jClicProject.getFileSystem();
                string = FileSystem.getFileNameOf(string);
            } else {
                string = jClicProject.getName() + ".jclic.zip";
            }
            projectInstaller.addFile(string);
            iconItem = projectInstaller.createIconItem();
            iconItem.project = string;
            iconItem.text = jClicProject.settings.title;
            iconItem.icon = jClicProject.settings.iconFileName;
        }
        this.titleFld.setText(StrUtils.secureString(projectInstaller.projectTitle));
        this.authFld.setText(StrUtils.secureString(projectInstaller.authors));
        this.folderFld.setText(StrUtils.secureString(projectInstaller.baseFolder));
        this.availModel.removeAllElements();
        object = new Vector();
        FileSystem.exploreFiles(null, file, (Vector)object, '/', null);
        for (n = 0; n < ((Vector)object).size(); ++n) {
            this.availModel.addElement(((Vector)object).get(n));
        }
        this.filesModel.removeAllElements();
        for (n = 0; n < projectInstaller.files.size(); ++n) {
            String string = projectInstaller.getFile(n);
            if (this.availModel.contains(string)) {
                this.availModel.removeElement(string);
            }
            this.filesModel.addElement(string);
        }
        iconItem = projectInstaller.getIconItem(0);
        if (iconItem != null) {
            this.projectFld.setText(StrUtils.secureString(iconItem.project));
            this.textFld.setText(StrUtils.secureString(iconItem.text));
            this.iconFld.setText(StrUtils.secureString(iconItem.icon));
            this.descFld.setText(StrUtils.secureString(iconItem.description));
        }
        this.checkButtons();
    }

    private void checkButtons() {
        this.addBtn.setEnabled(!this.availFiles.isSelectionEmpty());
        this.removeBtn.setEnabled(!this.includedFiles.isSelectionEmpty());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.checkButtons();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null && actionEvent.getSource() != null) {
            DefaultListModel defaultListModel = null;
            DefaultListModel defaultListModel2 = null;
            JList jList = null;
            if (actionEvent.getSource() == this.addBtn) {
                defaultListModel = this.availModel;
                defaultListModel2 = this.filesModel;
                jList = this.availFiles;
            } else if (actionEvent.getSource() == this.removeBtn) {
                defaultListModel2 = this.availModel;
                defaultListModel = this.filesModel;
                jList = this.includedFiles;
            }
            if (defaultListModel2 != null && defaultListModel != null) {
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        defaultListModel.removeElement(objectArray[i]);
                        defaultListModel2.addElement(objectArray[i]);
                    }
                }
                this.checkButtons();
            }
        }
    }

    public ProjectInstaller getProjectInstaller(Component component) {
        ProjectInstaller projectInstaller = new ProjectInstaller();
        String string = null;
        projectInstaller.projectTitle = StrUtils.nullableString(this.titleFld.getText());
        projectInstaller.authors = StrUtils.nullableString(this.authFld.getText());
        projectInstaller.baseFolder = StrUtils.nullableString(this.folderFld.getText());
        int n = this.filesModel.getSize();
        for (int i = 0; i < n; ++i) {
            projectInstaller.addFile((String)this.filesModel.get(i));
        }
        ProjectInstaller.IconItem iconItem = projectInstaller.createIconItem();
        iconItem.project = StrUtils.nullableString(this.projectFld.getText());
        iconItem.text = StrUtils.nullableString(this.textFld.getText());
        iconItem.icon = StrUtils.nullableString(this.iconFld.getText());
        iconItem.description = StrUtils.nullableString(this.descFld.getText());
        if (projectInstaller.projectTitle == null) {
            string = "noTitle";
        } else if (projectInstaller.baseFolder == null) {
            string = "noBaseFolder";
        } else if (n == 0) {
            string = "noFilesSelected";
        } else if (iconItem.project == null) {
            string = "noProjectSelected";
        } else if (iconItem.text == null) {
            string = "noButtonText";
        } else if (!projectInstaller.files.contains(iconItem.project)) {
            string = "projectNotInFiles";
        }
        if (string != null) {
            this.options.getMessages().showErrorWarning(component, "installer_error_" + string, null);
        }
        return string != null ? null : projectInstaller;
    }

    public static void createInstaller(JClicProject jClicProject, Component component) {
        Options options = jClicProject.getBridge().getOptions();
        Messages messages = options.getMessages();
        ProjectInstallerEditPanel projectInstallerEditPanel = new ProjectInstallerEditPanel(options);
        projectInstallerEditPanel.setValues(jClicProject);
        boolean bl = false;
        while (!bl) {
            if (messages.showInputDlg(component, projectInstallerEditPanel, "installer_caption")) {
                ProjectInstaller projectInstaller = projectInstallerEditPanel.getProjectInstaller(component);
                if (projectInstaller == null) continue;
                int[] nArray = new int[]{7};
                FileSystem fileSystem = jClicProject.getFileSystem();
                String string = fileSystem.chooseFile(projectInstallerEditPanel.suggestedFileName, true, nArray, options, null, component, false);
                if (string != null) {
                    try {
                        FileOutputStream fileOutputStream = fileSystem.createSecureFileOutputStream(string);
                        JDomUtility.saveDocument((OutputStream)fileOutputStream, new Document(projectInstaller.getJDomElement(false)));
                        fileOutputStream.close();
                        bl = true;
                    }
                    catch (Exception exception) {
                        options.getMessages().showErrorWarning(component, null, exception);
                    }
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
    }
}

