/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.beans.TextListEditor;
import edu.xtec.jclic.project.Author;
import edu.xtec.jclic.project.AuthorEditPanel;
import edu.xtec.jclic.project.Revision;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RevisionEditPanel
extends JPanel {
    Options options;
    private AuthorEditPanel authorEditPanel;
    private TextListEditor authorListEditor;
    private JTextArea commentsText;
    private JTextField dateText;
    private JTextField descText;

    public RevisionEditPanel(Options options) {
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.dateText = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.descText = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.authorListEditor = new TextListEditor(this.options){

            protected Object editItem(Object object, boolean bl) {
                return RevisionEditPanel.this.editAuthor(object, bl);
            }
        };
        JLabel jLabel4 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.commentsText = new JTextArea();
        this.setLayout(new GridBagLayout());
        jLabel.setLabelFor(this.dateText);
        jLabel.setText(this.options.getMsg("edit_project_rev_date"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel, gridBagConstraints);
        this.dateText.setToolTipText(this.options.getMsg("edit_project_rev_date_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.dateText, gridBagConstraints);
        jLabel2.setLabelFor(this.descText);
        jLabel2.setText(this.options.getMsg("edit_project_rev_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel2, gridBagConstraints);
        this.descText.setToolTipText(this.options.getMsg("edit_project_rev_description_tooltip"));
        this.descText.setPreferredSize(new Dimension(300, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.descText, gridBagConstraints);
        jLabel3.setLabelFor(this.authorListEditor);
        jLabel3.setText(this.options.getMsg("edit_project_rev_authors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.add((Component)jLabel3, gridBagConstraints);
        this.authorListEditor.setToolTipText(this.options.getMsg("edit_project_rev_authors_tooltip"));
        this.authorListEditor.setPreferredSize(new Dimension(400, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.authorListEditor, gridBagConstraints);
        jLabel4.setLabelFor(this.commentsText);
        jLabel4.setText(this.options.getMsg("edit_project_rev_comments"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 12;
        this.add((Component)jLabel4, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(300, 60));
        this.commentsText.setLineWrap(true);
        this.commentsText.setToolTipText(this.options.getMsg("edit_project_rev_comments_tooltip"));
        this.commentsText.setWrapStyleWord(true);
        jScrollPane.setViewportView(this.commentsText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    public void setRevision(Revision revision) {
        this.dateText.setText(this.options.getMessages().getShortDateStr(revision == null ? new Date() : revision.date));
        this.descText.setText(revision != null ? revision.description : "");
        this.commentsText.setText(revision != null ? revision.comments : "");
        Vector<Author> vector = new Vector<Author>();
        if (revision != null && revision.authors != null) {
            for (int i = 0; i < revision.authors.length; ++i) {
                vector.add(revision.authors[i]);
            }
        }
        this.authorListEditor.setListData(vector);
    }

    public Revision getRevision() {
        Revision revision = null;
        Date date = this.options.getMessages().parseShortDate(this.dateText.getText());
        String string = StrUtils.nullableString(this.descText.getText().trim());
        if (date == null) {
            this.options.getMessages().showAlert((Component)this, "DATE_INCORRECT");
        } else if (string == null) {
            this.options.getMessages().showAlert((Component)this, "edit_project_rev_err_nodesc");
        } else {
            revision = new Revision();
            revision.date = date;
            revision.description = string;
            revision.comments = StrUtils.nullableString(this.commentsText.getText().trim());
            Vector vector = this.authorListEditor.getListData();
            revision.authors = vector.toArray(new Author[vector.size()]);
        }
        return revision;
    }

    private Object editAuthor(Object object, boolean bl) {
        Author author = null;
        if (this.authorEditPanel == null) {
            this.authorEditPanel = new AuthorEditPanel(this.options);
        }
        if (bl) {
            object = null;
        }
        this.authorEditPanel.setAuthor((Author)object);
        if (this.options.getMessages().showInputDlg(this, new String[]{"edit_project_author_info"}, null, new JComponent[]{this.authorEditPanel}, bl ? "edit_project_author_add" : "edit_project_author_edit")) {
            author = this.authorEditPanel.getAuthor();
            if (author.name.length() < 1) {
                author = null;
            }
        }
        return author;
    }
}

