/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableCubicCurve2D;
import edu.xtec.jclic.shapers.EditableEllipse2D;
import edu.xtec.jclic.shapers.EditableLine2D;
import edu.xtec.jclic.shapers.EditableQuadCurve2D;
import edu.xtec.jclic.shapers.EditableRectangle;
import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import edu.xtec.jclic.shapers.HolesEditorPanel;
import edu.xtec.jclic.shapers.PointListener;
import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;

public class PolygonDrawPanel
implements MouseMotionListener,
MouseListener {
    private Vector vShapes;
    private static Vector vCopied;
    private Vector vRedrawingLines;
    private Vector vRedrawingLinesBeforeModify;
    private Vector vShapeBeforeModify;
    private Vector vPointListeners;
    private double iniX;
    private double iniY;
    private double finX;
    private double finY;
    private double lastFinX;
    private double lastFinY;
    private Point2D iniPoint = null;
    private Point2D lastPoint = null;
    private boolean bSelectedPoint = false;
    private double zoomX = 0.0;
    private double zoomY = 0.0;
    private double zoomH = -1.0;
    private double zoomW = -1.0;
    private boolean creatingRect = false;
    private boolean creatingEllipse = false;
    private boolean creatingPolygon = false;
    private boolean bRedrawingLines = false;
    private boolean bSelectingArea = false;
    private boolean bResizing = false;
    private int resizingDirection = -1;
    private boolean bSpecialLine = false;
    private boolean bMoving = false;
    private EditableShape specialLine = null;
    private int drawingMode = 1;
    static double defaultSensibility;
    private AffineTransform at;
    private Vector vDrawnBorders = null;
    private Shape current = null;
    private JComponent container;
    private short INITIAL = 0;
    private short END = 1;
    public static final int SELECTING = 1;
    public static final int MOVING = 2;
    public static final int NEW_POINT = 4;
    public static final int DRAWING_RECT = 5;
    public static final int DRAWING_ELLIPSE = 6;
    public static final int DRAWING_POLYGON = 7;
    public static final int ZOOM = 12;
    public static final int NO_RESIZING = -1;
    public static final int EAST = 0;
    public static final int SOUTH = 1;
    public static final int SOUTH_EAST = 2;
    private int backgroundComposite = 0;
    protected HolesEditorPanel hep;
    protected boolean canResize;
    protected Rectangle lastPreviewArea;
    static Cursor[] cursors;
    public static final int PEN_CURSOR = 0;
    public static final int CIRCLE_CURSOR = 1;
    protected Shape esborram = null;
    private double viewIniX = -1.0;
    private double viewIniY = -1.0;

    public PolygonDrawPanel(int n, int n2, HolesEditorPanel holesEditorPanel, boolean bl) {
        this.hep = holesEditorPanel;
        this.canResize = bl;
        this.vShapes = new Vector();
        if (vCopied == null) {
            vCopied = new Vector();
        }
        this.vRedrawingLines = new Vector();
        this.vRedrawingLinesBeforeModify = new Vector();
        this.vPointListeners = new Vector();
        this.at = new AffineTransform();
        this.initDrawnBorders();
        if (cursors == null) {
            cursors = new Cursor[2];
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            PolygonDrawPanel.cursors[0] = toolkit.createCustomCursor(ResourceManager.getImageIcon("cursors/llapis.gif").getImage(), new Point(12, 24), "pen");
            PolygonDrawPanel.cursors[1] = toolkit.createCustomCursor(ResourceManager.getImageIcon("cursors/cercle.gif").getImage(), new Point(16, 16), "circle");
        }
        holesEditorPanel.addKeyListener(new KeyHandler());
    }

    public void setDrawingMode(int n) {
        if (this.drawingMode != n) {
            this.drawingMode = n;
            if (this.creatingPolygon) {
                this.joinPolygon();
            }
            if (n != 4 && n != 1) {
                this.endPolygon();
            }
            this.hep.repaint(0L);
        }
    }

    public int getVisibleWidth() {
        return this.hep.getPreviewPanel().getWidth();
    }

    public int getVisibleHeight() {
        return this.hep.getPreviewPanel().getHeight();
    }

    public void initDrawnBorders() {
        if (this.vDrawnBorders != null) {
            this.vDrawnBorders.clear();
        } else {
            this.vDrawnBorders = new Vector();
        }
        for (int i = 0; i < this.hep.getNumShapes(); ++i) {
            Shape shape;
            if (i == this.hep.currentShape || (shape = this.hep.getHoles().getShape(i, this.hep.previewArea)) == null) continue;
            this.vDrawnBorders.addAll(this.getBorders(shape));
        }
    }

    private Vector getBorders(Shape shape) {
        boolean bl = false;
        boolean bl2 = false;
        if (shape == null) {
            return null;
        }
        Vector<Rectangle> vector = new Vector<Rectangle>();
        if (shape instanceof GeneralPath) {
            GeneralPath generalPath = (GeneralPath)shape;
            PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
            double[] dArray = new double[6];
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(dArray);
                switch (n) {
                    case 0: {
                        double d = dArray[0];
                        double d2 = dArray[1];
                        vector.add(new Rectangle((int)(d + (double)bl) - EditableShapeConstants.selectLength / 2, (int)(d2 + (double)bl2) - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength));
                        break;
                    }
                    case 1: {
                        double d = dArray[0];
                        double d2 = dArray[1];
                        vector.add(new Rectangle((int)(d + (double)bl) - EditableShapeConstants.selectLength / 2, (int)(d2 + (double)bl2) - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength));
                        break;
                    }
                    case 3: {
                        double d = dArray[4];
                        double d2 = dArray[5];
                        vector.add(new Rectangle((int)(d + (double)bl) - EditableShapeConstants.selectLength / 2, (int)(d2 + (double)bl2) - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength));
                        break;
                    }
                    case 2: {
                        double d = dArray[2];
                        double d2 = dArray[3];
                        vector.add(new Rectangle((int)(d + (double)bl) - EditableShapeConstants.selectLength / 2, (int)(d2 + (double)bl2) - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength));
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                pathIterator.next();
            }
        }
        return vector;
    }

    public void paint(Graphics2D graphics2D) {
        Cloneable cloneable;
        Graphics2D graphics2D2 = graphics2D;
        EditableShape editableShape = null;
        if (EditableShapeConstants.showDrawnPoints) {
            this.paintDrawnBorders(graphics2D);
        }
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)enumeration.nextElement();
            if (this.bSpecialLine && editableShape == this.specialLine) {
                editableShape.paintWithColor(graphics2D, this.drawingMode, EditableShapeConstants.CUT_COLOR);
                continue;
            }
            editableShape.paintWithColor(graphics2D, this.drawingMode, EditableShapeConstants.ACTIVE_COLOR);
        }
        if (this.bMoving) {
            this.paintMoved(graphics2D);
        }
        if (this.creatingRect) {
            graphics2D.setColor(EditableShapeConstants.selectedColor);
            cloneable = new EditableRectangle((int)this.iniX, (int)this.iniY, (int)(this.finX - this.iniX), (int)(this.finY - this.iniY));
            ((EditableRectangle)cloneable).paintWithColor(graphics2D, this.drawingMode, EditableShapeConstants.selectedColor);
        }
        if (this.creatingEllipse) {
            graphics2D.setColor(EditableShapeConstants.selectedColor);
            cloneable = new EditableEllipse2D((int)this.iniX, (int)this.iniY, (int)(this.finX - this.iniX), (int)(this.finY - this.iniY));
            ((EditableEllipse2D)cloneable).paintWithColor(graphics2D, this.drawingMode, EditableShapeConstants.selectedColor);
        }
        if (this.creatingPolygon && this.lastPoint != null) {
            cloneable = new EditableLine2D(this.lastPoint.getX(), this.lastPoint.getY(), this.finX, this.finY);
            ((EditableLine2D)cloneable).paintWithColor(graphics2D, this.drawingMode, EditableShapeConstants.selectedColor);
        }
    }

    public void drawGrid(Graphics graphics, int n) {
        double d;
        if (n <= 1) {
            return;
        }
        int n2 = (int)this.hep.previewArea.getWidth();
        int n3 = (int)this.hep.previewArea.getHeight();
        graphics.setColor(EditableShapeConstants.gridColor);
        for (d = (double)this.hep.previewArea.x; d <= (double)(this.hep.previewArea.x + n2); d += (double)n * this.hep.xFactor) {
            graphics.drawLine((int)d, this.hep.previewArea.y, (int)d, this.hep.previewArea.y + n3);
        }
        for (d = (double)this.hep.previewArea.y; d <= (double)(this.hep.previewArea.y + n3); d += (double)n * this.hep.yFactor) {
            graphics.drawLine(this.hep.previewArea.x, (int)d, this.hep.previewArea.x + n2, (int)d);
        }
    }

    protected void paintDrawnBorders(Graphics2D graphics2D) {
        Enumeration enumeration = this.vDrawnBorders.elements();
        while (enumeration.hasMoreElements()) {
            Rectangle rectangle = (Rectangle)enumeration.nextElement();
            double d = rectangle.getX();
            double d2 = rectangle.getY();
            double d3 = rectangle.getWidth();
            double d4 = rectangle.getHeight();
            d += d3 / 4.0;
            d2 += d4 / 4.0;
            graphics2D.setColor(EditableShapeConstants.DRAWN_BORDER_COLOR);
            graphics2D.fillRect((int)d, (int)d2, (int)(d3 /= 2.0), (int)(d4 /= 2.0));
        }
    }

    private void paintMoved(Graphics2D graphics2D) {
        Enumeration enumeration = vCopied.elements();
        while (enumeration.hasMoreElements()) {
            EditableShape editableShape = (EditableShape)enumeration.nextElement();
            EditableShape editableShape2 = (EditableShape)editableShape.clone();
            editableShape2.transform(AffineTransform.getTranslateInstance(this.finX - this.iniX, this.finY - this.iniY));
            editableShape2.paintWithColor(graphics2D, this.drawingMode, EditableShapeConstants.movingColor);
        }
    }

    public void updateView() {
        Vector vector = this.getGeneralPath();
        if (this.lastPreviewArea == null) {
            this.lastPreviewArea = this.hep.previewArea;
        }
        if (vector.size() > 0) {
            this.move(this.hep.previewArea.x - this.lastPreviewArea.x, this.hep.previewArea.y - this.lastPreviewArea.y, false, false);
        }
        try {
            this.lastPreviewArea = (Rectangle)this.hep.previewArea.clone();
        }
        catch (Exception exception) {
            System.err.println("Error updating view:\n" + exception);
        }
    }

    public void setShapeData(ShapeData shapeData, double d, double d2, double d3, double d4) {
        this.clean();
        this.current = shapeData != null ? shapeData.getShape(this.hep.previewArea) : null;
        double d5 = -1.0;
        double d6 = -1.0;
        if (shapeData.primitiveType >= 0 && shapeData.primitivePoints != null && shapeData.primitivePoints.length > 3) {
            EditableRectangle editableRectangle = null;
            double d7 = shapeData.primitivePoints[0] * this.hep.previewArea.getWidth() + this.hep.previewArea.getX();
            double d8 = shapeData.primitivePoints[1] * this.hep.previewArea.getHeight() + this.hep.previewArea.getY();
            double d9 = shapeData.primitivePoints[2] * this.hep.previewArea.getWidth();
            double d10 = shapeData.primitivePoints[3] * this.hep.previewArea.getHeight();
            switch (shapeData.primitiveType) {
                case 0: {
                    editableRectangle = new EditableRectangle((int)d7, (int)d8, (int)d9, (int)d10);
                    this.vShapes.add(editableRectangle);
                    break;
                }
                case 1: {
                    editableRectangle = new EditableEllipse2D((int)d7, (int)d8, (int)d9, (int)d10);
                    this.vShapes.add(editableRectangle);
                }
            }
        } else {
            Shape shape = shapeData.getShape(this.hep.previewArea);
            if (shape instanceof GeneralPath) {
                GeneralPath generalPath = (GeneralPath)shape;
                PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
                double[] dArray = new double[6];
                while (!pathIterator.isDone()) {
                    int n = pathIterator.currentSegment(dArray);
                    switch (n) {
                        case 0: {
                            d = dArray[0];
                            d2 = dArray[1];
                            if (d5 != -1.0) break;
                            d5 = d;
                            d6 = d2;
                            break;
                        }
                        case 1: {
                            this.vShapes.add(new EditableLine2D(d, d2, dArray[0], dArray[1]));
                            d = dArray[0];
                            d2 = dArray[1];
                            break;
                        }
                        case 3: {
                            this.vShapes.add(new EditableCubicCurve2D(d, d2, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]));
                            d = dArray[4];
                            d2 = dArray[5];
                            break;
                        }
                        case 2: {
                            this.vShapes.add(new EditableQuadCurve2D(d, d2, dArray[0], dArray[1], dArray[2], dArray[3]));
                            d = dArray[2];
                            d2 = dArray[3];
                            break;
                        }
                        case 4: {
                            if (d5 == -1.0 || d == d5 && d2 == d6) break;
                            this.vShapes.add(new EditableLine2D(d, d2, d5, d6));
                            d = d5;
                            d2 = d6;
                            break;
                        }
                    }
                    pathIterator.next();
                }
                if (d5 != -1.0 && (d != d5 || d2 != d6)) {
                    this.vShapes.add(new EditableLine2D(d, d2, d5, d6));
                }
            }
        }
        this.removeDrawnBorders(shapeData);
    }

    public void clean() {
        this.vShapes = new Vector();
        this.vRedrawingLines = new Vector();
        this.vRedrawingLinesBeforeModify = new Vector();
    }

    public boolean selectDrawnShape(Point2D point2D) {
        this.endPolygon();
        for (int i = 0; i < this.hep.getNumShapes(); ++i) {
            Shape shape = this.hep.getHoles().getShape(i, this.hep.previewArea);
            if (!shape.contains(point2D) || this.hep.currentShape == i) continue;
            this.hep.setCurrentShape(i);
            this.setShapeData(this.hep.getHoles().getShapeData(i), 0.0, 0.0, 1.0, 1.0);
            return true;
        }
        this.hep.setCurrentShape(this.hep.getHoles().getNumCells() + 1);
        this.clean();
        return false;
    }

    public void selectShape(int n) {
        if (n < 0) {
            return;
        }
        ShapeData shapeData = this.hep.getHoles().getShapeData(n);
        if (shapeData != null) {
            this.setShapeData(shapeData, 0.0, 0.0, 1.0, 1.0);
        }
    }

    private EditableShape aproximationToLine(double d, double d2) {
        return this.aproximationToLine(d, d2, null);
    }

    private EditableShape aproximationToLine(double d, double d2, Vector vector) {
        EditableShape editableShape = null;
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)enumeration.nextElement();
            if (vector != null && vector.contains(editableShape) || !editableShape.hasClickedBorder((int)d, (int)d2, false)) continue;
            return editableShape;
        }
        return null;
    }

    private Point2D getTransformedPoint(Point2D point2D, boolean bl) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
        if (EditableShapeConstants.gridWidth != -1 && EditableShapeConstants.pointsOnGrid && bl) {
            this.moveToGrid(double_);
        }
        return double_;
    }

    private void moveToGrid(Point2D point2D) {
        int n = (int)point2D.getX();
        int n2 = (int)point2D.getY();
        n = (int)((double)n - this.hep.previewArea.getX());
        n2 = (int)((double)n2 - this.hep.previewArea.getY());
        double d = (double)EditableShapeConstants.gridWidth * this.hep.xFactor;
        int n3 = (int)d;
        if (n3 == -1) {
            return;
        }
        int n4 = (int)((double)((int)((double)n / d)) * d);
        n = n - n4 < n3 / 2 ? n4 : (int)((double)((int)((double)(n + n3 - 1) / d)) * d);
        int n5 = (int)((double)((int)((double)n2 / d)) * d);
        n2 = n2 - n5 < n3 / 2 ? n5 : (int)((double)((int)((double)(n2 + n3 - 1) / d)) * d);
        n = (int)((double)n + this.hep.previewArea.getX());
        n2 = (int)((double)n2 + this.hep.previewArea.getY());
        point2D.setLocation(n, n2);
    }

    public Point2D aproximationToDrawnBorder(double d, double d2) {
        Enumeration enumeration = this.vDrawnBorders.elements();
        while (enumeration.hasMoreElements()) {
            Rectangle2D rectangle2D = (Rectangle2D)enumeration.nextElement();
            if (!rectangle2D.contains(d, d2)) continue;
            return new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        }
        return null;
    }

    protected void redrawingLines(double d, double d2) {
        EditableShape editableShape = null;
        Enumeration enumeration = this.vRedrawingLines.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)enumeration.nextElement();
            editableShape.changeBorder(d, d2);
        }
    }

    private void cleanZoom() {
        this.zoomX = 0.0;
        this.zoomY = 0.0;
        this.zoomW = -1.0;
        this.zoomH = -1.0;
        this.at = new AffineTransform();
        this.cancelCurrentOperations();
        this.bSelectingArea = false;
        this.hep.repaint(0L);
    }

    public void cancelCurrentOperations() {
        this.creatingRect = false;
        this.creatingEllipse = false;
    }

    public void cut(double d, double d2) {
        this.copy(false);
        this.clean();
        this.bMoving = true;
        this.iniX = d;
        this.iniY = d2;
        this.finX = this.iniX;
        this.finY = this.iniY;
    }

    public void cut() {
        this.cut(-1.0, -1.0);
    }

    public void copy(boolean bl) {
        vCopied.clear();
        EditableShape editableShape = null;
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)((EditableShape)enumeration.nextElement()).clone();
            if (bl && !editableShape.isSelected()) continue;
            vCopied.add(editableShape);
        }
    }

    public void paste() {
        this.bMoving = true;
        this.iniX = -1.0;
        this.iniY = -1.0;
        this.finX = -1.0;
        this.finY = -1.0;
        this.paste(5.0, 5.0);
    }

    public void paste(double d, double d2) {
        Vector<EditableShape> vector = new Vector<EditableShape>();
        this.deSelectAll();
        EditableShape editableShape = null;
        Enumeration enumeration = vCopied.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)enumeration.nextElement();
            EditableShape editableShape2 = (EditableShape)editableShape.clone();
            editableShape2.transform(AffineTransform.getTranslateInstance(d, d2));
            editableShape2.setSelected(true);
            this.vShapes.add(editableShape2);
            vector.add(editableShape2);
        }
        vCopied = vector;
    }

    public void deSelectAll() {
        EditableShape editableShape = null;
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)enumeration.nextElement();
            editableShape.setSelected(false);
        }
        this.bSelectedPoint = false;
        this.hep.repaint(0L);
    }

    private EditableShape nearestLine(double d, double d2) {
        EditableShape editableShape = null;
        EditableShape editableShape2 = null;
        double d3 = 0.0;
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            editableShape2 = (EditableShape)enumeration.nextElement();
            double d4 = editableShape2.distanceTo(d, d2);
            if (editableShape != null && !(d4 < d3)) continue;
            d3 = d4;
            editableShape = editableShape2;
        }
        return editableShape;
    }

    private void clicatISeleccionada(int n, int n2, boolean bl) {
        Point2D point2D = null;
        EditableShape editableShape = null;
        this.vRedrawingLines.clear();
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)enumeration.nextElement();
            if (bl && !editableShape.isSelected() || !editableShape.hasClickedBorder(n, n2, bl)) continue;
            Point2D point2D2 = editableShape.getNearestBorder(n, n2);
            if (point2D != null && !point2D.equals(point2D2)) continue;
            point2D = point2D2;
            this.vRedrawingLines.add(editableShape);
        }
        this.vRedrawingLinesBeforeModify = this.cloneVector(this.vRedrawingLines);
    }

    private Vector cloneVector(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EditableShape editableShape = (EditableShape)enumeration.nextElement();
                vector2.add(editableShape.clone());
            }
        }
        return vector2;
    }

    private void divideShape(EditableShape editableShape, double d, double d2) {
        if (editableShape != null) {
            EditableShape[] editableShapeArray = editableShape.divide(d, d2);
            if (editableShapeArray != null) {
                int n;
                Vector vector = new Vector();
                vector.addAll(this.vShapes);
                this.vShapes.remove(editableShape);
                for (n = 0; n < editableShapeArray.length; ++n) {
                    if (editableShapeArray[n] == null) continue;
                    this.vShapes.add(editableShapeArray[n]);
                }
                n = this.validateShape() ? 1 : 0;
                if (n == 0) {
                    this.vShapes = vector;
                }
            }
            this.hep.updateView();
        }
        this.hep.repaint(0L);
    }

    private boolean validateShape() {
        return this.getGeneralPath().size() == 1;
    }

    public Vector getGeneralPath() {
        Vector<GeneralPath> vector = new Vector<GeneralPath>();
        GeneralPath generalPath = new GeneralPath();
        Vector vector2 = new Vector();
        vector2.addAll(this.vShapes);
        if (vector2.size() <= 0) {
            return vector;
        }
        EditableShape editableShape = (EditableShape)vector2.get(0);
        vector2.remove(editableShape);
        generalPath.append(editableShape, true);
        short s = this.END;
        while (vector2.size() > 0) {
            EditableShape editableShape2 = this.getAdjacent(vector2, editableShape, s);
            if (editableShape2 != null) {
                generalPath.append(editableShape2, true);
                s = this.getNotUsed(editableShape, editableShape2);
                vector2.remove(editableShape2);
                editableShape = editableShape2;
                continue;
            }
            vector.add(generalPath);
            generalPath = new GeneralPath();
            s = this.END;
            editableShape = (EditableShape)vector2.get(0);
            vector2.remove(editableShape);
            generalPath.append(editableShape, true);
        }
        vector.add(generalPath);
        return vector;
    }

    private short getNotUsed(EditableShape editableShape, EditableShape editableShape2) {
        if (editableShape2.getInitialPoint().equals(editableShape.getInitialPoint()) || editableShape2.getInitialPoint().equals(editableShape.getEndPoint())) {
            return this.END;
        }
        return this.INITIAL;
    }

    private EditableShape getAdjacent(Vector vector, EditableShape editableShape, short s) {
        Enumeration enumeration = vector.elements();
        Point2D point2D = s == this.INITIAL ? editableShape.getInitialPoint() : editableShape.getEndPoint();
        while (enumeration.hasMoreElements()) {
            EditableShape editableShape2 = (EditableShape)enumeration.nextElement();
            if (!editableShape2.isAdjacentTo(point2D)) continue;
            return editableShape2;
        }
        return null;
    }

    public boolean hasSelectedDrawnShape(Point2D point2D) {
        for (int i = 0; i < this.hep.getNumShapes(); ++i) {
            Shape shape = this.hep.getHoles().getShape(i, this.hep.previewArea);
            if (!shape.contains(point2D)) continue;
            return true;
        }
        return false;
    }

    private double distanceToNearest(double d, double d2) {
        EditableShape editableShape = this.nearestLine(d, d2);
        if (editableShape != null) {
            return editableShape.distanceTo(d, d2);
        }
        return -1.0;
    }

    public void deleteSelected(boolean bl) {
        if (this.hasSelectedPoint()) {
            this.joinAdjacentsToSelectedPoint();
            this.bSelectedPoint = false;
        } else {
            EditableShape editableShape = null;
            Vector vector = new Vector();
            boolean bl2 = true;
            boolean bl3 = true;
            vector.addAll(this.vShapes);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                editableShape = (EditableShape)enumeration.nextElement();
                if (!editableShape.isSelected()) {
                    bl2 = false;
                    continue;
                }
                bl3 = false;
                if (!bl && this.vShapes.size() < 4) continue;
                this.vShapes.remove(editableShape);
                if (bl) continue;
                this.joinAdjacentsTo(editableShape, this.vShapes);
            }
            if (bl2 || bl3) {
                this.vShapes.clear();
                this.current = null;
                this.hep.getHoles().removeShape(this.hep.currentShape);
                this.hep.setCurrentShape(this.hep.getHoles().getNumCells());
            }
        }
    }

    private void joinAdjacentsTo(EditableShape editableShape, Vector vector) {
        EditableShape editableShape2 = this.getAdjacent(vector, editableShape, this.INITIAL);
        if (editableShape2 != null) {
            editableShape2.hasClickedBorder(editableShape.getInitialPoint().getX(), editableShape.getInitialPoint().getY(), false);
            editableShape2.changeBorder(editableShape.getEndPoint().getX(), editableShape.getEndPoint().getY());
        }
    }

    private void joinAdjacentsToSelectedPoint() {
        EditableShape editableShape = null;
        EditableShape editableShape2 = null;
        if (this.vShapes.size() != 1 && this.vShapes.size() <= 3) {
            return;
        }
        Enumeration enumeration = this.vShapes.elements();
        int n = 0;
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            Point2D point2D;
            editableShape = (EditableShape)enumeration.nextElement();
            if (!editableShape.hasSelectedBorder()) continue;
            if (editableShape instanceof EditableRectangle) {
                point2D = editableShape.getNotSelectedBorder();
                this.convertToSimpleShapes();
                this.selectBorder(point2D.getX(), point2D.getY());
                this.joinAdjacentsToSelectedPoint();
                bl = true;
                continue;
            }
            if (++n == 1) {
                editableShape2 = editableShape;
                continue;
            }
            point2D = editableShape.getNotSelectedBorder();
            Point2D point2D2 = editableShape2.getNotSelectedBorder();
            this.vShapes.add(new EditableLine2D(point2D, point2D2));
            this.vShapes.remove(editableShape);
            this.vShapes.remove(editableShape2);
        }
        this.hep.repaint(0L);
    }

    private void setEndToVector(double d, double d2, Vector vector) {
        EditableShape editableShape = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)enumeration.nextElement();
            editableShape.aproximateNearestBorder(d, d2);
        }
    }

    public boolean hasSelectedPoint() {
        return this.bSelectedPoint;
    }

    public Vector getSelectedShapes() {
        Vector<EditableShape> vector = new Vector<EditableShape>();
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            EditableShape editableShape = (EditableShape)enumeration.nextElement();
            if (!editableShape.isSelected()) continue;
            vector.add(editableShape);
        }
        return vector;
    }

    public int getNumShapes() {
        return this.vShapes.size();
    }

    public void deleteCurrent() {
        this.clean();
        this.current = null;
    }

    public ShapeData getShapeData() {
        ShapeData shapeData = null;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0 / this.hep.previewArea.getWidth(), 1.0 / this.hep.previewArea.getHeight());
        affineTransform.concatenate(AffineTransform.getTranslateInstance(-this.hep.previewArea.x, -this.hep.previewArea.y));
        if (this.getNumShapes() == 1) {
            EditableShape editableShape = (EditableShape)((EditableShape)this.vShapes.elements().nextElement()).clone();
            editableShape.transform(affineTransform);
            Shape shape = editableShape instanceof EditableEllipse2D ? ((EditableEllipse2D)editableShape).getEllipse() : editableShape;
            shapeData = ShapeData.getShapeData(shape, null, false);
        } else {
            Vector vector = this.getGeneralPath();
            if (vector.size() > 0) {
                GeneralPath generalPath = (GeneralPath)vector.elements().nextElement();
                Shape shape = generalPath.createTransformedShape(affineTransform);
                shapeData = ShapeData.getShapeData(shape, null);
            }
        }
        return shapeData;
    }

    public void endPolygon() {
        this.endPolygon(false, true);
    }

    public void endPolygon(boolean bl, boolean bl2) {
        this.endPolygon(bl, bl2, -1);
    }

    public void endPolygon(boolean bl, boolean bl2, int n) {
        ShapeData shapeData = this.getShapeData();
        this.addCurrentDrawnBorders(shapeData);
        this.endPolygon(shapeData, bl, bl2, n);
        if (shapeData != null) {
            this.clean();
        }
        this.bSelectedPoint = false;
    }

    private void addCurrentDrawnBorders(ShapeData shapeData) {
        if (shapeData != null && this.hep != null) {
            Shape shape = shapeData.getShape(this.hep.previewArea);
            this.vDrawnBorders.addAll(this.getBorders(shape));
        }
    }

    private void removeDrawnBorders(ShapeData shapeData) {
        Shape shape = shapeData.getShape(this.hep.previewArea);
        this.vDrawnBorders.removeAll(this.getBorders(shape));
    }

    public void endPolygon(ShapeData shapeData, boolean bl, boolean bl2, int n) {
        if (shapeData != null) {
            this.addCurrentDrawnBorders(shapeData);
            if (this.hep.currentShape < this.hep.getHoles().getNumCells()) {
                this.hep.getHoles().modifyShape(this.hep.currentShape, shapeData);
                this.hep.updateView();
            } else {
                shapeData.comment = StrUtils.secureString(shapeData.comment, "" + this.hep.currentShape);
                this.hep.getHoles().addShape(shapeData);
                this.hep.updateList();
                this.hep.updateView();
            }
        }
        int n2 = this.hep.currentShape + 1;
        n2 = bl ? (n >= 0 ? n : (n2 %= this.hep.getHoles().getNumCells())) : this.hep.getHoles().getNumCells();
        if (this.hep.currentShape != n2) {
            this.hep.setCurrentShape(n2);
        }
    }

    private void aplicateTransformation(AffineTransform affineTransform, boolean bl) {
        EditableShape editableShape = null;
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)enumeration.nextElement();
            if (bl && !editableShape.isSelected()) continue;
            editableShape.transform(affineTransform);
        }
    }

    public void move(int n, int n2, boolean bl, boolean bl2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
        this.aplicateTransformation(affineTransform, bl);
        this.hep.repaint(0L);
    }

    public void scale(double d, double d2, boolean bl, boolean bl2) {
        Point2D point2D = this.getCenter(bl2);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
        affineTransform.concatenate(AffineTransform.getScaleInstance(d, d2));
        affineTransform.concatenate(AffineTransform.getTranslateInstance(-point2D.getX(), -point2D.getY()));
        this.aplicateTransformation(affineTransform, bl);
        this.hep.repaint(0L);
    }

    public void rotate(double d, boolean bl, boolean bl2) {
        this.convertToSimpleShapes();
        Point2D point2D = this.getCenter(bl2);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, point2D.getX(), point2D.getY());
        this.aplicateTransformation(affineTransform, bl);
        this.hep.repaint(0L);
    }

    private Point2D getCenter(boolean bl) {
        if (!bl) {
            EditableShape editableShape = null;
            GeneralPath generalPath = new GeneralPath();
            Enumeration enumeration = this.vShapes.elements();
            while (enumeration.hasMoreElements()) {
                editableShape = (EditableShape)enumeration.nextElement();
                generalPath.append(editableShape, false);
            }
            Rectangle rectangle = generalPath.getBounds();
            return new Point2D.Double(rectangle.getCenterX(), rectangle.getCenterY());
        }
        return new Point2D.Double(this.hep.getPreviewPanel().getX(), this.hep.getPreviewPanel().getY());
    }

    private void convertToSimpleShapes() {
        EditableShape editableShape = null;
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            editableShape = (EditableShape)enumeration.nextElement();
            if (!(editableShape instanceof EditableRectangle)) continue;
            this.vShapes.remove(editableShape);
            EditableShape[] editableShapeArray = ((EditableRectangle)editableShape).divide(-1.0, -1.0, false);
            for (int i = 0; i < editableShapeArray.length; ++i) {
                if (editableShapeArray[i] == null) continue;
                this.vShapes.add(editableShapeArray[i]);
            }
        }
    }

    private EditableShape getSelectedShape(boolean bl) {
        Enumeration enumeration = this.vShapes.elements();
        EditableShape editableShape = null;
        int n = 0;
        while (enumeration.hasMoreElements() && n < 2) {
            EditableShape editableShape2 = (EditableShape)enumeration.nextElement();
            if (!editableShape2.isSelected()) continue;
            if (!bl || editableShape2 instanceof EditableLine2D) {
                editableShape = editableShape2;
                ++n;
                continue;
            }
            n = 2;
        }
        if (n == 1) {
            return editableShape;
        }
        return null;
    }

    public void convertToBezier() {
        EditableShape editableShape = this.getSelectedShape(false);
        if (editableShape != null) {
            double d = editableShape.getInitialPoint().getX();
            double d2 = editableShape.getInitialPoint().getY();
            double d3 = editableShape.getEndPoint().getX();
            double d4 = editableShape.getEndPoint().getY();
            double d5 = d + (d3 - d) / 3.0;
            double d6 = d + 2.0 * ((d3 - d) / 3.0);
            double d7 = d2 + (d4 - d2) / 3.0;
            double d8 = d2 + 2.0 * ((d4 - d2) / 3.0);
            EditableCubicCurve2D editableCubicCurve2D = new EditableCubicCurve2D(d, d2, d5, d7, d6, d8, d3, d4);
            editableCubicCurve2D.setSelected(true);
            this.vShapes.remove(editableShape);
            this.vShapes.add(editableCubicCurve2D);
        }
    }

    public void convertToQuad() {
        EditableShape editableShape = this.getSelectedShape(false);
        if (editableShape != null) {
            double d = editableShape.getInitialPoint().getX();
            double d2 = editableShape.getInitialPoint().getY();
            double d3 = editableShape.getEndPoint().getX();
            double d4 = editableShape.getEndPoint().getY();
            double d5 = d + (d3 - d) / 2.0;
            double d6 = d2 + (d4 - d2) / 2.0;
            EditableQuadCurve2D editableQuadCurve2D = new EditableQuadCurve2D(d, d2, d5, d6, d3, d4);
            editableQuadCurve2D.setSelected(true);
            this.vShapes.remove(editableShape);
            this.vShapes.add(editableQuadCurve2D);
        }
    }

    public void convertToLine() {
        EditableShape editableShape = this.getSelectedShape(false);
        if (editableShape != null && !(editableShape instanceof EditableRectangle)) {
            EditableLine2D editableLine2D = new EditableLine2D(editableShape.getInitialPoint(), editableShape.getEndPoint());
            editableLine2D.setSelected(true);
            this.vShapes.remove(editableShape);
            this.vShapes.add(editableLine2D);
        } else if (editableShape != null && editableShape instanceof EditableRectangle) {
            this.vShapes.remove(editableShape);
            EditableShape[] editableShapeArray = ((EditableRectangle)editableShape).divide(-1.0, -1.0, false);
            for (int i = 0; i < editableShapeArray.length; ++i) {
                if (editableShapeArray[i] == null) continue;
                this.vShapes.add(editableShapeArray[i]);
            }
        }
    }

    public void notifyShapeChanged() {
        Enumeration enumeration = this.vPointListeners.elements();
        while (enumeration.hasMoreElements()) {
            PointListener pointListener = (PointListener)enumeration.nextElement();
            pointListener.shapeChanged();
        }
    }

    public void addPointListener(PointListener pointListener) {
        this.vPointListeners.add(pointListener);
    }

    public void undoLastMove(Vector vector, Vector vector2) {
        this.vShapes.removeAll(vector);
        this.vShapes.addAll(vector2);
        vector.clear();
    }

    private boolean isIntoArea(Vector vector, boolean bl) {
        boolean bl2 = true;
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.hep.previewArea.getX() - 1.0, this.hep.previewArea.getY() - 1.0, this.hep.previewArea.getWidth() + 2.0, this.hep.previewArea.getHeight() + 2.0);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements() && bl2) {
            EditableShape editableShape;
            if (!bl) {
                editableShape = (EditableShape)enumeration.nextElement();
            } else {
                editableShape = (EditableShape)((EditableShape)enumeration.nextElement()).clone();
                editableShape.transform(AffineTransform.getTranslateInstance(this.finX - this.iniX, this.finY - this.iniY));
            }
            Point2D[] point2DArray = editableShape.getBorders();
            if (point2DArray == null) continue;
            for (int i = 0; i < point2DArray.length && bl2; ++i) {
                bl2 = double_.contains(point2DArray[i]);
            }
        }
        return bl2;
    }

    private void joinPolygon() {
        if (this.vShapes.size() >= 2) {
            this.vShapes.add(new EditableLine2D(this.lastPoint.getX(), this.lastPoint.getY(), this.iniPoint.getX(), this.iniPoint.getY()));
        } else {
            this.vShapes.clear();
        }
        this.creatingPolygon = false;
        this.lastPoint = null;
        this.iniPoint = null;
        if (this.bSelectedPoint) {
            this.deselectBorder();
        }
        this.bSelectedPoint = false;
        this.hep.setDrawingMode(1);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        Point2D point2D = this.getTransformedPoint(mouseEvent.getPoint(), true);
        if (this.bMoving) {
            this.hep.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (point2D.getX() < (double)this.hep.previewArea.x || point2D.getY() < (double)this.hep.previewArea.y || point2D.getX() > (double)this.hep.previewArea.x + this.hep.previewArea.getWidth() || point2D.getY() > (double)this.hep.previewArea.y + this.hep.previewArea.getHeight()) {
            return;
        }
        this.vShapeBeforeModify = this.drawingMode == 1 && !this.bMoving ? this.cloneVector(this.vRedrawingLines) : this.cloneVector(vCopied);
        EditableShape editableShape = null;
        Point2D point2D2 = this.aproximationToDrawnBorder(mouseEvent.getX(), mouseEvent.getY());
        if (point2D2 != null && EditableShapeConstants.pointsOnGrid) {
            this.finX = point2D2.getX();
            this.finY = point2D2.getY();
        } else {
            this.finX = point2D.getX();
            this.finY = point2D.getY();
        }
        if (this.creatingRect || this.creatingEllipse) {
            editableShape = this.aproximationToLine(this.finX, this.finY);
            this.hep.getPreviewPanel().repaint(0L);
        } else if (this.bRedrawingLines) {
            this.redrawingLines(this.finX, this.finY);
            editableShape = this.aproximationToLine(this.finX, this.finY, this.vRedrawingLines);
            this.hep.repaint(0L);
        } else if (this.bMoving || this.esInterior(this.finX, this.finY)) {
            editableShape = this.nearestLine(this.finX, this.finY);
            if (editableShape != null) {
                double d = editableShape.distanceTo(this.finX, this.finY);
                if (!this.bMoving && d > (double)(EditableShapeConstants.selectLength / 2)) {
                    this.cut(this.finX, this.finY);
                }
            }
            this.hep.repaint(0L);
        }
        if (this.creatingRect || this.creatingEllipse || this.bRedrawingLines) {
            if ((editableShape != null || point2D2 != null) && EditableShapeConstants.pointsOnGrid) {
                this.hep.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.hep.setCursor(cursors[0]);
            }
        }
        if (!(bl = this.isIntoArea(this.drawingMode == 1 && !this.bMoving ? this.vRedrawingLines : vCopied, this.bMoving))) {
            if (this.drawingMode == 1 && !this.bMoving) {
                this.undoLastMove(this.vRedrawingLines, this.vShapeBeforeModify);
                this.finX = this.lastFinX;
                this.finY = this.lastFinY;
            }
            if (this.bMoving) {
                this.finX = this.lastFinX;
                this.finY = this.lastFinY;
            }
        } else {
            this.lastFinX = this.finX;
            this.lastFinY = this.finY;
        }
        if (this.bResizing) {
            this.setResizingCursor(this.resizingDirection);
        }
    }

    protected boolean esCantonada(double d, double d2) {
        EditableShape editableShape = this.aproximationToLine(d, d2);
        return editableShape != null || this.aproximationToDrawnBorder(d, d2) != null;
    }

    protected boolean esSobreFigura(double d, double d2) {
        int n = Math.max(Math.max(2, EditableShapeConstants.selectLength / 2), EditableShapeConstants.gridWidth);
        double d3 = this.distanceToNearest(d, d2);
        return d3 >= 0.0 && d3 < (double)n;
    }

    protected boolean esInterior(double d, double d2) {
        return this.current != null && this.current.contains(d, d2);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        double d;
        double d2;
        Point point = mouseEvent.getPoint();
        boolean bl = this.esCantonada(mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY());
        if (this.drawingMode == 4 || bl && EditableShapeConstants.pointsOnGrid) {
            d2 = ((Point2D)point).getX();
            d = ((Point2D)point).getY();
        } else {
            d2 = ((Point2D)point).getX();
            d = ((Point2D)point).getY();
        }
        if (d2 < (double)this.hep.previewArea.x || d < (double)this.hep.previewArea.y || d2 > (double)this.hep.previewArea.x + this.hep.previewArea.getWidth() || d > (double)this.hep.previewArea.y + this.hep.previewArea.getHeight()) {
            return;
        }
        if (this.drawingMode != 4) {
            if (bl && (!this.creatingPolygon || EditableShapeConstants.pointsOnGrid)) {
                this.hep.setCursor(Cursor.getPredefinedCursor(12));
            } else if (this.creatingPolygon) {
                this.hep.setCursor(cursors[0]);
            } else if (!this.bMoving && this.esSobreFigura(d2, d)) {
                this.hep.setCursor(cursors[1]);
            } else if (this.esInterior(d2, d)) {
                this.hep.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                this.hep.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (this.drawingMode == 4) {
            if (this.esSobreFigura(d2, d)) {
                this.bSpecialLine = true;
                this.specialLine = this.nearestLine(d2, d);
                this.hep.setCursor(cursors[0]);
                this.hep.repaint(0L);
            } else {
                n = this.bSpecialLine;
                this.bSpecialLine = false;
                this.hep.setCursor(Cursor.getPredefinedCursor(0));
                if (n != 0) {
                    this.hep.repaint(0L);
                }
            }
        }
        if (this.bMoving) {
            if (this.iniX == -1.0) {
                this.deleteSelected(true);
                this.iniX = d2;
                this.iniY = d;
            }
            this.finX = d2;
            this.finY = d;
            this.hep.repaint(0L);
        }
        if (this.creatingPolygon) {
            this.finX = d2;
            this.finY = d;
            this.hep.repaint(0L);
        }
        if (this.canResize) {
            if (!this.bResizing) {
                n = this.getResizing(point);
                if (n != -1) {
                    this.setResizingCursor(n);
                }
            } else {
                this.setResizingCursor(this.resizingDirection);
            }
        }
    }

    protected int getResizing(Point2D point2D) {
        if (!this.canResize) {
            return -1;
        }
        ShapeData shapeData = this.hep.getHoles().getEnclosingShapeData();
        Rectangle rectangle = this.hep.getPreviewArea();
        double d = rectangle.getWidth();
        double d2 = rectangle.getHeight();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-this.hep.previewArea.x, -this.hep.previewArea.y);
        affineTransform.transform(point2D, point2D);
        if (point2D.getX() == d - 1.0 && point2D.getY() == d2 - 1.0) {
            return 2;
        }
        if (point2D.getX() == d - 1.0) {
            return 0;
        }
        if (point2D.getY() == d2 - 1.0) {
            return 1;
        }
        return -1;
    }

    protected void setResizingCursor(int n) {
        if (n == 0) {
            this.hep.setCursor(Cursor.getPredefinedCursor(11), false);
        } else if (n == 1) {
            this.hep.setCursor(Cursor.getPredefinedCursor(9), false);
        } else if (n == 2) {
            this.hep.setCursor(Cursor.getPredefinedCursor(5), false);
        }
    }

    protected void selectBorder(double d, double d2) {
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            EditableShape editableShape = (EditableShape)enumeration.nextElement();
            editableShape.selectBorder(d, d2);
        }
    }

    protected void deselectBorder() {
        Enumeration enumeration = this.vShapes.elements();
        while (enumeration.hasMoreElements()) {
            EditableShape editableShape = (EditableShape)enumeration.nextElement();
            editableShape.deselectBorder();
        }
    }

    protected boolean removeNullLines(Vector vector) {
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements() && !bl) {
            Rectangle rectangle;
            Point2D[] point2DArray;
            EditableShape editableShape = (EditableShape)enumeration.nextElement();
            if (!(editableShape instanceof EditableLine2D) || (point2DArray = editableShape.getBorders()).length <= 1 || !(rectangle = new Rectangle((int)point2DArray[0].getX() - EditableShapeConstants.selectLength / 2, (int)point2DArray[0].getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength)).contains(point2DArray[1].getX(), point2DArray[1].getY()) || this.vShapes.size() < 4) continue;
            bl = true;
            this.vShapes.remove(editableShape);
            this.joinAdjacentsTo(editableShape, this.vShapes);
        }
        return bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point2D point2D;
        EditableShape editableShape;
        Point2D point2D2 = mouseEvent.getPoint();
        boolean bl = this.esSobreFigura(point2D2.getX(), point2D2.getY());
        if (this.drawingMode != 4 && this.drawingMode != 7 && !bl && this.selectDrawnShape(point2D2) && !this.creatingPolygon) {
            this.notifyShapeChanged();
            this.hep.repaint(0L);
        } else if (this.drawingMode != 4 && bl && !this.creatingPolygon && (editableShape = this.nearestLine(point2D2.getX(), point2D2.getY())) != null) {
            if (this.esCantonada(point2D2.getX(), point2D2.getY())) {
                point2D = editableShape.getNearestBorder(point2D2.getX(), point2D2.getY());
                this.deSelectAll();
                this.bSelectedPoint = true;
                this.selectBorder(point2D.getX(), point2D.getY());
                this.hep.repaint(0L);
            } else {
                if (this.bSelectedPoint) {
                    this.deselectBorder();
                }
                this.bSelectedPoint = false;
                if (editableShape.isSelected()) {
                    editableShape.setSelected(false);
                } else {
                    if ((mouseEvent.getModifiers() & 1) == 0) {
                        this.deSelectAll();
                    }
                    editableShape.setSelected(true);
                }
                this.notifyShapeChanged();
                this.hep.repaint(0L);
            }
        }
        if (this.creatingPolygon) {
            if (mouseEvent.getClickCount() == 2) {
                this.joinPolygon();
            } else {
                point2D2 = mouseEvent.getPoint();
                editableShape = this.aproximationToLine(point2D2.getX(), point2D2.getY(), this.vRedrawingLines);
                point2D = null;
                Point2D point2D3 = this.aproximationToDrawnBorder(point2D2.getX(), point2D2.getY());
                if (editableShape != null) {
                    point2D = editableShape.getNearestBorder(point2D2.getX(), point2D2.getY());
                }
                if (point2D3 != null && EditableShapeConstants.pointsOnGrid) {
                    this.finX = point2D3.getX();
                    this.finY = point2D3.getY();
                } else {
                    point2D2 = this.getTransformedPoint(mouseEvent.getPoint(), true);
                    this.finX = point2D2.getX();
                    this.finY = point2D2.getY();
                }
                if (this.lastPoint != null) {
                    if (point2D != null && this.iniPoint.getX() == point2D.getX() && this.iniPoint.getY() == point2D.getY()) {
                        if (this.vShapes.size() >= 2) {
                            this.joinPolygon();
                        }
                    } else if (point2D == null) {
                        this.vShapes.add(new EditableLine2D(this.lastPoint.getX(), this.lastPoint.getY(), this.finX, this.finY));
                        this.lastPoint = new Point2D.Double(this.finX, this.finY);
                    }
                } else {
                    this.lastPoint = this.iniPoint = new Point2D.Double(this.finX, this.finY);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        Point2D point2D = this.getTransformedPoint(mouseEvent.getPoint(), this.drawingMode != 1);
        int n2 = (int)point2D.getX();
        int n3 = (int)point2D.getY();
        if (this.canResize && (n = this.getResizing(point2D)) != -1) {
            if (this.drawingMode != 1) {
                this.hep.setDrawingMode(1);
            }
            this.bResizing = true;
            this.resizingDirection = n;
        }
        if (n2 < this.hep.previewArea.x || n3 < this.hep.previewArea.y || (double)n2 > (double)this.hep.previewArea.x + this.hep.previewArea.getWidth() || (double)n3 > (double)this.hep.previewArea.y + this.hep.previewArea.getHeight()) {
            return;
        }
        if (this.bMoving) {
            this.paste(this.finX - this.iniX, this.finY - this.iniY);
            this.bMoving = false;
        }
        this.iniX = n2;
        this.iniY = n3;
        if (this.drawingMode == 1 && !this.bMoving) {
            this.clicatISeleccionada(n2, n3, false);
            if (this.vRedrawingLines.size() > 0) {
                this.bRedrawingLines = true;
            }
        } else if (!(this.drawingMode != 5 && this.drawingMode != 6 && this.drawingMode != 7 || this.hasSelectedDrawnShape(mouseEvent.getPoint()))) {
            if (this.drawingMode == 5) {
                this.creatingRect = true;
            } else if (this.drawingMode == 6) {
                this.creatingEllipse = true;
            } else {
                this.creatingPolygon = true;
            }
            EditableShape editableShape = this.aproximationToLine(n2, n3);
            Point2D point2D2 = this.aproximationToDrawnBorder(n2, n3);
            if (editableShape != null) {
                point2D2 = editableShape.getNearestBorder(n2, n3);
            }
            if (point2D2 != null) {
                this.iniX = point2D2.getX();
                this.iniY = point2D2.getY();
            } else {
                this.iniX = n2;
                this.iniY = n3;
            }
            this.finX = this.iniX;
            this.finY = this.iniY;
            this.hep.repaint(0L);
        } else if (this.drawingMode == 4) {
            EditableShape editableShape = this.specialLine;
            EditableShape editableShape2 = this.aproximationToLine(n2, n3, null);
            Point2D point2D3 = null;
            boolean bl = false;
            if (editableShape2 != null) {
                point2D3 = editableShape2.getNearestBorder(n2, n3);
            }
            if (this.drawingMode == 4 && editableShape != null && this.bSpecialLine && (point2D3 == null || editableShape instanceof EditableEllipse2D || editableShape instanceof EditableCubicCurve2D || editableShape instanceof EditableQuadCurve2D)) {
                this.divideShape(editableShape, n2, n3);
            } else {
                bl = this.selectDrawnShape(mouseEvent.getPoint());
            }
            if (!bl) {
                this.hep.setDrawingMode(1);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        ShapeData shapeData;
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.bMoving) {
            this.paste(this.finX - this.iniX, this.finY - this.iniY);
            this.bMoving = false;
            this.deSelectAll();
        }
        Point2D point2D = mouseEvent.getPoint();
        EditableShape editableShape = this.aproximationToLine(point2D.getX(), point2D.getY(), this.vRedrawingLines);
        Point2D point2D2 = null;
        Point2D point2D3 = this.aproximationToDrawnBorder(point2D.getX(), point2D.getY());
        if (editableShape != null || point2D3 != null) {
            this.hep.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.hep.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (editableShape != null) {
            point2D2 = editableShape.getNearestBorder(point2D.getX(), point2D.getY());
        }
        if (!((point2D = this.getTransformedPoint(mouseEvent.getPoint(), true)).getX() < (double)this.hep.previewArea.x || point2D.getY() < (double)this.hep.previewArea.y || point2D.getX() > (double)this.hep.previewArea.x + this.hep.previewArea.getWidth() || point2D.getY() > (double)this.hep.previewArea.y + this.hep.previewArea.getHeight())) {
            if (point2D3 != null && EditableShapeConstants.pointsOnGrid) {
                this.finX = point2D3.getX();
                this.finY = point2D3.getY();
            } else {
                this.finX = point2D.getX();
                this.finY = point2D.getY();
            }
        }
        if (this.drawingMode == 1 && !this.bMoving && point2D2 != null || !this.creatingPolygon && this.vShapes.size() > 1 && !this.validateShape()) {
            boolean bl = this.removeNullLines(this.vRedrawingLines);
            if (!bl) {
                this.undoLastMove(this.vRedrawingLines, this.vRedrawingLinesBeforeModify);
                this.finX = this.iniX;
                this.finY = this.iniY;
            }
        } else if (this.bRedrawingLines) {
            this.setEndToVector(this.finX, this.finY, this.vRedrawingLines);
            this.bRedrawingLines = false;
            this.vRedrawingLines.clear();
            this.vRedrawingLinesBeforeModify.clear();
        }
        if (this.creatingRect) {
            this.creatingRect = false;
            this.vShapes.add(new EditableRectangle((int)this.iniX, (int)this.iniY, (int)(this.finX - this.iniX), (int)(this.finY - this.iniY)));
            if (this.hep.currentShape >= this.hep.getHoles().getNumCells()) {
                ShapeData shapeData2 = new ShapeData();
                shapeData2.comment = "" + this.hep.currentShape;
                this.hep.getHoles().addShape(shapeData2);
                this.hep.updateList();
            }
        }
        if (this.creatingEllipse) {
            this.creatingEllipse = false;
            this.vShapes.add(new EditableEllipse2D((int)this.iniX, (int)this.iniY, (int)(this.finX - this.iniX), (int)(this.finY - this.iniY)));
            if (this.hep.currentShape >= this.hep.getHoles().getNumCells()) {
                ShapeData shapeData3 = new ShapeData();
                shapeData3.comment = "" + this.hep.currentShape;
                this.hep.getHoles().addShape(shapeData3);
                this.hep.updateList();
            }
        }
        if (this.bResizing) {
            if (this.resizingDirection != -1) {
                double d = point2D.getX();
                double d2 = point2D.getY();
                double d3 = d - this.iniX;
                double d4 = d2 - this.iniY;
                if (this.resizingDirection == 0) {
                    d4 = 0.0;
                } else if (this.resizingDirection == 1) {
                    d3 = 0.0;
                }
                this.hep.incDrawingArea(d3, d4);
            }
            this.bResizing = false;
        }
        this.current = (shapeData = this.getShapeData()) != null ? shapeData.getShape(this.hep.previewArea) : null;
        this.bSelectingArea = false;
        this.hep.repaint(0L);
        if (!this.creatingPolygon) {
            this.notifyShapeChanged();
        }
    }

    static {
        defaultSensibility = 1.5;
        cursors = null;
    }

    public class KeyHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                PolygonDrawPanel.this.deleteSelected(false);
                PolygonDrawPanel.this.hep.shapeChanged();
            }
        }
    }
}

