#! /bin/sh
# Generated by niminst

if [ $# -eq 1 ] ; then
  case $1 in
    "--help"|"-h"|"help"|"h")
      echo "Nimrod deinstallation script"
      echo "Usage: [sudo] sh deinstall.sh DIR"
      echo "Where DIR may be:"
      echo "  /usr/bin"
      echo "  /usr/local/bin"
      echo "  /opt"
      echo "  <some other dir> (treated like '/opt')"
      exit 1
      ;;
    "/usr/bin")
      bindir=/usr/bin
      configdir=/etc
      libdir=/usr/lib/nimrod
      docdir=/usr/share/nimrod/doc
      datadir=/usr/share/nimrod/data
      ;;
    "/usr/local/bin")
      bindir=/usr/local/bin
      configdir=/etc
      libdir=/usr/local/lib/nimrod
      docdir=/usr/local/share/nimrod/doc
      datadir=/usr/local/share/nimrod/data
      ;;
    *)
      bindir="$1/nimrod/bin"
      configdir="$1/nimrod/config"
      libdir="$1/nimrod/lib"
      docdir="$1/nimrod/doc"
      datadir="$1/nimrod/data"
      ;;
  esac
  echo "removing files..."

  rm -f $bindir/nimrod
  rm -f $configdir/nimrod.cfg
  rm -f $configdir/nimdoc.cfg
  rm -f $configdir/nimdoc.tex.cfg
  rm -rf $docdir
  rm -rf $datadir
  rm -rf $libdir

  echo "deinstallation successful"
else
  echo "Nimrod deinstallation script"
  echo "Usage: [sudo] sh deinstall.sh DIR"
  echo "Where DIR may be:"
  echo "  /usr/bin"
  echo "  /usr/local/bin"
  echo "  /opt"
  echo "  <some other dir> (treated like '/opt')"
  exit 1
fi

