/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright (C) 2004-2008 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "uimain.h"
#include "widgets.h"
#include "callbacks.h"
#include "interface.h"
#include "mltlang.h"

#define	ID_DUMMY2	ID_CNSKIPBLANK

UIBookletDlg* CreateBookletDlg(UIDialog *parent)
{
        UIBookletDlg *dialog;

        dialog = (UIBookletDlg *)CreateDialog(sizeof(UIBookletDlg), parent);

	if(dialog == NULL)
		return NULL;

        UI_DIALOG(dialog)->window = create_BookletDlg();

	ComboSignalConnect(UI_DIALOG(dialog)->window, "BookletDlgOpening_combo", GTK_SIGNAL_FUNC(on_BookletDlgOpening_combo_popwin_event));

	return dialog;
}

void ShowBookletDlg(UIBookletDlg *dialog)
{
	GtkWidget *window = UI_DIALOG(dialog)->window;;
	char *opt = NULL, *opt1 = NULL;
	double max_gutter_shift;
	double min_gutter_shift;
	char *text = NULL;
	char label[32];
	gboolean disable;

	cngplpSetData(UI_DLG_TOP(dialog)->data, ID_SHOWDLG, "Booklet");
	max_gutter_shift = GetCurrOptDouble(ID_MAX_GUTTER_SHIFT_NUM, 10.0);
	min_gutter_shift = GetCurrOptDouble(ID_MIN_GUTTER_SHIFT_NUM, 0.0);
	text = NameToText(ID_MAX_GUTTER_SHIFT_NUM, "CorrectionWidthRange");
	snprintf(label, 31, text, min_gutter_shift, max_gutter_shift);
	SetTextToLabel(window, "CorrectRange_label", label);
	SetSpinMaxMinValueDouble(window, "CorrectWidth_spinbutton", max_gutter_shift, min_gutter_shift);

	opt = GetCurrOpt(ID_CNCREEP, NULL);
	opt1 = GetCurrOpt(ID_CNDISPLACEMENTCORRECTION, NULL);
	if(opt != NULL && opt1 != NULL){
		ShowWidget(window, "hseparator26");
		ShowWidget(window, "CreepUse_checkbutton");
		ShowWidget(window, "Creep_frame");
		ShowWidget(window, "hbox82");
	}
	memFree(opt);
	memFree(opt1);
	SigDisable();
	UpdateBookletDlgWidgets(dialog, NULL);
	SigEnable();
	ShowDialog((UIDialog *)dialog, "BookletSetting_button");
}

void HideBookletDlg(UIBookletDlg *dialog, int apply)
{
	char *text;
	text = cngplpSetData(UI_DLG_TOP(dialog)->data, apply, "Booklet");
	UpdateWidget(ID_DUMMY2, text);
	HideDialog((UIDialog *)dialog);
}

void UpdateBookletDlgWidgets(UIBookletDlg *book, char *except_name)
{
	GtkWidget *window;

	window = UI_DIALOG(book)->window;

	GetOptToGList(window, ID_BOOKLET_DLG, "BookletDlgOpening_combo");
	UpdateBookletDlgCreepWidgets(g_main_window->prop);
}
