	.title	AS8x300 Assembler Test
	.sbttl	Absolute Value Assembly

	.xerr	2

	.radix	D

	; Define Areas and Banks

	.bank	s8x_c		(size=0x2000, fsfx=_cod)
	.area	s8x_code	(rel,con,cseg,bank=s8x_c)
	.area	s8x_call	(rel,con,cseg,bank=s8x_c)

	.bank	s8x_x		(size=0x2000, fsfx=_ext)
	.area	s8x_code_x	(rel,con,cseg,bank=s8x_x)
	.area	s8x_call_x	(rel,con,cseg,bank=s8x_x)

	.area	s8x_code	; The Code Area
	.xtnd	s8x_code_x	; The Extended Code Area

	.nlist
	.include	/s8xmcros.asm/
	.list


	.PAGE
	.TITLE	MAIN
	.SBTTL	MCCAP TEST PROGRAM
	;**********************************************
	;* THIS PROGRAM IS USED TO TEST THE ASSEMBLER *
	;* FOR PROPER OPERATION. IT SHOWS THE VARIOUS *
	;* INSTRUCTION FORMATS, ASSEMBLER DIRECTIVES, *
	;* AND ERROR CONDITIONS.                      *
	;**********************************************

	.fdef	4(5),-8(2),2,2

	.MACRO	MAC3	A1,A2
	  .LIST	(!,ME,ERR,LOC,BIN,EQT,CYC,SRC)
	  MOVE	A1,A2
	  XEC	.(A1)
	  XMIT	1,A2
	.ENDM

	.MACRO	MAC2
	  .LIST	(!,ME,ERR,LOC,BIN,EQT,CYC,SRC)
	  JMP	.+2
	  MOVE	R1,IVL
	  SEL	WS1
	MAC3	R1,R11
	.ENDM

	.MACRO	MAC1	P1,P2
	  .LIST	(!,ME,ERR,LOC,BIN,EQT,CYC,SRC)
	  MOVE	P1,P2
	  MOVE	P2,P1
	.ENDM

	.LIV	IV1	2,7,8		; 00B8
	.LIV	IV2	3,7,6		; 00FE
	.LIV	IV3	3,6,6		; 00F6
	.RIV	WS1	100,7,8		; 1938
	.RIV	WS2	101,6,7		; 1977
	.RIV	WS3	WS2+1,5,6	; 19AE

	HALT				; E0 00 50 20
	NOP [0,WS2]			; 00 00 06 50
	NOP				; 00 00 50 20
	MOVE	AUX,AUX [7]		; 00 00 70 20
	MOVE	R1,R0 []		; 01 00 50 20
	MOVE	R1,R1			; 01 01 50 20
	MOVE	R1,R11 [1,2,,3]		; 01 09 10 23
	MOVE	R1,R2 [IV1,7]		; 01 02 20 70
	MOVE	R1,R3 [,LAB1]		; 01 03 5A 00
	MOVE	R1,R4			; 01 04 50 20
	MOVE	R1,R5 [0B1111,-1,2]	; 01 05 FF F8
	MOVE	R1,R6 [0,X1,3,3]	; 01 06 0F FF
	MOVE	R1,IVL [,,,1]		; 01 07 50 21
	MOVE	R1,IVR			; 01 0F 50 20
	MOVE	R2,R1 [IV3,0Q77]	; 02 01 33 F0
	MOVE	OVF,R2 [2,.,1,1]	; 08 02 20 F5
	MOVE	AUX,AUX [0,0,0,0]	; 00 00 00 00
	MOVE	0,1			; 00 01 50 20
	MOVE	0,7			; 00 07 50 20
	MOVE	0,9			; 00 09	50 20
	MOVE	0,15			; 00 0F 50 20
	MOVE	0,16			; 00 10 50 20
	MOVE	0,23			; 00 17 50 20
	ADD	R1(1),R1		; 21 21 50 20
	ADD	R1(8),R1		; 21 01 50 20
	AND	AUX,IV1			; 40 17 50 20
	AND	R1,IV1+1		; 41 17 50 20
	AND	R2,1,IV1		; 42 37 50 20
	AND	R2,7,IV1		; 42 F7 50 20
	AND	R2,8,IV1		; 42 17 50 20
	XOR	IV1,R2			; 77 02 50 20
	XOR	IV1,0,R2		; 77 02 50 20
	XOR	IV1,1,R2		; 77 22 50 20
	XOR	IV1,7,R2		; 77 E2 50 20
	XMIT	'A,R1 [1,2,3,3]		; C1 41 10 2F
	XMIT	'Z,R2			; C2 5A 50 20
	XMIT	'0,AUX			; C0 30 50 20
	XMIT	'',R11			; C9 27 50 20
	XEC	.+1(IV1)		; 97 07 50 20
	XEC	.+1(IV1,3) [,LI2,0]	; 97 68 51 60
	XMIT	0X1F,R5			; C5 1F 50 20
	XMIT	0X0C4,R7		; C7 C4 50 20
	XMIT	-0X1B,R0		; C0 E5 50 20
	XMIT	-1,R4			; C4 FF 50 20
	XMIT	-256,R11		; C9 00 50 20	NUMBER TOO NEGATIVE
	XMIT	0,IVL			; C7 00 50 20
	XMIT	1,IVR			; CF 01 50 20
	XMIT	30,IV1			; D7 1E 50 20
	JMP	8191 [0,0,0,0]		; FF FF 00 00

	.LIV	LI2	22,4
	SEL	LI2 [0Q17,0,3,3]	; C7 16 F0 0F
	MOVE	R2,LI2			; 02 34 50 20

	.LIV	LI4	LI2+4,3,1
	SEL	LI4			; C7 1A 50 20
	ADD	LI4,R3			; 33 23 50 20

	;*******************
	;*  PAGING ERRORS  *
	;*******************

	ORG	128

	XEC	.(R1),256		; 81 80	50 20	PG ERROR
	XEC	.(R1),253		; 81 81 50 20	PG ERROR
	XEC	LAB1(R1)		; 81 A0 50 20
	XEC	LAB1(IV1)		; 97 00	50 20	PG ERROR
	XEC	LAB1-1(IV1)		; 97 1F 50 20
	XEC	LAB1-1(IV1),32		; 97 1F 50 20	PG ERROR
	XEC	.(IV1),LAB1-.		; 97 06 50 20
	XEC	.+1(IV1),LAB1-.		; 97 08 50 20	PG ERROR
	XEC	.(IV1),LAB1-. [2,100]	; 97 08 26 40

	ORG	128+32

LAB1:	MOVE	AUX,AUX			; 00 00 50 20
	NZT	R1,LAB2			; A1 C0 50 20
	NZT	IV1,LAB2		; B7 00 50 20	PG ERROR
	NZT	IV1,LAB2-1		; B7 1F 50 20
	NZT	IV2,4,LAB2-3		; B7 9D 50 20
	NZT	IV1,3,. [0,IV1,1,0]	; B7 65 00 24

	ORG	128+32+32

LAB2:	MOVE	AUX,R1			; 00 01 50 20
	XMIT	0,R1			; C1 00 50 20
	XEC	.(IV1,8)		; 97 02 50 20
	XEC	.(R1),2			; 81 C3 50 20

	MAC1	R1,AUX
	;  MOVE	R1,AUX			; 01 00 50 20
	;  MOVE	AUX,R1			; 00 01 50 20

	S1 = 22				;		LABELS AND ASSIGNMENTS
	JMP	S1			; E0 16 50 20	ARE EQUIVALENT IN ASXXXX
	
	S1 = S1 + 3			;		LABELS AND ASSIGNMENTS
	JMP	S1			; E0 19 50 20	ARE EQUIVALENT IN ASXXXX

	CALL	PROC1 ^/  /	^/	; C9 00 50 20/ ^/	;sE2r4E 50 20/
	MOVE	AUX,R1			; 00 01 50 20
	CALL	PROC2 ^/  /	^/	; C9 01 50 20/ ^/	;sE2r52 50 20/
	MOVE	2,AUX			; 02 00 50 20
	CALL	PROC3 ^/[0,0]/	^/	; C9 02 00 00/ ^/	;sE2r54 00 00/

	ORG	512

	MOVE	AUX,AUX			; 00 00 50 20
	XMIT	1,R1			; C1 01 50 20

	;* IF DIRECTIVE

	.IF 0				; 0000
	MOVE	R1,1
	XMIT	2,R4
	.ENDIF

	.IF 1				; 0001
	MOVE	2,R3			; 02 03 50 20
	.ENDIF

	;* VARIOUS EXPRESSIONS AND OPERATORS

	JMP	2 << 5			; E0 40 50 20
	JMP	2 >> 5			; E0 00 50 20
	XMIT	31&4,AUX		; C0 04 50 20
	XMIT	2+3-6+17,R1		; C1 10 50 20
	XMIT	0B1001+6,AUX		; C0 0F 50 20
	XMIT	R5+(2 << 3),AUX		; C0 15 50 20
	XMIT	0Q27,R2			; C2 17 50 20
	XMIT	2,R0 [1,.,0]		; C0 02 10 A0

	;* ARGUMENT ERRORS

	XMIT	,IV2,8			; C0 00 50 20	ARGUMENT ERROR
	XEC	,R1			; 80 00 50 20	ARGUMENT ERROR
	XMIT	-1,			; C0 00 50 20	ARGUMENT ERROR
	JMP	MAIN			; E0 00 50 20	UNDEFINED
	JMP	PROC1			;sE2r4E 50 20
	XMIT	-1,R2 [1,0Q28,1,0]	; C2 FF 10 24	ARGUMENT ERROR

	K1	=	0Q1237		; 029F
	K3	=	0Q1238		; 0053		INVALID DIGIT (8)
	K3	=	0B1002	        ; 0004		INVALID DIGIT (2)

	;* SYNTAX ERRORS

	XEC	.,R1			; 80 00 50 20	SYNTAX -> .(R1)
	XMIT	1++2,R1			; C1 03 50 20	SYNTAX -> 1+2,R1
					;		ASXXXX STRIPS EXTRA '+'
	XMIT	1,R0 [.IV1+,]		;		SYNTAX -> [.IV1+__,]

	;* IV BYTE AND BYTE ERRORS

	MOVE	IV1,IV1			; 17 17 50 20
	MOVE	WS1,IV1			; 1F 17 50 20
	MOVE	WS2,IV1			; 1E F7 50 20	ERROR
	MOVE	IV2,IV3			; 17 D6 50 20
	MOVE	IV1,IV2			; 17 D7 50 20	ERROR
	MOVE	IV2,8,WS2		; 17 1F 50 20
	MOVE	IV2,0,WS2		; 17 1F 50 20
	MOVE	IV1+1,IV1		; 17 17 50 20	ERROR - ALLOWED
					;		BYTE VALUE NOT USED

	;* VALUE ERRORS

	XEC	.(IV1,9)		;s97r3B 50 20	VALUE 9 > 8
	NZT	IV1,8,.			;sB7r1C 50 20
	NZT	IV1,9,.			;sB7r3D 50 20	VALUE 9 > 8
        XMIT    -257,R3                 ; C3 FF 50 20	VALUE -257 < -255
        XMIT    32,IV2,4                ; D7 80 50 20	VALUE 32 > 31
        XMIT    -32,IV1                 ; D7 00 50 20	VALUE -32 < -31
        XMIT    -33,IV2                 ; D7 1F 50 20	VALUE -33 < -31
        JMP     8192                    ; E0 00 50 20	VALUE 8192 > 8191
        XMIT    256,AUX                 ; C0 00 50 20	VALUE 256 > 255
        XMIT    5,R1 [15]		; C1 05 F0 20
        XMIT    -1,R2 [16]              ; C2 FF 00 20	VALUE 16 > 15
        ADD     R1,AUX [,,,5]           ; 21 00 50 21	VALUE 5 > 3

	X5	=	8192	        ; 2000
	JMP	X5			; E0 00 50 20	VALUE X5 > 8191

	.RIV	RI2	255		; 3FF9
	.RIV	RI3	256		; 4039		VALUE 256 > 255
	.RIV	RI5	2,8,0		; 0080		VALUE 8 > 7

	;* CONTEXT ERRORS

	XMIT	2,R1,3			; C0 00 50 20	CONTEXT ERROR
	NZT	R1,2,.			; A0 00 50 20	CONTEXT ERROR
	XMIT	31,IVL,3		; C0 00 50 20	CONTEXT ERROR
	XEC	.+1(R1,2)		;s81r2C 50 20	CONTEXT ERROR

	X1	=	-1		; FFFF
	SEL	X1			; C0 FF 50 20	CONTEXT ERROR

	;* UNDEFINED LABELS, LABEL ERRORS,
	;* AND DUPLICATE LABELS.

	XMIT	K7,R1			; C1 00 50 20	UNDEFINED

	LABEL,	=	2		;		SYNTAX
	ABCDEF	=	2	        ; 0002
	ABCDEF	=	3		; 0003		REASSIGNMENT ALLOWED IN ASXXXX
	ABCDEG	=	5		; 0005

J2:	MOVE	2,2			; 02 02 50 20	MULTIPLE DEFINITION / PHASE ERROR
J2:	MOVE	3,2			; 03 02 50 20	MULTIPLE DEFINITION / PHASE ERROR

LAB10:	ORG	.			;		ALLOWED IN ASXXXX

S1:	XMIT	-2,AUX			; C0 FE 50 20	PHASE ERROR
	MOVE	R1,R7			; 01 07 50 20

	;* REGISTER ERRORS
	MOVE	IVR,R1			; 0F 01 50 20	REGISTER ERROR
	MOVE	R1,OVF			; 01 08 50 20	REGISTER ERROR
	MOVE	0,10			; 00 0A 50 20	REGISTER ERROR
	MOVE	0,31			; 00 1F 50 20
	MOVE	0,32			; 00 00 50 20	REGISTER ERROR
	XMIT	0,OVF			; C8 00 50 20	REGISTER ERROR
	MOVE	IV1,8,IV1		; 17 17 50 20
	MOVE	IV1,9,IV1		; 17 37 50 20	REGISTER ERROR

	.8X305
	MOVE	R7,IVL
	MOVE	R15,R7
	MOVE	R12,R13
	MOVE	R13,R15
	MOVE	R14,R5
	MOVE	R0,R16
	MOVE	R17,R1

	.8X300
	MOVE	R1,R7			; 01 07 50 20
	MOVE	R7,R1			; 07 01 50 20	REGISTER ERROR
	MOVE	R12,R1			; 0A 01 50 20	REGISTER ERROR
	MOVE	IVL,R13			; 07 0B 50 20	REGISTER ERROR
	MOVE	R0,IVR			; 00 0F 50 20
	MOVE	R2,R14			; 02 0C 50 20	REGISTER ERROR
	MOVE	R15,R17			; 0D 0F 50 20	REGISTER ERROR
	MOVE	R16,R0			; 0E 00 50 20	REGISTER ERROR

	;* OPCODE ERRORS

	.8X305
	XML	2			; CC 02 50 20
	XMR	0X0F			; CD 0F 50 20

	.8X300
	XML	7			; CC 00 50 20	OPCODE ERROR
	XMR	11			; CD 00 50 20	OPCODE ERROR

STOP:	HALT [0Q17,0Q377,3,3]		;sE2r4D FF FF 

	PROC	PROC1
	.RIV	IVV1	3,6,1		; 00F1

	XMIT	R4,AUX			; C0 04 50 20

	X4	=	2		; 0002

	JMP	LAB1			;sE0rA0 50 20	ALLOWED IN ASXXXX
	RTN		^/		;sE2r68 50 20/
	MOVE	IVV1,R2

	PROC	PROC2
	JMP	S1			;sE2r30 50 20	ALLOWED IN ASXXXX
	S1	=	17	        ; 0011		ALLOWED IN ASXXXX
	RTN		^/		;sE2r68 50 20/

	PROC PROC3
	XMIT	S1,R1			; C1 11 50 20	ALLOWED IN ASXXXX
	MOVE	WS1,AUX			; 1F 00 50 20
	RTN		^/		;sE2r68 50 20/
	MOVE	AUX,R11			; 00 09 50 20
	RTN		^/		;sE2r68 50 20/
	PROC PROC5
	XMIT	1,R2			; C2 01 50 20
	CALL	PROC1 ^/[]/ 	^/	; C9 03 50 20/ ^/	;sE2r4E 50 20/
	ENTRY	ENTRY5
	CALL	PROC2 ^/  /	^/	; C9 04 50 20/ ^/	;sE2r52 50 20/
	RTN	^/[,,3]/	^/	;sE2r68 50 2C/
	PROC	PROC8
P1:	MOVE	R1,R1			; 01 01 50 20
	CALL	ENTRY5 ^/  /	^/	; C9 05 50 20/ ^/	;sE2r5C 50 20/

	MAC2
	;  JMP	.+2			;sE2r64 50 20
	;  MOVE	R1,IVL			; 01 07 50 20
	;  SEL	WS1			; CF 64 50 20
	;  MOVE	R1,R11			; 01 09 50 20
	;  XEC	.(R1)			;s81r66 50 20
	;  XMIT	1,R11			; C9 01 50 20


	;.area	s8x_code
	;.xtnd	s8x_code_x
	Call_Table	s8x_code,s8x_code_x ^/[0,0,0,0]/
	; XEC	.+1(R11) [0,0,0,0]	;s89r69 00 00
	; JMP	.RTN.1 [0,0,0,0]	;sE0rCA 00 00
	; JMP	.RTN.2 [0,0,0,0]	;sE0rCD 00 00
	; JMP	.RTN.3 [0,0,0,0]	;sE0rD0 00 00
	; JMP	.RTN.4 [0,0,0,0]	;sE2r5C 00 00
	; JMP	.RTN.5 [0,0,0,0]	;sE2r5E 00 00
	; JMP	.RTN.6 [0,0,0,0]	;sE2r62 00 00

	.end

