/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.support.v8.renderscript.AllocationThunker;
import android.support.v8.renderscript.BaseObj;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.FieldPacker;
import android.support.v8.renderscript.RSIllegalArgumentException;
import android.support.v8.renderscript.RSInvalidStateException;
import android.support.v8.renderscript.RSRuntimeException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Type;
import android.util.Log;

public class Allocation
extends BaseObj {
    Type mType;
    Bitmap mBitmap;
    int mUsage;
    Allocation mAdaptedAllocation;
    int mSize;
    boolean mConstrainedLOD;
    boolean mConstrainedFace;
    boolean mConstrainedY;
    boolean mConstrainedZ;
    boolean mReadAllowed = true;
    boolean mWriteAllowed = true;
    int mSelectedY;
    int mSelectedZ;
    int mSelectedLOD;
    Type.CubemapFace mSelectedFace = Type.CubemapFace.POSITIVE_X;
    int mCurrentDimX;
    int mCurrentDimY;
    int mCurrentDimZ;
    int mCurrentCount;
    public static final int USAGE_SCRIPT = 1;
    public static final int USAGE_GRAPHICS_TEXTURE = 2;
    public static final int USAGE_IO_INPUT = 32;
    public static final int USAGE_IO_OUTPUT = 64;
    public static final int USAGE_SHARED = 128;
    static BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();

    private int getIDSafe() {
        if (this.mAdaptedAllocation != null) {
            return this.mAdaptedAllocation.getID(this.mRS);
        }
        return this.getID(this.mRS);
    }

    public Element getElement() {
        return this.mType.getElement();
    }

    public int getUsage() {
        return this.mUsage;
    }

    public int getBytesSize() {
        return this.mType.getCount() * this.mType.getElement().getBytesSize();
    }

    private void updateCacheInfo(Type t) {
        this.mCurrentDimX = t.getX();
        this.mCurrentDimY = t.getY();
        this.mCurrentDimZ = t.getZ();
        this.mCurrentCount = this.mCurrentDimX;
        if (this.mCurrentDimY > 1) {
            this.mCurrentCount *= this.mCurrentDimY;
        }
        if (this.mCurrentDimZ > 1) {
            this.mCurrentCount *= this.mCurrentDimZ;
        }
    }

    private void setBitmap(Bitmap b) {
        this.mBitmap = b;
    }

    Allocation(int id, RenderScript rs, Type t, int usage) {
        super(id, rs);
        if ((usage & 0xFFFFFF1C) != 0) {
            throw new RSIllegalArgumentException("Unknown usage specified.");
        }
        if ((usage & 0x20) != 0) {
            this.mWriteAllowed = false;
            if ((usage & 0xFFFFFFDC) != 0) {
                throw new RSIllegalArgumentException("Invalid usage combination.");
            }
        }
        this.mType = t;
        this.mUsage = usage;
        this.mSize = this.mType.getCount() * this.mType.getElement().getBytesSize();
        if (t != null) {
            this.updateCacheInfo(t);
        }
        if (RenderScript.sUseGCHooks) {
            try {
                RenderScript.registerNativeAllocation.invoke(RenderScript.sRuntime, this.mSize);
            }
            catch (Exception e) {
                Log.e((String)"RenderScript_jni", (String)("Couldn't invoke registerNativeAllocation:" + e));
                throw new RSRuntimeException("Couldn't invoke registerNativeAllocation:" + e);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (RenderScript.sUseGCHooks) {
            RenderScript.registerNativeFree.invoke(RenderScript.sRuntime, this.mSize);
        }
        super.finalize();
    }

    private void validateIsInt32() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_32 || this.mType.mElement.mType == Element.DataType.UNSIGNED_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt16() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_16 || this.mType.mElement.mType == Element.DataType.UNSIGNED_16) {
            return;
        }
        throw new RSIllegalArgumentException("16 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt8() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_8 || this.mType.mElement.mType == Element.DataType.UNSIGNED_8) {
            return;
        }
        throw new RSIllegalArgumentException("8 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsFloat32() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsObject() {
        if (this.mType.mElement.mType == Element.DataType.RS_ELEMENT || this.mType.mElement.mType == Element.DataType.RS_TYPE || this.mType.mElement.mType == Element.DataType.RS_ALLOCATION || this.mType.mElement.mType == Element.DataType.RS_SAMPLER || this.mType.mElement.mType == Element.DataType.RS_SCRIPT) {
            return;
        }
        throw new RSIllegalArgumentException("Object source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    public Type getType() {
        return this.mType;
    }

    public void syncAll(int srcLocation) {
        switch (srcLocation) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new RSIllegalArgumentException("Source must be exactly one usage type.");
            }
        }
        this.mRS.validate();
        this.mRS.nAllocationSyncAll(this.getIDSafe(), srcLocation);
    }

    public void ioSend() {
        if ((this.mUsage & 0x40) == 0) {
            throw new RSIllegalArgumentException("Can only send buffer if IO_OUTPUT usage specified.");
        }
        this.mRS.validate();
        this.mRS.nAllocationIoSend(this.getID(this.mRS));
    }

    public void ioSendOutput() {
        this.ioSend();
    }

    public void ioReceive() {
        if ((this.mUsage & 0x20) == 0) {
            throw new RSIllegalArgumentException("Can only receive if IO_INPUT usage specified.");
        }
        this.mRS.validate();
        this.mRS.nAllocationIoReceive(this.getID(this.mRS));
    }

    public void copyFrom(BaseObj[] d) {
        this.mRS.validate();
        this.validateIsObject();
        if (d.length != this.mCurrentCount) {
            throw new RSIllegalArgumentException("Array size mismatch, allocation sizeX = " + this.mCurrentCount + ", array length = " + d.length);
        }
        int[] i = new int[d.length];
        for (int ct = 0; ct < d.length; ++ct) {
            i[ct] = d[ct].getID(this.mRS);
        }
        this.copy1DRangeFromUnchecked(0, this.mCurrentCount, i);
    }

    private void validateBitmapFormat(Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        if (bc == null) {
            throw new RSIllegalArgumentException("Bitmap has an unsupported format for this operation");
        }
        switch (bc) {
            case ALPHA_8: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_A) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + bc);
            }
            case ARGB_8888: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 4) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + bc);
            }
            case RGB_565: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGB && this.mType.getElement().getBytesSize() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + bc);
            }
            case ARGB_4444: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + bc);
            }
        }
    }

    private void validateBitmapSize(Bitmap b) {
        if (this.mCurrentDimX != b.getWidth() || this.mCurrentDimY != b.getHeight()) {
            throw new RSIllegalArgumentException("Cannot update allocation from bitmap, sizes mismatch");
        }
    }

    public void copyFromUnchecked(int[] d) {
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFromUnchecked(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, d);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFromUnchecked(0, 0, this.mCurrentDimX, this.mCurrentDimY, d);
        } else {
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, d);
        }
    }

    public void copyFromUnchecked(short[] d) {
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFromUnchecked(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, d);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFromUnchecked(0, 0, this.mCurrentDimX, this.mCurrentDimY, d);
        } else {
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, d);
        }
    }

    public void copyFromUnchecked(byte[] d) {
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFromUnchecked(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, d);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFromUnchecked(0, 0, this.mCurrentDimX, this.mCurrentDimY, d);
        } else {
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, d);
        }
    }

    public void copyFromUnchecked(float[] d) {
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFromUnchecked(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, d);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFromUnchecked(0, 0, this.mCurrentDimX, this.mCurrentDimY, d);
        } else {
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, d);
        }
    }

    public void copyFrom(int[] d) {
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFrom(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, d);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFrom(0, 0, this.mCurrentDimX, this.mCurrentDimY, d);
        } else {
            this.copy1DRangeFrom(0, this.mCurrentCount, d);
        }
    }

    public void copyFrom(short[] d) {
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFrom(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, d);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFrom(0, 0, this.mCurrentDimX, this.mCurrentDimY, d);
        } else {
            this.copy1DRangeFrom(0, this.mCurrentCount, d);
        }
    }

    public void copyFrom(byte[] d) {
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFrom(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, d);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFrom(0, 0, this.mCurrentDimX, this.mCurrentDimY, d);
        } else {
            this.copy1DRangeFrom(0, this.mCurrentCount, d);
        }
    }

    public void copyFrom(float[] d) {
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFrom(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, d);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFrom(0, 0, this.mCurrentDimX, this.mCurrentDimY, d);
        } else {
            this.copy1DRangeFrom(0, this.mCurrentCount, d);
        }
    }

    public void copyFrom(Bitmap b) {
        this.mRS.validate();
        if (b.getConfig() == null) {
            Bitmap newBitmap = Bitmap.createBitmap((int)b.getWidth(), (int)b.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(newBitmap);
            c.drawBitmap(b, 0.0f, 0.0f, null);
            this.copyFrom(newBitmap);
            return;
        }
        this.validateBitmapSize(b);
        this.validateBitmapFormat(b);
        this.mRS.nAllocationCopyFromBitmap(this.getID(this.mRS), b);
    }

    public void copyFrom(Allocation a) {
        this.mRS.validate();
        if (!this.mType.equals(a.getType())) {
            throw new RSIllegalArgumentException("Types of allocations must match.");
        }
        this.copy2DRangeFrom(0, 0, this.mCurrentDimX, this.mCurrentDimY, a, 0, 0);
    }

    public void setFromFieldPacker(int xoff, FieldPacker fp) {
        this.mRS.validate();
        int eSize = this.mType.mElement.getBytesSize();
        byte[] data = fp.getData();
        int count = data.length / eSize;
        if (eSize * count != data.length) {
            throw new RSIllegalArgumentException("Field packer length " + data.length + " not divisible by element size " + eSize + ".");
        }
        this.copy1DRangeFromUnchecked(xoff, count, data);
    }

    public void setFromFieldPacker(int xoff, int component_number, FieldPacker fp) {
        this.mRS.validate();
        if (component_number >= this.mType.mElement.mElements.length) {
            throw new RSIllegalArgumentException("Component_number " + component_number + " out of range.");
        }
        if (xoff < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        byte[] data = fp.getData();
        int eSize = this.mType.mElement.mElements[component_number].getBytesSize();
        if (data.length != (eSize *= this.mType.mElement.mArraySizes[component_number])) {
            throw new RSIllegalArgumentException("Field packer sizelength " + data.length + " does not match component size " + eSize + ".");
        }
        this.mRS.nAllocationElementData1D(this.getIDSafe(), xoff, this.mSelectedLOD, component_number, data, data.length);
    }

    private void data1DChecks(int off, int count, int len, int dataSize) {
        this.mRS.validate();
        if (off < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        if (count < 1) {
            throw new RSIllegalArgumentException("Count must be >= 1.");
        }
        if (off + count > this.mCurrentCount) {
            throw new RSIllegalArgumentException("Overflow, Available count " + this.mCurrentCount + ", got " + count + " at offset " + off + ".");
        }
        if (len < dataSize) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
    }

    public void generateMipmaps() {
        this.mRS.nAllocationGenerateMipmaps(this.getID(this.mRS));
    }

    public void copy1DRangeFromUnchecked(int off, int count, int[] d) {
        int dataSize = this.mType.mElement.getBytesSize() * count;
        this.data1DChecks(off, count, d.length * 4, dataSize);
        this.mRS.nAllocationData1D(this.getIDSafe(), off, this.mSelectedLOD, count, d, dataSize);
    }

    public void copy1DRangeFromUnchecked(int off, int count, short[] d) {
        int dataSize = this.mType.mElement.getBytesSize() * count;
        this.data1DChecks(off, count, d.length * 2, dataSize);
        this.mRS.nAllocationData1D(this.getIDSafe(), off, this.mSelectedLOD, count, d, dataSize);
    }

    public void copy1DRangeFromUnchecked(int off, int count, byte[] d) {
        int dataSize = this.mType.mElement.getBytesSize() * count;
        this.data1DChecks(off, count, d.length, dataSize);
        this.mRS.nAllocationData1D(this.getIDSafe(), off, this.mSelectedLOD, count, d, dataSize);
    }

    public void copy1DRangeFromUnchecked(int off, int count, float[] d) {
        int dataSize = this.mType.mElement.getBytesSize() * count;
        this.data1DChecks(off, count, d.length * 4, dataSize);
        this.mRS.nAllocationData1D(this.getIDSafe(), off, this.mSelectedLOD, count, d, dataSize);
    }

    public void copy1DRangeFrom(int off, int count, int[] d) {
        this.validateIsInt32();
        this.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, short[] d) {
        this.validateIsInt16();
        this.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, byte[] d) {
        this.validateIsInt8();
        this.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, float[] d) {
        this.validateIsFloat32();
        this.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, Allocation data, int dataOff) {
        this.mRS.nAllocationData2D(this.getIDSafe(), off, 0, this.mSelectedLOD, this.mSelectedFace.mID, count, 1, data.getID(this.mRS), dataOff, 0, data.mSelectedLOD, data.mSelectedFace.mID);
    }

    private void validate2DRange(int xoff, int yoff, int w, int h) {
        if (this.mAdaptedAllocation == null) {
            if (xoff < 0 || yoff < 0) {
                throw new RSIllegalArgumentException("Offset cannot be negative.");
            }
            if (h < 0 || w < 0) {
                throw new RSIllegalArgumentException("Height or width cannot be negative.");
            }
            if (xoff + w > this.mCurrentDimX || yoff + h > this.mCurrentDimY) {
                throw new RSIllegalArgumentException("Updated region larger than allocation.");
            }
        }
    }

    void copy2DRangeFromUnchecked(int xoff, int yoff, int w, int h, byte[] data) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, data, data.length);
    }

    void copy2DRangeFromUnchecked(int xoff, int yoff, int w, int h, short[] data) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, data, data.length * 2);
    }

    void copy2DRangeFromUnchecked(int xoff, int yoff, int w, int h, int[] data) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, data, data.length * 4);
    }

    void copy2DRangeFromUnchecked(int xoff, int yoff, int w, int h, float[] data) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, data, data.length * 4);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, byte[] data) {
        this.validateIsInt8();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, short[] data) {
        this.validateIsInt16();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, int[] data) {
        this.validateIsInt32();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, float[] data) {
        this.validateIsFloat32();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, Allocation data, int dataXoff, int dataYoff) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, data.getID(this.mRS), dataXoff, dataYoff, data.mSelectedLOD, data.mSelectedFace.mID);
    }

    public void copy2DRangeFrom(int xoff, int yoff, Bitmap data) {
        this.mRS.validate();
        if (data.getConfig() == null) {
            Bitmap newBitmap = Bitmap.createBitmap((int)data.getWidth(), (int)data.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(newBitmap);
            c.drawBitmap(data, 0.0f, 0.0f, null);
            this.copy2DRangeFrom(xoff, yoff, newBitmap);
            return;
        }
        this.validateBitmapFormat(data);
        this.validate2DRange(xoff, yoff, data.getWidth(), data.getHeight());
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, data);
    }

    private void validate3DRange(int xoff, int yoff, int zoff, int w, int h, int d) {
        if (this.mAdaptedAllocation == null) {
            if (xoff < 0 || yoff < 0 || zoff < 0) {
                throw new RSIllegalArgumentException("Offset cannot be negative.");
            }
            if (h < 0 || w < 0 || d < 0) {
                throw new RSIllegalArgumentException("Height or width cannot be negative.");
            }
            if (xoff + w > this.mCurrentDimX || yoff + h > this.mCurrentDimY || zoff + d > this.mCurrentDimZ) {
                throw new RSIllegalArgumentException("Updated region larger than allocation.");
            }
        }
    }

    void copy3DRangeFromUnchecked(int xoff, int yoff, int zoff, int w, int h, int d, byte[] data) {
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, data, data.length);
    }

    void copy3DRangeFromUnchecked(int xoff, int yoff, int zoff, int w, int h, int d, short[] data) {
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, data, data.length * 2);
    }

    void copy3DRangeFromUnchecked(int xoff, int yoff, int zoff, int w, int h, int d, int[] data) {
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, data, data.length * 4);
    }

    void copy3DRangeFromUnchecked(int xoff, int yoff, int zoff, int w, int h, int d, float[] data) {
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, data, data.length * 4);
    }

    public void copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, byte[] data) {
        this.validateIsInt8();
        this.copy3DRangeFromUnchecked(xoff, yoff, zoff, w, h, d, data);
    }

    public void copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, short[] data) {
        this.validateIsInt16();
        this.copy3DRangeFromUnchecked(xoff, yoff, zoff, w, h, d, data);
    }

    public void copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, int[] data) {
        this.validateIsInt32();
        this.copy3DRangeFromUnchecked(xoff, yoff, zoff, w, h, d, data);
    }

    public void copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, float[] data) {
        this.validateIsFloat32();
        this.copy3DRangeFromUnchecked(xoff, yoff, zoff, w, h, d, data);
    }

    public void copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, Allocation data, int dataXoff, int dataYoff, int dataZoff) {
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, data.getID(this.mRS), dataXoff, dataYoff, dataZoff, data.mSelectedLOD);
    }

    public void copyTo(Bitmap b) {
        this.mRS.validate();
        this.validateBitmapFormat(b);
        this.validateBitmapSize(b);
        this.mRS.nAllocationCopyToBitmap(this.getID(this.mRS), b);
    }

    public void copyTo(byte[] d) {
        this.validateIsInt8();
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(this.mRS), d);
    }

    public void copyTo(short[] d) {
        this.validateIsInt16();
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(this.mRS), d);
    }

    public void copyTo(int[] d) {
        this.validateIsInt32();
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(this.mRS), d);
    }

    public void copyTo(float[] d) {
        this.validateIsFloat32();
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(this.mRS), d);
    }

    public static Allocation createTyped(RenderScript rs, Type type, MipmapControl mips, int usage) {
        if (RenderScript.isNative) {
            RenderScriptThunker rst = (RenderScriptThunker)rs;
            return AllocationThunker.createTyped(rst, type, mips, usage);
        }
        rs.validate();
        if (type.getID(rs) == 0) {
            throw new RSInvalidStateException("Bad Type");
        }
        int id = rs.nAllocationCreateTyped(type.getID(rs), mips.mID, usage, 0);
        if (id == 0) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        return new Allocation(id, rs, type, usage);
    }

    public static Allocation createTyped(RenderScript rs, Type type, int usage) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, usage);
    }

    public static Allocation createTyped(RenderScript rs, Type type) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, 1);
    }

    public static Allocation createSized(RenderScript rs, Element e, int count, int usage) {
        if (RenderScript.isNative) {
            RenderScriptThunker rst = (RenderScriptThunker)rs;
            return AllocationThunker.createSized(rs, e, count, usage);
        }
        rs.validate();
        Type.Builder b = new Type.Builder(rs, e);
        b.setX(count);
        Type t = b.create();
        int id = rs.nAllocationCreateTyped(t.getID(rs), MipmapControl.MIPMAP_NONE.mID, usage, 0);
        if (id == 0) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        return new Allocation(id, rs, t, usage);
    }

    public static Allocation createSized(RenderScript rs, Element e, int count) {
        return Allocation.createSized(rs, e, count, 1);
    }

    static Element elementFromBitmap(RenderScript rs, Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        if (bc == Bitmap.Config.ALPHA_8) {
            return Element.A_8(rs);
        }
        if (bc == Bitmap.Config.ARGB_4444) {
            return Element.RGBA_4444(rs);
        }
        if (bc == Bitmap.Config.ARGB_8888) {
            return Element.RGBA_8888(rs);
        }
        if (bc == Bitmap.Config.RGB_565) {
            return Element.RGB_565(rs);
        }
        throw new RSInvalidStateException("Bad bitmap type: " + bc);
    }

    static Type typeFromBitmap(RenderScript rs, Bitmap b, MipmapControl mip) {
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(b.getWidth());
        tb.setY(b.getHeight());
        tb.setMipmaps(mip == MipmapControl.MIPMAP_FULL);
        return tb.create();
    }

    public static Allocation createFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        if (RenderScript.isNative) {
            RenderScriptThunker rst = (RenderScriptThunker)rs;
            return AllocationThunker.createFromBitmap(rst, b, mips, usage);
        }
        rs.validate();
        if (b.getConfig() == null) {
            if ((usage & 0x80) != 0) {
                throw new RSIllegalArgumentException("USAGE_SHARED cannot be used with a Bitmap that has a null config.");
            }
            Bitmap newBitmap = Bitmap.createBitmap((int)b.getWidth(), (int)b.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(newBitmap);
            c.drawBitmap(b, 0.0f, 0.0f, null);
            return Allocation.createFromBitmap(rs, newBitmap, mips, usage);
        }
        Type t = Allocation.typeFromBitmap(rs, b, mips);
        if (mips == MipmapControl.MIPMAP_NONE && t.getElement().isCompatible(Element.RGBA_8888(rs)) && usage == 131) {
            int id = rs.nAllocationCreateBitmapBackedAllocation(t.getID(rs), mips.mID, b, usage);
            if (id == 0) {
                throw new RSRuntimeException("Load failed.");
            }
            Allocation alloc = new Allocation(id, rs, t, usage);
            alloc.setBitmap(b);
            return alloc;
        }
        int id = rs.nAllocationCreateFromBitmap(t.getID(rs), mips.mID, b, usage);
        if (id == 0) {
            throw new RSRuntimeException("Load failed.");
        }
        return new Allocation(id, rs, t, usage);
    }

    public static Allocation createFromBitmap(RenderScript rs, Bitmap b) {
        return Allocation.createFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 131);
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        boolean isPow2;
        rs.validate();
        int height = b.getHeight();
        int width = b.getWidth();
        if (width % 6 != 0) {
            throw new RSIllegalArgumentException("Cubemap height must be multiple of 6");
        }
        if (width / 6 != height) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl = isPow2 = (height & height - 1) == 0;
        if (!isPow2) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(height);
        tb.setY(height);
        tb.setFaces(true);
        tb.setMipmaps(mips == MipmapControl.MIPMAP_FULL);
        Type t = tb.create();
        int id = rs.nAllocationCubeCreateFromBitmap(t.getID(rs), mips.mID, b, usage);
        if (id == 0) {
            throw new RSRuntimeException("Load failed for bitmap " + b + " element " + e);
        }
        return new Allocation(id, rs, t, usage);
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b) {
        return Allocation.createCubemapFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg, MipmapControl mips, int usage) {
        return null;
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg) {
        return Allocation.createCubemapFromCubeFaces(rs, xpos, xneg, ypos, yneg, zpos, zneg, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id, MipmapControl mips, int usage) {
        rs.validate();
        if ((usage & 0xE0) != 0) {
            throw new RSIllegalArgumentException("Unsupported usage specified.");
        }
        Bitmap b = BitmapFactory.decodeResource((Resources)res, (int)id);
        Allocation alloc = Allocation.createFromBitmap(rs, b, mips, usage);
        b.recycle();
        return alloc;
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id) {
        return Allocation.createFromBitmapResource(rs, res, id, MipmapControl.MIPMAP_NONE, 3);
    }

    public static Allocation createFromString(RenderScript rs, String str, int usage) {
        rs.validate();
        byte[] allocArray = null;
        try {
            allocArray = str.getBytes("UTF-8");
            Allocation alloc = Allocation.createSized(rs, Element.U8(rs), allocArray.length, usage);
            alloc.copyFrom(allocArray);
            return alloc;
        }
        catch (Exception e) {
            throw new RSRuntimeException("Could not convert string to utf-8.");
        }
    }

    static {
        Allocation.mBitmapOptions.inScaled = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MipmapControl {
        MIPMAP_NONE(0),
        MIPMAP_FULL(1),
        MIPMAP_ON_SYNC_TO_TEXTURE(2);

        int mID;

        private MipmapControl(int id) {
            this.mID = id;
        }
    }
}

