/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.renderscript.Allocation;
import android.renderscript.RSRuntimeException;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.BaseObj;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.ElementThunker;
import android.support.v8.renderscript.ExceptionThunker;
import android.support.v8.renderscript.FieldPacker;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Type;
import android.support.v8.renderscript.TypeThunker;

class AllocationThunker
extends Allocation {
    android.renderscript.Allocation mN;
    static BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();

    android.renderscript.Allocation getNObj() {
        return this.mN;
    }

    static Allocation.MipmapControl convertMipmapControl(Allocation.MipmapControl mc) {
        switch (mc) {
            case MIPMAP_NONE: {
                return Allocation.MipmapControl.MIPMAP_NONE;
            }
            case MIPMAP_FULL: {
                return Allocation.MipmapControl.MIPMAP_FULL;
            }
            case MIPMAP_ON_SYNC_TO_TEXTURE: {
                return Allocation.MipmapControl.MIPMAP_ON_SYNC_TO_TEXTURE;
            }
        }
        return null;
    }

    public Type getType() {
        return TypeThunker.find(this.mN.getType());
    }

    public Element getElement() {
        return this.getType().getElement();
    }

    public int getUsage() {
        try {
            return this.mN.getUsage();
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public int getBytesSize() {
        try {
            return this.mN.getBytesSize();
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    AllocationThunker(RenderScript rs, Type t, int usage, android.renderscript.Allocation na) {
        super(0, rs, t, usage);
        this.mType = t;
        this.mUsage = usage;
        this.mN = na;
    }

    public void syncAll(int srcLocation) {
        try {
            this.mN.syncAll(srcLocation);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void ioSend() {
        try {
            this.mN.ioSend();
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void ioReceive() {
        try {
            this.mN.ioReceive();
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFrom(BaseObj[] d) {
        if (d == null) {
            return;
        }
        android.renderscript.BaseObj[] dN = new android.renderscript.BaseObj[d.length];
        for (int i = 0; i < d.length; ++i) {
            dN[i] = d[i].getNObj();
        }
        try {
            this.mN.copyFrom(dN);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFromUnchecked(int[] d) {
        try {
            this.mN.copyFromUnchecked(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFromUnchecked(short[] d) {
        try {
            this.mN.copyFromUnchecked(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFromUnchecked(byte[] d) {
        try {
            this.mN.copyFromUnchecked(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFromUnchecked(float[] d) {
        try {
            this.mN.copyFromUnchecked(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFrom(int[] d) {
        try {
            this.mN.copyFrom(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFrom(short[] d) {
        try {
            this.mN.copyFrom(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFrom(byte[] d) {
        try {
            this.mN.copyFrom(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFrom(float[] d) {
        try {
            this.mN.copyFrom(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFrom(Bitmap b) {
        try {
            this.mN.copyFrom(b);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyFrom(Allocation a) {
        AllocationThunker at = (AllocationThunker)a;
        try {
            this.mN.copyFrom(at.mN);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void setFromFieldPacker(int xoff, FieldPacker fp) {
        try {
            android.renderscript.FieldPacker nfp = new android.renderscript.FieldPacker(fp.getData());
            this.mN.setFromFieldPacker(xoff, nfp);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void setFromFieldPacker(int xoff, int component_number, FieldPacker fp) {
        try {
            android.renderscript.FieldPacker nfp = new android.renderscript.FieldPacker(fp.getData());
            this.mN.setFromFieldPacker(xoff, component_number, nfp);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void generateMipmaps() {
        try {
            this.mN.generateMipmaps();
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy1DRangeFromUnchecked(int off, int count, int[] d) {
        try {
            this.mN.copy1DRangeFromUnchecked(off, count, d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy1DRangeFromUnchecked(int off, int count, short[] d) {
        try {
            this.mN.copy1DRangeFromUnchecked(off, count, d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy1DRangeFromUnchecked(int off, int count, byte[] d) {
        try {
            this.mN.copy1DRangeFromUnchecked(off, count, d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy1DRangeFromUnchecked(int off, int count, float[] d) {
        try {
            this.mN.copy1DRangeFromUnchecked(off, count, d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy1DRangeFrom(int off, int count, int[] d) {
        try {
            this.mN.copy1DRangeFrom(off, count, d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy1DRangeFrom(int off, int count, short[] d) {
        try {
            this.mN.copy1DRangeFrom(off, count, d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy1DRangeFrom(int off, int count, byte[] d) {
        try {
            this.mN.copy1DRangeFrom(off, count, d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy1DRangeFrom(int off, int count, float[] d) {
        try {
            this.mN.copy1DRangeFrom(off, count, d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy1DRangeFrom(int off, int count, Allocation data, int dataOff) {
        try {
            AllocationThunker at = (AllocationThunker)data;
            this.mN.copy1DRangeFrom(off, count, at.mN, dataOff);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, byte[] data) {
        try {
            this.mN.copy2DRangeFrom(xoff, yoff, w, h, data);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, short[] data) {
        try {
            this.mN.copy2DRangeFrom(xoff, yoff, w, h, data);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, int[] data) {
        try {
            this.mN.copy2DRangeFrom(xoff, yoff, w, h, data);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, float[] data) {
        try {
            this.mN.copy2DRangeFrom(xoff, yoff, w, h, data);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, Allocation data, int dataXoff, int dataYoff) {
        try {
            AllocationThunker at = (AllocationThunker)data;
            this.mN.copy2DRangeFrom(xoff, yoff, w, h, at.mN, dataXoff, dataYoff);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copy2DRangeFrom(int xoff, int yoff, Bitmap data) {
        try {
            this.mN.copy2DRangeFrom(xoff, yoff, data);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyTo(Bitmap b) {
        try {
            this.mN.copyTo(b);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyTo(byte[] d) {
        try {
            this.mN.copyTo(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyTo(short[] d) {
        try {
            this.mN.copyTo(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyTo(int[] d) {
        try {
            this.mN.copyTo(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void copyTo(float[] d) {
        try {
            this.mN.copyTo(d);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public static Allocation createTyped(RenderScript rs, Type type, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        TypeThunker tt = (TypeThunker)type;
        try {
            android.renderscript.Allocation a = android.renderscript.Allocation.createTyped((android.renderscript.RenderScript)rst.mN, (android.renderscript.Type)tt.mN, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
            return new AllocationThunker(rs, type, usage, a);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public static Allocation createFromBitmap(RenderScript rs, Bitmap b, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        try {
            android.renderscript.Allocation a = android.renderscript.Allocation.createFromBitmap((android.renderscript.RenderScript)rst.mN, (Bitmap)b, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
            TypeThunker tt = new TypeThunker(rs, a.getType());
            return new AllocationThunker(rs, tt, usage, a);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        try {
            android.renderscript.Allocation a = android.renderscript.Allocation.createCubemapFromBitmap((android.renderscript.RenderScript)rst.mN, (Bitmap)b, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
            TypeThunker tt = new TypeThunker(rs, a.getType());
            return new AllocationThunker(rs, tt, usage, a);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        try {
            android.renderscript.Allocation a = android.renderscript.Allocation.createCubemapFromCubeFaces((android.renderscript.RenderScript)rst.mN, (Bitmap)xpos, (Bitmap)xneg, (Bitmap)ypos, (Bitmap)yneg, (Bitmap)zpos, (Bitmap)zneg, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
            TypeThunker tt = new TypeThunker(rs, a.getType());
            return new AllocationThunker(rs, tt, usage, a);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id, Allocation.MipmapControl mips, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        try {
            android.renderscript.Allocation a = android.renderscript.Allocation.createFromBitmapResource((android.renderscript.RenderScript)rst.mN, (Resources)res, (int)id, (Allocation.MipmapControl)AllocationThunker.convertMipmapControl(mips), (int)usage);
            TypeThunker tt = new TypeThunker(rs, a.getType());
            return new AllocationThunker(rs, tt, usage, a);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public static Allocation createFromString(RenderScript rs, String str, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        try {
            android.renderscript.Allocation a = android.renderscript.Allocation.createFromString((android.renderscript.RenderScript)rst.mN, (String)str, (int)usage);
            TypeThunker tt = new TypeThunker(rs, a.getType());
            return new AllocationThunker(rs, tt, usage, a);
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public static Allocation createSized(RenderScript rs, Element e, int count, int usage) {
        RenderScriptThunker rst = (RenderScriptThunker)rs;
        ElementThunker et = (ElementThunker)e;
        try {
            android.renderscript.Allocation a = android.renderscript.Allocation.createSized((android.renderscript.RenderScript)rst.mN, (android.renderscript.Element)((android.renderscript.Element)e.getNObj()), (int)count, (int)usage);
            TypeThunker tt = new TypeThunker(rs, a.getType());
            return new AllocationThunker(rs, tt, usage, a);
        }
        catch (RSRuntimeException exc) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)exc));
        }
    }

    static {
        AllocationThunker.mBitmapOptions.inScaled = false;
    }
}

