/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.SystemProperties;
import android.renderscript.RenderScript;
import android.support.v8.renderscript.BaseObj;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RSDriverException;
import android.support.v8.renderscript.RSInvalidStateException;
import android.support.v8.renderscript.RSRuntimeException;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Sampler;
import android.util.Log;
import java.io.File;
import java.lang.reflect.Method;

public class RenderScript {
    static final String LOG_TAG = "RenderScript_jni";
    static final boolean DEBUG = false;
    static final boolean LOG_ENABLED = false;
    private Context mApplicationContext;
    static boolean sInitialized;
    static boolean sUseGCHooks;
    static Object sRuntime;
    static Method registerNativeAllocation;
    static Method registerNativeFree;
    static Object lock;
    static boolean isNative;
    private static int thunk;
    private static final String CACHE_PATH = "com.android.renderscript.cache";
    static String mCachePath;
    int mDev;
    int mContext;
    MessageThread mMessageThread;
    Element mElement_U8;
    Element mElement_I8;
    Element mElement_U16;
    Element mElement_I16;
    Element mElement_U32;
    Element mElement_I32;
    Element mElement_U64;
    Element mElement_I64;
    Element mElement_F32;
    Element mElement_F64;
    Element mElement_BOOLEAN;
    Element mElement_ELEMENT;
    Element mElement_TYPE;
    Element mElement_ALLOCATION;
    Element mElement_SAMPLER;
    Element mElement_SCRIPT;
    Element mElement_A_8;
    Element mElement_RGB_565;
    Element mElement_RGB_888;
    Element mElement_RGBA_5551;
    Element mElement_RGBA_4444;
    Element mElement_RGBA_8888;
    Element mElement_FLOAT_2;
    Element mElement_FLOAT_3;
    Element mElement_FLOAT_4;
    Element mElement_DOUBLE_2;
    Element mElement_DOUBLE_3;
    Element mElement_DOUBLE_4;
    Element mElement_UCHAR_2;
    Element mElement_UCHAR_3;
    Element mElement_UCHAR_4;
    Element mElement_CHAR_2;
    Element mElement_CHAR_3;
    Element mElement_CHAR_4;
    Element mElement_USHORT_2;
    Element mElement_USHORT_3;
    Element mElement_USHORT_4;
    Element mElement_SHORT_2;
    Element mElement_SHORT_3;
    Element mElement_SHORT_4;
    Element mElement_UINT_2;
    Element mElement_UINT_3;
    Element mElement_UINT_4;
    Element mElement_INT_2;
    Element mElement_INT_3;
    Element mElement_INT_4;
    Element mElement_ULONG_2;
    Element mElement_ULONG_3;
    Element mElement_ULONG_4;
    Element mElement_LONG_2;
    Element mElement_LONG_3;
    Element mElement_LONG_4;
    Element mElement_MATRIX_4X4;
    Element mElement_MATRIX_3X3;
    Element mElement_MATRIX_2X2;
    Sampler mSampler_CLAMP_NEAREST;
    Sampler mSampler_CLAMP_LINEAR;
    Sampler mSampler_CLAMP_LINEAR_MIP_LINEAR;
    Sampler mSampler_WRAP_NEAREST;
    Sampler mSampler_WRAP_LINEAR;
    Sampler mSampler_WRAP_LINEAR_MIP_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_NEAREST;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR_MIP_LINEAR;
    RSMessageHandler mMessageCallback = null;
    RSErrorHandler mErrorCallback = null;

    native int nDeviceCreate();

    native void nDeviceDestroy(int var1);

    native void nDeviceSetConfig(int var1, int var2, int var3);

    native int nContextGetUserMessage(int var1, int[] var2);

    native String nContextGetErrorMessage(int var1);

    native int nContextPeekMessage(int var1, int[] var2);

    native void nContextInitToClient(int var1);

    native void nContextDeinitToClient(int var1);

    static boolean shouldThunk() {
        if (thunk == 0) {
            thunk = Build.VERSION.SDK_INT >= 18 && SystemProperties.getInt((String)"debug.rs.forcecompat", (int)0) == 0 ? 1 : -1;
        }
        return thunk == 1;
    }

    public static void setupDiskCache(File cacheDir) {
        File f = new File(cacheDir, CACHE_PATH);
        mCachePath = f.getAbsolutePath();
        f.mkdirs();
    }

    native int rsnContextCreate(int var1, int var2, int var3, int var4);

    synchronized int nContextCreate(int dev, int ver, int sdkVer, int contextType) {
        return this.rsnContextCreate(dev, ver, sdkVer, contextType);
    }

    native void rsnContextDestroy(int var1);

    synchronized void nContextDestroy() {
        this.validate();
        this.rsnContextDestroy(this.mContext);
    }

    native void rsnContextSetPriority(int var1, int var2);

    synchronized void nContextSetPriority(int p) {
        this.validate();
        this.rsnContextSetPriority(this.mContext, p);
    }

    native void rsnContextDump(int var1, int var2);

    synchronized void nContextDump(int bits) {
        this.validate();
        this.rsnContextDump(this.mContext, bits);
    }

    native void rsnContextFinish(int var1);

    synchronized void nContextFinish() {
        this.validate();
        this.rsnContextFinish(this.mContext);
    }

    native void rsnContextSendMessage(int var1, int var2, int[] var3);

    synchronized void nContextSendMessage(int id, int[] data) {
        this.validate();
        this.rsnContextSendMessage(this.mContext, id, data);
    }

    native void rsnObjDestroy(int var1, int var2);

    synchronized void nObjDestroy(int id) {
        if (this.mContext != 0) {
            this.rsnObjDestroy(this.mContext, id);
        }
    }

    native int rsnElementCreate(int var1, int var2, int var3, boolean var4, int var5);

    synchronized int nElementCreate(int type, int kind, boolean norm, int vecSize) {
        this.validate();
        return this.rsnElementCreate(this.mContext, type, kind, norm, vecSize);
    }

    native int rsnElementCreate2(int var1, int[] var2, String[] var3, int[] var4);

    synchronized int nElementCreate2(int[] elements, String[] names, int[] arraySizes) {
        this.validate();
        return this.rsnElementCreate2(this.mContext, elements, names, arraySizes);
    }

    native void rsnElementGetNativeData(int var1, int var2, int[] var3);

    synchronized void nElementGetNativeData(int id, int[] elementData) {
        this.validate();
        this.rsnElementGetNativeData(this.mContext, id, elementData);
    }

    native void rsnElementGetSubElements(int var1, int var2, int[] var3, String[] var4, int[] var5);

    synchronized void nElementGetSubElements(int id, int[] IDs, String[] names, int[] arraySizes) {
        this.validate();
        this.rsnElementGetSubElements(this.mContext, id, IDs, names, arraySizes);
    }

    native int rsnTypeCreate(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7, int var8);

    synchronized int nTypeCreate(int eid, int x, int y, int z, boolean mips, boolean faces, int yuv) {
        this.validate();
        return this.rsnTypeCreate(this.mContext, eid, x, y, z, mips, faces, yuv);
    }

    native void rsnTypeGetNativeData(int var1, int var2, int[] var3);

    synchronized void nTypeGetNativeData(int id, int[] typeData) {
        this.validate();
        this.rsnTypeGetNativeData(this.mContext, id, typeData);
    }

    native int rsnAllocationCreateTyped(int var1, int var2, int var3, int var4, int var5);

    synchronized int nAllocationCreateTyped(int type, int mip, int usage, int pointer) {
        this.validate();
        return this.rsnAllocationCreateTyped(this.mContext, type, mip, usage, pointer);
    }

    native int rsnAllocationCreateFromBitmap(int var1, int var2, int var3, Bitmap var4, int var5);

    synchronized int nAllocationCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    native int rsnAllocationCreateBitmapBackedAllocation(int var1, int var2, int var3, Bitmap var4, int var5);

    synchronized int nAllocationCreateBitmapBackedAllocation(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateBitmapBackedAllocation(this.mContext, type, mip, bmp, usage);
    }

    native int rsnAllocationCubeCreateFromBitmap(int var1, int var2, int var3, Bitmap var4, int var5);

    synchronized int nAllocationCubeCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCubeCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    native int rsnAllocationCreateBitmapRef(int var1, int var2, Bitmap var3);

    synchronized int nAllocationCreateBitmapRef(int type, Bitmap bmp) {
        this.validate();
        return this.rsnAllocationCreateBitmapRef(this.mContext, type, bmp);
    }

    native int rsnAllocationCreateFromAssetStream(int var1, int var2, int var3, int var4);

    synchronized int nAllocationCreateFromAssetStream(int mips, int assetStream, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromAssetStream(this.mContext, mips, assetStream, usage);
    }

    native void rsnAllocationCopyToBitmap(int var1, int var2, Bitmap var3);

    synchronized void nAllocationCopyToBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyToBitmap(this.mContext, alloc, bmp);
    }

    native void rsnAllocationSyncAll(int var1, int var2, int var3);

    synchronized void nAllocationSyncAll(int alloc, int src) {
        this.validate();
        this.rsnAllocationSyncAll(this.mContext, alloc, src);
    }

    native void rsnAllocationIoSend(int var1, int var2);

    synchronized void nAllocationIoSend(int alloc) {
        this.validate();
        this.rsnAllocationIoSend(this.mContext, alloc);
    }

    native void rsnAllocationIoReceive(int var1, int var2);

    synchronized void nAllocationIoReceive(int alloc) {
        this.validate();
        this.rsnAllocationIoReceive(this.mContext, alloc);
    }

    native void rsnAllocationGenerateMipmaps(int var1, int var2);

    synchronized void nAllocationGenerateMipmaps(int alloc) {
        this.validate();
        this.rsnAllocationGenerateMipmaps(this.mContext, alloc);
    }

    native void rsnAllocationCopyFromBitmap(int var1, int var2, Bitmap var3);

    synchronized void nAllocationCopyFromBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyFromBitmap(this.mContext, alloc, bmp);
    }

    native void rsnAllocationData1D(int var1, int var2, int var3, int var4, int var5, int[] var6, int var7);

    synchronized void nAllocationData1D(int id, int off, int mip, int count, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id, off, mip, count, d, sizeBytes);
    }

    native void rsnAllocationData1D(int var1, int var2, int var3, int var4, int var5, short[] var6, int var7);

    synchronized void nAllocationData1D(int id, int off, int mip, int count, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id, off, mip, count, d, sizeBytes);
    }

    native void rsnAllocationData1D(int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7);

    synchronized void nAllocationData1D(int id, int off, int mip, int count, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id, off, mip, count, d, sizeBytes);
    }

    native void rsnAllocationData1D(int var1, int var2, int var3, int var4, int var5, float[] var6, int var7);

    synchronized void nAllocationData1D(int id, int off, int mip, int count, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id, off, mip, count, d, sizeBytes);
    }

    native void rsnAllocationElementData1D(int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7);

    synchronized void nAllocationElementData1D(int id, int xoff, int mip, int compIdx, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationElementData1D(this.mContext, id, xoff, mip, compIdx, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    synchronized void nAllocationData2D(int dstAlloc, int dstXoff, int dstYoff, int dstMip, int dstFace, int width, int height, int srcAlloc, int srcXoff, int srcYoff, int srcMip, int srcFace) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, dstAlloc, dstXoff, dstYoff, dstMip, dstFace, width, height, srcAlloc, srcXoff, srcYoff, srcMip, srcFace);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, byte[] var9, int var10);

    synchronized void nAllocationData2D(int id, int xoff, int yoff, int mip, int face, int w, int h, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, short[] var9, int var10);

    synchronized void nAllocationData2D(int id, int xoff, int yoff, int mip, int face, int w, int h, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int[] var9, int var10);

    synchronized void nAllocationData2D(int id, int xoff, int yoff, int mip, int face, int w, int h, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float[] var9, int var10);

    synchronized void nAllocationData2D(int id, int xoff, int yoff, int mip, int face, int w, int h, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    native void rsnAllocationData2D(int var1, int var2, int var3, int var4, int var5, int var6, Bitmap var7);

    synchronized void nAllocationData2D(int id, int xoff, int yoff, int mip, int face, Bitmap b) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id, xoff, yoff, mip, face, b);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    synchronized void nAllocationData3D(int dstAlloc, int dstXoff, int dstYoff, int dstZoff, int dstMip, int width, int height, int depth, int srcAlloc, int srcXoff, int srcYoff, int srcZoff, int srcMip) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, dstAlloc, dstXoff, dstYoff, dstZoff, dstMip, width, height, depth, srcAlloc, srcXoff, srcYoff, srcZoff, srcMip);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10, int var11);

    synchronized void nAllocationData3D(int id, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, short[] var10, int var11);

    synchronized void nAllocationData3D(int id, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int[] var10, int var11);

    synchronized void nAllocationData3D(int id, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    native void rsnAllocationData3D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, float[] var10, int var11);

    synchronized void nAllocationData3D(int id, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    native void rsnAllocationRead(int var1, int var2, byte[] var3);

    synchronized void nAllocationRead(int id, byte[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id, d);
    }

    native void rsnAllocationRead(int var1, int var2, short[] var3);

    synchronized void nAllocationRead(int id, short[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id, d);
    }

    native void rsnAllocationRead(int var1, int var2, int[] var3);

    synchronized void nAllocationRead(int id, int[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id, d);
    }

    native void rsnAllocationRead(int var1, int var2, float[] var3);

    synchronized void nAllocationRead(int id, float[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id, d);
    }

    native int rsnAllocationGetType(int var1, int var2);

    synchronized int nAllocationGetType(int id) {
        this.validate();
        return this.rsnAllocationGetType(this.mContext, id);
    }

    native void rsnAllocationResize1D(int var1, int var2, int var3);

    synchronized void nAllocationResize1D(int id, int dimX) {
        this.validate();
        this.rsnAllocationResize1D(this.mContext, id, dimX);
    }

    native void rsnAllocationResize2D(int var1, int var2, int var3, int var4);

    synchronized void nAllocationResize2D(int id, int dimX, int dimY) {
        this.validate();
        this.rsnAllocationResize2D(this.mContext, id, dimX, dimY);
    }

    native void rsnScriptBindAllocation(int var1, int var2, int var3, int var4);

    synchronized void nScriptBindAllocation(int script, int alloc, int slot) {
        this.validate();
        this.rsnScriptBindAllocation(this.mContext, script, alloc, slot);
    }

    native void rsnScriptSetTimeZone(int var1, int var2, byte[] var3);

    synchronized void nScriptSetTimeZone(int script, byte[] timeZone) {
        this.validate();
        this.rsnScriptSetTimeZone(this.mContext, script, timeZone);
    }

    native void rsnScriptInvoke(int var1, int var2, int var3);

    synchronized void nScriptInvoke(int id, int slot) {
        this.validate();
        this.rsnScriptInvoke(this.mContext, id, slot);
    }

    native void rsnScriptForEach(int var1, int var2, int var3, int var4, int var5, byte[] var6);

    native void rsnScriptForEach(int var1, int var2, int var3, int var4, int var5);

    native void rsnScriptForEachClipped(int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9, int var10, int var11, int var12);

    native void rsnScriptForEachClipped(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    synchronized void nScriptForEach(int id, int slot, int ain, int aout, byte[] params) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEach(this.mContext, id, slot, ain, aout);
        } else {
            this.rsnScriptForEach(this.mContext, id, slot, ain, aout, params);
        }
    }

    synchronized void nScriptForEachClipped(int id, int slot, int ain, int aout, byte[] params, int xstart, int xend, int ystart, int yend, int zstart, int zend) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEachClipped(this.mContext, id, slot, ain, aout, xstart, xend, ystart, yend, zstart, zend);
        } else {
            this.rsnScriptForEachClipped(this.mContext, id, slot, ain, aout, params, xstart, xend, ystart, yend, zstart, zend);
        }
    }

    native void rsnScriptInvokeV(int var1, int var2, int var3, byte[] var4);

    synchronized void nScriptInvokeV(int id, int slot, byte[] params) {
        this.validate();
        this.rsnScriptInvokeV(this.mContext, id, slot, params);
    }

    native void rsnScriptSetVarI(int var1, int var2, int var3, int var4);

    synchronized void nScriptSetVarI(int id, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarI(this.mContext, id, slot, val);
    }

    native void rsnScriptSetVarJ(int var1, int var2, int var3, long var4);

    synchronized void nScriptSetVarJ(int id, int slot, long val) {
        this.validate();
        this.rsnScriptSetVarJ(this.mContext, id, slot, val);
    }

    native void rsnScriptSetVarF(int var1, int var2, int var3, float var4);

    synchronized void nScriptSetVarF(int id, int slot, float val) {
        this.validate();
        this.rsnScriptSetVarF(this.mContext, id, slot, val);
    }

    native void rsnScriptSetVarD(int var1, int var2, int var3, double var4);

    synchronized void nScriptSetVarD(int id, int slot, double val) {
        this.validate();
        this.rsnScriptSetVarD(this.mContext, id, slot, val);
    }

    native void rsnScriptSetVarV(int var1, int var2, int var3, byte[] var4);

    synchronized void nScriptSetVarV(int id, int slot, byte[] val) {
        this.validate();
        this.rsnScriptSetVarV(this.mContext, id, slot, val);
    }

    native void rsnScriptSetVarVE(int var1, int var2, int var3, byte[] var4, int var5, int[] var6);

    synchronized void nScriptSetVarVE(int id, int slot, byte[] val, int e, int[] dims) {
        this.validate();
        this.rsnScriptSetVarVE(this.mContext, id, slot, val, e, dims);
    }

    native void rsnScriptSetVarObj(int var1, int var2, int var3, int var4);

    synchronized void nScriptSetVarObj(int id, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarObj(this.mContext, id, slot, val);
    }

    native int rsnScriptCCreate(int var1, String var2, String var3, byte[] var4, int var5);

    synchronized int nScriptCCreate(String resName, String cacheDir, byte[] script, int length) {
        this.validate();
        return this.rsnScriptCCreate(this.mContext, resName, cacheDir, script, length);
    }

    native int rsnScriptIntrinsicCreate(int var1, int var2, int var3);

    synchronized int nScriptIntrinsicCreate(int id, int eid) {
        this.validate();
        return this.rsnScriptIntrinsicCreate(this.mContext, id, eid);
    }

    native int rsnScriptKernelIDCreate(int var1, int var2, int var3, int var4);

    synchronized int nScriptKernelIDCreate(int sid, int slot, int sig) {
        this.validate();
        return this.rsnScriptKernelIDCreate(this.mContext, sid, slot, sig);
    }

    native int rsnScriptFieldIDCreate(int var1, int var2, int var3);

    synchronized int nScriptFieldIDCreate(int sid, int slot) {
        this.validate();
        return this.rsnScriptFieldIDCreate(this.mContext, sid, slot);
    }

    native int rsnScriptGroupCreate(int var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    synchronized int nScriptGroupCreate(int[] kernels, int[] src, int[] dstk, int[] dstf, int[] types) {
        this.validate();
        return this.rsnScriptGroupCreate(this.mContext, kernels, src, dstk, dstf, types);
    }

    native void rsnScriptGroupSetInput(int var1, int var2, int var3, int var4);

    synchronized void nScriptGroupSetInput(int group, int kernel, int alloc) {
        this.validate();
        this.rsnScriptGroupSetInput(this.mContext, group, kernel, alloc);
    }

    native void rsnScriptGroupSetOutput(int var1, int var2, int var3, int var4);

    synchronized void nScriptGroupSetOutput(int group, int kernel, int alloc) {
        this.validate();
        this.rsnScriptGroupSetOutput(this.mContext, group, kernel, alloc);
    }

    native void rsnScriptGroupExecute(int var1, int var2);

    synchronized void nScriptGroupExecute(int group) {
        this.validate();
        this.rsnScriptGroupExecute(this.mContext, group);
    }

    native int rsnSamplerCreate(int var1, int var2, int var3, int var4, int var5, int var6, float var7);

    synchronized int nSamplerCreate(int magFilter, int minFilter, int wrapS, int wrapT, int wrapR, float aniso) {
        this.validate();
        return this.rsnSamplerCreate(this.mContext, magFilter, minFilter, wrapS, wrapT, wrapR, aniso);
    }

    public void setMessageHandler(RSMessageHandler msg) {
        this.mMessageCallback = msg;
        if (isNative) {
            RenderScriptThunker rst = (RenderScriptThunker)this;
            RenderScript.RSMessageHandler newmsg = new RenderScript.RSMessageHandler(){

                public void run() {
                    RenderScript.this.mMessageCallback.mData = this.mData;
                    RenderScript.this.mMessageCallback.mID = this.mID;
                    RenderScript.this.mMessageCallback.mLength = this.mLength;
                    RenderScript.this.mMessageCallback.run();
                }
            };
            rst.mN.setMessageHandler(newmsg);
        }
    }

    public RSMessageHandler getMessageHandler() {
        return this.mMessageCallback;
    }

    public void sendMessage(int id, int[] data) {
        this.nContextSendMessage(id, data);
    }

    public void setErrorHandler(RSErrorHandler msg) {
        this.mErrorCallback = msg;
        if (isNative) {
            RenderScriptThunker rst = (RenderScriptThunker)this;
            RenderScript.RSErrorHandler newmsg = new RenderScript.RSErrorHandler(){

                public void run() {
                    RenderScript.this.mErrorCallback.mErrorMessage = this.mErrorMessage;
                    RenderScript.this.mErrorCallback.mErrorNum = this.mErrorNum;
                    RenderScript.this.mErrorCallback.run();
                }
            };
            rst.mN.setErrorHandler(newmsg);
        }
    }

    public RSErrorHandler getErrorHandler() {
        return this.mErrorCallback;
    }

    void validate() {
        if (this.mContext == 0) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    public void setPriority(Priority p) {
        this.validate();
        this.nContextSetPriority(p.mID);
    }

    RenderScript(Context ctx) {
        if (ctx != null) {
            this.mApplicationContext = ctx.getApplicationContext();
        }
    }

    public final Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public static RenderScript create(Context ctx, int sdkVersion) {
        return RenderScript.create(ctx, sdkVersion, ContextType.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderScript create(Context ctx, int sdkVersion, ContextType ct) {
        RenderScript rs = new RenderScript(ctx);
        if (RenderScript.shouldThunk()) {
            Log.v((String)LOG_TAG, (String)"RS native mode");
            return RenderScriptThunker.create(ctx, sdkVersion);
        }
        Object object = lock;
        synchronized (object) {
            if (!sInitialized) {
                try {
                    Class<?> vm_runtime = Class.forName("dalvik.system.VMRuntime");
                    Method get_runtime = vm_runtime.getDeclaredMethod("getRuntime", new Class[0]);
                    sRuntime = get_runtime.invoke(null, new Object[0]);
                    registerNativeAllocation = vm_runtime.getDeclaredMethod("registerNativeAllocation", Integer.TYPE);
                    registerNativeFree = vm_runtime.getDeclaredMethod("registerNativeFree", Integer.TYPE);
                    sUseGCHooks = true;
                }
                catch (Exception e) {
                    Log.e((String)LOG_TAG, (String)"No GC methods");
                    sUseGCHooks = false;
                }
                try {
                    System.loadLibrary("RSSupport");
                    System.loadLibrary("rsjni");
                    sInitialized = true;
                }
                catch (UnsatisfiedLinkError e) {
                    Log.e((String)LOG_TAG, (String)("Error loading RS jni library: " + e));
                    throw new RSRuntimeException("Error loading RS jni library: " + e);
                }
            }
        }
        Log.v((String)LOG_TAG, (String)"RS compat mode");
        rs.mDev = rs.nDeviceCreate();
        rs.mContext = rs.nContextCreate(rs.mDev, 0, sdkVersion, ct.mID);
        if (rs.mContext == 0) {
            throw new RSDriverException("Failed to create RS context.");
        }
        rs.mMessageThread = new MessageThread(rs);
        rs.mMessageThread.start();
        return rs;
    }

    public static RenderScript create(Context ctx) {
        return RenderScript.create(ctx, ContextType.NORMAL);
    }

    public static RenderScript create(Context ctx, ContextType ct) {
        int v = ctx.getApplicationInfo().targetSdkVersion;
        return RenderScript.create(ctx, v, ct);
    }

    public void contextDump() {
        this.validate();
        this.nContextDump(0);
    }

    public void finish() {
        this.nContextFinish();
    }

    public void destroy() {
        this.validate();
        this.nContextDeinitToClient(this.mContext);
        this.mMessageThread.mRun = false;
        try {
            this.mMessageThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.nContextDestroy();
        this.mContext = 0;
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0;
    }

    boolean isAlive() {
        return this.mContext != 0;
    }

    int safeID(BaseObj o) {
        if (o != null) {
            return o.getID(this);
        }
        return 0;
    }

    static {
        lock = new Object();
        isNative = false;
        thunk = 0;
    }

    static class MessageThread
    extends Thread {
        RenderScript mRS;
        boolean mRun = true;
        int[] mAuxData = new int[2];
        static final int RS_MESSAGE_TO_CLIENT_NONE = 0;
        static final int RS_MESSAGE_TO_CLIENT_EXCEPTION = 1;
        static final int RS_MESSAGE_TO_CLIENT_RESIZE = 2;
        static final int RS_MESSAGE_TO_CLIENT_ERROR = 3;
        static final int RS_MESSAGE_TO_CLIENT_USER = 4;
        static final int RS_ERROR_FATAL_UNKNOWN = 4096;

        MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient(this.mRS.mContext);
            while (this.mRun) {
                rbuf[0] = 0;
                int msg = this.mRS.nContextPeekMessage(this.mRS.mContext, this.mAuxData);
                int size = this.mAuxData[1];
                int subID = this.mAuxData[0];
                if (msg == 4) {
                    if (size >> 2 >= rbuf.length) {
                        rbuf = new int[size + 3 >> 2];
                    }
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf) != 4) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    if (this.mRS.mMessageCallback != null) {
                        this.mRS.mMessageCallback.mData = rbuf;
                        this.mRS.mMessageCallback.mID = subID;
                        this.mRS.mMessageCallback.mLength = size;
                        this.mRS.mMessageCallback.run();
                        continue;
                    }
                    throw new RSInvalidStateException("Received a message from the script with no message handler installed.");
                }
                if (msg == 3) {
                    String e = this.mRS.nContextGetErrorMessage(this.mRS.mContext);
                    if (subID >= 4096) {
                        throw new RSRuntimeException("Fatal error " + subID + ", details: " + e);
                    }
                    if (this.mRS.mErrorCallback != null) {
                        this.mRS.mErrorCallback.mErrorMessage = e;
                        this.mRS.mErrorCallback.mErrorNum = subID;
                        this.mRS.mErrorCallback.run();
                        continue;
                    }
                    Log.e((String)RenderScript.LOG_TAG, (String)("non fatal RS error, " + e));
                    continue;
                }
                try {
                    MessageThread.sleep(1L, 0);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        LOW(15),
        NORMAL(-4);

        int mID;

        private Priority(int id) {
            this.mID = id;
        }
    }

    public static class RSErrorHandler
    implements Runnable {
        protected String mErrorMessage;
        protected int mErrorNum;

        public void run() {
        }
    }

    public static class RSMessageHandler
    implements Runnable {
        protected int[] mData;
        protected int mID;
        protected int mLength;

        public void run() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextType {
        NORMAL(0),
        DEBUG(1),
        PROFILE(2);

        int mID;

        private ContextType(int id) {
            this.mID = id;
        }
    }
}

