/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.content.Context;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.support.v8.renderscript.ExceptionThunker;
import android.support.v8.renderscript.RSInvalidStateException;
import android.support.v8.renderscript.RenderScript;

class RenderScriptThunker
extends RenderScript {
    android.renderscript.RenderScript mN;

    void validate() {
        if (this.mN == null) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    public void setPriority(RenderScript.Priority p) {
        try {
            if (p == RenderScript.Priority.LOW) {
                this.mN.setPriority(RenderScript.Priority.LOW);
            }
            if (p == RenderScript.Priority.NORMAL) {
                this.mN.setPriority(RenderScript.Priority.NORMAL);
            }
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    RenderScriptThunker(Context ctx) {
        super(ctx);
        isNative = true;
    }

    public static RenderScript create(Context ctx, int sdkVersion) {
        try {
            RenderScriptThunker rs = new RenderScriptThunker(ctx);
            rs.mN = android.renderscript.RenderScript.create((Context)ctx, (int)sdkVersion);
            return rs;
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void contextDump() {
        try {
            this.mN.contextDump();
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void finish() {
        try {
            this.mN.finish();
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }

    public void destroy() {
        try {
            this.mN.destroy();
            this.mN = null;
        }
        catch (RSRuntimeException e) {
            throw ExceptionThunker.convertException((RuntimeException)((Object)e));
        }
    }
}

