/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RSRuntimeException;
import android.renderscript.Sampler;
import android.support.v8.renderscript.ExceptionThunker;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Sampler;

class SamplerThunker
extends Sampler {
    android.renderscript.Sampler mN;

    protected SamplerThunker(int id, RenderScript rs) {
        super(id, rs);
    }

    BaseObj getNObj() {
        return this.mN;
    }

    static Sampler.Value convertValue(Sampler.Value v) {
        switch (v) {
            case NEAREST: {
                return Sampler.Value.NEAREST;
            }
            case LINEAR: {
                return Sampler.Value.LINEAR;
            }
            case LINEAR_MIP_LINEAR: {
                return Sampler.Value.LINEAR_MIP_LINEAR;
            }
            case LINEAR_MIP_NEAREST: {
                return Sampler.Value.LINEAR_MIP_NEAREST;
            }
            case WRAP: {
                return Sampler.Value.WRAP;
            }
            case CLAMP: {
                return Sampler.Value.CLAMP;
            }
            case MIRRORED_REPEAT: {
                return Sampler.Value.MIRRORED_REPEAT;
            }
        }
        return null;
    }

    public static class Builder {
        RenderScriptThunker mRS;
        Sampler.Value mMin;
        Sampler.Value mMag;
        Sampler.Value mWrapS;
        Sampler.Value mWrapT;
        Sampler.Value mWrapR;
        float mAniso;

        public Builder(RenderScriptThunker rs) {
            this.mRS = rs;
            this.mMin = Sampler.Value.NEAREST;
            this.mMag = Sampler.Value.NEAREST;
            this.mWrapS = Sampler.Value.WRAP;
            this.mWrapT = Sampler.Value.WRAP;
            this.mWrapR = Sampler.Value.WRAP;
        }

        public void setMinification(Sampler.Value v) {
            if (v != Sampler.Value.NEAREST && v != Sampler.Value.LINEAR && v != Sampler.Value.LINEAR_MIP_LINEAR && v != Sampler.Value.LINEAR_MIP_NEAREST) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mMin = v;
        }

        public void setMagnification(Sampler.Value v) {
            if (v != Sampler.Value.NEAREST && v != Sampler.Value.LINEAR) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mMag = v;
        }

        public void setWrapS(Sampler.Value v) {
            if (v != Sampler.Value.WRAP && v != Sampler.Value.CLAMP && v != Sampler.Value.MIRRORED_REPEAT) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mWrapS = v;
        }

        public void setWrapT(Sampler.Value v) {
            if (v != Sampler.Value.WRAP && v != Sampler.Value.CLAMP && v != Sampler.Value.MIRRORED_REPEAT) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mWrapT = v;
        }

        public void setAnisotropy(float v) {
            if (!(v >= 0.0f)) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mAniso = v;
        }

        public Sampler create() {
            this.mRS.validate();
            try {
                Sampler.Builder b = new Sampler.Builder(this.mRS.mN);
                b.setMinification(SamplerThunker.convertValue(this.mMin));
                b.setMagnification(SamplerThunker.convertValue(this.mMag));
                b.setWrapS(SamplerThunker.convertValue(this.mWrapS));
                b.setWrapT(SamplerThunker.convertValue(this.mWrapT));
                b.setAnisotropy(this.mAniso);
                android.renderscript.Sampler s = b.create();
                SamplerThunker sampler = new SamplerThunker(0, this.mRS);
                sampler.mMin = this.mMin;
                sampler.mMag = this.mMag;
                sampler.mWrapS = this.mWrapS;
                sampler.mWrapT = this.mWrapT;
                sampler.mWrapR = this.mWrapR;
                sampler.mAniso = this.mAniso;
                sampler.mN = s;
                return sampler;
            }
            catch (RSRuntimeException e) {
                throw ExceptionThunker.convertException((RuntimeException)((Object)e));
            }
        }
    }
}

