/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.content.res.Resources;
import android.support.v8.renderscript.RSRuntimeException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Script;
import android.support.v8.renderscript.ScriptCThunker;
import java.io.IOException;
import java.io.InputStream;

public class ScriptC
extends Script {
    private static final String TAG = "ScriptC";

    protected ScriptC(int id, RenderScript rs) {
        super(id, rs);
    }

    protected ScriptC(RenderScript rs, Resources resources, int resourceID) {
        super(0, rs);
        if (RenderScript.isNative) {
            ScriptCThunker s;
            RenderScriptThunker rst = (RenderScriptThunker)rs;
            this.mT = s = new ScriptCThunker(rst, resources, resourceID);
            return;
        }
        int id = ScriptC.internalCreate(rs, resources, resourceID);
        if (id == 0) {
            throw new RSRuntimeException("Loading of ScriptC script failed.");
        }
        this.setID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized int internalCreate(RenderScript rs, Resources resources, int resourceID) {
        int pgmLength;
        byte[] pgm;
        InputStream is = resources.openRawResource(resourceID);
        try {
            try {
                pgm = new byte[1024];
                pgmLength = 0;
                while (true) {
                    int bytesRead;
                    int bytesLeft;
                    if ((bytesLeft = pgm.length - pgmLength) == 0) {
                        byte[] buf2 = new byte[pgm.length * 2];
                        System.arraycopy(pgm, 0, buf2, 0, pgm.length);
                        pgm = buf2;
                        bytesLeft = pgm.length - pgmLength;
                    }
                    if ((bytesRead = is.read(pgm, pgmLength, bytesLeft)) <= 0) {
                        break;
                    }
                    pgmLength += bytesRead;
                }
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new Resources.NotFoundException();
        }
        String resName = resources.getResourceEntryName(resourceID);
        String cachePath = rs.getApplicationContext().getCacheDir().toString();
        return rs.nScriptCCreate(resName, cachePath, pgm, pgmLength);
    }
}

