/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RSIllegalArgumentException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Script;
import android.support.v8.renderscript.ScriptIntrinsic;
import android.support.v8.renderscript.ScriptIntrinsic3DLUTThunker;
import android.support.v8.renderscript.Type;

public class ScriptIntrinsic3DLUT
extends ScriptIntrinsic {
    private Allocation mLUT;
    private Element mElement;

    protected ScriptIntrinsic3DLUT(int id, RenderScript rs, Element e) {
        super(id, rs);
        this.mElement = e;
    }

    public static ScriptIntrinsic3DLUT create(RenderScript rs, Element e) {
        if (RenderScript.isNative) {
            RenderScriptThunker rst = (RenderScriptThunker)rs;
            return ScriptIntrinsic3DLUTThunker.create(rs, e);
        }
        int id = rs.nScriptIntrinsicCreate(8, e.getID(rs));
        if (!e.isCompatible(Element.U8_4(rs))) {
            throw new RSIllegalArgumentException("Element must be compatible with uchar4.");
        }
        return new ScriptIntrinsic3DLUT(id, rs, e);
    }

    public void setLUT(Allocation lut) {
        Type t = lut.getType();
        if (t.getZ() == 0) {
            throw new RSIllegalArgumentException("LUT must be 3d.");
        }
        if (!t.getElement().isCompatible(this.mElement)) {
            throw new RSIllegalArgumentException("LUT element type must match.");
        }
        this.mLUT = lut;
        this.setVar(0, this.mLUT);
    }

    public void forEach(Allocation ain, Allocation aout) {
        this.forEach(0, ain, aout, null);
    }

    public Script.KernelID getKernelID() {
        return this.createKernelID(0, 3, null, null);
    }
}

