/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RSIllegalArgumentException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Script;
import android.support.v8.renderscript.ScriptIntrinsic;
import android.support.v8.renderscript.ScriptIntrinsicBlurThunker;

public class ScriptIntrinsicBlur
extends ScriptIntrinsic {
    private final float[] mValues = new float[9];
    private Allocation mInput;

    protected ScriptIntrinsicBlur(int id, RenderScript rs) {
        super(id, rs);
    }

    public static ScriptIntrinsicBlur create(RenderScript rs, Element e) {
        if (RenderScript.isNative) {
            RenderScriptThunker rst = (RenderScriptThunker)rs;
            return ScriptIntrinsicBlurThunker.create(rs, e);
        }
        if (!e.isCompatible(Element.U8_4(rs)) && !e.isCompatible(Element.U8(rs))) {
            throw new RSIllegalArgumentException("Unsuported element type.");
        }
        int id = rs.nScriptIntrinsicCreate(5, e.getID(rs));
        ScriptIntrinsicBlur sib = new ScriptIntrinsicBlur(id, rs);
        sib.setRadius(5.0f);
        return sib;
    }

    public void setInput(Allocation ain) {
        this.mInput = ain;
        this.setVar(1, ain);
    }

    public void setRadius(float radius) {
        if (radius <= 0.0f || radius > 25.0f) {
            throw new RSIllegalArgumentException("Radius out of range (0 < r <= 25).");
        }
        this.setVar(0, radius);
    }

    public void forEach(Allocation aout) {
        this.forEach(0, null, aout, null);
    }

    public Script.KernelID getKernelID() {
        return this.createKernelID(0, 2, null, null);
    }

    public Script.FieldID getFieldID_Input() {
        return this.createFieldID(1, null);
    }
}

