/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.FieldPacker;
import android.support.v8.renderscript.Matrix3f;
import android.support.v8.renderscript.Matrix4f;
import android.support.v8.renderscript.RSIllegalArgumentException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Script;
import android.support.v8.renderscript.ScriptIntrinsic;
import android.support.v8.renderscript.ScriptIntrinsicColorMatrixThunker;

public class ScriptIntrinsicColorMatrix
extends ScriptIntrinsic {
    private final Matrix4f mMatrix = new Matrix4f();
    private Allocation mInput;

    protected ScriptIntrinsicColorMatrix(int id, RenderScript rs) {
        super(id, rs);
    }

    public static ScriptIntrinsicColorMatrix create(RenderScript rs, Element e) {
        if (RenderScript.isNative) {
            RenderScriptThunker rst = (RenderScriptThunker)rs;
            return ScriptIntrinsicColorMatrixThunker.create(rs, e);
        }
        if (!e.isCompatible(Element.U8_4(rs))) {
            throw new RSIllegalArgumentException("Unsuported element type.");
        }
        int id = rs.nScriptIntrinsicCreate(2, e.getID(rs));
        return new ScriptIntrinsicColorMatrix(id, rs);
    }

    private void setMatrix() {
        FieldPacker fp = new FieldPacker(64);
        fp.addMatrix(this.mMatrix);
        this.setVar(0, fp);
    }

    public void setColorMatrix(Matrix4f m) {
        this.mMatrix.load(m);
        this.setMatrix();
    }

    public void setColorMatrix(Matrix3f m) {
        this.mMatrix.load(m);
        this.setMatrix();
    }

    public void setGreyscale() {
        this.mMatrix.loadIdentity();
        this.mMatrix.set(0, 0, 0.299f);
        this.mMatrix.set(1, 0, 0.587f);
        this.mMatrix.set(2, 0, 0.114f);
        this.mMatrix.set(0, 1, 0.299f);
        this.mMatrix.set(1, 1, 0.587f);
        this.mMatrix.set(2, 1, 0.114f);
        this.mMatrix.set(0, 2, 0.299f);
        this.mMatrix.set(1, 2, 0.587f);
        this.mMatrix.set(2, 2, 0.114f);
        this.setMatrix();
    }

    public void setYUVtoRGB() {
        this.mMatrix.loadIdentity();
        this.mMatrix.set(0, 0, 1.0f);
        this.mMatrix.set(1, 0, 0.0f);
        this.mMatrix.set(2, 0, 1.13983f);
        this.mMatrix.set(0, 1, 1.0f);
        this.mMatrix.set(1, 1, -0.39465f);
        this.mMatrix.set(2, 1, -0.5806f);
        this.mMatrix.set(0, 2, 1.0f);
        this.mMatrix.set(1, 2, 2.03211f);
        this.mMatrix.set(2, 2, 0.0f);
        this.setMatrix();
    }

    public void setRGBtoYUV() {
        this.mMatrix.loadIdentity();
        this.mMatrix.set(0, 0, 0.299f);
        this.mMatrix.set(1, 0, 0.587f);
        this.mMatrix.set(2, 0, 0.114f);
        this.mMatrix.set(0, 1, -0.14713f);
        this.mMatrix.set(1, 1, -0.28886f);
        this.mMatrix.set(2, 1, 0.436f);
        this.mMatrix.set(0, 2, 0.615f);
        this.mMatrix.set(1, 2, -0.51499f);
        this.mMatrix.set(2, 2, -0.10001f);
        this.setMatrix();
    }

    public void forEach(Allocation ain, Allocation aout) {
        this.forEach(0, ain, aout, null);
    }

    public Script.KernelID getKernelID() {
        return this.createKernelID(0, 3, null, null);
    }
}

