/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.Matrix4f;
import android.support.v8.renderscript.RSIllegalArgumentException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.RenderScriptThunker;
import android.support.v8.renderscript.Script;
import android.support.v8.renderscript.ScriptIntrinsic;
import android.support.v8.renderscript.ScriptIntrinsicLUTThunker;

public class ScriptIntrinsicLUT
extends ScriptIntrinsic {
    private final Matrix4f mMatrix = new Matrix4f();
    private Allocation mTables;
    private final byte[] mCache = new byte[1024];
    private boolean mDirty = true;

    protected ScriptIntrinsicLUT(int id, RenderScript rs) {
        super(id, rs);
    }

    public static ScriptIntrinsicLUT create(RenderScript rs, Element e) {
        if (RenderScript.isNative) {
            RenderScriptThunker rst = (RenderScriptThunker)rs;
            return ScriptIntrinsicLUTThunker.create(rs, e);
        }
        int id = rs.nScriptIntrinsicCreate(3, e.getID(rs));
        ScriptIntrinsicLUT si = new ScriptIntrinsicLUT(id, rs);
        si.mTables = Allocation.createSized(rs, Element.U8(rs), 1024);
        for (int ct = 0; ct < 256; ++ct) {
            si.mCache[ct] = (byte)ct;
            si.mCache[ct + 256] = (byte)ct;
            si.mCache[ct + 512] = (byte)ct;
            si.mCache[ct + 768] = (byte)ct;
        }
        si.setVar(0, si.mTables);
        return si;
    }

    private void validate(int index, int value) {
        if (index < 0 || index > 255) {
            throw new RSIllegalArgumentException("Index out of range (0-255).");
        }
        if (value < 0 || value > 255) {
            throw new RSIllegalArgumentException("Value out of range (0-255).");
        }
    }

    public void setRed(int index, int value) {
        this.validate(index, value);
        this.mCache[index] = (byte)value;
        this.mDirty = true;
    }

    public void setGreen(int index, int value) {
        this.validate(index, value);
        this.mCache[index + 256] = (byte)value;
        this.mDirty = true;
    }

    public void setBlue(int index, int value) {
        this.validate(index, value);
        this.mCache[index + 512] = (byte)value;
        this.mDirty = true;
    }

    public void setAlpha(int index, int value) {
        this.validate(index, value);
        this.mCache[index + 768] = (byte)value;
        this.mDirty = true;
    }

    public void forEach(Allocation ain, Allocation aout) {
        if (this.mDirty) {
            this.mDirty = false;
            this.mTables.copyFromUnchecked(this.mCache);
        }
        this.forEach(0, ain, aout, null);
    }

    public Script.KernelID getKernelID() {
        return this.createKernelID(0, 3, null, null);
    }
}

