// Autogenerated with DRAKON Editor 1.25
using System;
using System.Linq;
using System.Collections.Generic;
using System.Collections.ObjectModel;

class Bar {
	public delegate void AnyCode();
    public interface IBaseRecord
    {
        int Id { get; }
    }
    private interface IDelRecord
    {
        void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master);
        void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList);
        void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList);
    }
    public interface IDepartment : IBaseRecord {
        string Title { get; }
        ReadOnlyCollection<IEmployee> Employees { get; }
    }
    public interface IEmployee : IBaseRecord {
        string Name { get; }
        IDepartment Department { get; }
    }
    private int _next_department = 1;
    private readonly Dictionary<int, Department> _department_pk = new Dictionary<int, Department>();
    private int _next_employee = 1;
    private readonly Dictionary<int, Employee> _employee_pk = new Dictionary<int, Employee>();
    private class Department_Title_Comparer : IEqualityComparer<Department> {
        public bool Equals(Department x, Department y) {
            if (!Object.Equals(x._title, y._title)) return false;
            return true;
        }
        public int GetHashCode(Department obj) {
            int code = ((obj._title == null) ? 0 : obj._title.GetHashCode());
            return code;
        }
    }
    private readonly Dictionary<Department, Department> _department_Title = new Dictionary<Department, Department>(new Department_Title_Comparer());
    private class Employee_Department_Name_Comparer : IEqualityComparer<Employee> {
        public bool Equals(Employee x, Employee y) {
            if (x._department != null && y._department != null) {
                if (x._department._id != y._department._id) return false;
            } else {
                if (!Object.ReferenceEquals(x._department, y._department)) return false;
            }
            if (!Object.Equals(x._name, y._name)) return false;
            return true;
        }
        public int GetHashCode(Employee obj) {
            int code = ((obj._department == null) ? 0 : obj._department._id.GetHashCode());
            code = (code * 397) ^ ((obj._name == null) ? 0 : obj._name.GetHashCode());
            return code;
        }
    }
    private readonly Dictionary<Employee, Employee> _employee_Department_Name = new Dictionary<Employee, Employee>(new Employee_Department_Name_Comparer());
    private class Department : IDepartment, IDelRecord {
        public readonly int _id;
        public int Id { get { return _id; } }
        public Department(int id) {
            _id = id;
            _employees_Wrapper = _employees.AsReadOnly();
        }
        public string _title;
        public string Title {
            get { return _title; }
        }
        public ReadOnlyCollection<IEmployee> _employees_Wrapper;
        public readonly List<IEmployee> _employees = new List<IEmployee>();
        public ReadOnlyCollection<IEmployee> Employees {
            get { return _employees_Wrapper; }
        }
        public virtual void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            foreach (Employee _that_ in _employees) {
                if (!deletionList.Contains(_that_)) {
                    throw new ArgumentException(String.Format(
                      "'Department' with id '{0}' is referenced by other record.",
                      _id));
                }
            }
        }
        public virtual void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            db._department_Title.Remove(this);
            db._department_pk.Remove(_id);
        }
        public virtual void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            PreDeleteInner(deletionList);
        }
        public virtual void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
    }
    private readonly Department _department_Key = new Department(0);
    private class Employee : IEmployee, IDelRecord {
        public readonly int _id;
        public int Id { get { return _id; } }
        public Employee(int id) {
            _id = id;
        }
        public string _name;
        public string Name {
            get { return _name; }
        }
        public Department _department;
        public IDepartment Department {
            get { return _department; }
        }
        public virtual void EnsureCanDelete(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
        public virtual void DoDelete(Bar db, System.Collections.Generic.HashSet<IDelRecord> deletionList) {
            if (_department != null ) {
                if ( !deletionList.Contains(_department)) {
                    _department._employees.Remove(this);
                }
            }
            db._employee_Department_Name.Remove(this);
            db._employee_pk.Remove(_id);
        }
        public virtual void PreDeleteOuter(System.Collections.Generic.HashSet<IDelRecord> deletionList, bool master) {
            if (deletionList.Contains(this)) {
                return;
            } else {
                deletionList.Add(this);
            }
            PreDeleteInner(deletionList);
        }
        public virtual void PreDeleteInner(System.Collections.Generic.HashSet<IDelRecord> deletionList) {
        }
    }
    private readonly Employee _employee_Key = new Employee(0);
    public IDepartment InsertDepartment(int id, string title) {
        if ( id == 0 ) {
            id = _next_department;
        } else {
            if (_department_pk.ContainsKey(id)) {
                string className = _department_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_department ) {
            _next_department = id + 1;
        }
        _department_Key._title = title;
        if ( _department_Title.ContainsKey(_department_Key)) {
            throw new ArgumentException(
              "Fields 'Title' are not unique for 'Department'.");
        }
        var _record_ = new Department(id);
        _record_._title = title;
        _department_pk[id] = _record_;
        _department_Title[_record_] = _record_;
        return _record_;
    }
    public IDepartment GetDepartment(int id) {
        Department _record_;
        if (!_department_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int DepartmentCount() {
        return _department_pk.Count;
    }
    public IEnumerable<IDepartment> EachDepartment() {
        foreach (KeyValuePair<int, Department> record in _department_pk) {
            yield return record.Value;
        }
    }
    public void DeleteDepartment(IDepartment record) {
        if (record == null) return;
        Department _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_department_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Department' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }
    public IDepartment FindDepartmentByTitle(string title) {
        Department _record_;
        _department_Key._title = title;
        if (_department_Title.TryGetValue(_department_Key, out _record_)) {
            return _record_;
        } else {
            return null;
        }
    }
    public void SetDepartmentTitle(IDepartment record, string newValue) {
        Department _record_;
        if ( !_department_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Department' with id '{0}' does not exist.",
                record.Id));
        }
        if (Object.Equals(_record_._title, newValue)) {
            return;
        }
        _department_Key._title = newValue;
        if ( _department_Title.ContainsKey(_department_Key)) {
            throw new ArgumentException(
              "Fields 'Title' are not unique for 'Department'.");
        }
        _department_Title.Remove(_record_);
        _record_._title = newValue;
        _department_Title[_record_] = _record_;
    }
    public IEmployee InsertEmployee(int id, string name, IDepartment department) {
        if ( id == 0 ) {
            id = _next_employee;
        } else {
            if (_employee_pk.ContainsKey(id)) {
                string className = _employee_pk[id].GetType().Name;
                throw new ArgumentException(String.Format(
                    "'{0}' with id '{1}' already exists.",
                    className, id));
            }
        }
        if ( id >= _next_employee ) {
            _next_employee = id + 1;
        }
        _employee_Key._department = (Department)department;
        _employee_Key._name = name;
        if ( _employee_Department_Name.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Department Name' are not unique for 'Employee'.");
        }
        Department _department_;
        if (department == null ) {
            _department_ = null;
        } else if (!_department_pk.TryGetValue(department.Id, out _department_)) {
            throw new ArgumentException(String.Format(
                "'Department' with id '{0}' does not exist.",
                department.Id));
        }
        var _record_ = new Employee(id);
        _record_._name = name;
        _record_._department = _department_;
        _employee_pk[id] = _record_;
        _employee_Department_Name[_record_] = _record_;
        if (_record_._department != null ) {
            _record_._department._employees.Add(_record_);
        }
        return _record_;
    }
    public IEmployee GetEmployee(int id) {
        Employee _record_;
        if (!_employee_pk.TryGetValue(id, out _record_)) {
            return null;
        }
        return _record_;
    }
    public int EmployeeCount() {
        return _employee_pk.Count;
    }
    public IEnumerable<IEmployee> EachEmployee() {
        foreach (KeyValuePair<int, Employee> record in _employee_pk) {
            yield return record.Value;
        }
    }
    public void DeleteEmployee(IEmployee record) {
        if (record == null) return;
        Employee _record_;
        var deletionList = new System.Collections.Generic.HashSet<IDelRecord>();
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        _record_.PreDeleteOuter(deletionList, false);
        foreach (IDelRecord item in deletionList) {
            item.EnsureCanDelete(deletionList);
        }
        foreach (IDelRecord item in deletionList) {
            item.DoDelete(this, deletionList);
        }
    }
    public IEmployee FindEmployeeByDepartmentName(IDepartment department, string name) {
        Employee _record_;
        _employee_Key._department = (Department)department;
        _employee_Key._name = name;
        if (_employee_Department_Name.TryGetValue(_employee_Key, out _record_)) {
            return _record_;
        } else {
            return null;
        }
    }
    public void SetEmployeeName(IEmployee record, string newValue) {
        Employee _record_;
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        if (Object.Equals(_record_._name, newValue)) {
            return;
        }
        _employee_Key._department = _record_._department;
        _employee_Key._name = newValue;
        if ( _employee_Department_Name.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Department Name' are not unique for 'Employee'.");
        }
        _employee_Department_Name.Remove(_record_);
        _record_._name = newValue;
        _employee_Department_Name[_record_] = _record_;
    }
    public void SetEmployeeDepartment(IEmployee record, IDepartment newValue) {
        Employee _record_;
        if ( !_employee_pk.TryGetValue(record.Id, out _record_)) {
            throw new ArgumentException(String.Format(
                "'Employee' with id '{0}' does not exist.",
                record.Id));
        }
        if (Object.Equals(_record_._department, newValue)) {
            return;
        }
        _employee_Key._department = (Department)newValue;
        _employee_Key._name = _record_._name;
        if ( _employee_Department_Name.ContainsKey(_employee_Key)) {
            throw new ArgumentException(
              "Fields 'Department Name' are not unique for 'Employee'.");
        }
        Department _that_;
        if (newValue == null ) {
            _that_ = null;
        } else if (!_department_pk.TryGetValue(newValue.Id, out _that_)) {
            throw new ArgumentException(String.Format(
                "'Department' with id '{0}' does not exist.",
                newValue.Id));
        }
        if (_record_._department != null ) {
            _record_._department._employees.Remove(_record_);
        }
        _employee_Department_Name.Remove(_record_);
        _record_._department = _that_;
        _employee_Department_Name[_record_] = _record_;
        if (_record_._department != null ) {
            _record_._department._employees.Add(_record_);
        }
    }

    public static void Equal(object expected, object actual) {
        // item 231
        if (Object.Equals(expected, actual)) {
            
        } else {
            // item 213
            if (expected is System.Collections.IEnumerable) {
                // item 219
                if (actual is System.Collections.IEnumerable) {
                    // item 222
                    var expectedEn = (System.Collections.IEnumerable)expected;
                    var actualEn = (System.Collections.IEnumerable)actual;
                    // item 233
                    List<object> exList = expectedEn.Cast<object>().ToList();
                    List<object> acList = actualEn.Cast<object>().ToList();
                    // item 223
                    if (exList.Count == acList.Count) {
                        // item 2260001
                        int i = 0;
                        while (true) {
                            // item 2260002
                            if (i < exList.Count) {
                                
                            } else {
                                break;
                            }
                            // item 228
                            Equal(exList[i], acList[i]);
                            // item 2260003
                            i++;
                        }
                    } else {
                        // item 225
                        throw new Exception("Collections have different sizes");
                    }
                } else {
                    // item 221
                    throw new Exception("Both should be IEnumerable");
                }
            } else {
                // item 216
                if (actual is System.Collections.IEnumerable) {
                    // item 217
                    throw new Exception("Both should be IEnumerable");
                } else {
                    // item 229
                    throw new Exception("Objects are not equal.");
                }
            }
        }
    }

    public static void ExpectException(AnyCode code) {
        // item 248
        bool caught = false;
        try {
            code();
        }
        catch {
            caught = true;
        }
        // item 249
        if (caught) {
            
        } else {
            // item 252
            throw new Exception("Exception expected but not thrown.");
        }
    }

    public static void Main() {
        // item 255
        Bar db = new Bar();
        // item 161
        Bar.IDepartment yellow_m = db.InsertDepartment(0, "Yellow marketing");
        Bar.IDepartment grey_m = db.InsertDepartment(0, "Grey marketing");
        // item 162
        Bar.IEmployee mark = db.InsertEmployee(10, "Mark", grey_m);
        Bar.IEmployee john = db.InsertEmployee(20, "John", null);
        // item 188
        db.SetEmployeeDepartment(john, grey_m);
        // item 189
        var grey_employees = (
        	from e in grey_m.Employees 
        	select e.Id).ToList();
        var yellow_employees = (
        	from e in yellow_m.Employees
        	select e.Id).ToList();
        
        grey_employees.Sort();
        yellow_employees.Sort();
        // item 190
        Equal(new int[] {10, 20}, grey_employees);
        Equal(new int[0], yellow_employees);
        // item 191
        db.SetEmployeeDepartment(mark, yellow_m);
        // item 256
        grey_employees = (
        	from e in grey_m.Employees 
        	select e.Id).ToList();
        yellow_employees = (
        	from e in yellow_m.Employees
        	select e.Id).ToList();
        
        grey_employees.Sort();
        yellow_employees.Sort();
        // item 257
        Equal(new int[] {20}, grey_employees);
        Equal(new int[] {10}, yellow_employees);
        // item 194
        ExpectException(() =>  db.DeleteDepartment(grey_m));
        ExpectException(() =>  db.DeleteDepartment(yellow_m));
        // item 195
        db.SetEmployeeDepartment(mark, null);
        // item 196
        db.DeleteDepartment(yellow_m);
        // item 197
        db.DeleteEmployee(john);
        // item 198
        db.DeleteDepartment(grey_m);
    }

    public static void NotEqual(object left, object right) {
        // item 239
        if (Object.Equals(left, right)) {
            // item 242
            throw new Exception("Objects are equal.");
        } else {
            
        }
    }
}

