/* Autogenerated with DRAKON Editor 1.23 */
#ifndef M2M_H237
#define M2M_H237

#include "lib.h"

typedef struct m2m m2m;
typedef struct employee employee;
typedef int (*employee_fun)(employee* item, void* user_data /* null */);
typedef struct department department;
typedef int (*department_fun)(department* item, void* user_data /* null */);
typedef struct company company;
typedef int (*company_fun)(company* item, void* user_data /* null */);


m2m* /* own */
m2m_create(void);


void
m2m_destroy(m2m* me /* own. null */);


int
m2m_error(const m2m* db);


int
employee_id(const employee* me);


employee* /* null */
m2m_get_employee(m2m* db,
    int rec_id);


int
employee_departments_count(const employee* record);


department*
employee_departments(employee* record,
    int index);


int
m2m_set_employee_company(m2m* db,
    employee* _record_,
    company* new_value /* null */);


employee* /* null */
m2m_insert_employee(m2m* db,
    string8* name /* own. null */);


int
m2m_delete_employee(m2m* db,
    employee* record /* null */);


int
m2m_employee_count(const m2m* db);


int
m2m_foreach_employee(m2m* db,
    employee_fun visitor,
    void* user_data /* null */);


employee* /* null */
m2m_employee_by_name(m2m* db,
    const string8* name /* null */);


int
department_id(const department* me);


department* /* null */
m2m_get_department(m2m* db,
    int rec_id);


int
department_employees_count(const department* record);


employee*
department_employees(department* record,
    int index);


int
m2m_set_department_company(m2m* db,
    department* _record_,
    company* new_value /* null */);


department* /* null */
m2m_insert_department(m2m* db,
    string8* title /* own. null */);


int
m2m_delete_department(m2m* db,
    department* record /* null */);


int
m2m_department_count(const m2m* db);


int
m2m_foreach_department(m2m* db,
    department_fun visitor,
    void* user_data /* null */);


department* /* null */
m2m_department_by_title(m2m* db,
    const string8* title /* null */);


int
company_id(const company* me);


company* /* null */
m2m_get_company(m2m* db,
    int rec_id);


int
company_departments_count(const company* record);


department*
company_departments(company* record,
    int index);


int
company_employees_count(const company* record);


employee*
company_employees(company* record,
    int index);


company* /* null */
m2m_insert_company(m2m* db);


int
m2m_delete_company(m2m* db,
    company* record /* null */);


int
m2m_company_count(const m2m* db);


int
m2m_foreach_company(m2m* db,
    company_fun visitor,
    void* user_data /* null */);


void
m2m_add_department_employees(m2m* db,
    department* left,
    employee* right);


void
m2m_remove_department_employees(m2m* db,
    department* left,
    employee* right);






int main(
    int argc,
    char** argv
);


#endif

