/* Autogenerated with DRAKON Editor 1.23 */
#include "ownarrow.h"

#include <memory.h>
#include <stdio.h>






struct ownarrow {
    tobject base;
    array_table department;
    hashtable* department_by_title;
    array_table employee;
    hashtable* employee_by_name;
    array_table company;
    int error_code;
};
static type_info_t ownarrow_t = {
	OBJECT_SIGNATURE,
	"ownarrow",
	(destructor_fun)ownarrow_destroy
};
struct department {
    row_base _row;
    int _ref_count;
    string8* title;
};
struct employee {
    row_base _row;
    string8* name;
    department* department;
};
struct company {
    row_base _row;
    department* marketing;
};


static int
delete_generic(ownarrow* db,
    obj_list* deletion_list);


static int
ensure_can_delete(ownarrow* db,
    void* record,
    obj_list* deletion_list);


static void
do_delete(ownarrow* db,
    void* record,
    obj_list* deletion_list,
    int unlink);


static int
record_destructor(void* record,
    void* dbv);


static int
department_pre_delete(ownarrow* db,
    department* record,
    obj_list* deletion_list,
    int master);


static int
department_ensure_can_delete(ownarrow* db,
    department* record,
    obj_list* deletion_list);


static void
department_do_delete(ownarrow* db,
    department* record,
    obj_list* deletion_list,
    int unlink);


static unsigned int
department_by_title_hash(const void* vobj);


static int
department_by_title_eq(const void* lobj,
    const void* robj);


static int
employee_pre_delete(ownarrow* db,
    employee* record,
    obj_list* deletion_list,
    int master);


static int
employee_ensure_can_delete(ownarrow* db,
    employee* record,
    obj_list* deletion_list);


static void
employee_do_delete(ownarrow* db,
    employee* record,
    obj_list* deletion_list,
    int unlink);


static unsigned int
employee_by_name_hash(const void* vobj);


static int
employee_by_name_eq(const void* lobj,
    const void* robj);


static int
company_pre_delete(ownarrow* db,
    company* record,
    obj_list* deletion_list,
    int master);


static int
company_ensure_can_delete(ownarrow* db,
    company* record,
    obj_list* deletion_list);


static void
company_do_delete(ownarrow* db,
    company* record,
    obj_list* deletion_list,
    int unlink);


ownarrow* /* own */
ownarrow_create(void) {
    ownarrow* me = allocate_memory(sizeof(ownarrow));
    me->base.type = &ownarrow_t;
    array_table_init(&me->department, "department");
    me->department.do_delete = (dd_fun)department_do_delete;
    me->department.ensure_can_delete = (ensure_cd_fun)department_ensure_can_delete;
    me->department_by_title = hashtable_create(0, department_by_title_hash, department_by_title_eq);
    array_table_init(&me->employee, "employee");
    me->employee.do_delete = (dd_fun)employee_do_delete;
    me->employee.ensure_can_delete = (ensure_cd_fun)employee_ensure_can_delete;
    me->employee_by_name = hashtable_create(0, employee_by_name_hash, employee_by_name_eq);
    array_table_init(&me->company, "company");
    me->company.do_delete = (dd_fun)company_do_delete;
    me->company.ensure_can_delete = (ensure_cd_fun)company_ensure_can_delete;
    return me;
}


void
ownarrow_destroy(ownarrow* me /* own. null */) {
    if (!me) return;
    ENSURE(me->base.type == &ownarrow_t)
    hashtable_destroy(me->department_by_title);
    ownarrow_foreach_department(
        me,
        (department_fun)record_destructor,
        me);
    array_table_cleanup(&me->department);
    hashtable_destroy(me->employee_by_name);
    ownarrow_foreach_employee(
        me,
        (employee_fun)record_destructor,
        me);
    array_table_cleanup(&me->employee);
    ownarrow_foreach_company(
        me,
        (company_fun)record_destructor,
        me);
    array_table_cleanup(&me->company);
    free_memory(me, sizeof(ownarrow));
}


int
ownarrow_error(const ownarrow* db) {
    return db->error_code;
}


int
department_id(const department* me) {
    return me->_row.id;
}


department* /* null */
ownarrow_get_department(ownarrow* db,
    int rec_id) {
    if (rec_id < 0) return 0;
    if (rec_id >= db->department.next) return 0;
    return db->department.items[rec_id];
}


const string8* /* null */
department_cget_title(const department* me) {
    return me->title;
}


department* /* null */
ownarrow_insert_department(ownarrow* db,
    string8* title /* own. null */) {
    department* _record_;
    int rec_id;
    department _key_;
    department* found;
    _record_ = 0;
    _key_.title = title;
    found = hashtable_get(db->department_by_title, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    _record_ = allocate_memory(sizeof(department));
    rec_id = array_table_insert(&db->department, _record_);
    _record_->_row.id = rec_id;
    _record_->_row.table = &db->department;
    _record_->title = title;
    hashtable_put(db->department_by_title, _record_);
    _record_->_ref_count = 0;
    return _record_;
}


int
ownarrow_delete_department(ownarrow* db,
    department* record /* null */) {
    obj_list* deletion_list;
    int deleted = 0;
    if (!record) return 0;
    deletion_list = obj_list_create(0);
    ENSURE(record == ownarrow_get_department(db, record->_row.id))
    if (department_pre_delete(db, record, deletion_list, 0)) {
        deleted = delete_generic(db, deletion_list);
    }
    obj_list_destroy(deletion_list);
    return deleted;
}


int
ownarrow_department_count(const ownarrow* db) {
    return db->department.count;
}


int
ownarrow_foreach_department(ownarrow* db,
    department_fun visitor,
    void* user_data /* null */) {
    int i, n;
    department* current;
    n = db->department.next;
    for (i = 0; i < n; i++) {
        current = db->department.items[i];
        if (current) {
            if (visitor(current, user_data)) return 1;
        }
    }
    return 0;
}


department* /* null */
ownarrow_department_by_title(ownarrow* db,
    const string8* title /* null */) {
    department _key_;
    _key_.title = (string8*)title;
    return hashtable_get(db->department_by_title, &_key_);
}


int
employee_id(const employee* me) {
    return me->_row.id;
}


employee* /* null */
ownarrow_get_employee(ownarrow* db,
    int rec_id) {
    if (rec_id < 0) return 0;
    if (rec_id >= db->employee.next) return 0;
    return db->employee.items[rec_id];
}


const string8* /* null */
employee_cget_name(const employee* me) {
    return me->name;
}


department* /* null */
employee_department(employee* me) {
    return me->department;
}


int
ownarrow_set_employee_name(ownarrow* db,
    employee* _record_,
    string8* new_value /* own. null */) {
    employee* found;
    employee _key_;
    ENSURE(_record_ == ownarrow_get_employee(db, _record_->_row.id))
    if (_record_->name == new_value) {
        return 1;
    }
    _key_.name = new_value;
    found = hashtable_get(db->employee_by_name, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    hashtable_remove(db->employee_by_name, _record_);
    if (_record_->name) {
        string8_destroy(_record_->name);
    }
    _record_->name = new_value;
    hashtable_put(db->employee_by_name, _record_);
    return 1;
}


int
ownarrow_set_employee_department(ownarrow* db,
    employee* _record_,
    department* new_value /* null */) {
    ENSURE(_record_ == ownarrow_get_employee(db, _record_->_row.id))
    if (_record_->department == new_value) {
        return 1;
    }
    if (new_value) {
        ENSURE(new_value == ownarrow_get_department(db, new_value->_row.id))
    }
    if (_record_->department != 0 ) {
        _record_->department->_ref_count--;
    }
    _record_->department = new_value;
    if (_record_->department != 0 ) {
        _record_->department->_ref_count++;
    }
    return 1;
}


employee* /* null */
ownarrow_insert_employee(ownarrow* db,
    string8* name /* own. null */,
    department* department /* null */) {
    employee* _record_;
    int rec_id;
    employee _key_;
    employee* found;
    _record_ = 0;
    _key_.name = name;
    found = hashtable_get(db->employee_by_name, &_key_);
    if (found && found != _record_) {
        db->error_code = 1;
        return 0;
    }
    _record_ = allocate_memory(sizeof(employee));
    rec_id = array_table_insert(&db->employee, _record_);
    _record_->_row.id = rec_id;
    _record_->_row.table = &db->employee;
    _record_->name = name;
    _record_->department = department;
    hashtable_put(db->employee_by_name, _record_);
    if (_record_->department != 0 ) {
        _record_->department->_ref_count++;
    }
    return _record_;
}


int
ownarrow_delete_employee(ownarrow* db,
    employee* record /* null */) {
    obj_list* deletion_list;
    int deleted = 0;
    if (!record) return 0;
    deletion_list = obj_list_create(0);
    ENSURE(record == ownarrow_get_employee(db, record->_row.id))
    if (employee_pre_delete(db, record, deletion_list, 0)) {
        deleted = delete_generic(db, deletion_list);
    }
    obj_list_destroy(deletion_list);
    return deleted;
}


int
ownarrow_employee_count(const ownarrow* db) {
    return db->employee.count;
}


int
ownarrow_foreach_employee(ownarrow* db,
    employee_fun visitor,
    void* user_data /* null */) {
    int i, n;
    employee* current;
    n = db->employee.next;
    for (i = 0; i < n; i++) {
        current = db->employee.items[i];
        if (current) {
            if (visitor(current, user_data)) return 1;
        }
    }
    return 0;
}


employee* /* null */
ownarrow_employee_by_name(ownarrow* db,
    const string8* name /* null */) {
    employee _key_;
    _key_.name = (string8*)name;
    return hashtable_get(db->employee_by_name, &_key_);
}


int
company_id(const company* me) {
    return me->_row.id;
}


company* /* null */
ownarrow_get_company(ownarrow* db,
    int rec_id) {
    if (rec_id < 0) return 0;
    if (rec_id >= db->company.next) return 0;
    return db->company.items[rec_id];
}


int
ownarrow_set_company_marketing(ownarrow* db,
    company* _record_,
    department* new_value /* null */) {
    ENSURE(_record_ == ownarrow_get_company(db, _record_->_row.id))
    if (_record_->marketing == new_value) {
        return 1;
    }
    if (new_value) {
        ENSURE(new_value == ownarrow_get_department(db, new_value->_row.id))
    }
    if (_record_->marketing != 0 ) {
        _record_->marketing->_ref_count--;
    }
    _record_->marketing = new_value;
    if (_record_->marketing != 0 ) {
        _record_->marketing->_ref_count++;
    }
    return 1;
}


company* /* null */
ownarrow_insert_company(ownarrow* db) {
    company* _record_;
    int rec_id;
    _record_ = 0;
    _record_ = allocate_memory(sizeof(company));
    rec_id = array_table_insert(&db->company, _record_);
    _record_->_row.id = rec_id;
    _record_->_row.table = &db->company;
    return _record_;
}


int
ownarrow_delete_company(ownarrow* db,
    company* record /* null */) {
    obj_list* deletion_list;
    int deleted = 0;
    if (!record) return 0;
    deletion_list = obj_list_create(0);
    ENSURE(record == ownarrow_get_company(db, record->_row.id))
    if (company_pre_delete(db, record, deletion_list, 0)) {
        deleted = delete_generic(db, deletion_list);
    }
    obj_list_destroy(deletion_list);
    return deleted;
}


int
ownarrow_company_count(const ownarrow* db) {
    return db->company.count;
}


int
ownarrow_foreach_company(ownarrow* db,
    company_fun visitor,
    void* user_data /* null */) {
    int i, n;
    company* current;
    n = db->company.next;
    for (i = 0; i < n; i++) {
        current = db->company.items[i];
        if (current) {
            if (visitor(current, user_data)) return 1;
        }
    }
    return 0;
}


static int
delete_generic(ownarrow* db,
    obj_list* deletion_list) {
    void* record;
    int i, n;
    n = obj_list_length(deletion_list);
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        if (!ensure_can_delete(db, record, deletion_list)) {
            return 0;
        }
    }
    for (i = 0; i < n; i++) {
        record = obj_list_get(deletion_list, i);
        do_delete(db, record, deletion_list, 1);
    }
    return 1;
}


static int
ensure_can_delete(ownarrow* db,
    void* record,
    obj_list* deletion_list) {
    row_base* row = record;
    return row->table->ensure_can_delete(
        db,
        record,
        deletion_list);
}


static void
do_delete(ownarrow* db,
    void* record,
    obj_list* deletion_list,
    int unlink) {
    row_base* row = record;
    row->table->do_delete(
        db,
        record,
        deletion_list,
        unlink);
}


static int
record_destructor(void* record,
    void* dbv) {
    ownarrow* db = dbv;
    do_delete(
        db,
        record,
        0,
        0);
    return 0;
}


static int
department_pre_delete(ownarrow* db,
    department* record,
    obj_list* deletion_list,
    int master) {
    if (obj_list_contains(deletion_list, record)) {
        return 1;
    } else {
        obj_list_add(deletion_list, record);
    }
    if ((master && record->_ref_count > 1) || 
      (!master && record->_ref_count > 0 )) {
        db->error_code = 2;
        return 0;
    }
    return 1;
}


static int
department_ensure_can_delete(ownarrow* db,
    department* record,
    obj_list* deletion_list) {
    return 1;
}


static void
department_do_delete(ownarrow* db,
    department* record,
    obj_list* deletion_list,
    int unlink) {
    if (unlink) {
        hashtable_remove(db->department_by_title, record);
        array_table_delete(&db->department, record->_row.id);
    }
    string8_destroy(record->title);
    free_memory(record, sizeof(department));
}


static unsigned int
department_by_title_hash(const void* vobj) {
    const department* obj;
    unsigned int code;
    if (!vobj) return 0;
    obj = vobj;
    code = string8_hash(obj->title);
    return code;
}


static int
department_by_title_eq(const void* lobj,
    const void* robj) {
    const department* left;
    const department* right;
    left = lobj;
    right = robj;
    if (!string8_equal(left->title, right->title)) return 0;
    return 1;
}


static int
employee_pre_delete(ownarrow* db,
    employee* record,
    obj_list* deletion_list,
    int master) {
    if (obj_list_contains(deletion_list, record)) {
        return 1;
    } else {
        obj_list_add(deletion_list, record);
    }
    return 1;
}


static int
employee_ensure_can_delete(ownarrow* db,
    employee* record,
    obj_list* deletion_list) {
    return 1;
}


static void
employee_do_delete(ownarrow* db,
    employee* record,
    obj_list* deletion_list,
    int unlink) {
    if (unlink) {
        if (record->department != 0 ) {
            if ( !obj_list_contains(deletion_list, record->department)) {
                record->department->_ref_count--;
            }
        }
        hashtable_remove(db->employee_by_name, record);
        array_table_delete(&db->employee, record->_row.id);
    }
    string8_destroy(record->name);
    free_memory(record, sizeof(employee));
}


static unsigned int
employee_by_name_hash(const void* vobj) {
    const employee* obj;
    unsigned int code;
    if (!vobj) return 0;
    obj = vobj;
    code = string8_hash(obj->name);
    return code;
}


static int
employee_by_name_eq(const void* lobj,
    const void* robj) {
    const employee* left;
    const employee* right;
    left = lobj;
    right = robj;
    if (!string8_equal(left->name, right->name)) return 0;
    return 1;
}


static int
company_pre_delete(ownarrow* db,
    company* record,
    obj_list* deletion_list,
    int master) {
    if (obj_list_contains(deletion_list, record)) {
        return 1;
    } else {
        obj_list_add(deletion_list, record);
    }
    if ( record->marketing != 0 ) {
        if (!department_pre_delete(db, record->marketing, deletion_list, 1)) return 0;
    }
    return 1;
}


static int
company_ensure_can_delete(ownarrow* db,
    company* record,
    obj_list* deletion_list) {
    return 1;
}


static void
company_do_delete(ownarrow* db,
    company* record,
    obj_list* deletion_list,
    int unlink) {
    if (unlink) {
        if (record->marketing != 0 ) {
            if ( !obj_list_contains(deletion_list, record->marketing)) {
                record->marketing->_ref_count--;
            }
        }
        array_table_delete(&db->company, record->_row.id);
    }
    free_memory(record, sizeof(company));
}
int main(
    int argc,
    char** argv
) {
    // item 239
    company* yellow;
    company* grey;
    /* item 240 */
    department* yellow_m;
    department* grey_m;
    /* item 241 */
    employee* grey_e2;
    employee* grey_e;
    /* item 245 */
    int yellow_id, yellowm_id, grey_id, greym_id;
    /* item 233 */
    ownarrow* db = ownarrow_create();
    /* item 244 */
    string8* mark_str = string8_from_cstr("Mark", 20);
    /* item 160 */
    yellow = ownarrow_insert_company(db);
    grey = ownarrow_insert_company(db);
    /* item 246 */
    yellow_id = company_id(yellow);
    grey_id = company_id(grey);
    /* item 161 */
    yellow_m = ownarrow_insert_department(db,
     string8_from_cstr("Yellow marketing", 20));
    grey_m = ownarrow_insert_department(db,
     string8_from_cstr("Grey marketing", 20));
    /* item 247 */
    yellowm_id = department_id(yellow_m);
    greym_id = department_id(grey_m);
    /* item 162 */
    grey_e = ownarrow_insert_employee(db,
     string8_from_cstr("Mark", 100), grey_m);
    grey_e2 = ownarrow_insert_employee(db,
     string8_from_cstr("John", 100), 0);
    /* item 178 */
    ENSURE(0 ==  ownarrow_insert_employee(db, mark_str, grey_m))
    /* item 164 */
    ENSURE(ownarrow_set_company_marketing(db, yellow, yellow_m))
    ENSURE(ownarrow_set_company_marketing(db, grey, grey_m))
    /* item 165 */
    ENSURE(ownarrow_set_employee_department(db, grey_e2, grey_m))
    /* item 169 */
    ENSURE(yellow_m == ownarrow_get_department(db, yellowm_id))
    /* item 166 */
    ENSURE(0 == ownarrow_delete_department(db, yellow_m))
    /* item 167 */
    ENSURE(ownarrow_delete_company(db, yellow))
    /* item 168 */
    ENSURE(0 == ownarrow_get_department(db, yellowm_id))
    ENSURE(0 == ownarrow_get_company(db, yellow_id))
    /* item 170 */
    ENSURE(0 ==  ownarrow_delete_company(db, grey))
    /* item 171 */
    ENSURE(ownarrow_set_employee_department(db, grey_e, 0))
    /* item 172 */
    ENSURE(ownarrow_delete_employee(db, grey_e2))
    /* item 173 */
    ENSURE(ownarrow_delete_company(db, grey))
    /* item 174 */
    ENSURE(0 == ownarrow_get_company(db, grey_id))
    ENSURE(0 == ownarrow_get_department(db, greym_id))
    /* item 242 */
    object_destroy(db);
    /* item 248 */
    object_destroy(mark_str);
    /* item 243 */
    return 0;
    
}



