namespace eval graph2 {

variable errors {}

array set ups {}

variable arrow_types
array set arrow_types {}

# arrow constants
variable up_arrow			""
variable right_arrow		""
variable down_arrow			""
variable left_arrow			""

variable up_white_arrow		""
variable right_white_arrow	""
variable down_white_arrow	""
variable left_white_arrow	""

variable up_paw				""
variable right_paw			""
variable down_paw			""
variable left_paw			""

variable parallel			""

### item store tables ###

# horizontals
array set stor_hor {}

# verticals
array set stor_ver {}

# icons
array set stor_icons {}

# items from diagram
array set g_items {}

### manhattan store tables ###

array set man_icons {}
array set man_icons_left {}
array set man_icons_right {}
array set man_icons_top {}
array set man_icons_bottom {}
array set man_icons_status {}
array set man_lines {}
array set man_lines_begin {}
array set man_lines_end {}
array set man_icons_by_center {}
array set man_icons_marked {}

variable man_id 1
variable man_hors {}
variable man_vers {}







# Autogenerated with DRAKON Editor 1.27

proc a.to.head { a } {
    #item 1360
    variable arrow_types
    #item 1361
    if {$a == 0} {
        #item 1364
        return ""
    } else {
        #item 1359
        return $arrow_types($a)
    }
}

proc all.empty { a b c d } {
    #item 1162
    if {((($a == "") && ($b == "")) && ($c == "")) && ($d == "")} {
        #item 1165
        return 1
    } else {
        #item 1166
        return 0
    }
}

proc arrow.line { current next } {
    #item 368
    lassign $current item_id x y1 y2 a
    #item 369
    lassign $next next_item_id _ next_y1 next_y2 next_a
    #item 371
    if {[points.up $a]} {
        #item 384
        set yy \
        [expr {max($y2, $next_y2)}]
        #item 386
        set to_add {}
        #item 383
        set next_current \
        [list $item_id $x $y1 $yy $a]
    } else {
        #item 374
        if {$y2 > $next_y2} {
            #item 376
            set to_add {}
            #item 381
            set next_current \
            $current
        } else {
            #item 387
            set to_add $current
            #item 380
            set next_current \
            [list $next_item_id $x $y2 $next_y2 0]
        }
    }
    #item 370
    return [ list $to_add $next_current ]
}

proc attach.to.icon { id } {
    #item 721
    variable man_hors
    variable man_vers
    #item 699
    lassign \
    [man.icon.box $id] \
    left top right bottom
    foreach line_id $man_vers {
        #item 727
        lassign \
        [man.line.coords $line_id] \
        x y1 y2
        #item 728
        if {($x < $left) || ($x > $right)} {
            
        } else {
            #item 724
            if {$y2 == $top} {
                #item 773
                if {[ man.line.end $line_id ] == ""} {
                    #item 832
                    man.set.icon.top $id $line_id
                } else {
                    #item 793
                    complain.two.attached $line_id
                }
            } else {
                #item 732
                if {$y1 == $bottom} {
                    #item 794
                    if {[ man.line.begin $line_id ] == ""} {
                        #item 833
                        man.set.icon.bottom $id $line_id
                    } else {
                        #item 796
                        complain.two.attached $line_id
                    }
                } else {
                    
                }
            }
        }
    }
    foreach line_id $man_hors {
        #item 838
        lassign \
        [man.line.coords $line_id] \
        y x1 x2
        #item 839
        if {($y < $top) || ($y > $bottom)} {
            
        } else {
            #item 836
            if {$x2 == $left} {
                #item 844
                if {[ man.line.end $line_id ] == ""} {
                    #item 850
                    man.set.icon.left $id $line_id
                } else {
                    #item 846
                    complain.two.attached $line_id
                }
            } else {
                #item 843
                if {$x1 == $right} {
                    #item 847
                    if {[ man.line.begin $line_id ] == ""} {
                        #item 851
                        man.set.icon.right $id $line_id
                    } else {
                        #item 849
                        complain.two.attached $line_id
                    }
                } else {
                    
                }
            }
        }
    }
}

proc attach.to.icons { } {
    #item 674
    set ids [ man.icons ]
    foreach id $ids {
        #item 675
        attach.to.icon $id
    }
    #item 672
    return [ success.status ]
}

proc check.dangling { } {
    #item 930
    set icon_ids [ man.icons ]
    foreach icon_id $icon_ids {
        #item 944
        if {[ man.icon.type $icon_id ] == "knot"} {
            #item 947
            set left [ man.icon.left $icon_id ]
            set top [ man.icon.top $icon_id ]
            set right [ man.icon.right $icon_id ]
            set bottom [ man.icon.bottom $icon_id ]
            #item 1025
            set only \
            [get.only $left $top $right $bottom]
            #item 1026
            if {$only == {}} {
                
            } else {
                #item 1024
                set item_id [ man.line.item_id $only ]
                #item 1029
                set message \
                [mc2 "Line not connected to any icon."]
                #item 1030
                report.error $item_id $message
            }
        } else {
            
        }
    }
    #item 932
    return [ success.status ]
}

proc check.on.one.line { } {
    #item 1216
    set icon_ids [ man.icons ]
    foreach icon_id $icon_ids {
        #item 1223
        set left [ man.icon.left $icon_id ]
        set top [ man.icon.top $icon_id ]
        set right [ man.icon.right $icon_id ]
        set bottom [ man.icon.bottom $icon_id ]
        #item 1251
        check.segments.on.line $left $right 0
        check.segments.on.line $top $bottom 1
    }
    #item 1217
    return [ success.status ]
}

proc check.segments.on.line { first second is_vertical } {
    #item 1236
    if {($first == {}) || ($second == {})} {
        
    } else {
        #item 1240
        lassign \
        [man.line.coords $first] \
        first_coord _ _
        #item 1241
        lassign \
        [man.line.coords $second] \
        second_coord _ _
        #item 1242
        if {$first_coord == $second_coord} {
            
        } else {
            #item 1244
            set item_id \
            [man.line.item_id $first]
            #item 1245
            if {$is_vertical} {
                #item 1248
                set message \
                [mc2 "Broken vertical line."]
            } else {
                #item 1247
                set message \
                [mc2 "Broken horizontal line."]
            }
            #item 1250
            report.error $item_id $message
        }
    }
}

proc clear.array { name } {
    #item 109
    variable $name
    #item 110
    array unset $name
    array set $name {}
}

proc complain.two.attached { line_id } {
    #item 789
    set item_id [ man.line.item_id $line_id ]
    #item 791
    set message \
    [mc2 "This icon has several lines on its side."]
    #item 792
    report.error $item_id $message
}

proc connected.check { } {
    #item 1255
    set icon_ids [ man.icons ]
    #item 1256
    set first [ first.not.comment $icon_ids ]
    #item 1257
    traverse $first
    foreach icon_id $icon_ids {
        #item 1261
        if {([ man.marked $icon_id ]) || ([ man.icon.type $icon_id ] == "commentin")} {
            
        } else {
            #item 1277
            set message \
            [mc2 "All icons must be connected together."]
            #item 1267
            report.error {} $message
            #item 1278
            return 0
        }
    }
    #item 1258
    return 1
}

proc cut.segments { segments top bottom } {
    #item 468
    set output {}
    foreach segment $segments {
        #item 472
        lassign $segment item_id x y1 y2 a
        #item 473
        if {$a == 0} {
            #item 476
            lassign \
            [cut.simple $segment $top $bottom 0 0] \
            upper lower
        } else {
            #item 477
            if {[points.up $a]} {
                #item 480
                lassign \
                [cut.simple $segment $top $bottom $a 0] \
                upper lower
            } else {
                #item 479
                lassign \
                [cut.simple $segment $top $bottom 0 $a] \
                upper lower
            }
        }
        #item 481
        if {$upper == {}} {
            
        } else {
            #item 484
            lappend output $upper
        }
        #item 485
        if {$lower == {}} {
            
        } else {
            #item 488
            lappend output $lower
        }
    }
    #item 469
    return $output
}

proc cut.simple { segment top bottom ua la } {
    #item 494
    lassign $segment item_id x y1 y2
    #item 496
    if {$y1 < $top} {
        #item 499
        if {$y2 <= $top} {
            #item 502
            set upper $segment
            #item 503
            set lower {}
        } else {
            #item 501
            set upper \
            [list $item_id $x $y1 $top $ua]
            #item 504
            if {$y2 > $bottom} {
                #item 506
                set lower \
                [list $item_id $x $bottom $y2 $la]
            } else {
                #item 507
                set lower {}
            }
        }
    } else {
        #item 512
        set upper {}
        #item 514
        if {$y2 > $bottom} {
            #item 508
            if {$y1 >= $bottom} {
                #item 511
                set lower $segment
            } else {
                #item 513
                set lower \
                [list $item_id $x $bottom $y2 $la]
            }
        } else {
            #item 507
            set lower {}
        }
    }
    #item 495
    return [ list $upper $lower ]
}

proc export.errors { diagram_id } {
    #item 1049
    variable errors
    foreach err $errors {
        #item 1082
        lassign $err item_id message
        #item 1052
        graph::p.error $diagram_id $item_id $message
    }
}

proc export.icon { db diagram_id icon_id } {
    #item 1211
    variable man_icons
    #item 1183
    set left [ man.icon.left $icon_id ]
    set top [ man.icon.top $icon_id ]
    set right [ man.icon.right $icon_id ]
    set bottom [ man.icon.bottom $icon_id ]
    #item 1184
    set item $man_icons($icon_id)
    #item 1185
    lassign $item item_id type text t2 x y w h a b
    #item 1201
    if {$type == "commentin"} {
        #item 1198
        if {[all.empty $left $top $right $bottom]} {
            
        } else {
            #item 1205
            set type "action"
            #item 1206
            set text ""
            #item 1212
            $db eval {
            update items
            set type = 'action',
            text = ''
            where item_id = :item_id
            }
            #item 1186
            $db eval {
            insert into vertices (
            	vertex_id, diagram_id, x, y, w, h, a, b,
            	item_id, up, left, right, down,
            	type, text, text2)
            values (
            	:icon_id, :diagram_id, :x, :y, :w, :h, :a, :b,
            	:item_id, :top, :left, :right, :bottom,
            	:type, :text, :t2)
            }
        }
    } else {
        #item 1207
        if {$type == "knot"} {
            #item 1187
            set type ""
        } else {
            
        }
        #item 1186
        $db eval {
        insert into vertices (
        	vertex_id, diagram_id, x, y, w, h, a, b,
        	item_id, up, left, right, down,
        	type, text, text2)
        values (
        	:icon_id, :diagram_id, :x, :y, :w, :h, :a, :b,
        	:item_id, :top, :left, :right, :bottom,
        	:type, :text, :t2)
        }
    }
}

proc export.result { db diagram_id } {
    #item 1100
    variable man_lines
    variable man_icons
    variable man_hors
    variable man_vers
    #item 1101
    set icon_ids [ array names man_icons ]
    foreach line_id $man_vers {
        #item 1104
        lassign $man_lines($line_id) item_id x y1 y2 a
        #item 1106
        set begin [ man.line.begin $line_id ]
        set end [ man.line.end $line_id ]
        #item 1357
        set head [ a.to.head $a ]
        #item 1105
        $db eval {
        insert into edges (edge_id, diagram_id, vertex1, vertex2, head, vertical, items)
        values (:line_id, :diagram_id, :begin, :end, :head, 1, :item_id)
        }
    }
    foreach line_id $man_hors {
        #item 1109
        lassign $man_lines($line_id) item_id y x1 x2 a
        #item 1111
        set begin [ man.line.begin $line_id ]
        set end [ man.line.end $line_id ]
        #item 1129
        set head [ a.to.head $a ]
        #item 1110
        $db eval {
        insert into edges (edge_id, diagram_id, vertex1, vertex2, head, vertical, items)
        values (:line_id, :diagram_id, :begin, :end, :head, 0, :item_id)
        }
    }
    foreach icon_id $icon_ids {
        #item 1204
        export.icon $db $diagram_id $icon_id
    }
}

proc extract.manhattan { db diagram_id } {
    #item 306
    import $db $diagram_id
    #item 431
    if {[icons.dont.touch]} {
        #item 432
        icons.cut.lines
        #item 284
        if {[merge.lines]} {
            #item 516
            lines.cut.lines
            #item 590
            make.man.store
            #item 673
            if {[attach.to.icons]} {
                #item 872
                insert.knots
                #item 1031
                if {(([check.dangling]) && ([check.on.one.line])) && (!(([mwc::is_drakon $diagram_id]) && (!([connected.check]))))} {
                    #item 1032
                    export.result $db $diagram_id
                } else {
                    #item 1042
                    export.errors $diagram_id
                }
            } else {
                #item 1042
                export.errors $diagram_id
            }
        } else {
            #item 1042
            export.errors $diagram_id
        }
    } else {
        #item 1042
        export.errors $diagram_id
    }
}

proc first.not.comment { icon_ids } {
    foreach icon_id $icon_ids {
        #item 1332
        if {[ man.icon.type $icon_id ] == "commentin"} {
            
        } else {
            #item 1336
            return $icon_id
        }
        #item 1335
        set left [ man.icon.left $icon_id ]
        set top [ man.icon.top $icon_id ]
        set right [ man.icon.right $icon_id ]
        set bottom [ man.icon.bottom $icon_id ]
        #item 1338
        if {((($left == {}) && ($right == {})) && ($top == {})) && ($bottom == {})} {
            
        } else {
            #item 1336
            return $icon_id
        }
    }
    #item 1337
    return -1
}

proc get.only { one two three four } {
    #item 1007
    set count 0
    #item 997
    if {$one == {}} {
        
    } else {
        #item 1008
        incr count
        #item 1009
        set output $one
    }
    #item 1000
    if {$two == {}} {
        
    } else {
        #item 1013
        incr count
        #item 1014
        set output $two
    }
    #item 1002
    if {$three == {}} {
        
    } else {
        #item 1015
        incr count
        #item 1016
        set output $three
    }
    #item 1004
    if {$four == {}} {
        
    } else {
        #item 1017
        incr count
        #item 1018
        set output $four
    }
    #item 1019
    if {$count == 1} {
        #item 1022
        return $output
    } else {
        #item 1023
        return {}
    }
}

proc icons.cut.lines { } {
    #item 438
    variable stor_icons
    variable stor_hor
    variable stor_ver
    #item 444
    set xx [ array names stor_ver ]
    set yy [ array names stor_hor ]
    set ids [ array names stor_icons ]
    foreach item_id $ids {
        #item 437
        set item $stor_icons($item_id)
        #item 442
        lassign $item _ _ _ _ x y w h
        #item 443
        lassign \
        [make_rect $x $y $w $h] \
        left top right bottom
        #item 445
        icons.cut.segments $top $bottom $left $right stor_ver
        #item 446
        icons.cut.segments $left $right $top $bottom stor_hor
    }
}

proc icons.cut.segments { top bottom left right array_name } {
    #item 452
    upvar $array_name lines
    #item 453
    set xs [ array names lines ]
    foreach x $xs {
        #item 456
        if {($x >= $left) && ($x <= $right)} {
            #item 460
            set segments $lines($x)
            #item 461
            set segments2 [ cut.segments $segments $top $bottom ]
            #item 462
            set lines($x) $segments2
        } else {
            
        }
    }
}

proc icons.dont.touch { } {
    #item 403
    variable stor_icons
    #item 404
    set ids \
    [array names stor_icons]
    #item 402
    set count [ llength $ids ]
    #item 4050001
    set i 0
    while { 1 } {
        #item 4050002
        if {$i < $count - 1} {
            
        } else {
            break
        }
        #item 410
        set one_id [ lindex $ids $i ]
        #item 1035
        set one $stor_icons($one_id)
        #item 409
        set next \
        [expr {$i + 1}]
        #item 4070001
        set ii $next
        while { 1 } {
            #item 4070002
            if {$ii < $count} {
                
            } else {
                break
            }
            #item 411
            set another_id [ lindex $ids $ii ]
            #item 1036
            set another $stor_icons($another_id)
            #item 412
            if {[icons.touch $one $another]} {
                #item 415
                set item_id \
                [lindex $one 0]
                #item 416
                set message \
                [mc2 "No space between icons."]
                #item 417
                report.error $item_id $message
            } else {
                
            }
            #item 4070003
            incr ii
        }
        #item 4050003
        incr i
    }
    #item 418
    return [ success.status ]
}

proc icons.touch { left right } {
    #item 424
    lassign $left _ _ _ _ x1 y1 w1 h1
    #item 427
    lassign $right _ _ _ _ x2 y2 w2 h2
    #item 429
    lassign \
    [make_rect $x1 $y1 $w1 $h1] \
    l1 t1 r1 b1
    #item 430
    lassign \
    [make_rect $x2 $y2 $w2 $h2] \
    l2 t2 r2 b2
    #item 428
    return [ rectangles_intersect $l1 $t1 $r1 $b1 $l2 $t2 $r2 $b2 ]
}

proc import { dbase diagram_id } {
    #item 1041
    stor.clear
    #item 401
    $dbase eval {
    	select item_id, type, text, text2, x, y, w, h, a, b
    	from items
    	where diagram_id = :diagram_id
    	and type != 'commentout'
    } {
    	set item [ list \
    		$item_id $type \
    		$text $text2 \
    		$x $y $w $h $a $b ]
    	
    	stor.import.item $item
    }
}

proc insert.knots { } {
    #item 898
    variable man_hors
    variable man_vers
    foreach line_id $man_vers {
        #item 899
        lassign \
        [man.line.coords $line_id] \
        x y1 y2
        #item 886
        if {[ man.line.begin $line_id ] == ""} {
            #item 900
            set knot_id [ man.get.knot $x $y1 ]
            #item 901
            man.set.icon.bottom $knot_id $line_id
        } else {
            
        }
        #item 902
        if {[ man.line.end $line_id ] == ""} {
            #item 905
            set knot_id [ man.get.knot $x $y2 ]
            #item 906
            man.set.icon.top $knot_id $line_id
        } else {
            
        }
    }
    foreach line_id $man_hors {
        #item 912
        lassign \
        [man.line.coords $line_id] \
        y x1 x2
        #item 909
        if {[ man.line.begin $line_id ] == ""} {
            #item 913
            set knot_id [ man.get.knot $x1 $y ]
            #item 914
            man.set.icon.right $knot_id $line_id
        } else {
            
        }
        #item 915
        if {[ man.line.end $line_id ] == ""} {
            #item 918
            set knot_id [ man.get.knot $x2 $y ]
            #item 919
            man.set.icon.left $knot_id $line_id
        } else {
            
        }
    }
}

proc line.arrow { current next } {
    #item 326
    lassign $current item_id x y1 y2 a
    #item 327
    lassign $next next_item_id _ next_y1 next_y2 next_a
    #item 339
    if {[points.up $next_a]} {
        #item 360
        set yy \
        [expr {max($y2, $next_y2)}]
        #item 352
        if {$next_y1 > $y1} {
            #item 358
            set to_add \
            [list $item_id $x $y1 $next_y1 $a]
        } else {
            #item 362
            set to_add {}
        }
        #item 359
        set next_current \
        [list $next_item_id $x $next_y1 $yy $next_a]
    } else {
        #item 342
        if {$y2 > $next_y2} {
            #item 355
            set to_add \
            [list $next_item_id $x $y1 $next_y2 $next_a]
            #item 356
            set next_current \
            [list $item_id $x $next_y2 $y2 0]
        } else {
            #item 347
            set to_add {}
            #item 357
            set next_current \
            [list $next_item_id $x $y1 $next_y2 $next_a]
        }
    }
    #item 328
    return [ list $to_add $next_current ]
}

proc line.cuts.items { ver_item y hor_items } {
    #item 543
    lassign $ver_item item_id x y1 y2
    #item 544
    if {($y < $y1) || ($y > $y2)} {
        #item 548
        return $hor_items
    } else {
        #item 549
        set output {}
        foreach hor_item $hor_items {
            #item 553
            lassign \
            [segment.cut.segment $x $hor_item] \
            left right
            #item 554
            if {$left == {}} {
                
            } else {
                #item 557
                lappend output $left
            }
            #item 558
            if {$right == {}} {
                
            } else {
                #item 561
                lappend output $right
            }
        }
        #item 550
        return $output
    }
}

proc lines.cut { ver_name hor_name } {
    #item 528
    upvar $hor_name hor
    upvar $ver_name ver
    #item 529
    set xs [ array names ver ]
    set ys [ array names hor ]
    foreach x $xs {
        foreach ver_item $ver($x) {
            foreach y $ys {
                #item 534
                set hor_items [ line.cuts.items $ver_item $y $hor($y) ]
                set hor($y) $hor_items
            }
        }
    }
}

proc lines.cut.lines { } {
    #item 522
    variable stor_hor
    variable stor_ver
    #item 521
    lines.cut stor_hor stor_ver
    lines.cut stor_ver stor_hor
}

proc make.man.store { } {
    #item 649
    variable stor_hor
    variable stor_ver
    variable stor_icons
    #item 647
    man.clear
    #item 648
    set xs [ array names stor_ver ]
    set ys [ array names stor_hor ]
    set icon_ids [ array names stor_icons ]
    foreach x $xs {
        foreach item $stor_ver($x) {
            #item 655
            man.insert.vertical $item
        }
    }
    foreach y $ys {
        foreach item $stor_hor($y) {
            #item 660
            man.insert.horizontal $item
        }
    }
    foreach icon_id $icon_ids {
        #item 665
        set icon $stor_icons($icon_id)
        #item 666
        man.insert.icon $icon
    }
}

proc man.clear { } {
    #item 596
    variable man_id
    variable man_hors
    variable man_vers
    #item 595
    clear.array man_icons
    clear.array man_icons_left
    clear.array man_icons_right
    clear.array man_icons_top
    clear.array man_icons_bottom
    clear.array man_icons_status
    clear.array man_icons_by_center
    clear.array man_lines
    clear.array man_lines_begin
    clear.array man_lines_end
    clear.array man_icons_marked
    
    set man_hors {}
    set man_vers {}
}

proc man.find.icon { x y } {
    #item 865
    variable man_icons_by_center
    #item 869
    set center "$x,$y"
    #item 866
    if {[info exists man_icons_by_center($center)]} {
        #item 871
        return $man_icons_by_center($center)
    } else {
        #item 870
        return {}
    }
}

proc man.get.knot { x y } {
    #item 920
    variable man_icons_by_center
    #item 924
    set key "$x,$y"
    #item 921
    if {[info exists man_icons_by_center($key)]} {
        #item 925
        return $man_icons_by_center($key)
    } else {
        #item 858
        set item [ list "" "knot" "" "" $x $y 0 0 0 0 ]
        #item 859
        return [ man.insert.icon $item ]
    }
}

proc man.icon.bottom { id } {
    #item 986
    variable man_icons_bottom
    #item 987
    if {[info exists man_icons_bottom($id)]} {
        #item 990
        return $man_icons_bottom($id)
    } else {
        #item 991
        return ""
    }
}

proc man.icon.box { id } {
    #item 688
    variable man_icons
    #item 687
    set icon $man_icons($id)
    #item 689
    set x [ lindex $icon 4 ]
    set y [ lindex $icon 5 ]
    set w [ lindex $icon 6 ]
    set h [ lindex $icon 7 ]
    #item 690
    return [ make_rect $x $y $w $h ]
}

proc man.icon.item_id { id } {
    #item 1274
    variable man_icons
    #item 1273
    set icon $man_icons($id)
    #item 1275
    set type [ lindex $icon 0 ]
    #item 1276
    return $type
}

proc man.icon.left { id } {
    #item 953
    variable man_icons_left
    #item 954
    if {[info exists man_icons_left($id)]} {
        #item 957
        return $man_icons_left($id)
    } else {
        #item 958
        return ""
    }
}

proc man.icon.right { id } {
    #item 964
    variable man_icons_right
    #item 965
    if {[info exists man_icons_right($id)]} {
        #item 968
        return $man_icons_right($id)
    } else {
        #item 969
        return ""
    }
}

proc man.icon.top { id } {
    #item 975
    variable man_icons_top
    #item 976
    if {[info exists man_icons_top($id)]} {
        #item 979
        return $man_icons_top($id)
    } else {
        #item 980
        return ""
    }
}

proc man.icon.type { id } {
    #item 941
    variable man_icons
    #item 940
    set icon $man_icons($id)
    #item 942
    set type [ lindex $icon 1 ]
    #item 943
    return $type
}

proc man.icons { } {
    #item 680
    variable man_icons
    #item 681
    return [ array names man_icons ]
}

proc man.insert.horizontal { segment } {
    #item 620
    variable man_lines
    variable man_hors
    #item 621
    set id [ man.next.id ]
    #item 623
    set man_lines($id) $segment
    #item 625
    lappend man_hors $id
}

proc man.insert.icon { item } {
    #item 632
    variable man_icons
    variable man_icons_by_center
    #item 667
    set x [ lindex $item 4 ]
    set y [ lindex $item 5 ]
    set center "$x,$y"
    #item 631
    set id [ man.next.id ]
    #item 633
    set man_icons($id) $item
    #item 668
    set man_icons_by_center($center) $id
    #item 873
    return $id
}

proc man.insert.vertical { segment } {
    #item 609
    variable man_lines
    variable man_vers
    #item 610
    set id [ man.next.id ]
    #item 612
    set man_lines($id) $segment
    #item 614
    lappend man_vers $id
}

proc man.line.begin { id } {
    #item 737
    variable man_lines_begin
    #item 739
    if {[info exists man_lines_begin($id)]} {
        #item 743
        return $man_lines_begin($id)
    } else {
        #item 742
        return ""
    }
}

proc man.line.coords { id } {
    #item 717
    variable man_lines
    #item 718
    set line $man_lines($id)
    #item 719
    lassign $line item_id x y1 y2
    #item 720
    return [ list $x $y1 $y2 ]
}

proc man.line.end { id } {
    #item 748
    variable man_lines_end
    #item 750
    if {[info exists man_lines_end($id)]} {
        #item 754
        return $man_lines_end($id)
    } else {
        #item 753
        return ""
    }
}

proc man.line.item_id { id } {
    #item 780
    variable man_lines
    #item 781
    set line $man_lines($id)
    #item 782
    lassign $line item_id
    #item 783
    return $item_id
}

proc man.lines { } {
    #item 882
    variable man_lines
    #item 883
    return [ array names man_lines ]
}

proc man.mark { icon_id } {
    #item 1311
    variable man_icons_marked
    #item 1312
    set man_icons_marked($icon_id) 1
}

proc man.marked { icon_id } {
    #item 1318
    variable man_icons_marked
    #item 1320
    if {[info exists man_icons_marked($icon_id)]} {
        #item 1323
        return 1
    } else {
        #item 1324
        return 0
    }
}

proc man.next.id { } {
    #item 601
    variable man_id
    #item 602
    incr man_id
    #item 603
    return $man_id
}

proc man.print { } {
    #item 1057
    variable man_hors
    variable man_vers
    #item 1058
    puts man_hors=$man_hors
    puts man_vers=$man_vers
    #item 1061
    variable man_icons
    variable man_icons_left
    variable man_icons_right
    variable man_icons_top
    variable man_icons_bottom
    variable man_icons_status
    variable man_icons_by_center
    variable man_lines
    variable man_lines_begin
    variable man_lines_end
    #item 1060
    puts man_icons
    parray  man_icons
    puts man_icons_left
    parray  man_icons_left
    puts man_icons_right
    parray  man_icons_right
    puts man_icons_top
    parray  man_icons_top
    puts man_icons_bottom
    parray  man_icons_bottom
    puts man_icons_status
    parray  man_icons_status
    puts man_lines
    parray  man_lines
    puts man_lines_begin
    parray  man_lines_begin
    puts man_lines_end
    parray  man_lines_end
    puts man_icons_by_center
    parray  man_icons_by_center
    #item 1062
    variable stor_hor
    parray stor_hor
    variable stor_ver
    parray stor_ver
    variable stor_icons
    parray stor_icons
    #item 1068
    puts ====================
}

proc man.set.icon.bottom { id line_id } {
    #item 824
    variable man_icons_bottom
    variable man_lines_begin
    #item 823
    set man_icons_bottom($id) $line_id
    #item 825
    set man_lines_begin($line_id) $id
}

proc man.set.icon.left { id line_id } {
    #item 828
    variable man_icons_left
    variable man_lines_end
    #item 802
    set man_icons_left($id) $line_id
    #item 829
    set man_lines_end($line_id) $id
}

proc man.set.icon.right { id line_id } {
    #item 826
    variable man_icons_right
    variable man_lines_begin
    #item 809
    set man_icons_right($id) $line_id
    #item 827
    set man_lines_begin($line_id) $id
}

proc man.set.icon.top { id line_id } {
    #item 830
    variable man_icons_top
    variable man_lines_end
    #item 816
    set man_icons_top($id) $line_id
    #item 831
    set man_lines_end($line_id) $id
}

proc man.set.line.begin { id icon_id } {
    #item 770
    variable man_lines_begin
    #item 772
    set man_lines_begin($id) $icon_id
}

proc man.set.line.end { id icon_id } {
    #item 759
    variable man_lines_end
    #item 765
    set man_lines_end($id) $icon_id
}

proc merge.lines { } {
    #item 145
    variable stor_hor
    #item 144
    set ys [ array names stor_hor ]
    foreach y $ys {
        #item 148
        set items $stor_hor($y)
        #item 149
        set items2 [ merge.on.1.line $items ]
        #item 150
        set stor_hor($y) $items2
    }
    #item 158
    variable stor_ver
    #item 157
    set xs [ array names stor_ver ]
    foreach x $xs {
        #item 161
        set items $stor_ver($x)
        #item 162
        set items2 [ merge.on.1.line $items ]
        #item 163
        set stor_ver($x) $items2
    }
    #item 305
    return [ success.status ]
}

proc merge.on.1.line { items } {
    #item 178
    set sorted [ lsort -integer -index 2 $items ]
    #item 180
    set output {}
    #item 184
    set current {}
    foreach item $sorted {
        #item 185
        if {$current == {}} {
            #item 188
            set current $item
        } else {
            #item 189
            lassign \
            [merge.segments $current $item] \
            to_add current
            #item 190
            if {$to_add == {}} {
                
            } else {
                #item 192
                lappend output $to_add
            }
        }
    }
    #item 392
    lappend output $current
    #item 181
    return $output
}

proc merge.segments { current next } {
    #item 228
    variable parallel
    #item 207
    lassign $current item_id x y1 y2 a
    #item 208
    lassign $next _ _ next_y1 next_y2 next_a
    #item 210
    if {$next_y1 > $y2} {
        #item 214
        set to_add $current
        set next_current $next
    } else {
        #item 2210001
        if {$a == 0} {
            #item 2340001
            if {$next_a == 0} {
                #item 246
                set to_add {}
                #item 247
                set next_current \
                [merge.simple $current $next]
            } else {
                #item 2340002
                if {$next_a == $parallel} {
                    #item 279
                    set message \
                    [mc2 "This segment takes the same place as another"]
                    #item 278
                    report.error $item_id $message
                    #item 293
                    set to_add {}
                    set next_current $next
                } else {
                    #item 264
                    lassign \
                    [line.arrow $current $next] \
                    to_add next_current
                }
            }
        } else {
            #item 2210002
            if {($a == $parallel) || (!($next_a == 0))} {
                #item 279
                set message \
                [mc2 "This segment takes the same place as another"]
                #item 278
                report.error $item_id $message
                #item 293
                set to_add {}
                set next_current $next
            } else {
                #item 276
                lassign \
                [arrow.line $current $next] \
                to_add next_current
            }
        }
    }
    #item 209
    return [ list $to_add $next_current ]
}

proc merge.simple { current next } {
    #item 312
    lassign $current item_id x y1 y2 a
    #item 313
    lassign $next _ _ next_y1 next_y2
    #item 325
    set yy \
    [expr {max($y2, $next_y2)}]
    #item 319
    return [ list $item_id $x $y1 $yy $a ]
}

proc points.up { a } {
    #item 1067
    variable ups
    #item 586
    if {$a == 0} {
        #item 589
        return 1
    } else {
        #item 338
        return $ups($a)
    }
}

proc report.error { item_id message } {
    #item 291
    variable errors
    #item 292
    lappend errors [ list $item_id $message ]
}

proc reset.counter { } {
    #item 1145
    variable man_id
    #item 1146
    set man_id 0
}

proc segment.cut.segment { x hor_item } {
    #item 569
    lassign $hor_item item_id y x1 x2 a
    #item 570
    if {$x <= $x1} {
        #item 574
        set left {}
        #item 573
        set right $hor_item
    } else {
        #item 576
        if {$x >= $x2} {
            #item 578
            set left $hor_item
            #item 579
            set right {}
        } else {
            #item 580
            if {[points.up $a]} {
                #item 584
                set left \
                [list $item_id $y $x1 $x $a]
                #item 585
                set right \
                [list $item_id $y $x $x2 0]
            } else {
                #item 582
                set left \
                [list $item_id $y $x1 $x 0]
                #item 583
                set right \
                [list $item_id $y $x $x2 $a]
            }
        }
    }
    #item 575
    return [ list $left $right ]
}

proc stor.clear { } {
    #item 290
    variable errors
    set errors {}
    #item 34
    clear.array stor_hor
    clear.array stor_ver
    clear.array stor_icons
    clear.array ups
    #item 336
    variable ups
    variable arrow_types
    #item 40
    variable up_arrow 
    variable right_arrow 
    variable down_arrow 
    variable left_arrow 
    
    variable up_white_arrow 
    variable right_white_arrow 
    variable down_white_arrow 
    variable left_white_arrow 
    
    variable up_paw 
    variable right_paw 
    variable down_paw 
    variable left_paw 
    
    variable parallel
    #item 41
    set up_arrow            [ mv::get_link_code up_arrow ]
    set right_arrow         [ mv::get_link_code right_arrow ]
    set down_arrow          [ mv::get_link_code down_arrow ]
    set left_arrow          [ mv::get_link_code left_arrow ]
    
    set up_white_arrow      [ mv::get_link_code up_white_arrow ]
    set right_white_arrow   [ mv::get_link_code right_white_arrow ]
    set down_white_arrow    [ mv::get_link_code down_white_arrow ]
    set left_white_arrow    [ mv::get_link_code left_white_arrow ]
    
    set up_paw              [ mv::get_link_code up_paw ]
    set right_paw           [ mv::get_link_code right_paw ]
    set down_paw            [ mv::get_link_code down_paw ]
    set left_paw            [ mv::get_link_code left_paw ]
    
    set parallel            [ mv::get_link_code parallel ]
    #item 335
    set ups($up_arrow) 1
    set ups($right_arrow) 0
    set ups($down_arrow) 0
    set ups($left_arrow) 1
    
    set ups($up_white_arrow) 1
    set ups($right_white_arrow) 0
    set ups($down_white_arrow) 0
    set ups($left_white_arrow) 1
    
    set ups($up_paw) 1
    set ups($right_paw) 0
    set ups($down_paw) 0
    set ups($left_paw) 1
    
    set ups($parallel) 0
    #item 1358
    set arrow_types($up_arrow) "up arrow"
    set arrow_types($right_arrow) "right arrow"
    set arrow_types($down_arrow) "down arrow"
    set arrow_types($left_arrow) "left arrow"
    
    set arrow_types($up_white_arrow) "up white arrow"
    set arrow_types($right_white_arrow) "right white arrow"
    set arrow_types($down_white_arrow) "down white arrow"
    set arrow_types($left_white_arrow) "left white arrow"
    
    set arrow_types($up_paw) "up paw"
    set arrow_types($right_paw) "right paw"
    set arrow_types($down_paw) "down paw"
    set arrow_types($left_paw) "left paw"
    
    set arrow_types($parallel) "parallel"
}

proc stor.import.arrow { item } {
    #item 132
    variable left_arrow
    variable right_arrow
    #item 124
    lassign $item item_id type text text2 x y w h a b
    #item 125
    set vertical [ list $item_id "vertical" "" "" $x $y 0 $h 0 0 ]
    stor.import.vertical $vertical
    #item 134
    set y2 \
    [expr {$y + $h}]
    #item 127
    if {$b == 0} {
        #item 136
        set x2 \
        [expr {$x - $a}]
        #item 137
        set x2t \
        [expr {$x - $w}]
        #item 135
        set horizontal [ list $item_id "horizontal" "" "" $x2 $y2 $a 0 0 ]
        #item 138
        set arrow [ list $item_id "horizontal" "" "" $x2t $y $w 0 $left_arrow ]
    } else {
        #item 133
        set horizontal [ list $item_id "horizontal" "" "" $x $y2 $a 0 0 ]
        #item 126
        set arrow [ list $item_id "horizontal" "" "" $x $y $w 0 $right_arrow ]
    }
    #item 139
    stor.import.horizontal $horizontal 0
    stor.import.horizontal $arrow 0
}

proc stor.import.horizontal { item a_over } {
    #item 75
    variable stor_hor
    #item 69
    lassign $item item_id _ _ _ x y w h a
    #item 71
    if {$a_over == 0} {
        
    } else {
        #item 70
        set a $a_over
    }
    #item 81
    set x2 \
    [expr {$x + $w}]
    #item 74
    set item2 [ list $item_id $y $x $x2 $a ]
    #item 77
    if {[info exists stor_hor($y)]} {
        #item 76
        set on_y $stor_hor($y)
    } else {
        #item 80
        set on_y {}
    }
    #item 82
    lappend on_y $item2
    #item 83
    set stor_hor($y) $on_y
}

proc stor.import.icon { item } {
    #item 116
    variable stor_icons
    #item 117
    set item_id [ lindex $item 0 ]
    #item 118
    set stor_icons($item_id) $item
}

proc stor.import.if { item } {
    #item 1074
    lassign $item item_id type t1 t2 x y w h a b
    #item 1076
    set line_x \
    [expr {$x + $w}]
    #item 1077
    set line \
    [list $item_id horizontal "" "" $line_x $y $a 0 0]
    #item 1075
    stor.import.horizontal $line 0
    #item 1078
    stor.import.icon $item
}

proc stor.import.item { item } {
    #item 61
    variable parallel
    #item 42
    lassign $item item_id type
    #item 430001
    if {$type == "horizontal"} {
        #item 58
        stor.import.horizontal $item 0
    } else {
        #item 430002
        if {$type == "vertical"} {
            #item 59
            stor.import.vertical $item
        } else {
            #item 430003
            if {$type == "arrow"} {
                #item 62
                stor.import.arrow $item
            } else {
                #item 430004
                if {$type == "parallel"} {
                    #item 60
                    stor.import.horizontal \
                      $item $parallel
                } else {
                    #item 430005
                    if {$type == "if"} {
                        #item 1081
                        stor.import.if $item
                    } else {
                        #item 63
                        stor.import.icon $item
                    }
                }
            }
        }
    }
}

proc stor.import.vertical { item } {
    #item 95
    variable stor_ver
    #item 89
    lassign $item item_id _ _ _ x y w h a
    #item 101
    set y2 \
    [expr {$y + $h}]
    #item 94
    set item2 [ list $item_id $x $y $y2 $a ]
    #item 97
    if {[info exists stor_ver($x)]} {
        #item 96
        set on_x $stor_ver($x)
    } else {
        #item 100
        set on_x {}
    }
    #item 102
    lappend on_x $item2
    #item 103
    set stor_ver($x) $on_x
}

proc success.status { } {
    #item 299
    variable errors
    #item 302
    if {[ llength $errors ] == 0} {
        #item 300
        return 1
    } else {
        #item 301
        return 0
    }
}

proc traverse { icon_id } {
    #item 1288
    if {[ man.marked $icon_id ]} {
        
    } else {
        #item 1284
        man.mark $icon_id
        #item 1289
        set left [ man.icon.left $icon_id ]
        set top [ man.icon.top $icon_id ]
        set right [ man.icon.right $icon_id ]
        set bottom [ man.icon.bottom $icon_id ]
        #item 1290
        if {$left == {}} {
            
        } else {
            #item 1293
            set next [ man.line.begin $left ]
            traverse $next
        }
        #item 1294
        if {$right == {}} {
            
        } else {
            #item 1297
            set next [ man.line.end $right ]
            traverse $next
        }
        #item 1298
        if {$top == {}} {
            
        } else {
            #item 1301
            set next [ man.line.begin $top ]
            traverse $next
        }
        #item 1302
        if {$bottom == {}} {
            
        } else {
            #item 1305
            set next [ man.line.end $bottom ]
            traverse $next
        }
    }
}

}
