/** @file imagetag_cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.4
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef IMAGETAG_CMDLINE_H
#define IMAGETAG_CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "imagetag"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "imagetag"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "2.0.0"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * kernel_arg;	/**< @brief File with LZMA compressed kernel to include in the image..  */
  char * kernel_orig;	/**< @brief File with LZMA compressed kernel to include in the image. original value given at command line.  */
  const char *kernel_help; /**< @brief File with LZMA compressed kernel to include in the image. help description.  */
  char * rootfs_arg;	/**< @brief File with RootFS to include in the image..  */
  char * rootfs_orig;	/**< @brief File with RootFS to include in the image. original value given at command line.  */
  const char *rootfs_help; /**< @brief File with RootFS to include in the image. help description.  */
  char * output_arg;	/**< @brief Name of output file..  */
  char * output_orig;	/**< @brief Name of output file. original value given at command line.  */
  const char *output_help; /**< @brief Name of output file. help description.  */
  char * cfe_arg;	/**< @brief File with CFE to include in the image..  */
  char * cfe_orig;	/**< @brief File with CFE to include in the image. original value given at command line.  */
  const char *cfe_help; /**< @brief File with CFE to include in the image. help description.  */
  char * boardid_arg;	/**< @brief Board ID to set in the image (must match what router expects, e.g. \"96345GW2\")..  */
  char * boardid_orig;	/**< @brief Board ID to set in the image (must match what router expects, e.g. \"96345GW2\"). original value given at command line.  */
  const char *boardid_help; /**< @brief Board ID to set in the image (must match what router expects, e.g. \"96345GW2\"). help description.  */
  char * chipid_arg;	/**< @brief Chip ID to set in the image (must match the actual hardware, e.g. \"6345\")..  */
  char * chipid_orig;	/**< @brief Chip ID to set in the image (must match the actual hardware, e.g. \"6345\"). original value given at command line.  */
  const char *chipid_help; /**< @brief Chip ID to set in the image (must match the actual hardware, e.g. \"6345\"). help description.  */
  char * flash_start_arg;	/**< @brief Flash start address. (default='0xBFC00000').  */
  char * flash_start_orig;	/**< @brief Flash start address. original value given at command line.  */
  const char *flash_start_help; /**< @brief Flash start address. help description.  */
  char * image_offset_arg;	/**< @brief Offset from start address for the first byte after the CFE (in memory). (default='0x10000').  */
  char * image_offset_orig;	/**< @brief Offset from start address for the first byte after the CFE (in memory). original value given at command line.  */
  const char *image_offset_help; /**< @brief Offset from start address for the first byte after the CFE (in memory). help description.  */
  char * tag_version_arg;	/**< @brief Version number for imagetag format. (default='6').  */
  char * tag_version_orig;	/**< @brief Version number for imagetag format. original value given at command line.  */
  const char *tag_version_help; /**< @brief Version number for imagetag format. help description.  */
  char * signature_arg;	/**< @brief Magic string (signature), for boards that need it. (default='Broadcom Corporatio').  */
  char * signature_orig;	/**< @brief Magic string (signature), for boards that need it. original value given at command line.  */
  const char *signature_help; /**< @brief Magic string (signature), for boards that need it. help description.  */
  char * signature2_arg;	/**< @brief Second magic string (signature2). (default='ver. 2.0').  */
  char * signature2_orig;	/**< @brief Second magic string (signature2). original value given at command line.  */
  const char *signature2_help; /**< @brief Second magic string (signature2). help description.  */
  char * block_size_arg;	/**< @brief Flash erase block size. (default='0x10000').  */
  char * block_size_orig;	/**< @brief Flash erase block size. original value given at command line.  */
  const char *block_size_help; /**< @brief Flash erase block size. help description.  */
  char * load_addr_arg;	/**< @brief Kernel load address..  */
  char * load_addr_orig;	/**< @brief Kernel load address. original value given at command line.  */
  const char *load_addr_help; /**< @brief Kernel load address. help description.  */
  char * entry_arg;	/**< @brief Address where the kernel entry point will be for booting..  */
  char * entry_orig;	/**< @brief Address where the kernel entry point will be for booting. original value given at command line.  */
  const char *entry_help; /**< @brief Address where the kernel entry point will be for booting. help description.  */
  char * layoutver_arg;	/**< @brief Flash layout version (version 2.2x of the Broadcom code requires this)..  */
  char * layoutver_orig;	/**< @brief Flash layout version (version 2.2x of the Broadcom code requires this). original value given at command line.  */
  const char *layoutver_help; /**< @brief Flash layout version (version 2.2x of the Broadcom code requires this). help description.  */
  char * info1_arg;	/**< @brief String for first vendor information section..  */
  char * info1_orig;	/**< @brief String for first vendor information section. original value given at command line.  */
  const char *info1_help; /**< @brief String for first vendor information section. help description.  */
  char * altinfo_arg;	/**< @brief String for vendor information section (alternate/pirelli)..  */
  char * altinfo_orig;	/**< @brief String for vendor information section (alternate/pirelli). original value given at command line.  */
  const char *altinfo_help; /**< @brief String for vendor information section (alternate/pirelli). help description.  */
  char * info2_arg;	/**< @brief String for second vendor information section..  */
  char * info2_orig;	/**< @brief String for second vendor information section. original value given at command line.  */
  const char *info2_help; /**< @brief String for second vendor information section. help description.  */
  int root_first_flag;	/**< @brief Put the rootfs before the kernel (only for stock images, e.g. captured from the router's flash memory). (default=off).  */
  const char *root_first_help; /**< @brief Put the rootfs before the kernel (only for stock images, e.g. captured from the router's flash memory). help description.  */
  char * rsa_signature_arg;	/**< @brief String for RSA Signature section..  */
  char * rsa_signature_orig;	/**< @brief String for RSA Signature section. original value given at command line.  */
  const char *rsa_signature_help; /**< @brief String for RSA Signature section. help description.  */
  char * second_image_flag_arg;	/**< @brief Dual Image Flag (2=not-specified). (default='2').  */
  char * second_image_flag_orig;	/**< @brief Dual Image Flag (2=not-specified). original value given at command line.  */
  const char *second_image_flag_help; /**< @brief Dual Image Flag (2=not-specified). help description.  */
  char * inactive_arg;	/**< @brief Inactive Flag (2=not-specified). (default='2').  */
  char * inactive_orig;	/**< @brief Inactive Flag (2=not-specified). original value given at command line.  */
  const char *inactive_help; /**< @brief Inactive Flag (2=not-specified). help description.  */
  char * reserved2_arg;	/**< @brief String for second reserved section..  */
  char * reserved2_orig;	/**< @brief String for second reserved section. original value given at command line.  */
  const char *reserved2_help; /**< @brief String for second reserved section. help description.  */
  int kernel_file_has_header_flag;	/**< @brief Indicates that the kernel file includes the kernel header with correct load address and entry point, so no changes are needed (default=off).  */
  const char *kernel_file_has_header_help; /**< @brief Indicates that the kernel file includes the kernel header with correct load address and entry point, so no changes are needed help description.  */
  int pad_arg;	/**< @brief Pad the image to this size if smaller (in MiB).  */
  char * pad_orig;	/**< @brief Pad the image to this size if smaller (in MiB) original value given at command line.  */
  const char *pad_help; /**< @brief Pad the image to this size if smaller (in MiB) help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int kernel_given ;	/**< @brief Whether kernel was given.  */
  unsigned int rootfs_given ;	/**< @brief Whether rootfs was given.  */
  unsigned int output_given ;	/**< @brief Whether output was given.  */
  unsigned int cfe_given ;	/**< @brief Whether cfe was given.  */
  unsigned int boardid_given ;	/**< @brief Whether boardid was given.  */
  unsigned int chipid_given ;	/**< @brief Whether chipid was given.  */
  unsigned int flash_start_given ;	/**< @brief Whether flash-start was given.  */
  unsigned int image_offset_given ;	/**< @brief Whether image-offset was given.  */
  unsigned int tag_version_given ;	/**< @brief Whether tag-version was given.  */
  unsigned int signature_given ;	/**< @brief Whether signature was given.  */
  unsigned int signature2_given ;	/**< @brief Whether signature2 was given.  */
  unsigned int block_size_given ;	/**< @brief Whether block-size was given.  */
  unsigned int load_addr_given ;	/**< @brief Whether load-addr was given.  */
  unsigned int entry_given ;	/**< @brief Whether entry was given.  */
  unsigned int layoutver_given ;	/**< @brief Whether layoutver was given.  */
  unsigned int info1_given ;	/**< @brief Whether info1 was given.  */
  unsigned int altinfo_given ;	/**< @brief Whether altinfo was given.  */
  unsigned int info2_given ;	/**< @brief Whether info2 was given.  */
  unsigned int root_first_given ;	/**< @brief Whether root-first was given.  */
  unsigned int rsa_signature_given ;	/**< @brief Whether rsa-signature was given.  */
  unsigned int second_image_flag_given ;	/**< @brief Whether second-image-flag was given.  */
  unsigned int inactive_given ;	/**< @brief Whether inactive was given.  */
  unsigned int reserved2_given ;	/**< @brief Whether reserved2 was given.  */
  unsigned int kernel_file_has_header_given ;	/**< @brief Whether kernel-file-has-header was given.  */
  unsigned int pad_given ;	/**< @brief Whether pad was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_second_image_flag_values[];  /**< @brief Possible values for second-image-flag. */
extern const char *cmdline_parser_inactive_values[];  /**< @brief Possible values for inactive. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* IMAGETAG_CMDLINE_H */
